(*
 *  Main.pas - ezDICOM: Main Window
 *  Project: ezDICOM
 *  Purpose: ezDICOM Main Window
 *  Rev:
 *	01-Jul-97, wk: first implementation coded
 *   30-Oct-99, cr: updated for pixelgraphic
 *)
unit Main;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls,
	Menus, StdCtrls, Dialogs, Buttons, Messages, ExtCtrls,
  ComCtrls, ToolWin, ExtDlgs;

type
  TMainForm = class(TForm)
    MainMenu1 : TMainMenu;
    FileMenu: TMenuItem;
      FileOpenItem      : TMenuItem;
      N1                : TMenuItem;
      FileExitItem      : TMenuItem;
    WindowMenu: TMenuItem;
      WindowCascadeItem : TMenuItem;
      WindowTileItem    : TMenuItem;
      WindowArrangeItem : TMenuItem;
      WindowMinimizeItem: TMenuItem;
    HelpMenu: TMenuItem;
      HelpAboutItem     : TMenuItem;
    OpenDialog: TOpenDialog;
    Opengraphic1: TMenuItem;
    PGOpenDialog1: TOpenDialog;
    OpenGEdata1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure WindowCascadeItemClick(Sender: TObject);
    procedure UpdateMenuItems(Sender: TObject);
    procedure WindowTileItemClick(Sender: TObject);
    procedure WindowArrangeItemClick(Sender: TObject);
    procedure FileOpenItemClick(Sender: TObject);
    procedure FileExitItemClick(Sender: TObject);
    procedure WindowMinimizeItemClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure HelpAboutItemClick(Sender: TObject);
    procedure Opengraphic1Click(Sender: TObject);
    procedure OpenGEdata1Click(Sender: TObject);
  private
    { Private declarations }
    procedure CreateMDIChild(const Name: string; DICOM,lGenesis: boolean);
    //procedure ShowHint(Sender: TObject);
    //procedure StoreLanguageInIniFile( Language : string );
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

uses ChildWin, About;

(*========================================================================*)
procedure TMainForm.FormCreate(Sender: TObject);
begin
  //Application.OnHint        := ShowHint;
  Screen.OnActiveFormChange := UpdateMenuItems;
end;

(*procedure TMainForm.ShowHint(Sender: TObject);
begin
  StatusBar.SimpleText := Application.Hint;
end;

(*========================================================================*)
procedure TMainForm.CreateMDIChild(const Name: string; DICOM,lGenesis: boolean);
var
  Child: TMDIChild;
begin
  { create a new MDI child window }
LockWindowUpdate(MainForm.Handle);
//MyMDIChild := TMyMDIChild.Create(Application);
  Child := TMDIChild.Create( Application );
  Child.Caption := Name;
  //Child.ScaleBy(100,100);
  if NOT Child.LoadData( Name,DICOM,lGenesis ) then
  begin
  	Child.free;
    exit;
  end;
LockWindowUpdate(0);

end;

(*========================================================================*)
procedure TMainForm.FormDestroy(Sender: TObject);
begin
  Screen.OnActiveFormChange := nil;
end;


(*========================================================================*)
(*== Main menu ==*)
(*========================================================================*)
procedure TMainForm.UpdateMenuItems(Sender: TObject);
begin
  WindowCascadeItem.Enabled  := MDIChildCount > 0;
  WindowTileItem.Enabled     := MDIChildCount > 0;
  WindowArrangeItem.Enabled  := MDIChildCount > 0;
  WindowMinimizeItem.Enabled := MDIChildCount > 0;
end;

(*========================================================================*)
procedure TMainForm.FileOpenItemClick(Sender: TObject);
var I : Integer;
begin
 	if OpenDialog.Execute then
  begin
  	for I:=0 to OpenDialog.Files.Count-1 do
    begin
	   	CreateMDIChild(OpenDialog.Files[i],true,false);
		end;
	end;
end;

(*========================================================================*)
procedure TMainForm.FileExitItemClick(Sender: TObject);
begin
  Close;
end;

(*========================================================================*)
procedure TMainForm.WindowCascadeItemClick(Sender: TObject);
begin
  Cascade;
end;

(*========================================================================*)
procedure TMainForm.WindowTileItemClick(Sender: TObject);
begin
  Tile;
end;

(*========================================================================*)
procedure TMainForm.WindowArrangeItemClick(Sender: TObject);
begin
  ArrangeIcons;
end;

(*========================================================================*)
procedure TMainForm.WindowMinimizeItemClick(Sender: TObject);
var
  I: Integer;
begin
  { Must be done backwards through the MDIChildren array }
  for I := MDIChildCount - 1 downto 0 do
    MDIChildren[I].WindowState := wsMinimized;
end;

(*========================================================================*)
procedure TMainForm.HelpAboutItemClick(Sender: TObject);
begin
//	AboutDisplay := TRUE;
  AboutBox.ShowModal;
//  AboutDisplay := FALSE;
end;

(*========================================================================*)

(*========================================================================*)


procedure TMainForm.Opengraphic1Click(Sender: TObject);
begin
//     PGOpenDialog1.initialdir :=ExtractFilePath(OpenDialog.FileName);
     PGOpenDialog1.filename := '';
     if PGOpenDialog1.Execute then begin
        //showmessage('x');
        //PGOpenDialog1.initialdir :=ExtractFilePath(PGOpenDialog1.filename);
        CreateMDIChild(PGOpenDialog1.Filename,false,false);
     end;
end;


procedure TMainForm.OpenGEdata1Click(Sender: TObject);
var I : Integer;
begin
OpenDialog.Filter := 'GE Genesis  file|*.*';
 	if OpenDialog.Execute then
  begin
  	for I:=0 to OpenDialog.Files.Count-1 do
    begin
	   	CreateMDIChild(OpenDialog.Files[i],true,true);
		end;
	end;
OpenDialog.Filter := 'DICOM 3.0  file|*.*';

end;

end.
