unit ColSet;
//menu for higher and lower slices
//wincen and winwid
interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Childwin,Spin, Buttons, ExtCtrls, ComCtrls;

type
  TColorSettingsDlg = class(TForm)
    Bevel3: TBevel;
    SliceLabel: TLabel;
    MinMaxLabel: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    ApplyPrecise: TSpeedButton;
    Label6: TLabel;
    HidePreciseBtn: TSpeedButton;
    SchemeDrop: TComboBox;
    WinCenEdit: TSpinEdit;
    WinWidEdit: TSpinEdit;
    SliceSlider: TTrackBar;
    procedure SliceSliderChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ColUpdate;
    procedure ShowPreciseDetails;
    procedure SchemeDropChange(Sender: TObject);
    procedure ApplyPreciseClick(Sender: TObject);
    procedure WinWidEditChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ColorSettingsDlg: TColorSettingsDlg;

implementation

uses Main;
const
gColAbort : boolean = false;
var
gSliceOddChange: boolean;
//gConOddChange: boolean;
{$R *.DFM}

procedure TColorSettingsDlg.ShowPreciseDetails;
begin
     MinMaxLabel.caption := 'Image Min/Max: '+inttostr(TMDIChild(MainForm.ActiveMDIChild).gimgmin)+'/'+inttostr(TMDIChild(MainForm.ActiveMDIChild).gimgmax)+chr (13)
       + 'Displayed Min/Max: '+inttostr(TMDIChild(MainForm.ActiveMDIChild).gwinmin)+'/'+inttostr(TMDIChild(MainForm.ActiveMDIChild).gwinmax);
end;
procedure TColorSettingsDlg.SliceSliderChange(Sender: TObject);
begin
     if gColAbort then exit;
     gSliceOddChange := not gSliceOddChange;
     if (gSliceOddChange) then begin  //delphi3 trackbars call changes twice, this code reduces the overhead
        TMDIChild(MainForm.ActiveMDIChild).DisplayImage(false,SliceSlider.position,WinWidEdit.value,WincenEdit.value,SchemeDrop.itemindex);
        ShowPreciseDetails;
     end;
end;
procedure TColorSettingsDlg.ColUpdate;
begin
  gColAbort := true;
  if not TMDIChild(MainForm.ActiveMDIChild).FDICOM then begin
    ColorSettingsDlg.Height:= 20;
    //SpeedButton3.visible := true;
     exit;
  end;
  ColorSettingsDlg.Height := 185;
    //SpeedButton3.visible := false;
  if TMDIChild(MainForm.ActiveMDIChild).gDicomData.allocbits_per_pixel <= 8 then begin
     HidePreciseBtn.visible := true;
     WinWidEdit.visible := false;
     WinCenEdit.visible := false;
  end else begin
     HidePreciseBtn.visible := false;
     WinWidEdit.visible := true;
     WinCenEdit.visible := true;
  end;
  if TMDIChild(MainForm.ActiveMDIChild).gDicomdata.XYZdim[3] < 2 then begin
     SliceLabel.visible := false;
     SliceSlider.visible := false;
  end else begin
      SliceSlider.visible := true;
      SliceLabel.visible := true;
      SliceSlider.Max := TMDIChild(MainForm.ActiveMDIChild).gDICOMdata.XYZdim[3];
  end;
  SliceSlider.position := TMDIChild(MainForm.ActiveMDIChild).gSlice;
  SchemeDrop.ItemIndex := TMDIChild(MainForm.ActiveMDIChild).gScheme;
  WinCenEdit.value := TMDIChild(MainForm.ActiveMDIChild).gWinCen;
  WinWidEdit.value := TMDIChild(MainForm.ActiveMDIChild).gWinWid;
  ShowPreciseDetails;
  gColAbort := false;
end;
procedure TColorSettingsDlg.FormShow(Sender: TObject);
begin
     ColorSettingsDlg.left := MainForm.Left+30;
     ColorSettingsDlg.top := MainForm.top+30;

     ColUpdate;
end;

procedure TColorSettingsDlg.SchemeDropChange(Sender: TObject);
begin
     if gColAbort then exit;
          TMDIChild(MainForm.ActiveMDIChild).DisplayImage(false,SliceSlider.position,WinWidEdit.value,WincenEdit.value,SchemeDrop.itemindex);
end;

procedure TColorSettingsDlg.ApplyPreciseClick(Sender: TObject);
begin
     if not gColAbort then
     if (sender as TSpeedButton).tag = 1 then //full range
        WinWidEdit.Value := 0;
     if (sender as TSpeedButton).tag = 2 then begin //use file defaults
        WinCenEdit.value := TMDIChild(MainForm.ActiveMDIChild).gDICOMdata.WindowCenter;
        WinWidEdit.value := TMDIChild(MainForm.ActiveMDIChild).gDICOMdata.WindowWidth;
     end;
     TMDIChild(MainForm.ActiveMDIChild).DisplayImage(false,SliceSlider.position,WinWidEdit.value,WincenEdit.value,SchemeDrop.itemindex);
     ApplyPrecise.visible := false;
     ShowPreciseDetails;
end;
procedure TColorSettingsDlg.WinWidEditChange(Sender: TObject);
begin
    ApplyPrecise.visible := true;
end;

end.
