(*
 *  Childwin.pas - ezDICOM: Child Window
 *  Project: ezDICOM
 *  Purpose: Child Window of the ezDICOM
 *  Rev:
 *	01-Jul-97, wk: first implementation coded
 *   30-Oct-99, cr: updated for pixelgraphic
 *)
unit Childwin;

interface

uses SysUtils, Windows, Classes, Graphics, Forms,
     Controls, ExtCtrls, StdCtrls, Buttons,
     ComCtrls, Menus, Dialogs,DICOM;

type
  palentries   = array[0..255] of TPaletteEntry;
  palindices   = array[0..255] of word;
  ByteRA = array [0..0] of byte;
  Bytep0 = ^ByteRA;
  SmallIntRA = array [0..0] of SmallInt;
  SMallIntp0 = ^SmallIntRA;
  TMDIChild = class(TForm)
    MainMenu1: TMainMenu;
    OptionsSettingsMenu: TMenuItem;
    OptionsColorSettingsItem: TMenuItem;
    OptionsImgInfoItem: TMenuItem;
    FileMenu: TMenuItem;
    FileExitItem: TMenuItem;
    N1: TMenuItem;
    FileCloseItem: TMenuItem;
    FileOpenItem: TMenuItem;
    FileExportAsBmpItem: TMenuItem;
    FileOpenpicture1: TMenuItem;
    N2: TMenuItem;
    Lowerslice1: TMenuItem;
    Higherslice1: TMenuItem;
    PGSaveDialog1: TSaveDialog;
    Image: TImage;
    OpenGenesisGEdata1: TMenuItem;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FileOpenItemClick(Sender: TObject);
    procedure FileCloseItemClick(Sender: TObject);
    procedure FileExitItemClick(Sender: TObject);
    procedure OptionsImgInfoItemClick(Sender: TObject);
    procedure HelpAboutItemClick(Sender: TObject);
    procedure PopupColorSettingsItemClick(Sender: TObject);
    procedure PopupImgInfoItemClick(Sender: TObject);
    procedure PopupMenu1Popup(Sender: TObject);
    procedure PopupFitToImgItemClick(Sender: TObject);
    procedure FileExportAsBmpItemClick(Sender: TObject);
    procedure ExportasBMP1Click(Sender: TObject);
    procedure OptionsColorSettingsItemClick(Sender: TObject);
    procedure FileOpenpicture1Click(Sender: TObject);
    procedure OptimizeChildSize;
    procedure Lowerslice1Click(Sender: TObject);
    procedure SetConDefaults(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure WinWidEditChange(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure OpenGenesisGEdata1Click(Sender: TObject);

  private
    { Private declarations }
    FFileName     : string;
    gDynStr: string;
    gAbort: boolean;
  public
    FDICOM: boolean;
    gDicomData: DIcomData;
    gSlice,gnSLice,gImgMin,gImgMax,gWinMin,gWinMax,gWHite,gBlack,gScheme,gPro,gScale,gWinCen,gWinWid: integer;
    { Public declarations }
    function  LoadData( FileName : string; lDICOM,lGenesis: boolean ) : Boolean;
    procedure UpdatePalette(pWhite,pBlack,pScheme: integer);
//    procedure UpPal(lLo);
    procedure DisplayImage(lForceDraw: boolean; lSlice,lWinWid,lWincen,lScheme: integer);
  end;
var
	MDIChild : TMDIChild;


implementation

uses Main, ImgInfo, ColSet;//, View;
const
gImgOK : boolean = false;
var
gMinHt,gMinWid: integer;
{$R *.DFM}
procedure TMDIChild.OptimizeChildSize;
var
lX,lY: integer;
begin
     Image.Width := Image.Picture.Bitmap.Width;
     Image.Height := Image.Picture.Bitmap.Width;
     lX := round(gDICOMData.XYZdim[1]);
     lY := round(gDICOMData.XYZdim[2]);
     if lX > MainForm.ClientWidth then
        lX :=MainForm.ClientWidth;
     if (lY+40) > MainForm.ClientHeight then {title height}
        lY :=MainForm.ClientHeight-40;
     if lX < gMinWid then lX := gMinWid;
     if lY < gMinHt then lY := gMinHt;
     ClientWidth := lX;
     ClientHeight := lY;

end;
procedure FireLUT (lIntensity, lTotal: integer; var lR,lG,lB: integer);
var l255scale: integer;
begin
     l255Scale := round ( lIntensity/lTotal * 255);
     lR := (l255Scale - 52) * 3;
     if lR < 0 then lR := 0
     else if lR > 255 then lR := 255;
     lG := (l255Scale - {96}108) * 2{2};
     if lG < 0 then lG := 0
     else if lG > 255 then lG := 255;
     case l255Scale of
          0..55: lB :=  (l255Scale * 4);
          56..118: lB := 220-((l255Scale-55)*3);
          119..235: lB := 0;
          else lB := {255-}((l255Scale-235)*10);
     end; {case}
     if lB < 0 then lB := 0
     else if lB > 255 then lB := 255;
end;

procedure TMDIChild.UpdatePalette(pWhite,pBlack,pScheme: integer);
begin
end;

(*========================================================================*)
procedure TMDIChild.FormClose(Sender: TObject; var Action: TCloseAction);
begin
//	if FImgBuff <> nil then FreeMem( FImgBuff );
  gDynStr:= '';
  Action := caFree;
end;

(*========================================================================*)
procedure TMDIChild.FormCreate(Sender: TObject);
begin
  FFileName    := '';
  gMinHt := {ViewPanel.Height}10;
  gMinWid := {ViewPanel.Width}10;
  gDICOMData.XYZdim[1]        := 0;
  gDICOMData.XYZdim[2]       := 0;
end;


function TMDIChild.LoadData( FileName : string; lDICOM, lGenesis: boolean ) : Boolean;
var
     lHdrOK: boolean;
begin
	Result := TRUE;
     gImgOK := false;
	FFileName := FileName;
     gAbort:= true;
     if not lDICOM then begin
        FDICOM := false;
  	   Image.Picture.Bitmap.LoadFromFile( FileName );
        gDICOMData.XYZdim[1] := Image.Picture.Bitmap.Width;
        gDICOMData.XYZdim[2] := Image.Picture.Bitmap.Height;
        OptimizeChildSize;
        OptionsSettingsMenu.enabled := false;
        gImgOK := true;
//        refresh;
        exit;
     end else
         FDICOM := true;
  if lGenesis then
     read_ge_data(gDICOMdata, lHdrOK, gImgOK, gDynStr,FFileName)
  else
      read_dicom_data(false,false {this version does not load custom palette}, gDICOMdata, lHdrOK, gImgOK, gDynStr,FFileName );
  gWhite := 255;
  gBlack := 1;
  gScale := 1;
  gPro := 0;
  gWinCen := 0;
  gWinWid := 0;
    if gDICOMdata.monochrome = 1 then
     gScheme := 0
  else
      gScheme := 1;
  OptimizeChildSize;
  if gDICOMdata.SamplesPerPixel = 3 then begin
     showmessage('This software does not read RGB images');
     gImgOK := false;
  end;
  if (not lHdrOK) or (not gImgOK) then begin
     showmessage('Error reading image.');
     if red_table_size > 0 then begin
        freemem(red_table);
        red_table_size := 0;
     end;
     if green_table_size > 0 then begin
        freemem(green_table);
        green_table_size := 0;
     end;
     if blue_table_size > 0 then begin
        freemem(blue_table);
        blue_table_size := 0;
     end;
     //  exit;
  end;
  if gDicomdata.XYZdim[3] > 1 then begin
      LowerSlice1.enabled := true;
      HigherSlice1.enabled := true;
  end;
  PGSaveDialog1.initialdir := extractfilepath(FFilename);
  PGSaveDialog1.filename := '';
  if ColorSettingsDlg.visible then
     ColorSettingsDlg.ColUpdate;
  gAbort := false;
  DisplayImage(True,1,0,0,gScheme{z lscheme});
  Screen.Cursor := crDefault;
end;

(*========================================================================*)
procedure TMDIChild.FileOpenItemClick(Sender: TObject);
begin
	MainForm.FileOpenItemClick(Sender);
end;

(*========================================================================*)
procedure TMDIChild.FileExportAsBmpItemClick(Sender: TObject);
begin
PGSaveDialog1.Filter := 'Bitmap Files (*.BMP)|*.BMP;(*.JPG)|*.JPG';
PGSaveDialog1.Options := [ofOVerWritePrompt];
PGSaveDialog1.DefaultExt := 'bmp';
if PGSaveDialog1.Execute then
  	Image.Picture.Bitmap.SaveToFile( PGSaveDialog1.FileName );
end;

(*========================================================================*)
procedure TMDIChild.FileCloseItemClick(Sender: TObject);
begin
	Close;
end;

(*========================================================================*)
procedure TMDIChild.FileExitItemClick(Sender: TObject);
begin
	MainForm.FileExitItemClick(Sender);
end;

procedure TMDIChild.OptionsImgInfoItemClick(Sender: TObject);
var lLen,lI : integer;
lStr: string;
begin
  if not FDICOM then begin
     showmessage('Unable to show DICOM header information. This is not a DICOM file.');
     EXIT;
  end;
  ImgInfoDlg.Memo1.Lines.Clear;
      lLen := Length (gDynStr);
    if lLen > 0 then begin
       lStr := '';
       for lI := 1 to lLen do begin
           if gDynStr[lI] <> kCR then
              lStr := lStr + gDynStr[lI]
           else begin
                ImgInfoDlg.Memo1.Lines.add(lStr);
                lStr := '';
           end;
       end;
       ImgInfoDlg.Memo1.Lines.Add(lStr);
    end;

	ImgInfoDlg.ShowModal;
end;

(*========================================================================*)
procedure TMDIChild.HelpAboutItemClick(Sender: TObject);
begin
end;


(*========================================================================*)

(*========================================================================*)
procedure TMDIChild.DisplayImage(lForceDraw: boolean;lSlice,lWinWid,lWinCen,lScheme: integer);
label
444;
var
  lBuff,TmpBuff   : bYTEp0;
  lBuff16: SmallIntP0;
  lTmpPos,lTmpSz,lLastPixel: longint;
  lSmall: word;//smallint;
  infp: file;
  max16 : LongInt;
  min16 : LongInt;
  lByte2,lByte: byte;
  j,size   : Integer;
  lBufEntries,lLine,lImgPos,lLineStart,lLineEnd,lPos,value : LongInt;
  lCol,lXdim,lStoreSliceVox,lImageStart,lAllocSLiceSz,lStoreSliceSz,I,I12       : Integer;
  lR,lG,lB: integer;
	hBmp    : HBITMAP;
  BI      : PBitmapInfo;
  BIH     : TBitmapInfoHeader;
  Bmp     : TBitmap;
//  TmpDC   : hDC;
  ImagoDC : hDC;
function GetByte: byte;
begin
     if lTmpPos >= lTmpSz then begin //whoops GE "compression" has made the file BIGGER!
        {Worst case scenario filesize = 150% uncompressed, so this can only happen once}
        lTmpSz := FileSize(infp)-(lImageStart+lTmpSz);//2nd allocation
        if (lAllocSliceSz < lTmpSz) then
           lTmpSz := lAllocSliceSz; {idea: for multi slice images, limit compression}
        if lTmpSz < 1 then begin
            Showmessage('Error with GE Genesis compression.');
            GetByte := 0;
            exit;
        end;
        FreeMem(TmpBuff);
        GetMem( TmpBuff, lTmpSz);
        BlockRead(infp, TmpBuff^, lTmpSz);
        lTmpPos := 0;
     end;
     GetByte := TmpBuff[lTmpPos];
     inc(lTMpPos);
end;

begin
if (not gImgOK) or (gAbort) then exit;
if lSlice < 1 then exit;
if (gDicomData.GenesisPacked) then begin
   Showmessage('This file has PACKED data. Please e-mail [chris.rorden@mrc-cbu.cam.ac.uk]. '+
   'This software can not yet read PACKED files (minor modification are required).');
   exit;
end;
gSlice := lSlice;
  lAllocSLiceSz := (gDICOMdata.XYZdim[1]*gDICOMdata.XYZdim[2]{height * width} * gDICOMdata.Allocbits_per_pixel+7) div 8 ;
  if (lAllocSLiceSz) < 1 then exit;
     AssignFile(infp, FFileName);
     FileMode := 0; //Read only
	  Reset(infp, 1);

   lImageStart := gDicomData.ImageStart + ((lSlice-1) * (lAllocSliceSz*gDICOMdata.SamplesPerPixel));
  if (not gDicomData.GenesisCpt) and ((lImageStart + lAllocSliceSz) > (FileSize(infp))) then begin
        showmessage('This file does not have enough data for the image size.');
        closefile(infp);
        FileMode := 2; //read/write
        exit;
  end;
  Seek(infp, lImageStart);
  if (gDICOMdata.Allocbits_per_pixel = 8) and(gDICOMdata.SamplesPerPixel = 3) then begin
     GetMem( lBuff, lAllocSliceSz*gDICOMdata.SamplesPerPixel);
     if gDICOMdata.planarconfig = 0 then begin
         BlockRead(infp, lBuff^, lAllocSliceSz*gDICOMdata.SamplesPerPixel);
         //r <-> b values need to be swapped
         size := lAllocSliceSz-1;
         j := 0;
         for i := 0 to size do begin
             lByte := lBuff[j];
             lBuff[j] := lBuff[j+2];
             lBuff[j+2] := lByte;
             j := j + 3;
         end;
     end else begin
         GetMem( TmpBuff, lAllocSliceSz);
         BlockRead(infp, TmpBuff^, lAllocSliceSz{, n});
         size := lAllocSliceSz-1;
         j := 2;
         for i := 0 to size do begin
             lBuff[j] := TmpBuff[i];
             j := j + 3;
         end;
         BlockRead(infp, TmpBuff^, lAllocSliceSz{, n});
         size := lAllocSliceSz-1;
         j := 1;
         for i := 0 to size do begin
             lBuff[j] := TmpBuff[i];
             j := j + 3;
         end;
         BlockRead(infp, TmpBuff^, lAllocSliceSz{, n});
         size := lAllocSliceSz-1;
         j := 0;
         for i := 0 to size do begin
             lBuff[j] := TmpBuff[i];
             j := j + 3;
         end;
         FreeMem( TmpBuff);
     end; //planar config
     CloseFile(infp);
     FileMode := 2; //read/write
   exit;
  end; //rgb

  case gDICOMdata.Allocbits_per_pixel of
       8: begin
                   GetMem( lbuff, lAllocSliceSz);
                   BlockRead(infp, lbuff^, lAllocSliceSz{, n});
                   CloseFile(infp);
                   FileMode := 2; //read/write
                   end;
       16: begin
           Seek(infp, lImageStart);
           GetMem( lbuff16, lAllocSliceSz);
           if gDicomData.GenesisCpt then begin
              lLastPixel := 0;
                lBufEntries := lAllocSliceSz div 2;
                lTmpSz := FileSize(infp)-lImageStart;
                if (lAllocSliceSz < lTmpSz) then
                   lTmpSz := lAllocSliceSz; {idea: for multi slice images, limit compression}
                GetMem( TmpBuff, lTmpSz);
                BlockRead(infp, TmpBuff^, lTmpSz);
                lTmpPos := 0;
                   lImgPos := 0;
                       lLineStart := 1;
                       lLineEnd := gDicomData.XYZdim[1];
                   for lLine := 1 to gDICOMData.XYZdim[2] do begin
                       for lPos := lLineStart to lLineEnd do begin
                             lByte := GetByte;
                             if (lByte > 127) then begin
                                if ((lByte and 64)=64) then begin {new 16 bits}
                                   I := GetByte;//lByte2;
                                   lByte := GetByte;
                                   lLastPixel := ((I shl 8)+lByte);
                                end else begin {not lbyte and 64: 14 byte delta}
                                 lByte2 := getbyte;
                                 J := lByte2;
                                 if ((lByte and 32)=32) then {subtract delta}  //shl1=2,shl2=4,shl3=8,shl4=16,shl5=32
                                    I := (lByte or $E0)
                                 else
                                     I := lByte and $1F;
                                 lLastPixel := lLastPixel + smallint(((I)shl 8)+ (J {shl 5}))
                                end; {14 byte delta}
                             end else begin {not lbyte and 128: 7 byte delta}
                                 if (lByte > 63) then {subtract delta}
                                    lByte := lByte or $C0;
                                 lLastPixel := lLastPixel + shortInt(lByte);
(**)                         end; //lbyte values
                             if lImgPos < lBufEntries then
                                lbuff16[lImgPos] := lLastPixel
                             else //imgpos >= lAlloc
                                 goto 444;
                                inc(lImgPos);
                       end; //lPos
                   end; //for lines
                   444:
                Freemem(TmpBuff);
                end else begin //not genesis
                   BlockRead(infp, lbuff16^, lAllocSliceSz{, n});
                end;
                CloseFile(infp);
                FileMode := 2; //read/write
       end;
       12: begin
           GetMem( tmpbuff, lAllocSliceSz);
           BlockRead(infp, tmpbuff^, lAllocSliceSz{, n});
           CloseFile(infp);
           FileMode := 2; //read/write
           lStoreSliceVox := gDICOMdata.XYZdim[1]*gDICOMdata.XYZdim[2];
           lStoreSLiceSz := lStoreSliceVox * 2;
           GetMem( lbuff16, lStoreSLiceSz);
           I12 := 0;
           I := 0;
           repeat
                 lbuff16[I] := (((tmpbuff[I12]) shr 4) shl 8) + (((tmpbuff[I12+1]) and 15) + (((tmpbuff[I12]) and 15) shl 4) );
                 inc(I);
                 if I < lStoreSliceVox then
                    lbuff16[i] :=  (((tmpbuff[I12+2]) and 15) shl 8) +((((tmpbuff[I12+1]) shr 4 ) shl 4)+((tmpbuff[I12+2]) shr 4)  );//char (((integer(tmpbuff[I12+2]) and 16) shl 4)+ (integer(tmpbuff[I12+1]) shr 4));
                 inc(I);
                 I12 := I12 + 3;
           until I >= lStoreSliceVox;
           FreeMem( tmpbuff);
           end;
       else exit;
  end;
  if  (gDICOMdata.Storedbits_per_pixel)  > 8 then begin
  value := lbuff16[0];
  max16 := value;
  min16 := value;
  size := gDicomData.XYZdim[1]*gDicomData.XYZdim[2] {2*width*height};
  if (gDicomdata.little_endian <> 1) and (not gDicomData.GenesisCpt) then  //convert big-endian data to Intel friendly little endian
     for i := (Size-1) downto 0 do
         lbuff16[i] := swap(lbuff16[i]);
  i:=0;
  while I < Size do begin
    value := lbuff16[i];
    if value < min16 then min16 := value;
    if value > max16 then max16 := value;
    i := i+1;
  end;
  size := (gDicomData.XYZdim[1]*gDicomData.XYZdim[2])-1 {width*height-1 };
  gImgMin := min16;
  gImgMax := max16;
  if lWinWid{Edit.value} <> 0 then begin
      min16 := lWinCen{Edit.value} - (abs(trunc(lWinWid{Edit.value}/2)));
      max16 := lWinCen{Edit.value} + (abs(trunc(lWinWid{Edit.value}/2)));

  end;
  gWinMin := min16;
  gWinMax := max16;

//  minmaxlabel.caption := 'Image Min/Max: '+inttostr(min16)+'/'+inttostr(max16);
//  Conlabel.caption := 'Displayed Min/Max: '+inttostr(min16)+'/'+inttostr(max16);


  GetMem( lbuff,size+1 {width * height});
  for i := 0 to size do begin
     if lBuff16[i] < min16 then
        lbuff[i] := 0
     else if lBuff16[i] > max16 then
          lbuff[i] := 255
     else
  	    lbuff[i] := (Trunc(255*((lBuff16[i])-min16) / (max16-min16)));
  end;
  FreeMem( lbuff16 );
end;

//zz)
if (gDICOMdata.XYZdim[1] mod 8) <> 0 then begin
   lXdim :=  ((gDICOMdata.XYZdim[1]+7) div 8) * 8;
   lAllocSLiceSz := lXdim*gDICOMdata.XYZdim[2] ;
       GetMem( tmpbuff, lAllocSliceSz);
       I := 0;
       lCol := 1;
       I12 := 0;
       repeat
             if lCol <= gDICOMdata.XYZdim[1] then begin
                tmpbuff[I] := lbuff[I12];
                inc(I12);
             end else
                 tmpbuff[I] := (0);
             inc(lCol);
             if lCol > lXdim then lCol := 1;
             Inc(I);
       until I >= (lAllocSliceSz);
       freemem(lBuff);
       lbuff := tmpbuff;
end else
         lXdim := gDICOMdata.XYZdim[1];

	BIH.biSize   		 	 	:= Sizeof(BIH);
	BIH.biWidth  		 	 	:= lXdim;//gDICOMdata.XYZdim[1]{width};
  BIH.biHeight 		 	 	:= -gDICOMdata.XYZdim[2]{-height};
	BIH.biPlanes 		 	 	:= 1;
  BIH.biBitCount 	 	 	:= 8;
	BIH.biCompression 	:= BI_RGB;
  BIH.biSizeImage	 	 	:= 0;
	BIH.biXPelsPerMeter := 0;
  BIH.biYPelsPerMeter := 0;
	BIH.biClrUsed       := 0;
  BIH.biClrImportant  := 0;
{$P+,S-,W-,R-}

 		// Create DIB Bitmap Info with actual color table
	BI := AllocMem(SizeOf(TBitmapInfoHeader) + 256*Sizeof(TRGBQuad));
	try
	  BI^.bmiHeader := BIH;
	  case lScheme of
           0: for I:=0 to 255 do begin
  		     BI^.bmiColors[I].rgbBlue     := Byte(255- I );
                BI^.bmiColors[I].rgbGreen    := Byte(255- I );
	           BI^.bmiColors[I].rgbRed      := Byte(255- I );
		     BI^.bmiColors[I].rgbReserved := 0;
             end;
           1: for I:=0 to 255 do begin
  		     BI^.bmiColors[I].rgbBlue     := Byte( I );
                BI^.bmiColors[I].rgbGreen    := Byte( I );
	           BI^.bmiColors[I].rgbRed      := Byte( I );
		     BI^.bmiColors[I].rgbReserved := 0;
             end;
            2:  for I:=0 to 255 do begin
                 FireLUT (I,255,lR,lG,lB);

  		     BI^.bmiColors[I].rgbBlue     := lB;
                BI^.bmiColors[I].rgbGreen    := lG;
	           BI^.bmiColors[I].rgbRed      := lR ;
		     BI^.bmiColors[I].rgbReserved := 0;
             end;
           end; {case lScheme}

	  Bmp        := TBitmap.Create;
  	Bmp.Height := gDICOMdata.XYZdim[1]{width};
	  Bmp.Width  := gDICOMdata.XYZdim[2]{height};

       ImagoDC := GetDC(Self.Handle);
	  //ImagoDC := GetDC(eDICOMform.Handle);

	  hBmp :=  CreateDIBitmap(
    				ImagoDC,		// handle of device context
    				BIH,									// address of bitmap size and format data
    				CBM_INIT,							// initialization flag
	    			pCHar(lbuff),									// address of initialization data
  	  			BI^,									// address of bitmap color-format data
    				DIB_RGB_COLORS ); 		// color-data usage
	  Bmp.Handle := hBmp;
Image.Picture.Bitmap.Assign( Bmp );
Image.Refresh;
	  Bmp.Free;
	except
	  exit;
  end;
  FreeMem( BI, SizeOf(TBitmapInfoHeader) + 256*Sizeof(TRGBQuad));
  freemem(lBuff);
{$P-,S+,W+,R+}




//zz
(*if {(gDICOMdata.SamplesPerPixel = 1) and }(lForceDraw) {or (Image.Pixelgraphic.Width <> lXdim) or (Image.Pixelgraphic.Width <> gDICOMdata.XYZdim[2])} then begin
         Image.PixelGraphic:=TPixelGraphic.Create;
Image.PixelGraphic.SetDimension(gDICOMdata.XYZdim[1],gDICOMdata.XYZdim[2]{+1}, bc8);
Image.PixelGraphic.PaletteKind:=pGray256; {}
end;
  Image.PixelGraphic.BeginUpdate;
for i := (gDICOMdata.XYZdim[2]-1) downto 0 do begin
  j := gDICOMdata.XYZdim[1] * (i);
  Move(lBuff[j],Image.PixelGraphic.ScanLineBytes[i]^,gDICOMdata.XYZdim[1]);
end;
   freemem(lBuff);
  //  Move(lbuff^,Image.PixelGraphic.BitmapBytes^,lXdim*gDICOMdata.XYZdim[2]{lAllocSLiceSz});
  //gcBlack := 1;
  //gcWhite := 254;
  updatepalette(gWhite,gBlack,lScheme);
  Image.ActionMode:=amMoveImage;
  Image.ActionMode:=amNone;
  //  Image.refresh;
  FreePGMemoryContexts;
  {$P-,S+,W+,R+}
*)end;


(*========================================================================*)
(*== Child PopUP Menu Items ==*)
(*========================================================================*)
procedure TMDIChild.PopupColorSettingsItemClick(Sender: TObject);
begin
end;

(*========================================================================*)
procedure TMDIChild.PopupImgInfoItemClick(Sender: TObject);
begin
	OptionsImgInfoItemClick( Sender );
end;

(*========================================================================*)
procedure TMDIChild.ExportasBMP1Click(Sender: TObject);
begin
	FileExportAsBmpItemClick( Sender );
end;

(*========================================================================*)
procedure TMDIChild.PopupMenu1Popup(Sender: TObject);
begin
end;


(*========================================================================*)
procedure TMDIChild.PopupFitToImgItemClick(Sender: TObject);
begin
end;

(*========================================================================*)
procedure TMDIChild.OptionsColorSettingsItemClick(Sender: TObject);
begin
  ColorSettingsDlg.Show;
end;



procedure TMDIChild.FileOpenpicture1Click(Sender: TObject);
begin
	MainForm.Opengraphic1Click(Sender);
end;

procedure TMDIChild.Lowerslice1Click(Sender: TObject);
var
   lSlice: integer;
begin
  if (sender as TMenuItem).tag = 1 then begin{increment}
     if gSlice >= gDICOMdata.XYZdim[3] then
        lSlice := 1
     else
         lSlice := gSlice + 1;
  end else begin
     if gSlice > 1 then
        lSlice := gSlice -1
     else
         lSlice := gDICOMdata.XYZdim[3];
  end;
     if not ColorSettingsDlg.visible then
        DisplayImage(false,lSlice,gWinWid,gWincen,gScheme)
     else begin
         ColorSettingsDlg.SliceSlider.position := lSlice;
         ColorSettingsDlg.SliceSliderChange(nil);
         ColorSettingsDlg.SliceSliderChange(nil);
         //requires two calls because there are usually two change calls when the user moves the slider
     end;

end;

procedure TMDIChild.SetConDefaults(Sender: TObject);
begin
{  WinCenEdit.value := gDICOMdata.WindowCenter;
  WinWidEdit.value := gDICOMdata.WindowWidth;
  if not gAbort then
     DisplayImage(false,SliceSlider.value);}
end;

procedure TMDIChild.SpeedButton2Click(Sender: TObject);
begin
{     WinWidEdit.Value := 0;
     DisplayImage(false,SliceSlider.value);}
end;

procedure TMDIChild.SpeedButton3Click(Sender: TObject);
begin
{     DisplayImage(false,SliceSlider.value);}
end;

procedure TMDIChild.WinWidEditChange(Sender: TObject);
begin
//     SpeedButton3.visible := true;
end;

procedure TMDIChild.FormActivate(Sender: TObject);
begin
//showmessage('x');
  if ColorSettingsDlg.visible then
     ColorSettingsDlg.ColUpdate;

end;

procedure TMDIChild.OpenGenesisGEdata1Click(Sender: TObject);
begin
	MainForm.OpenGEdata1Click(Sender);
end;

end.



