unit ColSet;
//menu for higher and lower slices
//wincen and winwid
interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Childwin,Spin, PGraphic, Buttons, ExtCtrls, ComCtrls;

type
  TColorSettingsDlg = class(TForm)
    Bevel3: TBevel;
    Bevel1: TBevel;
    Label7: TLabel;
    Label1: TLabel;
    SliceLabel: TLabel;
    MinMaxLabel: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    ApplyPrecise: TSpeedButton;
    Label4: TLabel;
    Label6: TLabel;
    HidePreciseBtn: TSpeedButton;
    SchemeDrop: TComboBox;
    ScaleDrop: TComboBox;
    ProDrop: TComboBox;
    WinCenEdit: TSpinEdit;
    WinWidEdit: TSpinEdit;
    WhiteSlide: TTrackBar;
    BlackSlide: TTrackBar;
    SliceSlider: TTrackBar;
    procedure WhiteSlideChange(Sender: TObject);
    procedure SliceSliderChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ColUpdate;
    procedure ShowPreciseDetails;
    procedure SchemeDropChange(Sender: TObject);
    procedure ProDropChange(Sender: TObject);
    procedure ApplyPreciseClick(Sender: TObject);
    procedure WinWidEditChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ColorSettingsDlg: TColorSettingsDlg;

implementation

uses Main;
const
gColAbort : boolean = false;
var
gSliceOddChange: boolean;
gConOddChange: boolean;
{$R *.DFM}

procedure TColorSettingsDlg.ShowPreciseDetails;
begin
     MinMaxLabel.caption := 'Image Min/Max: '+inttostr(TMDIChild(MainForm.ActiveMDIChild).gimgmin)+'/'+inttostr(TMDIChild(MainForm.ActiveMDIChild).gimgmax)+chr (13)
       + 'Displayed Min/Max: '+inttostr(TMDIChild(MainForm.ActiveMDIChild).gwinmin)+'/'+inttostr(TMDIChild(MainForm.ActiveMDIChild).gwinmax);
end;
procedure TColorSettingsDlg.WhiteSlideChange(Sender: TObject);
begin
     if gColAbort then exit;
     gSliceOddChange := not gSliceOddChange;
     if (not gSliceOddChange) then exit;  //delphi3 trackbars call changes twice, this code reduces the overhead
     if ((Sender as TTrackBar).name <> 'BlackSlide') and(BlackSlide.position > WhiteSlide.position) then
        BlackSlide.position := WhiteSlide.position
     else if ((Sender as TTrackBar).name <> 'WhiteSlide') and (BlackSlide.position > WhiteSlide.position) then
            WhiteSlide.position := BlackSlide.position;

     TMDIChild(MainForm.ActiveMDIChild).updatepalette(WhiteSlide.position,BlackSlide.position,SchemeDrop.itemindex);
end;

procedure TColorSettingsDlg.SliceSliderChange(Sender: TObject);
begin
     if gColAbort then exit;
     gSliceOddChange := not gSliceOddChange;
     if (gSliceOddChange) then begin  //delphi3 trackbars call changes twice, this code reduces the overhead
        TMDIChild(MainForm.ActiveMDIChild).DisplayImage(false,SliceSlider.position,WinWidEdit.value,WincenEdit.value,SchemeDrop.itemindex);
        ShowPreciseDetails;
     end;
end;
procedure TColorSettingsDlg.ColUpdate;
begin
  gColAbort := true;
  if not TMDIChild(MainForm.ActiveMDIChild).FDICOM then begin
    ColorSettingsDlg.Height:= 20;
    //SpeedButton3.visible := true;
     exit;
  end;
  ColorSettingsDlg.Height := 270;
    //SpeedButton3.visible := false;
  if TMDIChild(MainForm.ActiveMDIChild).gDicomData.allocbits_per_pixel <= 8 then begin
     HidePreciseBtn.visible := true;
     WinWidEdit.visible := false;
     WinCenEdit.visible := false;
  end else begin
     HidePreciseBtn.visible := false;
     WinWidEdit.visible := true;
     WinCenEdit.visible := true;
  end;
  if TMDIChild(MainForm.ActiveMDIChild).gDicomdata.XYZdim[3] < 2 then begin
     SliceLabel.visible := false;
     SliceSlider.visible := false;
  end else begin
      SliceSlider.visible := true;
      SliceLabel.visible := true;
      SliceSlider.Max := TMDIChild(MainForm.ActiveMDIChild).gDICOMdata.XYZdim[3];
  end;
  SliceSlider.position := TMDIChild(MainForm.ActiveMDIChild).gSlice;
  SchemeDrop.ItemIndex := TMDIChild(MainForm.ActiveMDIChild).gScheme;
  ScaleDrop.ItemIndex := TMDIChild(MainForm.ActiveMDIChild).gScale;
  if TMDIChild(MainForm.ActiveMDIChild).gDICOMdata.XYZmm[1] <>  TMDIChild(MainForm.ActiveMDIChild).gDICOMdata.XYZmm[2] then begin
     ProDrop.ItemIndex := TMDIChild(MainForm.ActiveMDIChild).gPro;
      ProDrop.visible := true;
  end else
      ProDrop.visible := false;
  WhiteSlide.Position := TMDIChild(MainForm.ActiveMDIChild).gWhite;
  BlackSlide.Position := TMDIChild(MainForm.ActiveMDIChild).gBlack;
  WinCenEdit.value := TMDIChild(MainForm.ActiveMDIChild).gWinCen;
  WinWidEdit.value := TMDIChild(MainForm.ActiveMDIChild).gWinWid;
  ShowPreciseDetails;
  gColAbort := false;
end;
procedure TColorSettingsDlg.FormShow(Sender: TObject);
begin
     ColorSettingsDlg.left := MainForm.Left+30;
     ColorSettingsDlg.top := MainForm.top+30;

     ColUpdate;
end;

procedure TColorSettingsDlg.SchemeDropChange(Sender: TObject);
begin
     if gColAbort then exit;
     TMDIChild(MainForm.ActiveMDIChild).updatepalette(WhiteSlide.position,BlackSlide.position,SchemeDrop.itemindex);
end;

procedure TColorSettingsDlg.ProDropChange(Sender: TObject);
var lYRatio: extended;
begin
 if gColAbort then exit;
 //showmessage(floattostr(gDICOMdata.XYZmm[1]));
 TMDIChild(MainForm.ActiveMDIChild).Image.ZoomFactor := (ScaleDrop.itemindex+1)/2;
 TMDIChild(MainForm.ActiveMDIChild).gPro := ProDrop.itemindex;
 TMDIChild(MainForm.ActiveMDIChild).gScale := ScaleDrop.ItemIndex;
 begin //square or proportional voxels
      if TMDIChild(MainForm.ActiveMDIChild).gDICOMdata.XYZmm[1] <> 0 then
           lYRatio := TMDIChild(MainForm.ActiveMDIChild).gDICOMdata.XYZmm[2]/TMDIChild(MainForm.ActiveMDIChild).gDICOMdata.XYZmm[1]
        else
            lYRatio := 1;
       if (ProDrop.itemindex = 0) or (lYRatio = 1) then begin
          TMDIChild(MainForm.ActiveMDIChild).Image.Align := alClient;
          TMDIChild(MainForm.ActiveMDIChild).Image.Stretch := sZoomKAR;
          TMDIChild(MainForm.ActiveMDIChild).Image.Refresh;
       end else begin
        TMDIChild(MainForm.ActiveMDIChild).Image.Align := alNone;
        TMDIChild(MainForm.ActiveMDIChild).Image.Stretch := sAlways;
        TMDIChild(MainForm.ActiveMDIChild).Image.width := round(TMDIChild(MainForm.ActiveMDIChild).Image.PixelGraphic.Width *TMDIChild(MainForm.ActiveMDIChild).Image.ZoomFactor);
        TMDIChild(MainForm.ActiveMDIChild).image.height := round(TMDIChild(MainForm.ActiveMDIChild).Image.PixelGraphic.Height*lYratio*TMDIChild(MainForm.ActiveMDIChild).Image.ZoomFactor);
        TMDIChild(MainForm.ActiveMDIChild).Image.ActionMode:=amMoveImage;
        TMDIChild(MainForm.ActiveMDIChild).Image.ActionMode:=amNone;
          TMDIChild(MainForm.ActiveMDIChild).Image.Refresh;
       end; //proportional

      end;
end;

procedure TColorSettingsDlg.ApplyPreciseClick(Sender: TObject);
begin
     if not gColAbort then
     if (sender as TSpeedButton).tag = 1 then //full range
        WinWidEdit.Value := 0;
     if (sender as TSpeedButton).tag = 2 then begin //use file defaults
        WinCenEdit.value := TMDIChild(MainForm.ActiveMDIChild).gDICOMdata.WindowCenter;
        WinWidEdit.value := TMDIChild(MainForm.ActiveMDIChild).gDICOMdata.WindowWidth;
     end;
     TMDIChild(MainForm.ActiveMDIChild).DisplayImage(false,SliceSlider.position,WinWidEdit.value,WincenEdit.value,SchemeDrop.itemindex);
     ApplyPrecise.visible := false;
     ShowPreciseDetails;
end;
procedure TColorSettingsDlg.WinWidEditChange(Sender: TObject);
begin
    ApplyPrecise.visible := true;
end;

end.
