//****************************************************************************//
//**** UNITE ANIMATION GRAPHIQUE : EXERCICES D'UTILISATION DE LA DIBULTRA ****//
//****************************************************************************//
//                                                                            //
// Copyright (C) 1/1999 LEON Sbastien                                        //
//                                                                            //
//----------------------------------------------------------------------------//
//                                                                            //
// Ce programme est "libre", vous pouvez le redistribuer et/ou le modifier    //
// selon les termes de la LICENCE PUBLIQUE GENERALE GNU publie par la        //
// Free Software Foundation version 2.                                        //
//                                                                            //
// This unit is distribued under the terms of the GPL. You can read the       //
// terms of this licence in the "GPL.html" file given with this unit.         //
//                                                                            //
// Ce programme est distribu car potentiellement utile, mais SANS AUCUNE     //
// GARANTIE, ni explicite ni implicite, y compris les garanties de            //
// commercialisation ou d'adaptation dans un but spcifique.                  //
// Reportez-vous  la Licence Publique Gnrale GNU pour plus de dtails.     //
//                                                                            //
// Vous devez avoir reu une copie de la Licence Publique Gnrale GNU        //
// en mme temps que ce programme("gpl.html").                                //
// si ce n'est pas le cas, crivez  la :                                     //
// Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA     //
// 02111-1307, tats-Unis.                                                    //
//                                                                            //
//----------------------------------------------------------------------------//
//                                                                            //
// This program is free software; you can redistribute it and/or modify it    //
// under the terms of the GNU General Public License as published by the      //
// Free Software Foundation; either version 2 of the License, or (at your     //
// option) any later version. This program is distributed in the hope that    //
// it will be useful, but WITHOUT ANY WARRANTY; without even the implied      //
// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  //
// GNU General Public License for more details.                               //
//                                                                            //
// You should have received a copy of the GNU General Public License          //
// along with this program; if not, write to the Free Software Foundation,    //
// Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.            //
//                                                                            //
//                                                                            //
//****************************************************************************//
//                                                                            //
// DISCLAIMER OF WARRANTY :                                                   //
//                                                                            //
//   BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY     //
// FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN   //
// OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES     //
// PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED //
// OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF       //
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS  //
// TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE     //
// PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,   //
// REPAIR OR CORRECTION.                                                      //
//                                                                            //
//   IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING    //
// WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR        //
// REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, //
// INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING//
// OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED  //
// TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY   //
// YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER //
// PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE      //
// POSSIBILITY OF SUCH DAMAGES.                                               //
//                                                                            //
//****************************************************************************//

unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, DIBUltra, DIBType, TimerRX;

type
  TBoard = class(TForm)
    msg: TPanel;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormClick(Sender: TObject);
  private
    DIB : TDIBUltra;
    Timer : TRxTimer;
    procedure WMEraseBkgnd(var m: TWMEraseBkgnd); message WM_ERASEBKGND;
    procedure DrawingNextImage(Sender : TObject);
    { Dclarations prives }
  public
    { Dclarations publiques }
  end;

const
  MaxSin = $FF;
  Max2Sin= $1FF;
  nbC    = 11;
  TmInter= 25;

var
  Board: TBoard;
  Sine : array [0..MaxSin] of Integer;

  d : array [0..nbC] of Integer; // Dphasage entre les courbes
  H : array [0..nbC] of Integer; // Hauteur relative des courbes (255 = hauteur max)
  c : array [0..nbC] of Integer; // couleurs indexes des courbes
  Z : array [0..nbC] of Integer; // Sens et amplitude du mouvement
  W : array [0..nbC] of Integer; // Largeur de trait des courbes
  T : array [0..nbC] of LongInt; // Style des traits

  Cl: array [0..236] of Integer; // Index des couleurs indexes

implementation

{$R *.DFM}

// From TBitmap example : WinHelp of Delphi (Borland)
// comme toute la fiche va tre dessine, la gestion de ce message
// vite les raffichages inutiles de l'arrire-plan
// qui peuvent provoquer des sautillements.
procedure TBoard.WMEraseBkgnd(var m : TWMEraseBkgnd);
begin
  m.Result := LRESULT(False);
end;

procedure TBoard.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  DIB.Free;
  Timer.Free;
end;

const Style : array [0..10] of LongInt = (
              DUpsSolid, DUpsDot,DUpsDotDot,DUpsDash,
              DUpsLongDash,DUpsHugeDash,DUpsDoubleDash,
              DUpsDashDot,DUpsDashDotDot,DUpsIncDec,DUpsIncDec2);

procedure TBoard.FormCreate(Sender: TObject);
var
  n : integer ;
begin
  Timer := TRXTimer.Create(Self);
  Timer.enabled  := False;
  Timer.Interval := TmInter;
  Timer.OnTimer  := DrawingNextImage;

  DIB   := TDIBUltra.Create(Board.Width, Board.Height, DUpf8, @PaletteToAnimate8Bits);
  DIB.BrushColor := ClNavy;
  DIB.GDIStyle := True;

  // Init of Sinus table :
  For n := 0 to MaxSin Do Sine[n] := Round( 65535 * sin( 2*PI*n/(MaxSin+1)) );

  // Init of animation values
  For N := 0 to nbC Do Begin
    d[N] := random(MaxSin+1);
    H[N] := random(128+64)+64;
    c[N] := random(236) ;
    Z[N] := 2 * ((N MOD 5)-2) ; If (Z[N]=0) Then Z[N]:= 2;
    W[N] := (N MOD 3) + 1;
    T[N] := Style[N];
  End;
  For N := 0 to 236 Do Cl[N] := N + 10; // Index de couleur
  Timer.Enabled := True;
end;

procedure TBoard.FormPaint(Sender: TObject);
begin
  // Test dimensions
  DIB.BufferDim(Board.Width, Board.Height);
  // Test last user / Test du dernier utilisateur
  If Not DIB.BufferOf(Board) Then
  Begin
    // Draw on buffer only if it is useful
    DrawingNextImage(Self);
    Exit;
  End;
  // BitBlit on PaintBox1.Canvas
  DIB.DrawOn(Board.ClientRect,Board.Canvas,0,0);
end;

var BkgCl : integer = 0;
Procedure TBoard.DrawingNextImage(Sender : TObject);
Type
  Tadr = array [0..0] of LongInt;
var
  deltaY, deltaX : integer;
  x,y, Val, Cb   : integer;
  Adr            : ^Tadr;
Begin
  deltaX := Self.ClientWidth;
  deltaY := (Self.ClientHeight - msg.Height) div 2;
  BkgCl := (BkgCl + 2) MOD 236;

  For Y := 0 to (Self.ClientHeight - msg.Height -1) Do Begin
    Adr := DIB.ScanLine[Y];
    Cb  := (BkgCl+Y div 2) MOD 236; // The color Index
    Val := Cl[Cb]+Cl[Cb] SHL 8;
    Val := Val + Val SHL 16; // J'attaque un peu dlicat (accs direct DIB)
    For X := 0 to (Self.ClientWidth div 4) Do Adr^[X] := Val;
  End;

  For Cb := 0 To NbC Do Begin
    DIB.PenWidth := W[Cb];
    DIB.PenColorIndex := Cl[c[Cb]];
    DIB.PenStyle := T[Cb];
    DIB.RotateStyle(BkgCl * Z[Cb]);
    DIB.MoveTo(0,DeltaY + ((Sine[(d[Cb]) AND MaxSin] * H[Cb]) div $100 * DeltaY) div $10000);
    For x := 0 to deltaX Do Begin
      DIB.LineTo(x,DeltaY + ((Sine[(x+d[Cb]) AND MaxSin] * H[Cb]) div $100 * DeltaY) div $10000);
    End;
    d[Cb] := (d[Cb]+Z[Cb]) AND MaxSin;
    c[Cb] := (c[Cb]+Abs(Z[Cb])) MOD 236;
  End;
  // Affichage de la DIB
  DIB.DrawOn(Board.ClientRect,Board.Canvas,0,0);
End;

procedure TBoard.FormResize(Sender: TObject);
begin
  DIB.BufferToUpdate;
  FormPaint(Self);
end;

procedure TBoard.FormClick(Sender: TObject);
begin
  Timer.Enabled := Not Timer.Enabled;
end;

End.
