unit Prev;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DIBUltra, DIBType, ExtCtrls;

type
  TPreview = class(TForm)
    Time: TTimer;
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormPaint(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure TimeTimer(Sender: TObject);
    procedure Panel3MouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure Panel3MouseUp(Sender: TObject; Button: TMouseButton;   Shift: TShiftState; X, Y: Integer);
    procedure Panel2MouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure Panel2MouseUp(Sender: TObject; Button: TMouseButton;   Shift: TShiftState; X, Y: Integer);
  private
    { Dclarations prives }
    Tmp  : TDIBUltra;
    Fond : TDIBUltra;
    Img  : TDIBUltra;
    ModeUni : Boolean;
  public
    { Dclarations publiques }
    FileStr : String;
  end;

var
  Preview: TPreview;

implementation

{$R *.DFM}

{$R IMAGE.RES}

procedure TPreview.FormShow(Sender: TObject);
begin
  If (Tmp<>nil) Then Tmp.Free; // Normalement impossible;
  Tmp := nil;
  Tmp := TDIBUltra.CreateFromFile(FileStr);
  If (Tmp=nil) Then Begin
    ShowMessage('Image invalide !');
    Exit;
  End Else If Not(DUtAlpha in Tmp.Status) Then Begin
    ShowMessage('Cette image ne supporte pas un MultiChanel Alpha !');
    Tmp.free; Tmp := nil;
    Exit;
  End;
  Self.ClientWidth  := Tmp.Width;
  Self.ClientHeight := Tmp.Height + Panel1.Height;
  If (Fond<>nil) Then Fond.Free;
  Fond := TDIBUltra.Create(Tmp.Width, Tmp.Height, DUpf16, nil);
  ModeUni := True;
  Time.Enabled := True;
end;

procedure TPreview.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Time.Enabled := False;
  Tmp.Free;
  Fond.Free;
  Tmp  := nil;
  Fond := nil;
end;

procedure TPreview.FormPaint(Sender: TObject);
begin
  If (Tmp=nil) Then Begin ModalResult := mrOK; Exit End;
  If ModeUni Then
    Fond.ClearAll
  Else
    Img.TiledOn(Rect(0,0,Fond.Width-1,Fond.Height-1),Fond.Canvas);
  Tmp.AlphaChanelBlit(Fond,0,0,1);
  Canvas.CopyRect(ClientRect,Fond.Canvas,ClientRect);
end;

procedure TPreview.FormCreate(Sender: TObject);
begin
  Tmp  := nil;
  Fond := nil;
end;

var Num : byte = 10;
procedure TPreview.TimeTimer(Sender: TObject);
begin
  If (Tmp=nil) Then Begin Time.Enabled := False; Exit End;
  With PaletteToAnimate8Bits.palPalEntry[Num] Do
    Fond.BrushColor := peRed shl 16 + peGreen shl 08 + peBlue  ;
  Inc(Num); If (Num=246) Then Num := 10; // Palette circulaire des couleurs
  FormPaint(Self);
end;

procedure TPreview.Panel3MouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  If (ModeUni) Then Exit;
  Panel3.BevelOuter := bvLowered;
  Panel3.BevelOuter := bvLowered;
  ModeUni           := True;
  Time.Enabled      := True;
  Img.Free;
end;

procedure TPreview.Panel3MouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  Panel3.BevelOuter := bvRaised;
  Panel3.BevelOuter := bvRaised;
end;

procedure TPreview.Panel2MouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  If Not(ModeUni) Then Exit;
  Panel2.BevelOuter := bvLowered;
  Panel2.BevelOuter := bvLowered;
  ModeUni           := False;
  Time.Enabled      := False;
  Img := TDIBUltra.CreateFromResourceName(HInstance, 'image');
  FormPaint(Self);
end;

procedure TPreview.Panel2MouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  Panel2.BevelOuter := bvRaised;
  Panel2.BevelOuter := bvRaised;
end;

end.
