unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, ComCtrls,
  DIBUltra, DIBType;

type
  TForm1 = class(TForm)
    MotifButton  : TBitBtn;
    MaskButton   : TBitBtn;
    UnMaskButton : TBitBtn;
    ProcessButton: TBitBtn;
    TestButton   : TBitBtn;
    BitBtn1      : TBitBtn;
    BitBtn2      : TBitBtn;
    Panel1       : TPanel;
    Panel2       : TPanel;
    Panel3       : TPanel;
    Open         : TOpenDialog;
    Tab1         : TTabControl;
    TabControl2  : TTabControl;
    StaticText1  : TLabel;
    StaticText2  : TLabel;
    StaticText3  : TLabel;
    StaticText4  : TLabel;
    StaticText6  : TLabel;
    StaticText5  : TLabel;
    StaticText7  : TLabel;
    StaticText8  : TLabel;
    Motif        : TPaintBox;
    Masque       : TPaintBox;
    Strech       : TCheckBox;
    PrevButton: TBitBtn;
    procedure MotifButtonClick(Sender: TObject);
    procedure MaskButtonClick(Sender: TObject);
    procedure ProcessButtonClick(Sender: TObject);
    procedure TestButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure MotifPaint(Sender: TObject);
    procedure MasquePaint(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure PrevButtonClick(Sender: TObject);
  private
    { Dclarations prives }
    MotifBt  : TDIBUltra;
    MasqueBt : TDIBUltra;
    Rct      : TRect;
    MotifOK  : Boolean;
    MasqueOK : Boolean;
    Executed : Boolean;
  public
    { Dclarations publiques }
    MotifPath: String;
  end;

var
  Form1: TForm1;

implementation

uses Prev;

{$R *.DFM}

procedure TForm1.MotifButtonClick(Sender: TObject);
begin
  If (MotifBt<>nil) Then Begin MotifBt.Free; MotifBt := nil End;
  Open.InitialDir := ExtractFileDir(Application.ExeName)+'\..';
  If (Not Open.execute) Then Exit;
  MotifPath := Open.FileName;
  MotifBt := TDIBUltra.CreateFromFile(MotifPath);
  Motif.Repaint;
  // Bad Pixel Format
  If (MotifBt.PixelFormat <> DUpf8) Then
  Begin
    motifOK :=False;
    MotifBt.Free; MotifBt := nil;
    Raise Exception.Create('L''image du motif doit tre enregistre en 256 couleurs.');
  End;
  motifOK := True;
  MaskButton.Enabled := True;
end;

procedure TForm1.MaskButtonClick(Sender: TObject);
begin
  If (Not motifOK) Then Exit;
  If (MasqueBt<>nil) Then Begin MasqueBt.Free; MasqueBt := nil End;
  If (Not Open.execute) Then Exit;
  MasqueBt := TDIBUltra.CreateFromFile(Open.FileName);
  // Bad Pixel Format
  If (MasqueBt.PixelFormat <> DUpf8) Then
  Begin
    masqueOK :=False;
    MasqueBt.Free; MasqueBt := nil;
    Masque.Repaint;
    Raise Exception.Create('L''image du masque doit tre enregistre en 256 niveaux de gris (index 256 couleurs).');
  End;
  // Bad dimensions
  If (MasqueBt.width  <> MotifBt.width)  AND
     (MasqueBt.height <> MotifBt.height) Then
  Begin
    masqueOK :=False;
    MasqueBt.Free; MasqueBt := nil;
    Masque.Repaint;
    Raise Exception.Create('L''image du masque doit tre de mme dimensions que le motif !');
  End;
  Masque.Repaint;
  masqueOK := True;
  UnMaskButton.Enabled := True;
  ProcessButton.Enabled := True;
end;

const
  fAlphaDIB  = $4DFD; // Identifiant d'une UltraDIB compresse avec couche alpha accole
  fUltraDIB  = $4DFE; // Identifiant d'une UltraDIB compresse
  fAlphaInfo = $A6;

procedure TForm1.ProcessButtonClick(Sender: TObject);
Begin
  MotifBt.SetAlphaMask(MasqueBt,1,0);
  MotifPath := Copy(MotifPath,0,Length(MotifPath)-3)+'udc';
  MotifBt.SaveToFile(MotifPath,DUsmDIBUltra,DUpf16);
  Executed := True;
  MaskButton.Enabled    := False;
  MotifButton.Enabled   := False;
  UnMaskButton.Enabled  := True;
  TestButton.Enabled    := True;
  ProcessButton.Enabled := False;
End;

procedure TForm1.TestButtonClick(Sender: TObject);
begin
  If Not Executed Then Exit;
  Preview.FileStr := MotifPath;
  Preview.ShowModal;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Rct                   := Rect(0,0,Motif.Width-1, Motif.Height-1);
  MotifOK               := False;
  MasqueOK              := False;
  Executed              := False;
  MotifBt               := nil;
  MasqueBt              := nil;
  TestButton.Enabled    := False;
  ProcessButton.Enabled := False;
  MaskButton.Enabled    := False;
  MotifButton.Enabled   := True;
  Motif.Repaint;
  Masque.Repaint;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
  MotifBt.Free;
  MasqueBt.Free;
  FormCreate(Self);
End;

procedure TForm1.MotifPaint(Sender: TObject);
begin
  If (MotifBt<>nil) Then Motif.Canvas.CopyRect(Rct,MotifBt.Canvas,Rct);
end;

procedure TForm1.MasquePaint(Sender: TObject);
begin
  If (MasqueBt<>nil) Then Masque.Canvas.CopyRect(Rct,MasqueBt.Canvas,Rct);
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
  Application.Terminate;
end;

procedure TForm1.PrevButtonClick(Sender: TObject);
begin
  Open.InitialDir := ExtractFileDir(Application.ExeName)+'\..';
  If Not (Open.Execute) Then Exit;
  Preview.FileStr := Open.FileName;
  Preview.ShowModal;
end;

end.
