unit demoForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  DIBUltra, DIBType, ExtCtrls;

type
  TForm1 = class(TForm)
    Timer1: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Dclarations prives }
    Motif : TDIBUltra; // Remplie par le motif
    Dest  : TDIBUltra; // Utilise pour placer le fond
    Fond  : TDIBUltra;
    Rct   : TRect;
    PosX  : Integer;
  public
    { Dclarations publiques }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

const Pl = 2;

procedure TForm1.FormCreate(Sender: TObject);
var
  Bt : TBitmap;
  R  : TRect;
begin
  Bt           := TBitmap.Create;
  Bt.LoadFromFile('..\Fond.bmp');
  R            := Rect(0,0,Bt.Width, Bt.Height);
  Fond         := TDIBUltra.Create(Bt.Width, Bt.Height, DUpf16, nil);
  Fond.Canvas.CopyRect(R,Bt.Canvas,R);
  Bt.Free;
  ClientWidth  := Fond.Width;
  ClientHeight := Fond.Height;
  PosX         := ClientHeight;
  Rct          := ClientRect; InflateRect(Rct,Pl,Pl);
  Motif        := TDIBUltra.CreateFromFile('..\Motif.udc'); // Remplie par le motif
  Dest         := TDIBUltra.Create(Motif.Width, Motif.Height+Pl, DUpf16, nil); // Utilise pour placer le fond
  Timer1.Enabled := True;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  Fond.Free;
  Motif.Free;
  Dest.Free;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
  Fond.DrawOn(ClientRect, Canvas, 0,0);
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var
  RctD  : TRect;
  T1,T2 : LongInt;
begin
  Try
    RctD := Rct; OffsetRect(RctD,5,PosX);
    // On rcupre le fond InflateRect
    Dest.Canvas.CopyRect(Rct,Fond.Canvas,RctD);
    // On ajoute le motif, couche Alpha numro 1, par Alpha Blending
    T1 := GetTickCount; Motif.AlphaChanelBlit(Dest,0,0,1); T2 := GetTickCount;
    // On repose l'image
    Canvas.CopyRect(RctD,Dest.Canvas,Rct);
    Caption := 'AlphaBlit : '+IntToStr(T2-T1)+'ms.';
    Dec(PosX,Pl); If (PosX<(-ClientHeight)) Then PosX := ClientHeight;
  Except
    Timer1.Enabled := False;
  End;
end;

end.
