unit Palunit;
              
interface

// Most of this code is not useful, I used it under BPW and it is left
// here for one project I use it for, you can safely delete it.

uses Windows, SysUtils, Classes, Graphics, Forms, Dialogs,
     Controls, Buttons, StdCtrls, FileCtrl, ExtCtrls, ComCtrls;

type
  TPalette_dlg = class(TForm)
    OKBtn        : TButton;
    CancelBtn    : TButton;
    Bevel1       : TBevel;
    Palette_List: TListBox;
    procedure FormCreate(Sender:TObject);
  end;

type
  palentries   = array[0..255] of TPaletteEntry;
  palindices   = array[0..255] of word;
  RGBQuads     = array[0..255] of TRGBQUAD;

type
  pMyBitmapInfo  = ^TMyBitmapInfo;
  TMyBitmapInfo  = record
    BMIheader   : TBITMAPINFOHEADER;
    BMIcolors   : palindices;
  end;

type
  TMyLogPalette = record
    palVersion    : Word;
    palNumEntries : Word;
    palEntry      : palentries;
  end;

type
  pen_array   = array[  0..255] of HPen;
  xpen_array  = array[-10..245] of HPen;
  pPens       = ^xpen_array;

procedure create_256_identity_palette_from_file(var pal:TMyLogPalette; var Hpal:HPalette; filename:shortstring);
procedure create_256_pens_from_palette(hpal:HPalette; pal:TMyLogPalette; var pens:pen_array; style:integer);
procedure dispose_256_pens(pens:pen_array);
procedure LogPal_to_RGBQuad(f,n:word; var logpal:palentries; var RGBQuad:RGBQuads);
procedure find_all_palettes(destlist:TStringList);

// the global variables here are useful.
var
  Palette_dlg   : TPalette_dlg;
  Palette_Dir   : string;
// You may need these
  pal_colours   : integer;
  pal_coloursm1 : integer;
// these two are the important ones
  hpalApp       : HPalette;
  App_Palette   : TMyLogPalette;

implementation

{$R *.DFM}

procedure TPalette_dlg.FormCreate(Sender: TObject);
begin
  find_all_palettes(TStringList(Palette_List.Items));
end;

procedure create_256_identity_palette_from_file(var pal:TMyLogPalette;var Hpal:HPalette; filename:shortstring);
var screen        : hDC;
    pal_cols      : integer;
    lp1,lp2,c1,c2 : Integer;
    f             : text;
    instr,substr  : shortstring;
    r_g_b         : array[1..3] of integer;
    pal_name      : string;
begin
  if extractfilepath(filename)='' then pal_name := Palette_Dir+filename
  else pal_name:=filename;
  if not fileexists(pal_name) then begin
    Showmessage(pal_name+#13'Palette file not found');
    exit;
  end;
  assign(f,pal_name); reset(f); readln(f,pal_cols);
  if pal_cols>236 then pal_colours := 236
  else                 pal_colours := pal_cols;
  pal_coloursm1     := pal_colours-1;
  pal.palVersion    := $0300;
  pal.palNumEntries := 256;

  Screen            := GetDC(0);
  GetSystemPaletteEntries(Screen,0  ,10,pal.palEntry);
  GetSystemPaletteEntries(Screen,246,10,pal.palEntry[246]);
  ReleaseDC(0,Screen);

  for lp1:=0 to pal_coloursm1 do begin
    readln(f,instr); c1:=1;
    for lp2:=1 to 3 do begin
      c2:=1;
      while (instr[c1]=' ') do inc(c1);
      while (instr[c1]<>' ') and (c1<=length(instr)) do begin
        substr[c2]:=instr[c1];
        inc(c1); inc(c2);
      end;
      substr[0]:=chr(c2-1);
      val(substr,r_g_b[lp2],c2);
    end;
    pal.palEntry[10+lp1].peFlags := pc_Reserved;
    pal.palEntry[10+lp1].peRed   := r_g_b[1];
    pal.palEntry[10+lp1].peGreen := r_g_b[2];
    pal.palEntry[10+lp1].peBlue  := r_g_b[3];
  end;
  if pal_coloursm1<235 then for lp1:=pal_colours to 235 do begin
    pal.palEntry[10+lp1].peFlags := pc_Reserved;
    pal.palEntry[10+lp1].peRed   := pal.palEntry[10+lp1-pal_colours].peRed;
    pal.palEntry[10+lp1].peGreen := pal.palEntry[10+lp1-pal_colours].peGreen;
    pal.palEntry[10+lp1].peBlue  := pal.palEntry[10+lp1-pal_colours].peBlue;
  end;
  if (Hpal<>0) then DeleteObject(Hpal);
  Hpal := CreatePalette(PLogPalette(@pal)^);
  close(f);
end;

{ ============================================================ }
{ I used to use this code in BPW7.0 - left here for usefulness }

procedure create_256_pens_from_palette(hpal:HPalette; pal:TMyLogPalette; var pens:pen_array; style:integer);
var lp1 : integer;
    adc : hDC;
begin
  adc := GetDC(0);
  SelectPalette(adc,hpal,false);
  RealizePalette(adc);
  ReleaseDC(0,adc);
  for lp1:=0 to 255 do with pal.palEntry[lp1] do begin
    if style=0 then pens[lp1]:=CreatePen(PS_SOLID,1,RGB(peRed,peGreen,peBlue){paletteindex(lp1)});
    if style=1 then pens[lp1]:=CreatePen(PS_DOT  ,1,paletteindex(lp1));
    if pens[lp1]=0 then begin
      messageBox(0,'Caution : Error creating pens'#13'Windows may be low on resources !!!',
      'GDI cockup',mb_ok);
      postquitmessage(0); exit;
    end;
  end;
end;

procedure dispose_256_pens(pens:pen_array);
var lp1 : integer;
begin
  for lp1:=0 to 255 do DeleteObject(pens[lp1]);
end;

procedure LogPal_to_RGBQuad(f,n:word; var logpal:palentries; var RGBQuad:RGBQuads);
var lp1 : integer;
begin
  for lp1:=f to (f+n-1) do begin
    RGBQuad[lp1].rgbRed      := logpal[lp1].peRed;
    RGBQuad[lp1].rgbGreen    := logpal[lp1].peGreen;
    RGBQuad[lp1].rgbBlue     := logpal[lp1].peBlue;
    RGBQuad[lp1].rgbReserved := logpal[lp1].peFlags;
  end;
end;

procedure find_all_palettes(destlist:TStringList);
var fullname  : string;
    F         : TSearchRec;
    i         : integer;
begin // fills a TStringlist with palettes - useful for listboxes
  fullname:=palette_dir+'*.pal';
  i := FindFirst(fullname,faAnyFile,F);
  if i<>0 then exit;
  while i=0 do begin
    if (F.Attr and faDirectory)<>0 then begin
    end
    else begin
      destlist.Add(UpperCase(F.name));
    end;
    i := FindNext(F);
  end;
  FindClose(F);
end;

begin
  Palette_Dir   := ExtractFilePath(Application.ExeName)+'\palette\';
  { insert a different diectory here if you want }
end.

