unit DIB_surf;

interface

uses
  { Borland }
  Windows,Sysutils,Graphics,Classes,
  { Mine }
  Palunit;

type
  Pshape = ^shape;
  shape  = array[0..255] of Tpoint;

type
  DIBsurfaceobject = Class(TObject)
    DIBheader    : TMyBitmapInfo;
    DIBPalette   : TMyLogPalette;
    DIBhpalette  : hPalette;
    DIBpalsize   : integer;
    DIBbits      : Pointer;
    DIBhandle    : THandle;
    DIBDC        : hDC;
    Original_BMP : hBitmap;
    Original_PAL : hPalette;
    DIBWidth     : integer;
    DIBHeight    : integer;
    DIBWidth_b   : integer;
    DIBSize      : integer;
    constructor Create(palette:TMyLogPalette; newsize:TPoint);
    destructor  destroy;  override;
    procedure   change_size(newsize:TPoint; force:boolean);
    procedure   change_palette(palette:TMyLogPalette);

    procedure   copy_surface_to_screen(destDC:hDC);
    procedure   copy_screen_to_surface(sourceDC:hDC);
    procedure   clear_surface;
    procedure   set_pixel(x,y:integer; b:byte);
    procedure   safe_set_pixel(x,y:integer; b:byte);

    { fast(ish) utility routines }
    procedure   draw_line(x1,y1,x2,y2:integer; b:byte);
    procedure   draw_horizontal_line(x1,x2,y:integer; b:byte);
    procedure   draw_vertical_line(x,y1,y2:integer; b:byte);
    procedure   fill_polygon(n:integer; poly:Pshape; fillcol:byte);
  end;

implementation

{ ------------------------------------------------------------------------ }
{                             DIB surface object                           }
{ ------------------------------------------------------------------------ }
constructor DIBsurfaceobject.Create(palette:TMyLogPalette; newsize:TPoint);
var lp1 : integer;
begin
  inherited Create;
  DIBbits      := nil;
  DIBhandle    := 0;
  DIBPalette   := palette;
  DIBhpalette  := CreatePalette(PLogPalette(@palette)^);
  DIBDC        := CreateCompatibleDC(0);
  Original_PAL := SelectPalette(DIBDC,DIBhpalette,false);
  with DIBheader do begin
    with bmiHeader do begin
      biSize          := sizeof(TBITMAPINFOHEADER);
      biWidth         := newsize.x;
      biHeight        := newsize.y;
      biPlanes        := 1;
      biBitCount      := 8;
      biCompression   := BI_RGB;
      biSizeImage     := 0;
      biXPelsPerMeter := 0;
      biYPelsPerMeter := 0;
      biClrUsed       := 0;
      biClrImportant  := 0;
    end;
    for lp1:=0 to 255 do BMIcolors[lp1] := (lp1+0) and 255; { pal_indices }
// makes palette mapped from 10->235 (0-9 and 236->255 reserved for system)
// use lp1+10 to map 0->235, but then 0 isn't black any more :(
  end;
  Original_BMP := 0;
  DIBWidth     := 0;
  DIBHeight    := 0;
  change_size(newsize,false);
end;

destructor DIBsurfaceobject.destroy;
begin
  if Original_BMP<>0 then SelectObject(DIBDC,Original_BMP);
  if Original_PAL<>0 then SelectPalette(DIBDC,Original_PAL,false);
  if DIBhandle<>0    then DeleteObject(DIBhandle);
  if DIBhpalette<>0  then DeleteObject(DIBhpalette);
  DeleteDC(DIBDC);
  inherited destroy;
end;

procedure DIBsurfaceobject.change_size(newsize:TPoint; force:boolean);
begin
  if (not force) and (newsize.x=DIBWidth) and (newsize.y=DIBHeight) then exit;
  DIBWidth   := newsize.x;
  DIBHeight  := newsize.y;
  DIBWidth_b := ((DIBWidth+3)shr 2)shl 2;
  DIBSize    := DIBWidth_b*DIBHeight;
  if Original_BMP<>0 then SelectObject(DIBDC,Original_BMP);
  if DIBhandle<>0 then DeleteObject(DIBhandle);
  DIBheader.BMIheader.biWidth  := DIBWidth;
  DIBheader.BMIheader.biHeight :=-DIBHeight;  { Top down for me please...}
  { the minus sign may or may not be necessary on your machine - I'm not sure }
  { without it - the DIB is bottom up - See old WinG documentation            }
  DIBhandle    := CreateDIBSection(DIBDC,pBitmapInfo(@DIBheader)^,DIB_PAL_COLORS,DIBbits,nil,0);
  Original_BMP := SelectObject(DIBDC,DIBhandle);
end;

procedure DIBsurfaceobject.change_palette(palette:TMyLogPalette);
var tempRGBQuads : RGBQuads;
begin
  if Original_PAL<>0 then SelectPalette(DIBDC,Original_PAL,false);
  if DIBhpalette<>0  then DeleteObject(DIBhpalette);
  DIBPalette   := palette;
  DIBhpalette  := CreatePalette(PLogPalette(@palette)^);
  LogPal_to_RGBQuad(0,255,DIBpalette.palEntry,tempRGBQuads);
  SetDIBColorTable(DIBDC,0,256,tempRGBQuads);
  Original_PAL := SelectPalette(DIBDC,DIBhpalette,false);
end;

procedure DIBsurfaceobject.copy_surface_to_screen(destDC:hDC);
begin
  SelectPalette(destDC,DIBhpalette,false);
  BitBlt(destDC,0,0,DIBWidth,DIBHeight,DIBDC,0,0,SRCCOPY);
end;

procedure DIBsurfaceobject.copy_screen_to_surface(sourceDC:hDC);
begin
  BitBlt(DIBDC,0,0,DIBWidth,DIBHeight,sourceDC,0,0,SRCCOPY);
end;

procedure DIBsurfaceobject.clear_surface;
var DWORDptr : Plongint;
    lp1      : integer;
begin
  DWORDptr:=DIBbits;
  for lp1:=0 to (DIBsize div 4)-1 do begin
    Plongint(DWORDptr)^:=$00000000;
    inc(DWORDptr); { UNDOCUMENTED - inc(pointer) is 4 bytes not 1 }
  end;
end;

procedure DIBsurfaceobject.set_pixel(x,y:integer; b:byte);
begin
  Pbyte( integer(DIBbits) + y*DIBWidth_b + x )^ := b;
end;

procedure DIBsurfaceobject.safe_set_pixel(x,y:integer; b:byte);
begin
  if (x<DIBWidth) and (x>=0) then begin
    if (y<DIBHeight) and (y>=0) then begin
      Pbyte( integer(DIBbits) + y*DIBWidth_b + x )^ := b;
    end;
  end;
end;

// ***************************************************************8

procedure DIBsurfaceobject.draw_line(x1,y1,x2,y2:integer; b:byte);
var lp1              : integer;
    x,y              : integer;
    dy,dx,step,delta : integer;
begin
  dx:=x2-x1;
  dy:=y2-y1;
  { case nought }
  if (dy=0) and (dx=0) then set_pixel(x1,y1,b)
  { case one }
  else if dy=0 then begin draw_horizontal_line(x1,x2,y1,b); exit; end
  { case two }
  else if dx=0 then begin draw_vertical_line(x1,y1,y2,b); exit; end
  { case three }
  else if (abs(dx)>abs(dy)) then begin
    if dy>0 then begin step:= 1; end
    else         begin step:=-1; dy:=-dy; end;
    delta:=dy div 2;
    if dx>=0 then begin
      y:=y1;
      for lp1:=x1 to x2 do begin
        set_pixel(lp1,y,b); delta:=delta+dy;
        if delta>dx then begin y:=y+step; delta:=delta-dx; end;
      end;
    end
    else begin { dx<0 }
      y:=y2; dx:=-dx; dy:=-dy;
      for lp1:=x2 to x1 do begin
        set_pixel(lp1,y,b); delta:=delta-dy;
        if delta>dx then begin y:=y-step; delta:=delta-dx; end;
      end;
    end;
  end
  else begin  { dy>dx }
    if dx>0 then begin step:= 1; end
    else         begin step:=-1; dx:=-dx; end;
    delta:=dx div 2;
    if dy>=0 then begin
      x:=x1;
      for lp1:=y1 to y2 do begin
        set_pixel(x,lp1,b); delta:=delta+dx;
        if delta>dy then begin x:=x+step; delta:=delta-dy; end;
      end;
    end
    else begin { dy<0 }
      x:=x2; dy:=-dy; dx:=-dx;
      for lp1:=y2 to y1 do begin
        set_pixel(x,lp1,b); delta:=delta-dx;
        if delta>dy then begin x:=x-step; delta:=delta-dy; end;
      end;
    end;
  end;
end;

procedure DIBsurfaceobject.draw_horizontal_line(x1,x2,y:integer; b:byte);
var lp1,offset : integer;
begin
  offset:=integer(DIBbits)+ y*DIBWidth_b;
  if x2>=x1 then for lp1:=offset+x1 to offset+x2 do Pbyte(lp1)^ := b
  else for lp1:=offset+x2 to offset+x1 do Pbyte(lp1)^ := b;
end;

procedure DIBsurfaceobject.draw_vertical_line(x,y1,y2:integer; b:byte);
var lp1,offset : integer;
begin
  if y1<=y2 then begin
    offset := integer(DIBbits)+ y1*DIBWidth_b + x;
    for lp1:=y1 to y2 do begin Pbyte(offset)^ := b; inc(offset,DIBWidth_b); end;
  end
  else begin
    offset := integer(DIBbits)+ y2*DIBWidth_b + x;
    for lp1:=y2 to y1 do begin Pbyte(offset)^ := b; inc(offset,DIBWidth_b); end;
  end;
end;

procedure DIBsurfaceobject.fill_polygon(n:integer; poly:Pshape; fillcol:byte);
var loop1                   : integer;    { very fast - no floating point            }
    yval,ymax,ymin          : integer;    { standard screen pixel scanline algorithm }
    yval0,yval1,yval2,yval3 : integer;
    ydifl,ydifr             : integer;
    xval0,xval1,xval2,xval3 : integer;
    xleft,xright            : integer;
    mu                      : integer;
    minvertex               : integer;
    vert0,vert1,vert2,vert3 : integer;
begin
  ymax:=-999999; ymin:=999999;
  { get top & bottom scan lines to work with }
  for loop1:=0 to n-1 do begin
    yval:=poly^[loop1].y;
    if yval>ymax then ymax:=yval;
    if yval<ymin then begin ymin:=yval; minvertex:=loop1; end;
  end;
  vert0 := minvertex;      vert1 :=(minvertex+1) mod n;
  vert2 := minvertex;      vert3 :=(minvertex-1) mod n;
  yval0 := poly^[vert0].y; yval1 := poly^[vert1].y;
  yval2 := poly^[vert2].y; yval3 := poly^[vert3].y;
  ydifl := yval1-yval0;    ydifr := yval3-yval2;
  xval0 := poly^[vert0].x; xval1 := poly^[vert1].x;
  xval2 := poly^[vert2].x; xval3 := poly^[vert3].x;

  for loop1:=ymin to ymax do begin

    {intersection on left hand side }
    mu:=(loop1-yval0);
    if mu>ydifl then begin
      vert0:=vert1; vert1:=(vert1+1) mod n;
      yval0 := poly^[vert0].y; yval1 := poly^[vert1].y;
      xval0 := poly^[vert0].x; xval1 := poly^[vert1].x;
      ydifl := yval1-yval0;
      mu:=(loop1-yval0)
    end;
    if ydifl<>0 then xleft:=xval0 - (mu*integer(xval0-xval1) div ydifl)
    else             xleft:=xval0;

    {intersection on right hand side }
    if ydifr<>0 then mu:=(loop1-yval2)
    else mu:=ydifr;
    if mu>ydifr then begin
      vert2:=vert3; vert3:=(vert3-1) mod n;
      yval2 := poly^[vert2].y; yval3 := poly^[vert3].y;
      xval2 := poly^[vert2].x; xval3 := poly^[vert3].x;
      ydifr := yval3-yval2;
      if ydifr<>0 then mu:=(loop1-yval2)
      else mu:=ydifr;
    end;
    if ydifr<>0 then xright:=xval2 + (mu*integer(xval3-xval2) div ydifr)
    else             xright:=xval2;
    draw_horizontal_line(xleft,xright,loop1,fillcol);
  end;
end;

initialization
end.

