unit DIB_Form;

interface

uses                   
  { Borland }
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics,
  Forms, Dialogs, Controls, StdCtrls,
  { Mine }
  DIB_Surf, Palunit;

type // use DIBSurfaceForm as a base class instead of TForm
  TDIBSurfaceForm = class(TForm)
    procedure FormResize(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    DIBsurface   : DIBSurfaceObject;
    Original_pal : hPalette;
    win_size     : TPoint;
    destructor  destroy; override;
    procedure   clear_surface;
{                didn't need these after all
    procedure   WMPaletteChanged(var Message: TWMPaletteChanged);   message WM_PaletteChanged;
    procedure   WMQueryNewPalette(var Message: TWMQueryNewPalette); message WM_QueryNewPalette;
}
    function    GetPalette : HPalette; override;
  end;

var
  DIBSurfaceForm : TDIBSurfaceForm;

implementation

{$R *.DFM}

procedure TDIBSurfaceForm.FormCreate(Sender: TObject);
begin
  inherited;
  DIBsurface   := DIBsurfaceobject.Create(App_Palette,Point(4,4));
  Original_pal := SelectPalette(canvas.handle,DIBsurface.DIBhpalette,false);
end;

destructor TDIBSurfaceForm.destroy;
begin
  SelectPalette(canvas.handle,Original_pal,false);
  DIBsurface.Free;
  inherited destroy;
end;

procedure TDIBSurfaceForm.clear_surface;
begin
  DIBsurface.Clear_surface;
  repaint;
end;

procedure TDIBSurfaceForm.FormResize(Sender: TObject);
begin
  inherited;
  win_size := GetClientRect.bottomright;
  DIBsurface.change_size(win_size,false);
  DIBsurface.clear_surface;
  invalidateRect(handle,nil,false);
end;

procedure TDIBSurfaceForm.FormPaint(Sender: TObject);
begin
  DIBsurface.Copy_surface_to_screen(canvas.handle);
end;

{
procedure TDIBSurfaceForm.WMPaletteChanged(var Message: TWMPaletteChanged);
begin
// didn't need this after all...
  inherited;
end;

procedure TDIBSurfaceForm.WMQueryNewPalette(var Message: TWMQueryNewPalette);
begin
// didn't need this after all...
  inherited;
end;
}

{ // didn't realize Delphi provided this for me ! - tut tut }
function TDIBSurfaceForm.GetPalette : HPalette;
begin
  if DIBSurface<>nil then result := DIBsurface.DIBhpalette
  else result := inherited GetPalette;
end;

initialization
end.

