unit DIB_demo;

interface

uses
  { Borland }
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics,
  Forms, StdCtrls, Dialogs, Controls, Spin, ExtCtrls,
  { Mine }
  DIB_Surf, DIB_Form, Palunit;

type
  TDIBDemoForm = class(TDIBSurfaceForm)
    Label1: TLabel;
    Label2: TLabel;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    cycle: TCheckBox;
    SpinEdit1: TSpinEdit;
    syscols: TCheckBox;
    speedbar: TScrollBar;
    Label3: TLabel;
    Label4: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure IdleAction(Sender: TObject; var Done: Boolean);
  end;

var
  DIBDemoForm : TDIBDemoForm;

implementation

{$R *.DFM}

procedure TDIBDemoForm.Button1Click(Sender: TObject);
begin
  if Palette_dlg.ShowModal=mrok then begin
    create_256_identity_palette_from_file(App_Palette,hpalApp,
      Palette_dlg.palette_list.Items[Palette_dlg.palette_list.ItemIndex]);
    DIBsurface.change_palette(App_Palette);
    SelectPalette(canvas.handle,DIBsurface.DIBhpalette,false);
    RealizePalette(canvas.handle);
    repaint;
  end;
end;

{ just a quickie to save time with 4 pointed polygons for demo }
procedure set_polygon_vertices(var poly:Pshape; x1,y1,x2,y2,x3,y3,x4,y4:word);
var lp1 : word;
begin                  { the order of clockwise/anticlockwise is important }
  poly^[0].x:=x1; poly^[0].y:=y1;
  poly^[1].x:=x2; poly^[1].y:=y2;
  poly^[2].x:=x3; poly^[2].y:=y3;
  poly^[3].x:=x4; poly^[3].y:=y4;
  { use anticlockwise coordinates }
end;

procedure TDIBDemoForm.Button2Click(Sender: TObject);
var newpoly : PShape;
    n       : integer;
begin
  n := 4;                 
  Getmem(newpoly,sizeof(TPoint)*n);
  if newpoly=nil then showmessage('error');
  set_polygon_vertices(newpoly,5,300,250,270,300,100,100,150);
  DIBsurface.fill_polygon(n,newpoly,random(236)+10);
  Freemem(newpoly,sizeof(TPoint)*n);
  Dibsurface.copy_surface_to_screen(canvas.handle);
end;

procedure TDIBDemoForm.Button3Click(Sender: TObject);
var lp1 : integer;
begin
  if syscols.checked then for lp1:=0 to Dibsurface.DIBheight-1 do
    Dibsurface.draw_horizontal_line(0,Dibsurface.DIBwidth,lp1,lp1)
  else for lp1:=0 to Dibsurface.DIBheight-1 do
    Dibsurface.draw_horizontal_line(0,Dibsurface.DIBwidth,lp1,(lp1 mod pal_colours)+10);
  Dibsurface.copy_surface_to_screen(canvas.handle);
end;

procedure TDIBDemoForm.Button4Click(Sender: TObject);
var lp1,lp2,col : integer;
    val         : double;
begin
  for lp1:=0 to DIBsurface.DIBwidth-1 do begin
    for lp2:=0 to DIBsurface.DIBHEIGHT-1 do begin
      val := sin(2*pi*lp1/DIBsurface.DIBwidth)*sin(2*pi*lp2/DIBsurface.DIBheight);
      { val is -1->+1 }
      val := ((val+1)/2)*pal_coloursm1 +10;   { 10 -> 236 }
      col := round(val);
      DIBsurface.Set_Pixel(lp1,lp2,col);
    end;
  end;
  Dibsurface.copy_surface_to_screen(canvas.handle);
end;

procedure TDIBDemoForm.Button5Click(Sender: TObject);
var lp1,x1,y1,x2,y2,c : integer;
begin
  x1 := Width div 2;
  y1 := Height div 2;
  for lp1:=0 to 360 do begin
    x2 := x1 + round(100*cos(2*pi*lp1/360));
    y2 := y1 + round(100*sin(2*pi*lp1/360));
    c  := round((lp1/360)*pal_coloursm1)+10;
    DIBsurface.draw_line(x1,y1,x2,y2,c);
  end;
  Dibsurface.copy_surface_to_screen(canvas.handle);
end;

procedure TDIBDemoForm.IdleAction(Sender: TObject; var Done: Boolean);
var adc        : HDC;
    temp,delay : integer;
    anim_pal   : palentries;
begin
  if not cycle.checked then begin done:=true; exit; end;
  temp:=SpinEdit1.value;   // cycle ??? step forwards/backwards
  if temp>pal_colours then temp:=pal_colours;
  GetPaletteEntries(hpalApp,10,pal_colours,anim_pal[10]);
  if temp>0 then begin    // forward cycling
    animatepalette(hpalApp,10,pal_colours-temp,@anim_pal[10+temp]);
    animatepalette(hpalApp,10+pal_colours-temp,temp,@anim_pal[10]);
  end
  else begin temp:=-temp; // reverse cycling
    animatepalette(hpalApp,10+temp,pal_colours-temp,@anim_pal[10]);
    animatepalette(hpalApp,10,temp,@anim_pal[10+pal_colours-temp]);
  end;
  adc := canvas.handle;
  SelectPalette(adc,hpalApp,false);
  RealizePalette(adc);
  done:=false;
  for delay := 0 to speedbar.position*100 do begin
    temp := round(delay*1.0);
    // rough delay because my Pentium pro is very fast and timers are too slow
  end;
end;

initialization
end.


