unit DIB_Form;

interface

uses
  { Borland }
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics,
  Forms, Dialogs,
  { Mine }
  DIB_Surf,Palunit, Controls, StdCtrls;

type
  TDIBSurfaceForm = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Button4: TButton;
    Button5: TButton;
    procedure FormResize(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    DIBsurface   : DIBSurfaceObject;
    Original_pal : hPalette;
    win_size     : TPoint;
    destructor destroy; override;
    procedure  clear_surface;
    procedure  WMPaletteChanged(var Message: TWMPaletteChanged); message WM_PaletteChanged;
    procedure  WMQueryNewPalette(var Message: TWMQueryNewPalette); message WM_QueryNewPalette;
  end;

var
  DIBSurfaceForm : TDIBSurfaceForm;

implementation

{$R *.DFM}

procedure TDIBSurfaceForm.FormCreate(Sender: TObject);
begin
  DIBsurface   := DIBsurfaceobject.Create(App_Palette,win_size);
  Original_pal := SelectPalette(canvas.handle,DIBsurface.DIBhpalette,false);
end;

destructor TDIBSurfaceForm.destroy;
begin
  SelectPalette(canvas.handle,Original_pal,false);
  DIBsurface.Free;
  inherited destroy;
end;

procedure TDIBSurfaceForm.clear_surface;
begin
  DIBsurface.Clear_surface;
  repaint;
end;

procedure TDIBSurfaceForm.FormResize(Sender: TObject);
begin
  win_size := GetClientRect.bottomright;
  DIBsurface.change_size(win_size,false);
  DIBsurface.clear_surface;
  invalidateRect(handle,nil,false);
end;

procedure TDIBSurfaceForm.FormPaint(Sender: TObject);
begin
  SelectPalette(canvas.handle,DIBsurface.DIBhpalette,false);
  Realizepalette(canvas.handle);
  DIBsurface.Copy_surface_to_screen(canvas.handle);
end;

procedure TDIBSurfaceForm.WMPaletteChanged(var Message: TWMPaletteChanged);
begin
  inherited;
end;

procedure TDIBSurfaceForm.WMQueryNewPalette(var Message: TWMQueryNewPalette);
begin
  SelectPalette(canvas.handle,DIBsurface.DIBhpalette,false);
  Realizepalette(canvas.handle);
  inherited;
end;

procedure TDIBSurfaceForm.Button1Click(Sender: TObject);
begin
  if Palette_dlg.ShowModal=mrok then begin
    DIBsurface.change_palette(Palette_dlg.palette_list.Filename);
    repaint;
  end;
end;

{ just a quickie to save time with 4 pointed polygons for demo }
procedure set_polygon_vertices(var poly:Pshape; x1,y1,x2,y2,x3,y3,x4,y4:word);
var lp1 : word;
begin                  { the order of clockwise/anticlockwise is important }
  poly^[0].x:=x1; poly^[0].y:=y1;
  poly^[1].x:=x2; poly^[1].y:=y2;
  poly^[2].x:=x3; poly^[2].y:=y3;
  poly^[3].x:=x4; poly^[3].y:=y4;
  { use anticlockwise coordinates }
end;

procedure TDIBSurfaceForm.Button2Click(Sender: TObject);
var newpoly : PShape;
    n       : integer;
begin
  n := 4;
  Getmem(newpoly,sizeof(TPoint)*n);
  if newpoly=nil then showmessage('error');
  set_polygon_vertices(newpoly,5,300,250,270,300,100,100,150);
  DIBsurface.fill_polygon(n,newpoly,random(236)+10);
  Freemem(newpoly,sizeof(TPoint)*n);
  Dibsurface.copy_surface_to_screen(canvas.handle);
end;

procedure TDIBSurfaceForm.Button3Click(Sender: TObject);
var lp1 : integer;
begin
  for lp1:=0 to Dibsurface.DIBheight-1 do
    Dibsurface.draw_horizontal_line(0,Dibsurface.DIBwidth,lp1,lp1);
  Dibsurface.copy_surface_to_screen(canvas.handle);
end;

procedure TDIBSurfaceForm.Button4Click(Sender: TObject);
var lp1,lp2,col : integer;
    val         : double;
begin
  for lp1:=0 to DIBsurface.DIBwidth-1 do begin
    for lp2:=0 to DIBsurface.DIBHEIGHT-1 do begin
      val := sin(2*pi*lp1/DIBsurface.DIBwidth)*sin(2*pi*lp2/DIBsurface.DIBheight);
      { val is -1->+1 }
      val := ((val+1)/2)*pal_coloursm1 +10;   { 10 -> 236 }
      col := round(val);
      DIBsurface.Set_Pixel(lp1,lp2,col);
    end;
  end;
  Dibsurface.copy_surface_to_screen(canvas.handle);
end;

procedure TDIBSurfaceForm.Button5Click(Sender: TObject);
var lp1,x1,y1,x2,y2,c : integer;
begin
  x1 := Width div 2;
  y1 := Height div 2;
  for lp1:=0 to 360 do begin
    x2 := x1 + round(100*cos(2*pi*lp1/360));
    y2 := y1 + round(100*sin(2*pi*lp1/360));
    c  := round((lp1/360)*pal_coloursm1)+10;
    DIBsurface.draw_line(x1,y1,x2,y2,c);
  end;
  Dibsurface.copy_surface_to_screen(canvas.handle);
end;

initialization
end.



initialization
end.

