unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Grids, Calendar, Buttons, Menus, ExtCtrls, Plan32;

type
  TMainForm = class(TForm)
    Cald: TCalendar;
    SpeedButton2: TSpeedButton;
    PopupMenu1: TPopupMenu;
    AdressBook1: TMenuItem;
    Panel1: TPanel;
    N1: TMenuItem;
    Save1: TMenuItem;
    Print1: TMenuItem;
    Clear1: TMenuItem;
    Panel2: TPanel;
    SpeedButton1: TSpeedButton;
    Panel3: TPanel;
    Planning1: TPlanning;
    procedure FormCreate(Sender: TObject);
    procedure CaldChange(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure AdressBook1Click(Sender: TObject);
    procedure Planning1GetEditText(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure Clear1Click(Sender: TObject);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
begin
Panel1.Caption:= FormatDateTime('dddd d mmmm yyyy', Date);
Planning1.LoadPlanning;
end;

procedure TMainForm.CaldChange(Sender: TObject);
begin
 Planning1.SavePlanning;
 Planning1.Day:=  Cald.Day;
 Planning1.Month:=  Cald.Month;
 Planning1.Year:=  Cald.Year;
 Planning1.ClearPlanning;
 Planning1.LoadPlanning;
 Panel1.Caption:= FormatDateTime('dddd d mmmm yyyy',
                  EncodeDate(Cald.Year,Cald.Month,Cald.Day));
end;

procedure TMainForm.Planning1GetEditText(Sender: TObject);
begin
 Planning1.SavePlanning;
end;

procedure TMainForm.SpeedButton1Click(Sender: TObject);
begin
 Cald.NextMonth;
end;

procedure TMainForm.SpeedButton2Click(Sender: TObject);
begin
 Cald.PrevMonth;
end;

procedure TMainForm.AdressBook1Click(Sender: TObject);
begin
 //Form1.ShowModal;
end;

procedure TMainForm.Save1Click(Sender: TObject);
begin
  Planning1.SavePlanning;
end;

procedure TMainForm.Print1Click(Sender: TObject);
begin
  Planning1.PrintPlanning;
end;

procedure TMainForm.Clear1Click(Sender: TObject);
begin
  Planning1.ClearPlanning;
end;

end.
