unit DGCDispText;

interface

uses
  WinTypes, WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, dsgnIntf, ExtCtrls, DGC, DDraw, Trace;


Const
     CurrVersion = '0.85';
     Author = 'Dani Seelhofer';
     AuthorEmail = 'Dani.Seelhofer@student.unisg.ch';
type
  TAbout = class(TPropertyEditor)
	public
		procedure Edit; override;
		function GetAttributes: TPropertyAttributes; override;
		function GetValue: string; override;
	end;
  TAlignment = (alLeft, alCenter, alRight);
  TDGCDispText = class(TComponent)
  private
    { Private-Deklarationen }
    FAbout: TAbout;
    FScreen: TDGCScreen;
    FDisplayText: String;
    FTransparent: Boolean;
    FYPos: LongInt;
    FAlign: TAlignment;
    FIndent: Integer;

    Dummy: string;

  protected

  public
     TextSurface: TDGCSurface;
     constructor create(AOwner: TComponent);override;
     procedure DisplayText;

  published
    property About: TAbout read FAbout write FAbout;
    property DGCScreen: TDGCScreen read FScreen write FScreen;
    property Output: String read FDisplayText write FDisplayText;
    property Transparent: Boolean read FTransparent write FTransparent;
    property YPos: LongInt read FYPos write FYPos;
    property Align: TAlignment read FAlign write FAlign;
    property Indent: Integer read FIndent write FIndent;

    { Published-Deklarationen }
  end;

procedure Register;

implementation

constructor TDGCDispText.create(AOwner: TComponent);
begin
     inherited Create(AOwner);
     FYPos := 50;

end;

procedure TDGCDispText.DisplayText;
const
     VSPACE = 4;
var
   x, CurrXPos, CurryPos,CurrWidth, ErrIndex: integer;
   CurrLetterIndex, TotalWidth, TotalHeight: integer;
   CurrLetter: string;
   PrintText: string;
   TextSurface: TDGCSurface;
   MultipleLines: Boolean;
   TotalLines: integer;
   NewSurface: array[0..99] of TDGCSurface;
   NewSurfaceWidth: array[0..99] of integer;
   CurrentSurface: integer;
begin

    PrintText := FDisplayText;
    if not(copy(PrintText,Length(PrintText),1) = '#') then PrintText := PrintText +'#';

    FScreen.CreateSurface(TextSurface, FScreen.ScreenWidth, FScreen.ScreenHeight);

    CurrXPos := 0;
    CurrYPos := 0;
    CurrLetterIndex := 0;
    TotalWidth := 0;
    TotalHeight := FScreen.Images[0].Height;
    MultipleLines := False;
    CurrentSurface := 0;

    TotalLines := -1;   //needs 2 B -1 'cause later on we'll determine the current surface from it
                        //=> Surfaces ('NewSurfaces) start with 0...
    for x := 1 to Length(PrintText) do
        begin
             CurrLetter := Copy(PrintText,x,1);
             if CurrLetter = '#' then inc(TotalLines);
        end;

     x := 0;
     for x := 1 to Length(PrintText) do
         begin
              CurrLetter := Copy(PrintText,x,1);
              if uppercase(CurrLetter) = 'A' then CurrLetterIndex := 0;
              if uppercase(CurrLetter) = 'B' then CurrLetterIndex := 1;
              if uppercase(CurrLetter) = 'C' then CurrLetterIndex := 2;
              if uppercase(CurrLetter) = 'D' then CurrLetterIndex := 3;
              if uppercase(CurrLetter) = 'E' then CurrLetterIndex := 4;
              if uppercase(CurrLetter) = 'F' then CurrLetterIndex := 5;
              if uppercase(CurrLetter) = 'G' then CurrLetterIndex := 6;
              if uppercase(CurrLetter) = 'H' then CurrLetterIndex := 7;
              if uppercase(CurrLetter) = 'I' then CurrLetterIndex := 8;
              if uppercase(CurrLetter) = 'J' then CurrLetterIndex := 9;
              if uppercase(CurrLetter) = 'K' then CurrLetterIndex := 10;
              if uppercase(CurrLetter) = 'L' then CurrLetterIndex := 11;
              if uppercase(CurrLetter) = 'M' then CurrLetterIndex := 12;
              if uppercase(CurrLetter) = 'N' then CurrLetterIndex := 13;
              if uppercase(CurrLetter) = 'O' then CurrLetterIndex := 14;
              if uppercase(CurrLetter) = 'P' then CurrLetterIndex := 15;
              if uppercase(CurrLetter) = 'Q' then CurrLetterIndex := 16;
              if uppercase(CurrLetter) = 'R' then CurrLetterIndex := 17;
              if uppercase(CurrLetter) = 'S' then CurrLetterIndex := 18;
              if uppercase(CurrLetter) = 'T' then CurrLetterIndex := 19;
              if uppercase(CurrLetter) = 'U' then CurrLetterIndex := 20;
              if uppercase(CurrLetter) = 'V' then CurrLetterIndex := 21;
              if uppercase(CurrLetter) = 'W' then CurrLetterIndex := 22;
              if uppercase(CurrLetter) = 'X' then CurrLetterIndex := 23;
              if uppercase(CurrLetter) = 'Y' then CurrLetterIndex := 24;
              if uppercase(CurrLetter) = 'Z' then CurrLetterIndex := 25;
              if uppercase(CurrLetter) = '0' then CurrLetterIndex := 26;
              if uppercase(CurrLetter) = '1' then CurrLetterIndex := 27;
              if uppercase(CurrLetter) = '2' then CurrLetterIndex := 28;
              if uppercase(CurrLetter) = '3' then CurrLetterIndex := 29;
              if uppercase(CurrLetter) = '4' then CurrLetterIndex := 30;
              if uppercase(CurrLetter) = '5' then CurrLetterIndex := 31;
              if uppercase(CurrLetter) = '6' then CurrLetterIndex := 32;
              if uppercase(CurrLetter) = '7' then CurrLetterIndex := 33;
              if uppercase(CurrLetter) = '8' then CurrLetterIndex := 34;
              if uppercase(CurrLetter) = '9' then CurrLetterIndex := 35;
              if uppercase(CurrLetter) = '!' then CurrLetterIndex := 36;
              if uppercase(CurrLetter) = '.' then CurrLetterIndex := 37;
              if uppercase(CurrLetter) = '?' then CurrLetterIndex := 38;
              if uppercase(CurrLetter) = '"' then CurrLetterIndex := 39;
              if uppercase(CurrLetter) = ',' then CurrLetterIndex := 40;
              if uppercase(CurrLetter) = ' ' then CurrLetterIndex := 41;
              if uppercase(CurrLetter) = ':' then CurrLetterIndex := 42;
              if uppercase(CurrLetter) = '#' then                 //=> Next line...
                begin
                      if TotalWidth = 0 then TotalWidth := 1;     //In order to do a double line-break...
                      FScreen.CreateSurface(NewSurface[CurrentSurface], TotalWidth, TotalHeight);
                      NewSurface[CurrentSurface].BltFast(0, 0, TextSurface, Rect(0,0,TotalWidth,TotalHeight), False);
                      NewSurfaceWidth[CurrentSurface] := TotalWidth;
                      inc(CurrentSurface);
                      TotalWidth := 0;
                      CurrXPos := 0;
                      CurrLetterIndex := 99;
                 end;

              if CurrLetter = '' then break;

              if not(CurrLetterIndex = 99) then
                 begin
                      CurrWidth := FScreen.Images[CurrLetterIndex].Width;
                      TextSurface.BltFast(0+CurrXPos,0,FScreen.Images[CurrLetterIndex],FScreen.Images[CurrLetterIndex].ClientRect, False);
                      CurrXPos := CurrXPos + CurrWidth;
                      if CurrXPos > TotalWidth then TotalWidth := CurrXPos;
                 end;
         end;

     for x := 0 to TotalLines do
         begin
              if FAlign = alCenter then
                 FScreen.Front.BltFast((FScreen.ScreenWidth - NewSurfaceWidth[x]) div 2, FYPos+CurrYPos, NewSurface[x], NewSurface[x].ClientRect, FTransparent);
             if FAlign = alLeft then
                 FScreen.Front.BltFast(0 + Indent , FYPos+CurrYPos, NewSurface[x], NewSurface[x].ClientRect, FTransparent);
              if FAlign = alRight then
                 FScreen.Front.BltFast((FScreen.ScreenWidth - NewSurface[x].Width) - FIndent, FYPos+CurrYPos, NewSurface[x], NewSurface[x].ClientRect, FTransparent);

              CurrYPos := CurrYPos+TotalHeight+VSPACE;
              NewSurface[x].Destroy;
         end;
     TextSurface.destroy;
end;


function TAbout.GetAttributes: TPropertyAttributes;
begin
	Result := [paMultiSelect, paDialog, paReadOnly];
end;

function TAbout.GetValue: string;
begin
	Result := '(About TProgInfo...)';
end;


procedure TAbout.Edit;
var
   msg: PChar;
   msg_title: PChar;
begin
     msg:='(C) 1997 by '+Author+#13#10+'Email: '+AuthorEmail+#13#10#13#10+'DGC (C) Pullen, Bearne, Kurtz';
     msg_title:='TDGCDisplayText 32-bit Delphi Component V'+CurrVersion;

     Application.MessageBox(msg, msg_title, MB_OK+ MB_ICONINFORMATION);
end;

procedure Register;
begin
  RegisterComponents('DirectX', [TDGCDispText]);
  RegisterPropertyEditor(TypeInfo(TAbout), TDGCDispText, 'ABOUT', TAbout);
end;

end.
