unit frmbtest;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,StdCtrls,
  blowfish, ExtCtrls, des;

type
  TfrmTestDES = class(TForm)
    grpText: TGroupBox;
    btnDecrypt: TButton;
    btnEncrypt: TButton;
    edtTestText: TEdit;
    lblTestText: TLabel;
    grpFile: TGroupBox;
    btnFileEncrypt: TButton;
    odlFileEnc: TOpenDialog;
    sdlFileEnc: TSaveDialog;
    btnFileDecrypt: TButton;
    odlFileDec: TOpenDialog;
    sdlFileDec: TSaveDialog;
    rgrMode: TRadioGroup;
    rdbECB: TRadioButton;
    rdbCBC: TRadioButton;
    rdbCFB: TRadioButton;
    rdbOFB: TRadioButton;
    DES1: TDES;
    procedure btnFileEncryptClick(Sender: TObject);
    procedure btnEncryptClick(Sender: TObject);
    procedure btnDecryptClick(Sender: TObject);
    procedure btnFileDecryptClick(Sender: TObject);
    procedure rdbECBClick(Sender: TObject);
    procedure rdbCBCClick(Sender: TObject);
    procedure rdbCFBClick(Sender: TObject);
    procedure rdbOFBClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmTestDES: TfrmTestDES;

implementation

{$R *.DFM}

procedure TfrmTestDES.btnFileEncryptClick(Sender: TObject);
begin
     DES1.LoadIVString('InitVector');
     DES1.InitialiseString('PassPhrase');
     if odlFileEnc.Execute then
     begin
          if sdlFileEnc.Execute then
          begin
               DES1.EncryptFile(odlFileEnc.FileName, sdlFileEnc.FileName);
          end;
     end;
end;

procedure TfrmTestDES.btnEncryptClick(Sender: TObject);
var
     Tempstr: string;
begin
     DES1.LoadIVString('InitVector');
     DES1.InitialiseString('PassPhrase');
     DES1.EncryptString(edtTestText.Text,Tempstr);
     edtTestText.Text := TempStr;
end;

procedure TfrmTestDES.btnDecryptClick(Sender: TObject);
var
     Tempstr: string;
begin
     DES1.InitialiseString('PassPhrase');
     DES1.LoadIVString('InitVector');
     DES1.DecryptString(edtTestText.Text,Tempstr);
     edtTestText.Text := TempStr;
end;

procedure TfrmTestDES.btnFileDecryptClick(Sender: TObject);
begin
     DES1.LoadIVString('InitVector');
     DES1.InitialiseString('PassPhrase');
     if odlFileDec.Execute then
     begin
          if sdlFileDec.Execute then
          begin
               DES1.DecryptFile(odlFileDec.FileName, sdlFileDec.FileName);
          end;
     end;
end;

procedure TfrmTestDES.rdbECBClick(Sender: TObject);
begin
     DES1.CipherMode := ECB;
end;

procedure TfrmTestDES.rdbCBCClick(Sender: TObject);
begin
     DES1.CipherMode := CBC;
end;

procedure TfrmTestDES.rdbCFBClick(Sender: TObject);
begin
     DES1.CipherMode := CFB;
end;

procedure TfrmTestDES.rdbOFBClick(Sender: TObject);
begin
     DES1.CipherMode := OFB;
end;

end.
