{ OpenGL with Delphi and minimum effort by Jonas Dieckelmann }
Program DelphiGL;

uses Windows, Messages, OpenGL;

var
  hParentWnd: hWnd;                                   // Window-Handle
  hDC: hDC;                                           // Handle to Device Context of hParentWnd
  hRC: hRC;                                           // Handle to Rendering Context
  WndClass: TWndClass;                                // Window Class
  iMessage: TMsg;                                     // Screen-Width/Height
  PWndWidth, PWndHeight: Integer;                     // Rotate the Asteroid
  Angle: Integer;

// This Function handles Messages for our new hParentWnd
function MainWndProc(hWnd:hWnd; iMessage: uInt; wParam: wParam; lParam: lParam): lResult; export; stdcall;
begin
  Result := 0;
  case iMessage of
    WM_DESTROY: PostQuitMessage(0);  // Tells Windows that App wants to close
  else
    Result := DefWindowProc(hWnd, iMessage, wParam, lParam); // get lResult from the Default Window Procedure
  end;
end;

// This Procedure creates our Window
procedure PrepareWindow;
begin
 if (hPrevInst = 0) then
   begin
     WndClass.style := CS_HREDRAW or CS_VREDRAW;
     WndClass.lpfnWndProc := @MainWndProc;              // Points to the Procedure which handels Messages for the Window
     WndClass.cbClsExtra := 0;
     WndClass.cbWndExtra := 0;
     WndClass.hInstance := GetModuleHandle(nil);
     WndClass.hIcon := LoadIcon(0, IDI_APPLICATION);
     WndClass.hCursor := LOADCURSOR(0, IDC_ARROW);
     WndClass.hBrBackground := 0;                       // No Background needed for OpenGL
     WndClass.lpszMenuName := '';
     WndClass.lpszClassName := 'glClass';
     if RegisterClass(WndClass) = 0  then
      begin
        MessageBox(hParentWnd, 'WndClass could not be registered !', nil, MB_OK or MB_ICONSTOP or MB_TASKMODAL);
        Halt;
      end;
     //endif RegisterClass(...) = 0
   end;
  //endif hPrevInst = 0}

  PWndWidth := GetSystemMetrics(SM_CXSCREEN);
  PWndHeight := GetSystemMetrics(SM_CYSCREEN);
  hParentWnd := CreateWindow('glClass', 'MAIN', WS_SYSMENU, 0, 0, PWndWidth, PWndHeight, 0, 0, hInstance, nil);
  // 'Main' is the Caption ; WS_SYSMENU creates a Window with a caption-bar and an exit button
  // 'glClass' identifies the WndClass we have registered (see CreateWindow API-Help for more Info)
end;

// This is where we do the drawing stuff (see OpenGL API-Help for more Info)
procedure DrawScene;
begin
 Angle := Angle+10;
 glClear(GL_DEPTH_BUFFER_BIT or GL_COLOR_BUFFER_BIT);  // clears the Frame Buffer for a new Frame
 glPushMatrix;                                         // saves current Matrix
 glTranslatef(0, 0, -8);                               // Move Viewpoint back so we can see the entire Scene
 glRotatef(Angle, 1, 0, 0);                            // Rotate the Viewpoint around the Object

  glBegin(GL_TRIANGLES);                               // Following glBegin... glEnd Statements draw the Polygons
    glNormal3f(-0.74116, -0.579615, 0.338716);         // of the Asteroid
    glVertex3f(-0.475525, -0.142578, 0.154755);        // You can delete this lines to do some drawing of your own
    glVertex3f(-0.293854, -0.451569, 0.0235291);
    glVertex3f(-0.344055, -0.147278, 0.434387);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.410835, -0.910633, -0.0442978);
    glVertex3f(-0.293854, -0.451569, 0.0235291);
    glVertex3f(-0.0111389, -0.565186, -0.262848);
    glVertex3f(0.168762, -0.656647, -0.0511475);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.569974, -0.805453, 0.162401);
    glVertex3f(0.168762, -0.656647, -0.0511475);
    glVertex3f(0.417633, -0.475372, -0.0255432);
    glVertex3f(0.253418, -0.528687, 0.286377);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.949311, -0.3094, -0.0554997);
    glVertex3f(0.417633, -0.475372, -0.0255432);
    glVertex3f(0.471161, -0.290833, -0.138733);
    glVertex3f(0.531952, -0.152008, 0.127167);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.9759, 0.0404478, 0.214439);
    glVertex3f(0.531952, -0.152008, 0.127167);
    glVertex3f(0.533997, 0.20929, 0.0497131);
    glVertex3f(0.472351, 0.0888977, 0.352966);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.672389, 0.730092, -0.121896);
    glVertex3f(0.533997, 0.20929, 0.0497131);
    glVertex3f(0.425964, 0.25, -0.302368);
    glVertex3f(0.306183, 0.404633, -0.0369263);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.292631, 0.954815, -0.051914);
    glVertex3f(0.306183, 0.404633, -0.0369263);
    glVertex3f(0.0134583, 0.491821, -0.083374);
    glVertex3f(0.131439, 0.474701, 0.266785);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.29624, 0.930867, -0.21384);
    glVertex3f(0.0134583, 0.491821, -0.083374);
    glVertex3f(-0.131439, 0.40448, -0.262848);
    glVertex3f(-0.293854, 0.415649, 0.0107727);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.704095, 0.703107, 0.0994509);
    glVertex3f(-0.475525, 0.224731, 0.0743408);
    glVertex3f(-0.344055, 0.324249, 0.301544);
    glVertex3f(-0.293854, 0.415649, 0.0107727);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.986932, -0.0344614, -0.157411);
    glVertex3f(-0.425293, -0.0452881, -0.181488);
    glVertex3f(-0.475525, -0.142578, 0.154755);
    glVertex3f(-0.475525, 0.224731, 0.0743408);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.319147, -0.514182, -0.796091);
    glVertex3f(-0.267548, -0.15448, -0.425323);
    glVertex3f(0.191071, -0.337128, -0.491211);
    glVertex3f(-0.0111389, -0.565186, -0.262848);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.156126, -0.100546, 0.982606);
    glVertex3f(-0.317749, -0.0470581, 0.448822);
    glVertex3f(-0.344055, -0.147278, 0.434387);
    glVertex3f(-0.0487366, -0.464478, 0.448853);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.77365, -0.250923, -0.58181);
    glVertex3f(0.191071, -0.337128, -0.491211);
    glVertex3f(0.312347, 0, -0.475342 );
    glVertex3f(0.471161, -0.290833, -0.138733);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.376298, -0.37407, 0.847627);
    glVertex3f(-0.0487366, -0.464478, 0.448853);
    glVertex3f(0.253418, -0.528687, 0.286377);
    glVertex3f(0.212646, -0.201538, 0.448853);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.511356, 0.31956, -0.797744);
    glVertex3f(0.312347, 0, -0.475342 );
    glVertex3f(0.131378, 0.249969, -0.491211);
    glVertex3f(0.425964, 0.25, -0.302368);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.407016, -0.0631076, 0.911238);
    glVertex3f(0.212646, -0.201538, 0.448853);
    glVertex3f(0.472351, 0.0888977, 0.352966);
    glVertex3f(0.212646, 0.267761, 0.481354);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.270432, 0.623807, -0.733302);
    glVertex3f(0.131378, 0.249969, -0.491211);
    glVertex3f(-0.267548, 0.15448, -0.425323);
    glVertex3f(-0.131439, 0.40448, -0.262848);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.187651, 0.74153, 0.644143);
    glVertex3f(0.212646, 0.267761, 0.481354);
    glVertex3f(0.131439, 0.474701, 0.266785);
    glVertex3f(-0.0811768, 0.360779, 0.459869);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.839618, 0, -0.543177 );
    glVertex3f(-0.425293, -0.0452881, -0.181488);
    glVertex3f(-0.267548, 0.15448, -0.425323);
    glVertex3f(-0.267548, -0.15448, -0.425323);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.523449, 0.281854, 0.804089);
    glVertex3f(-0.344055, 0.324249, 0.301544);
    glVertex3f(-0.317749, -0.0470581, 0.448822);
    glVertex3f(-0.0811768, 0.360779, 0.459869);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.889618, -0.190557, 0.415053);
    glVertex3f(-0.447205, 0.0761719, 0.315887);
    glVertex3f(-0.475525, -0.142578, 0.154755);
    glVertex3f(-0.344055, -0.147278, 0.434387);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.672801, -0.631467, 0.385471);
    glVertex3f(0.00344849, -0.631836, 0.247131);
    glVertex3f(-0.344055, -0.147278, 0.434387);
    glVertex3f(-0.293854, -0.451569, 0.0235291);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.879473, -0.438944, -0.183999);
    glVertex3f(-0.361786, -0.280945, -0.0588074);
    glVertex3f(-0.293854, -0.451569, 0.0235291);
    glVertex3f(-0.475525, -0.142578, 0.154755);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.703044, -0.516037, -0.489321);
    glVertex3f(-0.361786, -0.280945, -0.0588074);
    glVertex3f(-0.0111389, -0.565186, -0.262848);
    glVertex3f(-0.293854, -0.451569, 0.0235291);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.17191, -0.842719, -0.510169);
    glVertex3f(0.282532, -0.491699, -0.285278);
    glVertex3f(0.168762, -0.656647, -0.0511475);
    glVertex3f(-0.0111389, -0.565186, -0.262848);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.42147, -0.892735, -0.159332);
    glVertex3f(0.00344849, -0.631836, 0.247131);
    glVertex3f(-0.293854, -0.451569, 0.0235291);
    glVertex3f(0.168762, -0.656647, -0.0511475);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.333159, -0.906305, 0.260032);
    glVertex3f(0.00344849, -0.631836, 0.247131);
    glVertex3f(0.168762, -0.656647, -0.0511475);
    glVertex3f(0.253418, -0.528687, 0.286377);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.764525, -0.567613, 0.305478);
    glVertex3f(0.473358, -0.170807, 0.400909);
    glVertex3f(0.253418, -0.528687, 0.286377);
    glVertex3f(0.417633, -0.475372, -0.0255432);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.586159, -0.768494, -0.256583);
    glVertex3f(0.282532, -0.491699, -0.285278);
    glVertex3f(0.417633, -0.475372, -0.0255432);
    glVertex3f(0.168762, -0.656647, -0.0511475);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.705977, -0.593585, -0.386334);
    glVertex3f(-0.361786, -0.280945, -0.0588074);
    glVertex3f(-0.267548, -0.15448, -0.425323);
    glVertex3f(-0.0111389, -0.565186, -0.262848);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.141872, -0.760405, -0.633764);
    glVertex3f(0.282532, -0.491699, -0.285278);
    glVertex3f(-0.0111389, -0.565186, -0.262848);
    glVertex3f(0.191071, -0.337128, -0.491211);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.27854, -0.381434, -0.881433);
    glVertex3f(0.00231934, 0, -0.577454 );
    glVertex3f(0.191071, -0.337128, -0.491211);
    glVertex3f(-0.267548, -0.15448, -0.425323);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.679685, 0.0732876, 0.729834);
    glVertex3f(-0.447205, 0.0761719, 0.315887);
    glVertex3f(-0.344055, -0.147278, 0.434387);
    glVertex3f(-0.317749, -0.0470581, 0.448822);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.694999, -0.631368, 0.34402);
    glVertex3f(0.00344849, -0.631836, 0.247131);
    glVertex3f(-0.0487366, -0.464478, 0.448853);
    glVertex3f(-0.344055, -0.147278, 0.434387);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.17093, -0.110087, 0.979114);
    glVertex3f(-0.0549011, 0, 0.5 );
    glVertex3f(-0.317749, -0.0470581, 0.448822);
    glVertex3f(-0.0487366, -0.464478, 0.448853);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.796179, -0.46695, -0.384781);
    glVertex3f(0.282532, -0.491699, -0.285278);
    glVertex3f(0.471161, -0.290833, -0.138733);
    glVertex3f(0.417633, -0.475372, -0.0255432);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.968681, -0.225635, -0.103661);
    glVertex3f(0.525299, -0.042511, -0.17334);
    glVertex3f(0.531952, -0.152008, 0.127167);
    glVertex3f(0.471161, -0.290833, -0.138733);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.902522, -0.39741, 0.16589);
    glVertex3f(0.473358, -0.170807, 0.400909);
    glVertex3f(0.417633, -0.475372, -0.0255432);
    glVertex3f(0.531952, -0.152008, 0.127167);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.976342, 0.0429096, 0.21193);
    glVertex3f(0.473358, -0.170807, 0.400909);
    glVertex3f(0.531952, -0.152008, 0.127167);
    glVertex3f(0.472351, 0.0888977, 0.352966);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.877521, 0.357037, 0.320127);
    glVertex3f(0.408844, 0.328003, 0.260376);
    glVertex3f(0.472351, 0.0888977, 0.352966);
    glVertex3f(0.533997, 0.20929, 0.0497131);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.999592, -0.0112823, -0.0262407);
    glVertex3f(0.525299, -0.042511, -0.17334);
    glVertex3f(0.533997, 0.20929, 0.0497131);
    glVertex3f(0.531952, -0.152008, 0.127167);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.764909, -0.303992, -0.567894);
    glVertex3f(0.282532, -0.491699, -0.285278);
    glVertex3f(0.191071, -0.337128, -0.491211);
    glVertex3f(0.471161, -0.290833, -0.138733);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.774426, -0.249842, -0.581243);
    glVertex3f(0.525299, -0.042511, -0.17334);
    glVertex3f(0.471161, -0.290833, -0.138733);
    glVertex3f(0.312347, 0, -0.475342 );
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.312115, -0.0676723, -0.947631);
    glVertex3f(0.00231934, 0, -0.577454 );
    glVertex3f(0.312347, 0, -0.475342 );
    glVertex3f(0.191071, -0.337128, -0.491211);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.197739, -0.72867, 0.655698);
    glVertex3f(0.00344849, -0.631836, 0.247131);
    glVertex3f(0.253418, -0.528687, 0.286377);
    glVertex3f(-0.0487366, -0.464478, 0.448853);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.211591, -0.413455, 0.885598);
    glVertex3f(0.473358, -0.170807, 0.400909);
    glVertex3f(0.212646, -0.201538, 0.448853);
    glVertex3f(0.253418, -0.528687, 0.286377);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.108039, -0.107399, 0.988328);
    glVertex3f(-0.0549011, 0, 0.5 );
    glVertex3f(-0.0487366, -0.464478, 0.448853);
    glVertex3f(0.212646, -0.201538, 0.448853);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.942466, 0.202839, -0.265731);
    glVertex3f(0.525299, -0.042511, -0.17334);
    glVertex3f(0.425964, 0.25, -0.302368);
    glVertex3f(0.533997, 0.20929, 0.0497131);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.540665, 0.809814, -0.227778);
    glVertex3f(0.170563, 0.425323, -0.285278);
    glVertex3f(0.306183, 0.404633, -0.0369263);
    glVertex3f(0.425964, 0.25, -0.302368);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.657824, 0.75244, -0.0332111);
    glVertex3f(0.408844, 0.328003, 0.260376);
    glVertex3f(0.533997, 0.20929, 0.0497131);
    glVertex3f(0.306183, 0.404633, -0.0369263);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.467657, 0.881464, 0.0657114);
    glVertex3f(0.408844, 0.328003, 0.260376);
    glVertex3f(0.306183, 0.404633, -0.0369263);
    glVertex3f(0.131439, 0.474701, 0.266785);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.036579, 0.998664, 0.036503);
    glVertex3f(-0.138153, 0.486145, 0.223846);
    glVertex3f(0.131439, 0.474701, 0.266785);
    glVertex3f(0.0134583, 0.491821, -0.083374);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.296505, 0.951448, -0.0826477);
    glVertex3f(0.170563, 0.425323, -0.285278);
    glVertex3f(0.0134583, 0.491821, -0.083374);
    glVertex3f(0.306183, 0.404633, -0.0369263);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.818651, 0.0249238, -0.57375);
    glVertex3f(0.525299, -0.042511, -0.17334);
    glVertex3f(0.312347, 0, -0.475342 );
    glVertex3f(0.425964, 0.25, -0.302368);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.407482, 0.655568, -0.635759);
    glVertex3f(0.170563, 0.425323, -0.285278);
    glVertex3f(0.425964, 0.25, -0.302368);
    glVertex3f(0.131378, 0.249969, -0.491211);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.3086, 0.163933, -0.936959);
    glVertex3f(0.00231934, 0, -0.577454 );
    glVertex3f(0.131378, 0.249969, -0.491211);
    glVertex3f(0.312347, 0, -0.475342 );
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.157363, 0.179867, 0.971022);
    glVertex3f(0.473358, -0.170807, 0.400909);
    glVertex3f(0.472351, 0.0888977, 0.352966);
    glVertex3f(0.212646, -0.201538, 0.448853);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.618173, 0.421188, 0.663674);
    glVertex3f(0.408844, 0.328003, 0.260376);
    glVertex3f(0.212646, 0.267761, 0.481354);
    glVertex3f(0.472351, 0.0888977, 0.352966);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.137357, -0.0684344, 0.988155);
    glVertex3f(-0.0549011, 0, 0.5 );
    glVertex3f(0.212646, -0.201538, 0.448853);
    glVertex3f(0.212646, 0.267761, 0.481354);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.898457, -0.367331, -0.240507);
    glVertex3f(-0.361786, -0.280945, -0.0588074);
    glVertex3f(-0.475525, -0.142578, 0.154755);
    glVertex3f(-0.425293, -0.0452881, -0.181488);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.990518, 0.0293809, 0.134204);
    glVertex3f(-0.447205, 0.0761719, 0.315887);
    glVertex3f(-0.475525, 0.224731, 0.0743408);
    glVertex3f(-0.475525, -0.142578, 0.154755);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.930333, 0.145751, -0.336506);
    glVertex3f(-0.361786, 0.262848, -0.223602);
    glVertex3f(-0.425293, -0.0452881, -0.181488);
    glVertex3f(-0.475525, 0.224731, 0.0743408);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.0915225, 0.922481, -0.375037);
    glVertex3f(0.170563, 0.425323, -0.285278);
    glVertex3f(-0.131439, 0.40448, -0.262848);
    glVertex3f(0.0134583, 0.491821, -0.083374);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.533345, 0.770975, -0.348053);
    glVertex3f(-0.361786, 0.262848, -0.223602);
    glVertex3f(-0.293854, 0.415649, 0.0107727);
    glVertex3f(-0.131439, 0.40448, -0.262848);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.272513, 0.955032, -0.116838);
    glVertex3f(-0.138153, 0.486145, 0.223846);
    glVertex3f(0.0134583, 0.491821, -0.083374);
    glVertex3f(-0.293854, 0.415649, 0.0107727);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.863373, 0.378291, 0.333889);
    glVertex3f(-0.447205, 0.0761719, 0.315887);
    glVertex3f(-0.344055, 0.324249, 0.301544);
    glVertex3f(-0.475525, 0.224731, 0.0743408);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.574288, 0.804112, 0.153612);
    glVertex3f(-0.138153, 0.486145, 0.223846);
    glVertex3f(-0.293854, 0.415649, 0.0107727);
    glVertex3f(-0.344055, 0.324249, 0.301544);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.742204, 0.639143, -0.201568);
    glVertex3f(-0.361786, 0.262848, -0.223602);
    glVertex3f(-0.475525, 0.224731, 0.0743408);
    glVertex3f(-0.293854, 0.415649, 0.0107727);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.100014, 0.766867, -0.633966);
    glVertex3f(0.170563, 0.425323, -0.285278);
    glVertex3f(0.131378, 0.249969, -0.491211);
    glVertex3f(-0.131439, 0.40448, -0.262848);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.496295, 0.646655, -0.579248);
    glVertex3f(-0.361786, 0.262848, -0.223602);
    glVertex3f(-0.131439, 0.40448, -0.262848);
    glVertex3f(-0.267548, 0.15448, -0.425323);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.245954, 0.427173, -0.870075);
    glVertex3f(0.00231934, 0, -0.577454 );
    glVertex3f(-0.267548, 0.15448, -0.425323);
    glVertex3f(0.131378, 0.249969, -0.491211);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.838044, -0.412032, -0.357647);
    glVertex3f(-0.361786, -0.280945, -0.0588074);
    glVertex3f(-0.425293, -0.0452881, -0.181488);
    glVertex3f(-0.267548, -0.15448, -0.425323);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.49107, 0, -0.87112 );
    glVertex3f(0.00231934, 0, -0.577454 );
    glVertex3f(-0.267548, -0.15448, -0.425323);
    glVertex3f(-0.267548, 0.15448, -0.425323);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.874574, 0.115899, -0.470838);
    glVertex3f(-0.361786, 0.262848, -0.223602);
    glVertex3f(-0.267548, 0.15448, -0.425323);
    glVertex3f(-0.425293, -0.0452881, -0.181488);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(0.399242, 0.730775, 0.553691);
    glVertex3f(0.408844, 0.328003, 0.260376);
    glVertex3f(0.131439, 0.474701, 0.266785);
    glVertex3f(0.212646, 0.267761, 0.481354);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.0385133, 0.878612, 0.475982);
    glVertex3f(-0.138153, 0.486145, 0.223846);
    glVertex3f(-0.0811768, 0.360779, 0.459869);
    glVertex3f(0.131439, 0.474701, 0.266785);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.0385461, 0.107696, 0.993436);
    glVertex3f(-0.0549011, 0, 0.5 );
    glVertex3f(0.212646, 0.267761, 0.481354);
    glVertex3f(-0.0811768, 0.360779, 0.459869);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.549513, 0.274117, 0.789237);
    glVertex3f(-0.447205, 0.0761719, 0.315887);
    glVertex3f(-0.317749, -0.0470581, 0.448822);
    glVertex3f(-0.344055, 0.324249, 0.301544);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.206353, 0.0933145, 0.974018);
    glVertex3f(-0.0549011, 0, 0.5 );
    glVertex3f(-0.0811768, 0.360779, 0.459869);
    glVertex3f(-0.317749, -0.0470581, 0.448822);
  glEnd;
  glBegin(GL_TRIANGLES);
    glNormal3f(-0.408821, 0.761405, 0.503119);
    glVertex3f(-0.138153, 0.486145, 0.223846);
    glVertex3f(-0.344055, 0.324249, 0.301544);
    glVertex3f(-0.0811768, 0.360779, 0.459869);
  glEnd;

 SwapBuffers(hDC);                                     // Swap Frame Buffers
 glPopMatrix;                                          // Get rid of current matrix and go back to previously saved Matrix
 
end;

// Here we prepare OpenGL in order to draw the scene
procedure PrepareScene;
begin
  glEnable(GL_DEPTH_TEST);
  glEnable(GL_CULL_FACE);
  glEnable(GL_LIGHTING);
  glEnable(GL_LIGHT0);
  glHint(GL_PERSPECTIVE_CORRECTION_HINT,GL_NICEST);
  glMatrixMode(GL_PROJECTION);
  glViewPort(0, 0, PWndWidth, PWndHeight);              // Assing screen-size for rendering
  gluPerspective(60, 800/600, 1, 100);                  // Aditional Viewing-Volume settings
  glMatrixMode(GL_MODELVIEW);
end;

begin
  PrepareWindow;
  hDC := GetDC(hParentWnd);                                       // Get a DC from our Window
  InitOpenGL;                                                     // Activate DLL's
  hRC := CreateRenderingContext(hDC, [opDoubleBuffered], 0, 0);   // Sets up OpenGL RC for our Window
  ActivateRenderingContext(hDC, hRC);                             // Activates the RC
  PrepareScene;
  ShowWindow(hParentWnd, SW_SHOW);                                // Makes our Window visible 
  angle := 0;

  // This loop keeps the Program running
  repeat
    PeekMessage(iMessage, 0, 0, 0, PM_REMOVE);                    // Intercept Messages from our Window
    TranslateMessage(iMessage);
    DispatchMessage(iMessage);                                    // Dispatch Messages to the MainWndProc
    DrawScene;
  until (iMessage.message = WM_QUIT);

  // After Quit-Message is recived, clear memory by releasing RC and Window
  DeactivateRenderingContext;
  DestroyRenderingContext(hRC);
  CloseOpenGL;
  DestroyWindow(hParentWnd);
end.
