unit ics_wrapper;

{
ics_wrapper will allow you to interface your Delphi app with Cybersource's
ics2api.dll C API/DLL library. For examples on use of these wrapped
functions, see the ics_test.pas file.
Written by Chris Ihlenfeld
http:/www.digital-concepts.net
No warranty, i.e. use at your own risk.
Some limited help can be found by contacting me at
ics_wrapper@digital-concepts.net
Dont email asking to write any programs for you, I will only provide some help
with using this wrapper.
At some time in the future, I will tie this wrapper into a Delphi component.
}

interface
  const ics = 'ics2api.dll';  //ICS DLL filename, recommend keeping DLL
                              //in same directory as your Delphi project

var
  ics_msg: Pointer;           //Pointer for ICS SCMP message
  ics_res: Pointer;           //Pointer for ics_send results
  ics_rcode: PChar;           //Pointer for ics_rcode


{ics_init}
//Creates and initializes an SCMP message
function ics_init(debug: Integer): Pointer; cdecl external ics;

{ics_send}
//Sends an encrypted message to the ICS server
function ics_send(msg: Pointer): Pointer; cdecl external ics;

{ics_print}
// ics_print will send its output to STDOUT, I havent figured out
// how to capture this in delphi as of yet.
//Would be nice if the CyberSource guys would add into the DLL the ability to
//get back an array of the name fields available, then I can easily do
//something with it. (hint hint)
//Definately would be useful to be able to dump the ics contents.
function ics_print(msg: Pointer): Integer; cdecl external ics;

{ics_add}
//Adds a field (a name-value pair) to an SCMP message
function ics_fadd(ics_msg: Pointer; name: String; value:String): Integer; cdecl external ics;

{ics_fremove}
//Removes a field from an SCMP message by name
function ics_fremove(ics_msg: Pointer; name: String): Integer; cdecl external ics;

{ics_fget}
//Returns the quantity of fields in an SCMP message by position
function ics_fget(ics_msg: Pointer; index: Integer): pChar; cdecl external ics;

{ics_fgetbyname}
//Returns a field from an SCMP message by name
function ics_fgetbyname(ics_msg: Pointer; name: String): pChar; cdecl external ics;

{ics_fcount}
//Returns the quantity of fields in an SCMP message
function ics_fcount(ics_msg: Pointer): Integer; cdecl external ics;

{ics_destroy}
//Clears a used SCMP message
procedure ics_destroy(ics_msg: Pointer); cdecl external ics;

// You will probably never need the following 2 functions, but I included them anyway.
function sendCertRequest(request: PChar; requestLen, update: Integer; senderName,
               serverHost, serverPort, serverCert, merchantCert, merchantPrivateKey,
               proxyuser, proxypwd, proxyurl: PChar): PChar; cdecl external ics;

function generateCertRequest(merchant: PChar): Pointer; cdecl external ics;


implementation
{No implementation section needed. You can copy the above declarations into
your source file anywhere between the interface and implementation sections,
except within a Type declaration. I recommend keeping it in this stand-alone
file and added "ics_wrapper" to you "uses" clause. }

end.
