unit ics_test;

{
ics_test program is a simple test util to allow you to test your ics_wrapper
and see how things work. It also shows you how to use each wrapped function.
All functions and variables are declared in ics_wrapper.pas
Written by Chris Ihlenfeld
http:/www.digital-concepts.net
No warranty, i.e. use at your own risk.
Some limited help can be found by contacting me at
ics_wrapper@digital-concepts.net
Dont email asking to write any programs for you, I will only provide some help with using this wrapper.
At some time in the future, I will tie this wrapper into a Delphi component.
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TfrmTest = class(TForm)
    btnTest: TButton;
    Label1: TLabel;
    memResult: TMemo;
    btnClear: TButton;
    procedure btnTestClick(Sender: TObject);
    procedure btnClearClick(Sender: TObject);
  private

  public

  end;

var
  frmTest: TfrmTest;

implementation

{$R *.DFM}

uses ics_wrapper;

procedure TfrmTest.btnTestClick(Sender: TObject);
var
   NameValuePairs: TStringList;
   i: Integer;
begin
   try
      NameValuePairs := TStringList.Create;
      ics_msg := ics_init(0);

      //initialize a list with our name value pairs
      NameValuePairs.Values['server_host'] := 'ics2test.ic3.com';
      NameValuePairs.Values['server_port'] := '80';

      { Uncomment these lines for http proxy support
       Some proxies require Authentication with username and password }
       //NameValuePairs.Values['http_proxy'] := 'http://proxy.cybersource.com';
       //NameValuePairs.Values['http_proxy_username'] := 'proxyusername';
       //NameValuePairs.Values['http_proxy_password'] := 'proxypassword';

       NameValuePairs.Values['ics_applications'] := 'ics_score,ics_auth,ics_bill';
       NameValuePairs.Values['merchant_id'] := 'ICS2Test';
       NameValuePairs.Values['customer_firstname'] := 'bobo';
       NameValuePairs.Values['customer_lastname'] := 'leclown';
       NameValuePairs.Values['customer_email'] := 'bobo@circus.com';
       NameValuePairs.Values['customer_phone'] := '408-556-9100';
       NameValuePairs.Values['bill_address1'] := '550 s. winchester blvd.';
       NameValuePairs.Values['bill_city'] := 'san jose';
       NameValuePairs.Values['bill_state'] := 'ca';
       NameValuePairs.Values['bill_zip'] := '95128';
       NameValuePairs.Values['bill_country'] := 'US';
       NameValuePairs.Values['customer_cc_number'] := '4111111111111111';
       NameValuePairs.Values['customer_cc_expmo'] := '12';
       NameValuePairs.Values['customer_cc_expyr'] := '2001';
       NameValuePairs.Values['merchant_ref_number'] := '10001010';
       NameValuePairs.Values['currency'] := 'USD';
       NameValuePairs.Values['offer0'] := 'offerid:0^amount:4.59';


          memResult.Lines.Add('Calling ics_fadd to add name/value pairs...');
       //now lets call ics_fadd passing the name value pairs in our list
       for i:=0 to (NameValuePairs.Count - 1) do
          ics_fadd(ics_msg, NameValuePairs.Names[i],NameValuePairs.Values[NameValuePairs.Names[i]]);

          memResult.Lines.Add(' ');
          memResult.Lines.Add('The following name value pairs were successfully added:');
          memResult.Lines.Add('(Data retrieved with ics_fgetbyname)');
          memResult.Lines.Add(' ');
          for i:=0 to (NameValuePairs.Count - 1) do
             memResult.Lines.Add(IntToStr(i+1)+': '+NameValuePairs.Names[i]+' = '+ics_fgetbyname(ics_msg, NameValuePairs.Names[i]));
          memResult.Lines.Add(' ');
          memResult.Lines.Add('Total number of name/value pairs added (ics_fcount) is: '
             +IntToStr(ics_fcount(ics_msg)));
          memResult.Lines.Add(' ');
          memResult.Lines.Add('Sending request to: '
             +ics_fgetbyname(ics_msg, 'server_host')+' port: '
	           +ics_fgetbyname(ics_msg, 'server_port')+' (ics_send)');
       ics_res := ics_send(ics_msg);
       if Assigned(ics_res) then begin
          ics_rcode := ics_fgetbyname(ics_res, 'ics_rcode');
             memResult.Lines.Add(' ');
             memResult.Lines.Add('Response received, ics_rcode is '+ics_rcode+' ... results as follows:');
             memResult.Lines.Add(' '); 
          if Assigned(ics_rcode) then begin
	           //would be nice to be able to print out the results here.
	           case StrToInt(ics_rcode) of
                -1: memResult.Lines.Add('Error sending ICS order!');
                0: memResult.Lines.Add('Declined ICS order, ics_rmsg: '
                     +ics_fgetbyname(ics_res, 'ics_rmsg'));
                1: memResult.Lines.Add('Successful ICS order!');
             else
                memResult.Lines.Add('Unexpected result! ics_rcode = '+ics_rcode);
             end;
          end
          else memResult.Lines.Add('Error no ics_rcode, ics_rcode = NULL');
       end
       else memResult.Lines.Add('Error sending ICS order! ics_res = NULL');
   finally
       NameValuePairs.Free;
       ics_destroy(ics_msg);
       ics_destroy(ics_res);
   end;
   //For you application, you could enclose this procedure in a function that
   //returns the ics_rcode.
end;

procedure TfrmTest.btnClearClick(Sender: TObject);
begin
   memResult.Lines.Clear;
end;

end.
