unit HalInsp;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls, Menus,delphin,Buttons;

type
  THalInspForm = class(TForm)
    Panel1: TPanel;
    ObjectTree: TTreeView;
    PropList: TListView;
    Label1: TLabel;
    PopupMenu1: TPopupMenu;
    N1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    N4: TMenuItem;
    StatusBar1: TStatusBar;
    ImageList1: TImageList;
    showvars: TSpeedButton;
    showprocs: TSpeedButton;
    showinherited: TSpeedButton;
    SpeedButton4: TSpeedButton;
    LoadAll: TSpeedButton;
    procedure N4Click(Sender: TObject);
    procedure ShowConstsClick(Sender: TObject);
    procedure ShowProcsClick(Sender: TObject);
    procedure ShowVarsClick(Sender: TObject);
    procedure ShowInheritedClick(Sender: TObject);
    procedure ObjectTreeChange(Sender: TObject; Node: TTreeNode);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SyncButtonClick(Sender: TObject);
    procedure LoadAllClick(Sender: TObject);
  private
    rObj,rCOnst,rFuns,rProcs:TTreeNode;
    FShowQualif,FShowConsts,FShowProcs,FShowVars,FShowInherited:Boolean;
    OldCallBack:TCallBackFun;
    ObjExists:TStringList;
    procedure loaded;override;
    procedure updatePropList;
    procedure setShowQualif(v:boolean);
    procedure setShowConsts(v:boolean);
    procedure setShowProcs(v:boolean);
    procedure setShowVars(v:boolean);
    procedure setShowInherited(v:boolean);
    procedure whenloaded;
  public
    destructor destroy;override;
    property AShowQualif:Boolean Read FShowQualif Write setSHowQualif;
    property AShowConsts:boolean Read FShowConsts Write setShowConsts;
    property AShowProcs:boolean Read FShowProcs Write setShowProcs;
    property AShowVars:boolean Read FShowVars Write setShowVars;
    property AShowInherited:boolean Read FShowInherited Write setShowInherited;
  end;

Const
  AHalInspForm: THalInspForm=nil; {don't add to your project}
{---------------------------------}
Procedure ShowInspector;
{---------------------------------}
implementation

{$R *.DFM}
{---------------------------------}

Procedure ShowInspector;
begin
  If not Assigned(AHalInspForm) then 
  begin
    Screen.Cursor:=crHourGlass;
    AHalInspForm:=THalInspForm.Create(Application);
    Screen.Cursor:=crDefault;
  end;
  AHalInspForm.Show;
end;

{---------------------------------}

destructor THalInspForm.destroy;
begin
  ObjExists.Free;
  AHalInspForm:=nil;
  inherited;
end;

{---------------------------------}

procedure THalInspForm.setShowQualif(v:boolean);
begin
  FShowQualif:=V;
  UpdatePropList;
end;

{---------------------------------}

procedure THalInspForm.setShowConsts(v:boolean);
begin
  FShowConsts:=V;
  UpdatePropList;
end;

{---------------------------------}

procedure THalInspForm.setShowProcs(v:boolean);
begin
  FShowProcs:=V;
  UpdatePropList;
end;

{---------------------------------}

procedure THalInspForm.setShowVars(v:boolean);
begin
  FShowVars:=V;
  UpdatePropList;
end;

{---------------------------------}

procedure THalInspForm.setShowInherited(v:boolean);
begin
  FShowInherited:=V;
  UpdatePropList;
end;

{---------------------------------}
const improcedure=1;
      imconst    =0;
      imnone     =-1;
      imvariable =2;
      iminherited=3;
      cproperty ='property    ';
      cfunction ='function    ';
      cprocedure='procedure ';
          cconst='const       ';

procedure THalInspForm.updatePropList;
{---}
procedure SimpleAdd(const aname:String);
begin
 PropList.Items.Add.caption:=aname;
end;
{---}
procedure ObjNameAdd(const aname:String);
var t:tlistitem;
begin
 t:=PropList.Items.Add;
 t.caption:=aname;
 t.imageindex:=-1;
 t.StateIndex:=-1;
end;
{---}
procedure AddList(const aname:string;inher,isfun,isprop:boolean);
var t:tlistitem;
    msi,usi:string;
    i:integer;
begin
 t:=PropList.Items.Add;
 If isprop then begin usi:=cproperty;t.imageindex:=imvariable;end
 else begin
       If isfun=false then usi:=cfunction else usi:=cprocedure;
       t.imageindex:=improcedure;
      end;
 msi:=aname;
 If AShowQualif=false then delete(msi,1,pos('.',msi));
 t.Caption:=usi+msi;
 If inher then t.StateIndex:=3 else t.StateIndex:=-1;
end;
{---}
procedure AddListItem(W:TStringList{;inher:boolean});
var st:string;
    h,k,i:integer;
    isfun,isPropSet,isprop:boolean;
    er:string;
begin
with Funs do begin
 for i:=0 to Count-1 do begin
  isprop:=TFunListItem(Objects[i]).IsProp;
  isFun:=TFunListItem(Objects[i]).Fun;
  isPropSet:=TFunListItem(Objects[i]).IsPropSet;
  er:=Strings[i];
  If (((isprop=false) and (FShowProcs)) or
      ((isprop) and (IsPropSet=false) and (FShowVars)))
     and
  (W.Find(copy(er,1,pos('.',er)),h))
  then AddList(er,w.objects[h]<>nil,isfun,isprop);
 end;
{ If (AShowInherited) then begin
  st:=getpearent(itemname);
  If (st<>'') then AddListItem(st,true);
 end;}
 end;
end;
{---}
procedure addfs(b:boolean);
var i:integer;
begin
  for i:=0 to Funs.Count-1 do
   if (pos('.',Funs.Strings[i])=0)
      and (TFunListItem(Funs.Objects[i]).Fun=b)
   then
   AddList(Funs.Strings[i],false,b,false);
end;
{---}
var i:integer;
    W:TStringList;
    s:string;
label l1;    
begin
 If ObjectTree.Selected=nil then exit;
 PropList.Items.BeginUpdate;
 PropList.Items.Clear;

 IF ObjectTree.Selected=rObj then
  For i:=0 to ObjectTypes.Count-1 do ObjNameAdd(Objecttypes.Strings[i])
 else
 IF ObjectTree.Selected=rFuns then addfs(true)
 else
 IF ObjectTree.Selected=rConst then
  for i:=0 to ResConsts.Count-1 do SimpleAdd(ResConsts[i])
 else
 IF ObjectTree.Selected=rProcs then addfs(false)
 else begin
       s:=ObjectTree.Selected.Text;
       W:=TStringList.Create;
       W.Sorted:=True;
       W.AddObject(s+'.',nil);
       If AShowInherited then
       While true do begin
        S:=getpearent(s);
        If s='' then goto l1;
        W.AddObject(s+'.',self);
       end;
       l1:
       AddListItem(W{,false});
       W.Free;
      end;
{ SimpleAdd('HEHE');}
 PropList.AlphaSort;

 PropList.Items.EndUpdate;
end;
{---------------------------------}
procedure THalInspForm.loaded;
begin
 inherited;
 whenloaded;
end;
{---------------------------------}
procedure THalInspForm.whenloaded;
var i:integer;


function TreeAdd(const parname,aname:string):TTreeNode;forward;

function TreeMAdd(const parname,aname:string):TTreeNode;
var q,j:integer;
    m:TTreeNode;
begin
 With ObjectTree do begin

{  For j:=0 to Items.Count-1 do
   If CompareText(aname,Items[j].Text)=0 then begin
    Result:=Items[j];
    exit;
   end;}

  If Parname='' then Result:=Items.AddChild(rObj,aname)
  else begin
   If ObjExists.Find(parname,q) then begin
     Result:=Items.AddChild(TTreeNode(ObjExists.Objects[q]),aname);
     exit;
   end;

   {For j:=0 to Items.Count-1 do
    If CompareText(parname,Items[j].Text)=0 then begin
     Result:=Items.AddChild(Items[j],aname);
     exit;
    end;}

   m:=TreeAdd(GetPearent(parname),parname);
   Result:=Items.AddChild(m,aname);
  end;
 end;
end;
{--}
function TreeAdd(const parname,aname:string):TTreeNode;
var bname:string;
    q:integer;
begin
  bname:=AnsiUpperCase(aname);
  If ObjExists.Find(bname,q) then
        Result:=TTreeNode(ObjExists.Objects[q])
   else begin
        Result:=TreeMAdd(AnsiUpperCase(parname),bname);
        ObjExists.AddObject(bname,Result);
        end;
end;
{--}
label lw;
var oldtime:TDatetime;
begin
{ UseUnits;}
{$IFDEF TIMES}
 oldtime:=TIme;
{$ENDIF}
 ObjectTree.OnCHange:=nil;
 If not assigned(ObjExists) then begin
  ObjExists:=TStringList.Create;
  ObjExists.Sorted:=True;
 end;
  ObjExists.Clear;
 ObjectTree.Items.BeginUpdate;
 ObjectTree.Items.Clear;
 rFuns:=ObjectTree.Items.Add(nil,inspect_procs);
 rProcs:=ObjectTree.Items.Add(nil,inspect_funs);
 rObj:=ObjectTree.Items.Add(nil,Inspect_objects);
 rConst:=ObjectTree.Items.Add(nil,Inspect_Consts);
 PropList.Items.Clear;
 With ObjectTypes do begin
  For i:=0 to Count-1 do
   TreeAdd(tobjectlistitem(objects[i]).pearent,Strings[i]);
  ObjectTree.AlphaSort;
  ObjectTree.FullExpand;
 end;
{ FShowConsts:=showconsts.down;}
 FShowProcs:=showprocs.down;
 FShowVars:=showvars.down;
 FShowInherited:=showinherited.down;
 ObjectTree.Items.EndUpdate;

 If ObjectTree.Items.Count=0 then goto lw;
 ObjectTree.Selected:=ObjectTree.Items[0];
 AShowQualif:=N4.Checked;
lw:
 ObjectTree.OnChange:=ObjectTreeChange;
{$IFDEF TIMES}
 ShowMessage(TimeToSTr(oldTIme)+#13#10+TimeToSTr(TIme));
{ ShowMessage(TimeToSTr(TIme-oldtime));}
{$ENDIF}
end;
{---------------------------------}
procedure THalInspForm.N4Click(Sender: TObject);
begin
 N4.Checked:=not N4.Checked;
 AShowQualif:=N4.Checked;
end;
{---------------------------------}
procedure THalInspForm.ShowConstsClick(Sender: TObject);
begin
{ AShowConsts:=ShowConsts.down;}
end;
{---------------------------------}
procedure THalInspForm.ShowProcsClick(Sender: TObject);
begin
 AShowProcs:=ShowProcs.down;
end;
{---------------------------------}
procedure THalInspForm.ShowVarsClick(Sender: TObject);
begin
 AShowVars:=ShowVars.down;
end;
{---------------------------------}
procedure THalInspForm.ShowInheritedClick(Sender: TObject);
begin
 AShowInherited:=Showinherited.down;
end;
{---------------------------------}
procedure THalInspForm.ObjectTreeChange(Sender: TObject; Node: TTreeNode);
var b:boolean;
begin
 b:=(ObjectTree.selected<>rObj) and
    (ObjectTree.selected<>rConst) and
    (ObjectTree.selected<>rFuns) and
    (ObjectTree.selected<>rProcs);
 showvars.enabled:=b;
 showprocs.enabled:=b;
 showinherited.enabled:=b;
 label1.enabled:=b;
 updateproplist;
end;

procedure THalInspForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
{ Action:=caFree;}
end;

procedure THalInspForm.SyncButtonClick(Sender: TObject);
begin
 whenloaded;
end;

procedure THalInspForm.LoadAllClick(Sender: TObject);
begin
 Screen.Cursor:=crhourGlass;
 ObjectTree.OnChange:=nil;
 WhenLoaded;
 ObjectTree.OnChange:=ObjectTreeChange;
 Screen.Cursor:=crDefault;
 LoadAll.Visible:=false;
end;

end.
