unit getunit;

interface
uses delphin,dialogs,classes,sysutils;
{--------------------------------}
{ EXTERNAL OBJECT TYPES IMPORT

  You can use function ProcessUnit to import Delphi object types in HAL
  or add object types manually

  After importing add result unit to your project

  procedure processunit(const inname,outname,objlist:string;ImProcs:Boolean);

  inname  - full path to input unit
  outname - full path to output unit
  objlist - list of object names separated by coma
            (only these objects will be processed)
            (if objlist='' then all objects will be processed
  ImProcs - true   import procedures and functions
            false  no import of procedures and functions

  Unfortunately you have to modify output file in some cases
  (unit will not be compiled by Delphi without corrections)
}
{--------------------------------}
type TUnitAn=class(THalCompiler)
     public
      UnitName:String;
      ClassesRead:TStringList;
      ClassesTypes:TStringList;
      ProcNames:TStringList;
      OnlyObj:TStringList;
      AST:TStringList;
      ProcessObj,ProcessFuns:Boolean;
      function getpropparamlist:boolean;
      function  getpropinterf:string;
      procedure propanalyze(const pname:string);
      procedure proceedvar(const pname,vname,vtype:string);
      procedure functionanalyze(const cname:string;r:boolean); {r=true if function}
      procedure getvariables(const pname:string);
      procedure classanalyze(const cname:string);
      procedure compile;override;
      procedure unitnameanalyze;
      constructor Create(M:TMemoryStream;AOnlyObj,MAST:TStringList);
      destructor Destroy;override;
     end;
{--------------------------------}
procedure processunit(const inname,outname,objlist:string;ImProcs:Boolean);
{--------------------------------}
implementation
{--------------------------------}
procedure processunit(const inname,outname,objlist:string;ImProcs:Boolean);
var InpFile:TFileStream;
    InpMem:TMemoryStream;
    OutFile:TFileStream;
    OutUnitName:String;
    OutStrings:TStringList;
    Analyzer:TUnitAn;
    OnlyObjects:TStringList;
    i:integer;
begin
try
try
 OnlyObjects:=TStringList.Create;
 InpFile:=TFileStream.Create(inname,fmopenread);
 InpMem:=TMemoryStream.Create;
 OutFIle:=TFileStream.Create(outname,fmcreate);
 OutUnitName:=extractfilename(outname);
 OutUnitName:=changefileext(outunitname,'');
 OutStrings:=TStringList.Create;
 InpMem.CopyFrom(InpFile,InpFile.Size);
 Analyzer:=TUnitAn.Create(InpMem,OnlyObjects,OutStrings);
 Analyzer.ProcessFuns:=ImProcs;
 OnlyObjects.CommaText:=AnsiUpperCase(objlist);
{--}
 with OutStrings do begin
  Add('Unit '+OutUnitName+';');
  Add('Interface');
  Add('Uses IntLists, ');
  Add('Implementation');
  Add('{');
  Add('');

  Add('To Convert Variant to object use function VO()');
  Add('To Convert Object to variant use function OV()');

  Add('');
  Add('}');
  Add('');
  Analyzer.Compile;

  Add('');
  Add('Initialization');
  Add('');


  for i:=0 to Analyzer.ClassesRead.Count-1 do begin
   Add('   AddObjectType('''+Analyzer.ClassesRead[i]+''','''+
   Analyzer.ClassesTypes[i]+''');');
  end;

  Add('');

  for i:=0 to ANalyzer.ProcNames.Count-1 do
  Add('   '+ANalyzer.ProcNames[i]);

  Strings[2]:=Strings[2]+Analyzer.UnitName+';';
{------------}
  Add('');
  Add('End.');
 end;
{--}
 OutStrings.SaveToStream(OutFile);
 ShowMessage('Everything went OK!');
Finally
 Analyzer.Free;
 InpFile.Free;
 InpMem.Free;
 OutFile.Free;
 OutStrings.Free;
 OnlyObjects.Free;
end;
except
  ShowMessage('There were some problems!');raise;
end;
end;
{--------------------------------}
constructor TUnitAn.Create(M:TMemoryStream;AOnlyObj,MAST:TStringList);
begin
 inherited Create(M,nil);
 ClassesRead:=TStringList.Create;
 ClassesTypes:=TStringList.Create;
 OnlyObj:=AOnlyObj;
 AST:=MAST;
 ProcNames:=TStringList.Create;
end;
{--------------------------------}
destructor TUnitAn.Destroy;
begin
 ClassesRead.Free;
 ClassesTypes.Free;
 ProcNames.Free;
 inherited;
end;
{--------------------------------}
procedure TUnitAn.unitnameanalyze;
begin
 Token:=Readtoken;
 UnitName:=Token.Data;
 getdelimeter;
end;
{--------------------------------}
procedure TUnitAn.functionanalyze(const cname:string;r:boolean); {r=true if function}
var mline,funname:string;
    ParamCount:Integer;
    Params:Array[0..100] of boolean;
{    ParamNames:Array[0..100] of string;
    ParamTypes:Array[0..100] of string;}
    FunType:String;
    rt:integer;
{--}
procedure loadparameters;
var
    curmode:boolean;
label l1,l2;
begin
{while nexttoken.id<>idclosebracket do token:=readtoken;}
l1:
curmode:=false;
 case nexttoken.id of
  id_var: begin
           Token:=ReadToken;
           curmode:=true;
           goto l2;
          end;
  id_const:begin token:=readtoken;goto l2;end;
  idclosebracket:exit;
  id_default,id_read,id_write,id_index,ididentifier:begin
                l2:token:=readtoken;
                   params[paramcount]:=curmode;
                   inc(paramcount);
                   if nexttoken.id=id2points then begin
                    Token:=ReadToken;
                    while (nexttoken.id<>iddelimeter) and
                           (nexttoken.id<>idclosebracket)
                    do Token:=readtoken;{type}
                   end;
                   if nexttoken.id=idcomma then begin
                    token:=readtoken;
                    goto l2;
                   end;
                if nexttoken.id=iddelimeter then token:=readtoken;
                goto l1;
               end;
 end;

end;
{--}
begin
 Token:=ReadToken;{get prefix}
{ If Token.data='POINT' then Showmessage('POINT');}
 Token:=ReadToken;
 FunName:=Token.Data;
 If ProcessObj then ProcessObj:=(FunName[1]<>'_');
 ParamCount:=0;
 if nexttoken.id=idopenbracket then begin
  getopenbracket;
  loadparameters;
  getclosebracket;
 end;
 If r then begin
  Token:=ReadToken;{ get :}
  Token:=Readtoken;
  FunType:=Token.Data;
 end;
 getdelimeter;
 {--}
 if (ProcessObj=false) then exit;
 with AST do begin
 Add('{--------------------}');
 Add('function my'+Cname+FunName+
     '(slf:tobject;var s:array of variant):variant;');
 Add('begin');

 If Cname<>'' then
 mline:=' '+Cname+'(slf).'+FunName else
 mline:=' '+FunName;

 if R then begin
 { if funtype[1]='T' then mline:='ObjToVar('+mline+')';}
  mline:=' Result :='+mline;
 end;

 if paramcount>0 then begin
  mline:=mline+'(';
  for rt:=0 to paramcount-1 do begin
   mline:=mline+'S['+inttostr(rt)+']';
   if rt<paramcount-1 then mline:=mline+',';
  end;
  mline:=mline+')';
 end;
 Mline:=Mline+';';
 Add(mline);
 Add('End;');
 end;

 if r=false then
 mline:='AddProc(' else mline:='AddFun(';
If Cname='' then
 mline:=mline+''''+FunName+''','+'my'+cname+funname+',['
else
 mline:=mline+''''+Cname+'.'+FunName+''','+'my'+cname+funname+',[';

 if paramcount=0 then mline:=mline+'2'
  else begin
        for rt:=0 to paramcount-1 do begin
         if params[rt] then mline:=mline+'1' else mline:=mline+'0';
         if rt<paramcount-1 then mline:=mline+',';
        end;
       end;
 mline:=mline+']);';
 ProcNames.Add(mline);

end;
{--------------------------------}
procedure TUnitAn.proceedvar(const pname,vname,vtype:string);
var mline:string;
const cnm:array[boolean] of string=('get_','set_');
{--}
procedure mdk(f:boolean);{f=false when get}
begin
 with AST do begin
  Add('Function '+pname+cnm[f]+vname+
   '(slf:tobject;var s:array of variant):variant;');
  Add('Begin');
  mline:=pname+'(slf).'+vname;
  if f=false then mline:='  Result := '+mline+';'
   else mline:=mline+':=S[0];';
  Add(mline);
  Add('End;');
 end;
end;
{--}
begin
 {AddProp('TEdit.SelStart',TEditGetSelStart,TEditSetSelStart);}
 mline:='AddProp('''+pname+'.'+vname+''','+
 pname+cnm[false]+vname+','+pname+cnm[true]+vname+');';
 ProcNames.Add(mline);
 Ast.Add('{--------------------}');
 mdk(false);
 Ast.Add('');
 mdk(true);
end;
{--------------------------------}
procedure TUnitAn.getvariables(const pname:string);
var w:array[0..100] of string;
    wcount:integer;
    i:integer;

label l1;
begin
wcount:=0;
l1:
Token:=Readtoken;
w[wcount]:=token.data;
inc(wcount);
if nexttoken.id=idcomma then begin token:=readtoken;goto l1;end;
token:=readtoken;{:}
token:=readtoken;{type}
getdelimeter;
If ProcessObj then
for i:=0 to wcount-1 do proceedvar(pname,w[i],'');
end;
{--------------------------------}
function TUnitAn.getpropparamlist:boolean;
begin
Result:=false;
 if nexttoken.id=idsqopenbracket then begin
  while token.id<>idsqclosebracket do token:=readtoken;
  Result:=true;
 end;
end;
{--------------------------------}
function TUnitAn.getpropinterf:string;
var aw:boolean;
begin
 aw:=getpropparamlist;
 token:=readtoken;{:}
 token:=readtoken;
 Result:=token.data;
 if nexttoken.id=id_index then begin
  token:=readtoken;
  token:=readtoken;
 end;
 if aw then Result:='';
end;
{--------------------------------}
procedure TUnitAn.propanalyze(const pname:string);
 var vname,vtype:string;
label l1;
begin
 Token:=ReadToken;
 Vname:=token.data;
 if nexttoken.id<>iddelimeter then begin
 Vtype:=getpropinterf;if vtype='' then VName:='';end else vtype:='';
 while token.id<>iddelimeter do token:=readtoken;
 if nexttoken.id=id_default then begin
  token:=readtoken;
  getdelimeter;
 end;
 if (length(vname)>0) and (pos('ON',vname)<>1) and (ProcessObj)
 then
 proceedvar(pname,vname,vtype);
end;
{--------------------------------}
procedure TUnitAn.classanalyze(const cname:string);
var CParent:String;
    r:integer;
label l1;
{--}
procedure myskip;
var
    k:integer;
label l1;
begin
l1:
 k:=nexttoken.id;
 if (k<>id_private) and
       (k<>id_protected) and
       (k<>id_public) and
       (k<>id_published) and
       (k<>id_end) then begin Token:=ReadToken;goto l1;end;
end;
{--}
begin
 CParent:='';
 Token:=ReadToken;{class read}
 case nexttoken.id of
  iddelimeter:exit;
  ididentifier:exit;
  idopenbracket:begin
                 getopenbracket;
                 Token:=ReadToken;
                 CParent:=Token.Data;
                 getclosebracket;
                 if nexttoken.id=iddelimeter then exit;
                end;
  id_end:exit;
 end;
 if CParent='' then CPAREnt:='TOBJECT';

If ProcessObj then begin
 ClassesRead.Add(CName);
 ClassesTypes.Add(CParent);
end;
 l1:r:=nexttoken.id;
 case r of
 id_private,id_protected:begin
                          Token:=ReadToken;myskip;
                          goto l1;
                         end;
 id_class,id_public,id_published: begin
                          Token:=ReadToken;
                          goto l1;
                         end;
 id_end:exit;
 ididentifier : begin
                 getvariables(cname);
                 goto l1;
                end;
 id_function,id_procedure,id_constr,id_destr:
           begin
            functionanalyze(cname,(r=id_function) or (r=id_constr));
            getafterproc;
            goto l1;
           end;
 id_property:begin
             Token:=ReadToken;
             propanalyze(cname);
             {myskip;}
             goto l1;
             end;

 else begin Error('Token unknown:'+token.data);goto l1;end;
 end;
end;
{--------------------------------}
procedure TUnitAn.Compile;
 label l1;
 var VarName:String;
     u:integer;
     l:integer;
begin
 l1:
 l:=nextToken.ID;
 case l of
  id_unit     :begin Token:=ReadToken;unitnameanalyze;goto l1;end;
  id_implement:exit;
  id_procedure,id_function:begin
                            {Token:=ReadToken;}
                            ProcessObj:=(ProcessFuns);
                            {and (String(NextToken.data)[1]<>'_');}
                            functionanalyze('',l=id_function);
                            getafterproc;
                            goto l1;
                           end;
  id2points:begin Token:=ReadToken;
                  case nexttoken.id of
                  id_procedure,id_function:token:=readtoken;
                  end;
                  goto l1;
            end;
  idequal     :begin
                 VarName:=Token.Data;
                 Token:=ReadToken;
                 case NextToken.ID of
                 id_class:begin
                           ProcessObj:=(OnlyObj.Count=0) or (OnlyObj.Find(VarName,u));
                           ClassAnalyze(VarName);
                          end;
                 id_function,id_procedure:token:=readtoken;
                 end;
                 goto l1;
               end;
 else begin Token:=ReadToken;goto l1;end;
 end;
end;
{--------------------------------}
end.
