(**************************************************
 *  Delphi 2.x DDE components are scrap, so:      *
 *  A DDE workaround - it ain't more...           *
 *  but it's for free and it helps ;-)            *
 *                                                *
 *  (c) 1997 Konrad Baechler, Zuerich             *
 *  kbaechler@access.ch                           *
 *  http://www.access.ch/private-users/kbaechler  *
 *                                                *
 *  Chief Marketing APIA SA, Kloten               *
 *  http://www.apiasa.com                         *
 *                                                *
 *  If you think this is useful and you extend    *
 *  it, please send me copy. Thanks.              *
 **************************************************)

unit dde;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DB, Buttons, ComCtrls, ExtCtrls, DBTables, Grids,
  Menus, DdeMan;

type
  TF_Main = class(TForm)
    Panel1: TPanel;
    StatusBar1: TStatusBar;
    GroupBox1: TGroupBox;
    edtDDEService: TEdit;
    Label2: TLabel;
    Label5: TLabel;
    edtDDETopic: TEdit;
    sbtQuit: TSpeedButton;
    btnDDEOpen: TBitBtn;
    btnDDEClose: TBitBtn;
    sgDDEReceive: TStringGrid;
    DDEPopup: TPopupMenu;
    RemoveItem1: TMenuItem;
    DdeClientConv: TDdeClientConv;
    DdeClientItem: TDdeClientItem;
    edtItem: TEdit;
    btnItemAdd: TBitBtn;
    lblDDEStatus: TLabel;
    Label3: TLabel;
    Label1: TLabel;
    procedure btnDDEOpenClick(Sender: TObject);
    procedure btnDDECloseClick(Sender: TObject);
    procedure sbtQuitClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnItemAddClick(Sender: TObject);
    procedure edtItemEnter(Sender: TObject);
    procedure RemoveItem1Click(Sender: TObject);
    procedure DdeClientItemChange(Sender: TObject);
  private
    { Private declarations }
    DdeList: TList;
    DdeClient: ^string;
    DdeChangeExit: Boolean;
    procedure DdeClientProcess;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  end;

var
  F_Main: TF_Main;

implementation

{$R *.DFM}

constructor TF_Main.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  with sgDDEReceive do
  begin
    Cells[0,0]:='Item (Source)';
    Cells[1,0]:='Value';
  end;
  {TList for storing the items...}
  DDEList:=TList.Create;
end;

destructor TF_Main.Destroy;
var t: LongInt;
begin
  {clean up}
  if assigned(DDEList) then
  begin
    with DDEList do
    begin
      for t:=0 to Count-1 do
        if assigned(Items[t]) then
          begin
            Dispose(Items[t]);
            Items[t]:=nil;
          end;
      Free;
    end;
  end;
  inherited Destroy;
end;

procedure TF_Main.btnDDEOpenClick(Sender: TObject);
begin
  if DDEClientConv.SetLink(edtDDEService.Text, edtDDETopic.Text) then
  begin
    btnDDEOpen.Enabled:=False;
    btnDDEClose.Enabled:=True;
    btnItemAdd.Enabled:=True;
    lblDDEStatus.Caption:='Connected';
  end
  else
    ShowMessage('Couldnot connect to DDE service');
end;

procedure TF_Main.btnDDECloseClick(Sender: TObject);
var t: integer;
begin
  {Clean up without destroying DDEList}
  if assigned(DDEList) then
  begin
    with DDEList do
    begin
      for t:=0 to Count-1 do
        if assigned(Items[t]) then
          begin
            Dispose(Items[t]);
            Items[t]:=nil;
          end;
      Pack;
    end;
  end;
  btnDDEOpen.Enabled:=True;
  btnDDEClose.Enabled:=False;
  btnItemAdd.Enabled:=False;
  lblDDEStatus.Caption:='Not connected';
end;

procedure TF_Main.sbtQuitClick(Sender: TObject);
begin
  Close;
end;

procedure TF_Main.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  action:=caFree;
end;

procedure TF_Main.btnItemAddClick(Sender: TObject);
begin
  if btnDDEOpen.Enabled then
    ShowMessage('No DDE channel opened.')
  else
  begin
    {Add a new item}
    New(DdeClient);
    DdeClient^:=edtItem.Text;
    DDEList.Add(DdeClient);
    DdeClientItem.DdeItem:=edtItem.Text;

    {Display}
    sgDDEReceive.Cells[0, sgDDEReceive.RowCount-1]:=edtItem.Text;
    sgDDEReceive.RowCount:=sgDDEReceive.RowCount+1
  end;
  btnItemAdd.Default:=false;
end;

procedure TF_Main.edtItemEnter(Sender: TObject);
begin
  btnItemAdd.Default:=true;
end;

procedure TF_Main.RemoveItem1Click(Sender: TObject);
var
  t: LongInt;
begin
  {Removing a single item from the list}
  if assigned(DDEList) then
  with DDEList, sgDDEReceive do
  begin
    Dispose(Items[Selection.Top-1]);
    Items[Selection.Top-1]:=nil;
    Pack;
    Rows[Selection.Top].Clear;
    For t:=Selection.Top to RowCount-2 do
      Rows[t]:=Rows[t+1];
    sgDDEReceive.RowCount:=sgDDEReceive.RowCount-1;
  end
  else
    ShowMessage('DDEList not assigned.');
end;

{ Core procedures of the workaround...}
procedure TF_Main.DdeClientItemChange(Sender: TObject);
begin
  {Since the Sender param is worthless, the handling has to
   happen 'manually' --> DdeClientProcess
   The flag DdeChangeExit provides security against endless looping}
  if not DdeChangeExit then
    DdeClientProcess;
end;

procedure TF_Main.DdeClientProcess;
var
  t: integer;
begin
  {Set flag}
  DdeChangeExit:=True;
  with DdeList do
  {Loop thru DDEList to retrieve all data from DDE service}
  for t:=0 to Count-1 do
    begin
      {Get data...}
      DdeClientItem.DdeItem:=string(Items[t]^);
      {... and display it}
      sgDDEReceive.Cells[1,t+1]:=DdeClientItem.Text;
    end;
  {Clear flag}
  DdeChangeExit:=False;
end;

end.
