//******************************************************************************
//** Registration unit for the DCP cryptographic components ********************
//******************************************************************************
//** Written by David Barton (davebarton@bigfoot.com) **************************
//** http://www.hertreg.ac.uk/ss/ **********************************************
//******************************************************************************
unit CryptReg;

interface
uses
  Classes, DCPcrypt, Blowfish, Cast128, Gost, IDEA, Mars, Misty1, RC2, RC5, RC6,
  Rijndael, Rmd160, SHA1, Twofish;

procedure Register;

//******************************************************************************
//******************************************************************************
implementation

{$R Blowfish.dcr}
{$R Cast128.dcr}
{$R Gost.dcr}
{$R IDEA.dcr}
{$R Mars.dcr}
{$R Misty1.dcr}
{$R RC2.dcr}
{$R RC5.dcr}
{$R RC6.dcr}
{$R Rijndael.dcr}
{$R Rmd160.dcr}
{$R SHA1.dcr}
{$R Twofish.dcr}

procedure Register;
begin
  RegisterComponents(DCPpage,[TDCP_blowfish, TDCP_cast128, TDCP_gost, TDCP_idea,
    TDCP_mars, TDCP_misty1, TDCP_rc2, TDCP_rc5, TDCP_rc6, TDCP_rijndael,
    TDCP_twofish]);
  RegisterComponents(DCPpage,[TDCP_rmd160, TDCP_sha1]);
end;

end.
