{*******************************************************}
{                                                       }
{  TDCMinTray Component                                 }
{                                                       }
{  Copyright (c) 1997-1999 Dream Company                }
{  http://www.dream-com.com                             }
{  e-mail: contact@dream-com.com                        }
{                                                       }
{*******************************************************}
unit dcMinTray;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ShellApi;

type
  TDCMinTray = class(TComponent)
  private
    FForm:TForm;
    FHint:String;
    FIsSetHook:Boolean;
    FMainFormInstance:Pointer;
    FMainFormWndProc:Pointer;
    FTrayData:TNotifyIconData;
    FTrayIconCreated:Boolean;
    Procedure AddTrayIcon;
    Procedure MainFormWndProc(Var Message:TMessage);
    Procedure RemoveTrayIcon;
    Procedure SetHint(const Value:String);
    Procedure UnhookMainForm;
  protected
    Procedure Loaded;override;
  public
    Constructor Create(AOwner:TComponent);override;
    Destructor Destroy;override;
  published
    Property Hint:String read FHint write SetHint;
  end;

procedure Register;

implementation

const
  TrayID=1;
  CM_TRAYICON=WM_USER+1;

Constructor TDCMinTray.Create(AOwner:TComponent);
Begin
  Inherited;
End;

{---------------------------------------------------------}

Destructor TDCMinTray.Destroy;
Begin
  Inherited;
End;

{---------------------------------------------------------}

Procedure TDCMinTray.AddTrayIcon;
Var
  AHint:String;
Begin
  FTrayData.cbSize:=SizeOf(FTrayData);
  FTrayData.Wnd:=FForm.Handle;
  FTrayData.uID:=TrayID;
  FTrayData.uFlags:=NIF_ICON Or NIF_MESSAGE Or NIF_TIP;
  FTrayData.uCallBackMessage:=CM_TRAYICON;
  FTrayData.hIcon:=FForm.Icon.Handle;
  If FTrayData.hIcon=0 Then
    FTrayData.hIcon:=Application.Icon.Handle;
  AHint:=FHint;
  If AHint='' Then
    AHint:=FForm.Caption;  
  StrLCopy(FTrayData.szTip,PChar(AHint),SizeOf(FTrayData.szTip)-1);
  Shell_NotifyIcon(NIM_ADD,@FTrayData);
  FTrayIconCreated:=True;
End;

{---------------------------------------------------------}

Procedure TDCMinTray.Loaded;
Begin
  Inherited;
  If Not (csDesigning In ComponentState) And (Owner Is TForm) And
     ((Application.MainForm=Nil) Or (Owner=Application.MainForm)) Then
  Begin
    FForm:=Owner As TForm;
    FMainFormInstance:=MakeObjectInstance(MainFormWndProc);
    FMainFormWndProc:=Pointer(SetWindowLong(FForm.Handle,GWL_WNDPROC,Integer(FMainFormInstance)));
    FIsSetHook:=True;
  End;
End;

{---------------------------------------------------------}

Procedure TDCMinTray.MainFormWndProc(Var Message:TMessage);
Var
  IsCallWndProc:Boolean;
Begin
  IsCallWndProc:=True;
  Case Message.Msg Of
    WM_SYSCOMMAND:
      Case Message.wParam Of
        SC_MINIMIZE:
        Begin
          ShowWindow(FForm.Handle,SW_HIDE);
          ShowWindow(Application.Handle,SW_HIDE);
          AddTrayIcon;
          IsCallWndProc:=False;
        End;
      End;
    WM_DESTROY:
    Begin
      RemoveTrayIcon;
      UnhookMainForm;
    End;
    CM_TRAYICON:
    Begin
      Case Message.lParam Of
        WM_LBUTTONDBLCLK:
          Begin
            RemoveTrayIcon;
            ShowWindow(Application.Handle,SW_SHOW);
            ShowWindow(FForm.Handle,SW_SHOW);
          End;
      End;
    End;
  End;
  If IsCallWndProc Then
    With Message Do
      Result:=CallWindowProc(FMainFormWndProc,Application.MainForm.Handle,Msg,wParam,lParam);
End;

{---------------------------------------------------------}

Procedure TDCMinTray.RemoveTrayIcon;
Begin
  If FTrayIconCreated Then
  Begin
    Shell_NotifyIcon(NIM_DELETE,@FTrayData);
    FTrayIconCreated:=False;
  End;
End;

{---------------------------------------------------------}

Procedure TDCMinTray.SetHint(const Value:String);
Var
  Data:TNotifyIconData;
Begin
  If FHint=Value Then
    Exit;
  FHint:=Value;
  If FTrayIconCreated Then
  Begin
    Data:=FTrayData;
    Data.uFlags:=NIF_TIP;
    StrLCopy(Data.szTip,PChar(FHint),SizeOf(Data.szTip)-1);
    Shell_NotifyIcon(NIM_MODIFY,@Data);
  End;
End;

{---------------------------------------------------------}

Procedure TDCMinTray.UnhookMainForm;
Begin
  If FIsSetHook Then
  Begin
    SetWindowLong(Application.MainForm.Handle,GWL_WNDPROC,Integer(FMainFormWndProc));
  End;  
End;

procedure Register;
begin
  RegisterComponents('Dream Company', [TDCMinTray]);
end;

end.