unit DemoUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, DcTree, StdCtrls,treeed, Menus, ExtCtrls,dcgen;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    Exit1: TMenuItem;
    Panel1: TPanel;
    Label1: TLabel;
    DCMSTreeView1: TDCMSTreeView;
    SellAllBut: TButton;
    DeSelAllBut: TButton;
    SelLevelBut: TButton;
    EditTreeBut: TButton;
    ListView1: TListView;
    EditListBut: TButton;
    EditMenuBut: TButton;
    IdeInspBut: TButton;
    Demo1: TMenuItem;
    EditTreeView1: TMenuItem;
    EditListView1: TMenuItem;
    EditMenu1: TMenuItem;
    IdeInspector1: TMenuItem;
    Label2: TLabel;
    Label3: TLabel;
    procedure SellAllButClick(Sender: TObject);
    procedure DeSelAllButClick(Sender: TObject);
    procedure SelLevelButClick(Sender: TObject);
    procedure EditTreeButClick(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure EditListButClick(Sender: TObject);
    procedure EditMenuButClick(Sender: TObject);
    procedure IdeInspButClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.SellAllButClick(Sender: TObject);
begin
  DCMSTreeView1.SelectAllItems;
end;

procedure TForm1.DeSelAllButClick(Sender: TObject);
begin
  DCMSTreeView1.DeSelectAllItems;
  DCMSTreeView1.Selected:=nil;
end;

procedure TForm1.SelLevelButClick(Sender: TObject);
var
  level:integer;
  i:integer;
  Lst:Tlist;
begin
  DCMSTreeView1.DeSelectAllItems;
  Lst:=TList.Create;
  with  DCMSTreeView1 do
   if Selected <> nil then
   begin
     BeginUpdate;
     try
       Level:=Selected.Level;
       for i:= 0 to Items.Count-1 do
        if Items[i].Level = level then
           Lst.Add(Items[i]);
       ItemsSelected:=Lst;
     finally
       Lst.Free;
       EndUpdate;
    end;
   end;
end;

procedure TForm1.EditTreeButClick(Sender: TObject);
begin
  EditObject(DCMSTreeView1,'TreeNodes','');
end;
procedure TForm1.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.About1Click(Sender: TObject);
begin
  ShowMessage('Demo project');
end;

procedure TForm1.EditListButClick(Sender: TObject);
begin
  CallPropertyEdit(ListView1,'Items');
end;

procedure TForm1.EditMenuButClick(Sender: TObject);
begin
  CallPropertyEdit(MainMenu1,'Items');
end;

procedure TForm1.IdeInspButClick(Sender: TObject);
begin
  EditObject(Application,'IDE Inspector','');
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  DCMSTreeView1.FullExpand;
end;

initialization
  RegisterInstantTree;

end.
