{*******************************************************}
{                                                       }
{  Copyright (c) 1997,1998 S.Kurinny & S.Kostinsky      }
{                                                       }
{*******************************************************}
unit MainUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, StdCtrls, ComCtrls, ExtCtrls, oinspect, dsgnintf, Grids,
  shellapi, dcsplit;

type
  TMainForm = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Button1: TButton;
    Label1: TLabel;
    CheckBox1: TCheckBox;
    RadioButton1: TRadioButton;
    ListBox1: TListBox;
    ComboBox1: TComboBox;
    ScrollBar1: TScrollBar;
    GroupBox1: TGroupBox;
    RadioButton2: TRadioButton;
    SpeedButton1: TSpeedButton;
    Panel1: TPanel;
    Panel2: TPanel;
    Splitter1: TDCSplitter;
    SelBox: TListBox;
    Button3: TButton;
    PageControl2: TPageControl;
    Properties: TTabSheet;
    Events: TTabSheet;
    Panel3: TPanel;
    RadioVB: TRadioButton;
    RadioDelphi: TRadioButton;
    CheckAliases: TCheckBox;
    CheckGroups: TCheckBox;
    HeaderControl1: THeaderControl;
    PropertyList: TObjectInspector;
    EventList: TObjectInspector;
    Panel4: TPanel;
    Button2: TButton;
    Label2: TLabel;
    procedure ButtonSetClick(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure PropertyListGetCellParams(Sender: TObject; clist: TList;
      propedit: TPropertyEditor; column: Integer; Font: TFont;
      var BackColor: TColor);
    procedure PropertyListDrawCell(Sender: TObject; ACol: Integer;
      ARect: TRect; propedit: TPropertyEditor; var processed: Boolean);
    procedure CheckAliasesClick(Sender: TObject);
    procedure CheckGroupsClick(Sender: TObject);
    procedure HeaderControl1SectionResize(HeaderControl: THeaderControl;
      Section: THeaderSection);
    procedure HeaderControl1SectionTrack(HeaderControl: THeaderControl;
      Section: THeaderSection; Width: Integer; State: TSectionTrackState);
    procedure EventListSplitterMoving(Sender: TObject; X: Integer);
    procedure PropertyListComponentChanged(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation
const
  RegistrationURL = 'http://www.nstarsolutions.com/987.htm';

{$R *.DFM}

procedure TMainForm.ButtonSetClick(Sender: TObject);
var i : integer;
    clist : TList;
begin
  PropertyList.BeginUpdate;
  EventList.BeginUpdate;
  clist := TList.Create;
  with SelBox do
    for i := 0 to SelBox.Items.Count - 1 do
      if Selected[i] then
        clist.Add(TControl(Items.Objects[I]));

  PropertyList.SetControls(clist);
  EventList.SetControls(clist);
  clist.Free;
  PropertyList.EndUpdate;
  EventList.EndUpdate;
end;

procedure TMainForm.Button3Click(Sender: TObject);
var i : integer;
begin
  for i := 0 to Selbox.Items.Count - 1 do
    Selbox.Selected[i] := false;
  PropertyList.CurrentControl := nil;
  EventList.CurrentControl := nil;
end;

procedure TMainForm.RadioGroup1Click(Sender: TObject);
begin
  if RadioDelphi.Checked then
    begin
      PropertyList.Style := isDelphi;
      EventList.Style := isDelphi;
    end
  else
    begin
      PropertyList.Style := isVB;
      EventList.Style := isVB;
    end;
end;

procedure TMainForm.FormCreate(Sender: TObject);
var i : integer;
begin
  Designer := PropertyList.InternalDesigner;
  for i := 0 to ComponentCount - 1 do
   SelBox.Items.AddObject(Components[i].ClassName, Components[i]);
  PageControl1.ActivePage := TabSheet1;
  EventList.Style := isDelphi;
  PropertyList.Style := isDelphi;
  EventList.Options := EventList.Options + [oiUseGroups];
  PropertyList.Options := PropertyList.Options + [oiUseGroups];
  HeaderControl1.Sections[0].
  Width := EventList.FixedColWidth + 2;
end;

procedure TMainForm.PropertyListGetCellParams(Sender: TObject;
  clist: TList; propedit: TPropertyEditor; column: Integer; Font: TFont;
  var BackColor: TColor);
begin
  if Assigned(propedit) and (propedit.GetName = 'Caption') then
    BackColor := clGreen;
end;

procedure TMainForm.PropertyListDrawCell(Sender: TObject; ACol: Integer;
  ARect: TRect; propedit: TPropertyEditor; var processed: Boolean);
var tmp : array[0..100] of char;
begin
  processed := false;
  if  Assigned(propedit) and (propedit.GetName = 'Color') and (ACol = 1) then
   with TObjectInspector(Sender).Canvas do
     begin
       SetTextColor(Handle, StringToColor(propedit.GetValue));
       ExtTextOut(TObjectInspector(Sender).Canvas.Handle, ARect.Left,
                  ARect.Top + 2, ETO_CLIPPED + ETO_OPAQUE,
                  @ARect, StrPCopy(tmp, propedit.GetValue),
                  length(propedit.GetValue), nil);

       processed := true;
     end
end;

procedure TMainForm.CheckAliasesClick(Sender: TObject);
begin
  if CheckAliases.Checked then
    PropertyList.Options := PropertyList.Options + [oiUseAliases]
  else
    PropertyList.Options := PropertyList.Options - [oiUseAliases]
end;

procedure TMainForm.CheckGroupsClick(Sender: TObject);
begin
  if CheckGroups.Checked then
    PropertyList.Options := PropertyList.Options + [oiUseGroups]
  else
    PropertyList.Options := PropertyList.Options - [oiUseGroups]
end;

procedure TMainForm.HeaderControl1SectionResize(
  HeaderControl: THeaderControl; Section: THeaderSection);
begin
  EventList.FixedColWidth := HeaderControl1.Sections[0].Width - 2;
end;

procedure TMainForm.HeaderControl1SectionTrack(
  HeaderControl: THeaderControl; Section: THeaderSection; Width: Integer;
  State: TSectionTrackState);
begin
  EventList.FixedColWidth := Width - 2;
end;

procedure TMainForm.EventListSplitterMoving(Sender: TObject; X: Integer);
begin
  HeaderControl1.Sections[0].Width := X + 2;
end;


procedure TMainForm.PropertyListComponentChanged(Sender: TObject);
var
  index : integer;
  i     : integer;
begin
  index := -1;
  for i := 0 to SelBox.Items.Count - 1 do
    if SelBox.Items.Objects[i] = PropertyList.CurrentControl then
      begin
        index := i;
        break;
      end;

  if index <> -1 then
    if not SelBox.Selected[index] then
      with SelBox do
        for i := 0 to SelBox.Items.Count - 1 do
          Selected[i] := i = index;

  SelBox.ItemIndex := index;
end;

{------------------------------------------------------------------}

procedure JumpToURL(const s : string);
begin
  ShellExecute(Application.MainForm.Handle, nil, PChar(s), nil, nil, SW_SHOW);
end;

{------------------------------------------------------------------}

procedure TMainForm.Button2Click(Sender: TObject);
begin
  JumpToURL(RegistrationURL);
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Designer := nil;
end;

end.
