unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  dsgnintf, typinfo, DCGen, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Memo1: TMemo;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    procedure GetPropEdit(PropEdit : TPropertyEditor);
  public
    procedure ShowAllProperties(c : TComponent);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.GetPropEdit(PropEdit : TPropertyEditor);
begin
  with PropEdit do
    begin
      Memo1.Lines.Add(GetName + ' = ' + GetValue);
      Free;
    end;
end;

procedure TForm1.ShowAllProperties(c : TComponent);
var
  Designer : TFDesigner;
  clist    : TComponentList;
begin
  clist    := TComponentList.Create;
  Designer := TFDesigner.Create;
  try
    Memo1.Lines.Clear;
    clist.Add(c);
    Designer.Form := GetPForm(c);    // GetPForm is declared in DCGEN.PAS
    GetComponentProperties(clist, tkAny - [tkMethod], Designer, GetPropEdit);
  finally
    Designer.Free;
    clist.Free;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
 ShowAllProperties(Button1);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
Close;
end;

end.
