unit DemoForm;
{demo of DBcvt VCL use}
{
1.2		2/11/95
	   	- compiled and tested with version 1.4 of DBcvt
1.5		9/1/96
	   	- compiled and tested with version 1.5 of DBcvt
      - added export test
			- Revison of DBcvt is now show in upper right corner
			- released with DBcvt 1.5
2.0   10/30/96
			- tested to work with DBcvt 2.0.
}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, DBcvt, DBTables, DB, DBCtrls, ExtCtrls, Grids,
  DBGrids;

type
  TForm1 = class(TForm)
    Table1: TTable;
    DataSource1: TDataSource;
    Panel1: TPanel;
    BtnGetData: TButton;
    BtnClose: TButton;
    Table1TAlpha: TStringField;
    Table1TNumber: TFloatField;
    Table1TMoney: TCurrencyField;
    Table1TShort: TSmallintField;
    Table1TLongInt: TIntegerField;
    Table1TBCD: TBCDField;
    Table1TDate: TDateField;
    Table1TTime: TTimeField;
    Table1TTimeStamp: TDateTimeField;
    Table1TMemo: TMemoField;
    Table1TLogical: TBooleanField;
    Label1: TLabel;
    LblError: TLabel;
    DBMemo1: TDBMemo;
    DBGrid1: TDBGrid;
    Memo1: TMemo;
    Panel2: TPanel;
    Panel3: TPanel;
    Panel4: TPanel;
    CkbxNames: TCheckBox;
    Table1TCalc: TFloatField;
    Ascii2DB1: TAscii2DB;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Button1: TButton;
    DB2Ascii1: TDB2Ascii;
    Table2: TTable;
    Table2TAlpha: TStringField;
    Table2TNumber: TFloatField;
    Table2TMoney: TCurrencyField;
    Table2TShort: TSmallintField;
    Table2TLongInt: TIntegerField;
    Table2TBCD: TBCDField;
    Table2TDate: TDateField;
    Table2TTime: TTimeField;
    Table2TTimeStamp: TDateTimeField;
    Table2TMemo: TMemoField;
    Table2TLogical: TBooleanField;
    Table2TAutoIncrement: TIntegerField;
    Button2: TButton;
    Label5: TLabel;
    Label6: TLabel;
    procedure BtnGetDataClick(Sender: TObject);
    procedure BtnCloseClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Btn_SaveClick(Sender: TObject);
    procedure Ascii2DB1Parse(Sender: TObject; var ParsedList: TList;
      aRecord: string; var NumberOfFields: LongInt);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{Get data from ASCII file}
procedure TForm1.BtnGetDataClick(Sender: TObject);
var
	r: word;
begin
	if Memo1.Modified then begin
  	r := MessageDlg('Save memo edits?', mtConfirmation, mbYesNoCancel,0);
    case r of
		mrCancel: exit;
    mrYes: Memo1.Lines.SaveToFile(Ascii2DB1.AsciiFile);
    end;
  end;

	if CkBxNames.State = cbChecked
	then Ascii2DB1.NamesFirst := true
	else Ascii2DB1.NamesFirst := false;
	DataSource1.Enabled := False;
	Ascii2DB1.Execute;
	Table1.Active := True;
	DataSource1.Enabled := True;
	LblError.Caption := GetErrorString(Ascii2DB1.ErrorCode);
end;

{quite demo app}
procedure TForm1.BtnCloseClick(Sender: TObject);
begin
	close;
end;

{set things up so it will work no matter where installed}
procedure TForm1.FormCreate(Sender: TObject);
begin
	Ascii2DB1.AsciiFile := ExtractFilePath(Application.ExeName) + Ascii2DB1.AsciiFile;
	Table1.DataBaseName := ExtractFilePath(Application.ExeName);
	Memo1.Lines.LoadFromFile(Ascii2DB1.AsciiFile);
 	Table1.Active := True;
	DataSource1.Enabled := True;
	Label2.caption := 'Version: ' + DBcvtVersion;
end;

{save (and overwrite) source.txt}
procedure TForm1.Btn_SaveClick(Sender: TObject);
begin
	Memo1.Lines.SaveToFile(Ascii2DB1.AsciiFile);
end;

{Change string to upper case}
{in OnParse, we must edit the parsedList's (TFieldStream) FieldString value}
procedure TForm1.Ascii2DB1Parse(Sender: TObject; var ParsedList: TList;
  aRecord: String; var NumberOfFields: LongInt);
var
  fs: TFieldStream;
begin
	if NumberOfFields > 1 then begin
	  fs := TFieldStream(ParsedList.Items[0]);
    fs.fieldstring := UpperCase(fs.fieldstring);
	end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
	DB2Ascii1.Execute;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
	Table1.DisableControls;
	Table1.Active := False;
	Table1.Close;
	Table1.EmptyTable;
  Table1.Active := True;
  Table1.EnableControls;
end;

end.

(*
{convert first record to upper case before adding to table}
procedure TForm1.Ascii2DB1Parse(Sender: TObject;
  var ParsedStrings: TStringList);
var
	s: String;
begin
	if ParsedStrings.Count > 1 then begin
		ParsedStrings[0] := UpperCase(ParsedStrings[0])
		end;
	end;

{do some sort of calculated field}
procedure TForm1.Ascii2DB1PrePost(Sender: TObject; var TempTable: TTable; var OkToPost: Boolean);
begin
	TempTable.FindField('TCalc').AsInteger := TempTable.FindField('TNumber').AsInteger * 2;
end;


end.


  *)
