unit DateEdit;

{ ----------------------------------------------------------------

  TDateEdit
  Version 2, January 1999
  Delphi TEdit control with date and simple numeric validation.

  TDateEdit is a standard Delphi 2 TEdit control, with two new
  boolean methods: IsValidDate and IsValidNumber. Both methods
  return boolean true or false, to make writing it into an
  expression very simple. Please read DATEEDIT.TXT for more info.

  Brought to you by:
  Robert Manning
  South Bay Computer Assistance
  PO Box 21, Stanton, CA 90680
  RobertM782@aol.com
  http://members.aol.com/robertm782/public/sbcapage.htm
  http://members.aol.com/rjmsite2/public/prog1.html

  ---------------------------------------------------------------- }

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TDateEdit = class(TEdit)
  private
    { Private declarations }
    FIsValidDate: Boolean;
    FIsValidNumber: Boolean;
    FMonthErrorMsg: string;
    FDayErrorMsg: string;
    FYearErrorMsg: string;
    FUnknownFormatErrMsg: string;
  protected
    { Protected declarations }
    function CheckDateFormat: Boolean; {checks for valid date in DateEdit.Text}
    function TextNumberFormat: Boolean; {checks for valid number in DateEdit.Text}
    function CheckNumberFormat(entry: string): Boolean; {checks for valid number passed}
  public                                                 {in parameter 'entry'}
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    property IsValidDate: Boolean read CheckDateFormat write FIsValidDate;
    property IsValidNumber: Boolean read TextNumberFormat write FIsValidNumber;
  published
    { Published declarations }
    property MonthErrorMsg: string read FMonthErrorMsg write FMonthErrorMsg;
    property DayErrorMsg: string read FDayErrorMsg write FDayErrorMsg;
    property YearErrorMsg: string read FYearErrorMsg write FYearErrorMsg;
    property UnknownFormatErrMsg: string read FUnknownFormatErrMsg write FUnknownFormatErrMsg;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TDateEdit]);
end;

constructor TDateEdit.Create(AOwner: TComponent);
begin
  inherited Create(AOwner); {The parameter MUST be AOwner}
  {set default error messages}
  MonthErrorMsg := 'Incorrect Month Entry (Valid: 1 to 12)';
  DayErrorMsg := 'Incorrect Day Entry!';
  YearErrorMsg := 'Incorrect Year Entry (Valid: 1900 to 9999)';
  UnknownFormatErrMsg := 'Unknown Date Format in use!';
end;

{function to check text in edit control to see if it's a valid date. we base
 the evaluation on the currently configured Windows settings on the system.}
function TDateEdit.CheckDateFormat: boolean;
var
  monthData: array[1..12] of integer;
  entry, temp1, temp2, temp3, sdf1, sdf2, sdf3: string;
  count, t1, t2, t3, shortDF, j: integer;
  ds: Char;
  myresult: Boolean;
begin
   entry := Text; {get what's in the editbox}
   monthData[1] := 31;
   monthData[2] := 28;
   monthData[3] := 31;
   monthData[4] := 30;
   monthData[5] := 31;
   monthData[6] := 30;
   monthData[7] := 31;
   monthData[8] := 31;
   monthData[9] := 30;
   monthData[10] := 31;
   monthData[11] := 30;
   monthData[12] := 31;
   ds := DateSeparator; {global Windows date separator character}
   myresult := True; {assume valid date, set to false on error}
   temp1 := ''; {these hold month/day/year strings after parsing}
   temp2 := '';
   temp3 := '';
   t1 := 0;
   t2 := 0;
   t3 := 0;
   sdf1 := ''; {these signify which ShortDateFormat is in use}
   sdf2 := '';
   sdf3 := '';
   shortDF := 0;
   count := 1;

   {parse the text and extract month/day/year strings:}
   while (entry[count] <> ds) and (count <= Length(entry)) do
   begin
      if entry[count] in ['0'..'9'] then
         temp1 := temp1 + entry[count]
      else
      begin
         CheckDateFormat := false;
         exit;
      end;
      count := count + 1;
   end;
   count := count + 1; {skip date separator}
   while (entry[count] <> ds) and (count <= Length(entry)) do
   begin
      if entry[count] in ['0'..'9'] then
         temp2 := temp2 + entry[count]
      else
      begin
         CheckDateFormat := false;
         exit;
      end;
      count := count + 1;
   end;
   count := count + 1; {skip date separator}
   while (count <= length(entry)) and (entry[count] <> ' ') and (entry[count] <> '') do
   begin
      if entry[count] in ['0'..'9'] then
         temp3 := temp3 + entry[count]
      else
      begin
         CheckDateFormat := false;
         exit;
      end;
      count := count + 1;
   end;

  {now figure out what the ShortDateFormat is:}
   count := 1;
   while ShortDateFormat[count] <> ds do
    begin
        sdf1 := ShortDateFormat[count];
        count := count + 1;
    end;
   count := count + 1;
   while ShortDateFormat[count] <> ds do
    begin
        sdf2 := ShortDateFormat[count];
        count := count + 1;
    end;
   count := count + 1;
   for j := count to length(ShortDateFormat) do
       sdf3 := ShortDateFormat[j];

   {set a flag based on the ShortDateFormat is:}
   if (uppercase(sdf1) = 'D') and (uppercase(sdf2) = 'M') and (uppercase(sdf3) = 'Y') then
      shortDF := 1
   else if (uppercase(sdf1) = 'M') and (uppercase(sdf2) = 'D') and (uppercase(sdf3) = 'Y') then
      shortDF := 2
   else if (uppercase(sdf1) = 'Y') and (uppercase(sdf2) = 'M') and (uppercase(sdf3) = 'D') then
      shortDF := 3;

   {store values as integers:}
   if (temp1 <> '') and (checkNumberFormat(temp1) = true) then
      t1 := StrToInt(temp1);
   if (temp2 <> '')  and (checkNumberFormat(temp2) = true) then
      t2 := StrToInt(temp2);
   if (temp3 <> '') and (checkNumberFormat(temp3) = true) then
      t3 := StrToInt(temp3);

   {now evaluate based on ShortDateFormat:}
   if shortDF = 1 then
    begin {DAY/MONTH/YEAR}
       if (((t3 mod 4 = 0) and (t3 mod 100 <> 0)) or ((t3 mod 400 = 0))) then
          monthData[2] := 29; {add 1 for a leap year}
       if (t2 < 1) or (t2 > 12) or (Length(temp2) > 2) then
        begin
           if MonthErrorMsg <> '' then
              MessageDlg(MonthErrorMsg, mtError, [mbOk], 0);
           myresult := False;
        end
       else if (t1 < 1) or (t1 > monthData[t2]) or (Length(temp1) > 2) then
        begin
           if DayErrorMsg <> '' then
              MessageDlg(DayErrorMsg+#13+#10+' (Valid: 1 to '+IntToStr(monthdata[t2])+')', mtError, [mbOk], 0);
           myresult := False;
        end
       else if (t3 < 1900) or (t3 > 9999) or (Length(temp3) <> 4) then
        begin
           if YearErrorMsg <> '' then
              MessageDlg(YearErrorMsg, mtError, [mbOk], 0);
           myresult := False;
        end;
    end
   else if shortDF = 2 then
    begin {MONTH/DAY/YEAR}
       if (((t3 mod 4 = 0) and (t3 mod 100 <> 0)) or ((t3 mod 400 = 0))) then
          monthData[2] := 29; {add 1 for a leap year}
       if (t1 < 1) or (t1 > 12) or (Length(temp1) > 2) then
        begin
           if MonthErrorMsg <> '' then
              MessageDlg(MonthErrorMsg, mtError, [mbOk], 0);
           myresult := False;
        end
       else if (t2 < 1) or (t2 > monthData[t1]) or (Length(temp2) > 2)  then
        begin
           if DayErrorMsg <> '' then
              MessageDlg(DayErrorMsg+#13+#10+' (Valid: 1 to '+IntToStr(monthdata[t1])+')', mtError, [mbOk], 0);
           myresult := False;
        end
       else if (t3 < 1900) or (t3 > 9999) or (Length(temp3) <> 4) then
        begin
           if YearErrorMsg <> '' then
              MessageDlg(YearErrorMsg, mtError, [mbOk], 0);
           myresult := False;
        end;
    end
   else if shortDF = 3 then
    begin {YEAR/MONTH/DAY}
       if (((t1 mod 4 = 0) and (t1 mod 100 <> 0)) or ((t1 mod 400 = 0))) then
          monthData[2] := 29; {add 1 for a leap year}
       if (t2 < 1) or (t2 > 12) or (Length(temp2) > 2)  then
        begin
           if MonthErrorMsg <> '' then
              MessageDlg(MonthErrorMsg, mtError, [mbOk], 0);
           myresult := False;
        end
       else if (t3 < 1) or (t3 > monthData[t2]) or (Length(temp3) > 2)  then
        begin
           if DayErrorMsg <> '' then
              MessageDlg(DayErrorMsg+#13+#10+' (Valid: 1 to '+IntToStr(monthdata[t2])+')', mtError, [mbOk], 0);
           myresult := False;
        end
       else if (t1 < 1900) or (t1 > 9999) or (Length(temp1) <> 4) then
        begin
           if YearErrorMsg <> '' then
              MessageDlg(YearErrorMsg, mtError, [mbOk], 0);
           myresult := False;
        end;
    end
   else {UNKNOWN DATE FORMAT}
    begin
       if UnknownFormatErrMsg <> '' then
          MessageDlg(UnknownFormatErrMsg, mtError, [mbOk], 0)
       else
          MessageDlg('Unknown Date Format in use! Use D/M/Y, M/D/Y, or Y/M/D only.', mtError, [mbOk], 0);
       myresult := False;
    end;
   CheckDateFormat := myresult;
end;

{this function is called by CheckDateFormat. checks individual strings that were
parsed from DateEdit.Text to make sure they're really positive integer numbers. if the
text contains anything other than '0'..'9' then the function returns false. we
don't worry about numbers other than positive integers 1 to 9999; test
DateEdit.IsValidNumber if you want to check for float format or normal integers.
note, valid range = 1 to 9999.}
function TDateEdit.CheckNumberFormat(entry: string): Boolean;
var i, num, code: integer;
begin
   checkNumberFormat := false;
   if (entry <> '') and (Length(entry) <= 4) then
   begin
      for i := 1 to Length(entry) do
      begin
         if entry[i] in ['0'..'9'] then
            checkNumberFormat := true
         else
         begin
            checkNumberFormat := false;
            break;
         end;
      end; {for}
      Val(entry, num, code);
      if code <> 0 then
         checkNumberFormat := false;
      if num <= 0 then {make sure this isn't zero}
         checkNumberFormat := false;
   end; {if entry <> ''}
end;

{function to check DateEdit.Text for a valid number.}
function TDateEdit.TextNumberFormat: Boolean;
var num: double;
    code: integer;
begin
   TextNumberFormat := false;
   if Text <> '' then
   begin
      try
         Val(Text, num, code);
         if code = 0 then
            TextNumberFormat := true;
      except
         TextNumberFormat := false;
      end;
   end;
end;

end.