
unit tapitst1;

{ Quick & dirty TAPI sample }

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,
  Tapi, ComCtrls;

const
  { Hard-coded value specifying device ID to initialize, 0..NumDevs }
  DevIdToInitialize = 0;

type
  TForm1 = class(TForm)
    Button1: TButton;
    ListBox1: TListBox;
    Edit1: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    StatusBar1: TStatusBar;
    Button2: TButton;
    Button3: TButton;
    procedure Button1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    LineApp : HLINEAPP;
    Line : HLINE;
    Call : HCALL;
    Version : DWORD;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

function LineCallStateToStr (CallState : DWORD) : string;
begin
  case CallState of
    LINECALLSTATE_IDLE :
      Result:='IDLE';
    LINECALLSTATE_OFFERING :
      Result:='OFFERING';
    LINECALLSTATE_ACCEPTED :
      Result:='ACCEPTED';
    LINECALLSTATE_DIALTONE :
      Result:='DIALTONE';
    LINECALLSTATE_DIALING :
      Result:='DIALING';
    LINECALLSTATE_RINGBACK :
      Result:='RINGBACK';
    LINECALLSTATE_BUSY :
      Result:='BUSY';
    LINECALLSTATE_SPECIALINFO :
      Result:='SPECIALINFO';
    LINECALLSTATE_CONNECTED :
      Result:='CONNECTED';
    LINECALLSTATE_PROCEEDING :
      Result:='PROCEEDING';
    LINECALLSTATE_ONHOLD :
      Result:='ONHOLD';
    LINECALLSTATE_CONFERENCED :
      Result:='CONFERENCED';
    LINECALLSTATE_ONHOLDPENDCONF :
      Result:='ONHOLDPENDCONF';
    LINECALLSTATE_ONHOLDPENDTRANSFER :
      Result:='ONHOLDPENDTRANSFER';
    LINECALLSTATE_DISCONNECTED :
      Result:='DISCONNECTED';
    LINECALLSTATE_UNKNOWN :
      Result:='UNKNOWN';
  else
    Result:='Unknown (' + IntTostr(CallState) + ')';
  end;
end;

function LineCallStateInfoToStr (CallState, Info : DWORD) : string;
begin
  Result:='';
  case CallState of
    LINECALLSTATE_DIALTONE :
      case Info of
        LINEDIALTONEMODE_NORMAL :
          Result:='NORMAL';
        LINEDIALTONEMODE_SPECIAL :
          Result:='SPECIAL';
        LINEDIALTONEMODE_INTERNAL :
          Result:='INTERNAL';
        LINEDIALTONEMODE_EXTERNAL :
          Result:='EXTERNAL';
        LINEDIALTONEMODE_UNKNOWN :
          Result:='UNKNOWN';
        LINEDIALTONEMODE_UNAVAIL :
          Result:='UNAVAIL';
      end;
    LINECALLSTATE_BUSY :
      case Info of
        LINEBUSYMODE_sTATION :
          Result:='STATION';
        LINEBUSYMODE_TRUNK :
          Result:='TRUNK';
        LINEBUSYMODE_UNKNOWN :
          Result:='UNKNOWN';
        LINEBUSYMODE_UNAVAIL :
          Result:='UNAVAIL';
      end;
    LINECALLSTATE_DISCONNECTED :
      case Info of
        LINEDISCONNECTMODE_NORMAL :
          Result:='NORMAL';
        LINEDISCONNECTMODE_UNKNOWN :
          Result:='UNKNOWN';
        LINEDISCONNECTMODE_REJECT :
          Result:='REJECT';
        LINEDISCONNECTMODE_PICKUP :
          Result:='PICKUP';
        LINEDISCONNECTMODE_FORWARDED :
          Result:='FORWARDED';
        LINEDISCONNECTMODE_BUSY :
          Result:='BUSY';
        LINEDISCONNECTMODE_NOANSWER :
          Result:='NOANSWER';
        LINEDISCONNECTMODE_BADADDRESS :
          Result:='BADADDRESS';
        LINEDISCONNECTMODE_UNREACHABLE :
          Result:='UNREACHABLE';
        LINEDISCONNECTMODE_CONGESTION :
          Result:='CONGESTION';
        LINEDISCONNECTMODE_INCOMPATIBLE :
          Result:='INCOMPATIBLE';
        LINEDISCONNECTMODE_UNAVAIL :
          Result:='UNAVAIL'
      end;
  end;
  if Result = '' then
    Result:='Undefined (' + IntToStr(Info) + ')';
end;

procedure LineCallbackProc (hDevice,
                            dwMessage,
                            dwInstance,
                            dwParam1,
                            dwParam2,
                            dwParam3 : DWORD); stdcall; far;
var
  S : string;
begin
  case dwMessage of
    LINE_CALLSTATE :
      begin
        Form1.StatusBar1.SimpleText:=
          'Device state is ' + LineCallStateToStr(dwParam1) + ' (' +
          LineCallStateInfoToStr(dwParam1, dwParam2) + ')';

        S:='LINE_CALLSTATE, state = ' +
          LineCallStateToStr(dwParam1) + '; ' +
          LineCallStateInfoToStr(dwParam1, dwParam2);

        Form1.Button2.Enabled:=
          (dwParam1 <> LINECALLSTATE_IDLE) and
          (dwParam1 <> LINECALLSTATE_DISCONNECTED); 
      end;
    LINE_REPLY :
      S:='LINE_REPLY, result = ' + IntToStr(dwParam2);
  else
    S:='# ' + IntToStr(dwMessage);
  end;
  Form1.ListBox1.Items.Add(
    'Device ' + IntToStr(hDevice) + ': ' + S);
end;

procedure TForm1.Button1Click(Sender: TObject);
const
  DeviceIdSize = 128;
var
  r : Integer;
  LineCallParams : TLINECALLPARAMS;
  DeviceId : LPVARSTRING;
  P : PChar;
begin
{!! This code gets the device ID from a line handle

  GetMem(DeviceId, DeviceIdSize);
  try
    DeviceId^.dwTotalSize:=DeviceIdSize;
    TapiCheck(lineGetID(Line, 0, Call, LINECALLSELECT_LINE, DeviceId, 'tapi/line'));
    P:=Pointer(Integer(DeviceId) + DeviceId^.dwStringOffset);

    TapiCheck(lineConfigDialog(DevId, Self.Handle, 'tapi/line'));
  finally
    FreeMem(DeviceId, DeviceIdSize);
  end;
}

  FillChar(LineCallParams, SizeOf(LineCallParams), 0);
  with LineCallParams do
    begin
      dwTotalSize:=SizeOf(LineCallParams);
      dwBearerMode:=LINEBEARERMODE_VOICE;
      dwMediaMode:=LINEMEDIAMODE_DATAMODEM;
      dwCallParamFlags:=LINECALLPARAMFLAGS_ORIGOFFHOOK;
    end;
  TapiCheck(lineMakeCall(Line, @Call, PChar(Edit1.Text), 0, @LineCallParams));
  Button2.Enabled:=True;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  if Call.unused <> 0 then
    lineDrop(Call, nil, 0);

  if Line.unused <> 0 then
    lineClose(Line);

  TapiCheck(lineShutdown(LineApp));
end;

procedure TForm1.FormCreate(Sender: TObject);
const
  HiVer = $00020000;  // Highest API version wanted (2.0)
  LoVer = $00010004;  // Lowest API version accepted (1.4)
var
  NumDevs : Integer;
  Ext : TLINEEXTENSIONID;
begin
  TapiCheck(lineInitialize(@LineApp,
                           System.hInstance,
                           LineCallbackProc,
                           'TapiTst',
                           @NumDevs));
  StatusBar1.SimpleText:='TAPI initialized. Devices = ' + IntToStr(NumDevs);
  StatusBar1.Update;

  Version:=0;
  TapiCheck(lineNegotiateAPIVersion(LineApp, DevIdToInitialize,
    LoVer, HiVer, @Version, @Ext));

  TapiCheck(lineOpen(LineApp, DevIdToInitialize, @Line, Version, 0, 0,
    LINECALLPRIVILEGE_OWNER,
    LINEMEDIAMODE_DATAMODEM, nil));

  Button1.Enabled:=True;
  Button3.Enabled:=True;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  TapiCheck(lineConfigDialog(DevIdToInitialize, Self.Handle, nil));
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  if Call.unused <> 0 then
    begin
      lineDrop(Call, nil, 0);
      Call.unused:=0;
    end;
end;

end.

