{ Translated 15/11/96 by Alexander Staubo <alex@image.no>. For information
  about the translation, see notes in oledb.pas.
}

{!! 2-byte enumerated types seems to be the norm here }
{$MINENUMSIZE 2}

unit Transact;

interface

uses
  Ole2, Windows;

//.-------------------------------------------------------------------------
//.
//.  Microsoft Windows
//.  Copyright (C) Microsoft Corporation, 1995.
//.
//.  File: transact.idl
//.
//.  Contents: The basic transaction interfaces and types.
//.
//.--------------------------------------------------------------------------

type
  {!! Conversion types }
  LONG = Longint;

			(* size is 16 *)
  PBOID = ^TBOID;  //!! Added
  TBOID =
    record
      rgb : array[0..15] of Byte;
    end;

const
  BOID_NULL : TBOID = (rgb : (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0));
  {!!
  #define BOID_NULL (*((BOID*)(&IID_NULL)))
  }

  MAX_TRAN_DESC = 40;		// used by XACTOPT via midl - see transact.idl

			(* size is 16 *)
type
  TXACTUOW = TBOID;

			(* size is 4 *)
  TISOLEVEL = LONG;

{$IFDEF Win32}
const
  ISOLATIONLEVEL_UNSPECIFIED      = $ffffffff;
	ISOLATIONLEVEL_CHAOS            = $10;
	ISOLATIONLEVEL_READUNCOMMITTED  = $100;
	ISOLATIONLEVEL_BROWSE           = $100;
	ISOLATIONLEVEL_CURSORSTABILITY  = $1000;
	ISOLATIONLEVEL_READCOMMITTED	  = $1000;
	ISOLATIONLEVEL_REPEATABLEREAD	  = $10000;
	ISOLATIONLEVEL_SERIALIZABLE	    = $100000;
	ISOLATIONLEVEL_ISOLATED	        = $100000;
type
			(* size is 2 *)
  TISOLATIONLEVEL = Word;  //!! Correct size?
{$ELSE}
const
  ISOLATIONLEVEL_UNSPECIFIED      = $FFFFFFFF;
  ISOLATIONLEVEL_CHAOS            = $00000010;
  ISOLATIONLEVEL_READUNCOMMITTED  = $00000100;
  ISOLATIONLEVEL_BROWSE           = $00000100;
  ISOLATIONLEVEL_CURSORSTABILITY  = $00001000;
  ISOLATIONLEVEL_READCOMMITTED    = $00001000;
  ISOLATIONLEVEL_REPEATABLEREAD   = $00010000;
  ISOLATIONLEVEL_SERIALIZABLE     = $00100000;
  ISOLATIONLEVEL_ISOLATED         = $00100000;
{$ENDIF}

type
			(* size is 40 *)
  TXACTTRANSINFO =
    record
      uow : TXACTUOW;
      isoLevel : TISOLEVEL;
      isoFlags : ULONG;
      grfTCSupported : DWORD;
      grfRMSupported : DWORD;
      grfTCSupportedRetaining : DWORD;
      grfRMSupportedRetaining : DWORD;
    end;

			(* size is 36 *)
  TXACTSTATS =
    record
      cOpen : ULONG;
      cCommitting : ULONG;
      cCommitted : ULONG;
      cAborting : ULONG;
      cAborted : ULONG;
      cInDoubt : ULONG;
      cHeuristicDecision : ULONG;
      timeTransactionsUp : TFileTime;
    end;

			(* size is 2 *)
  TISOFLAG = Word;  //!! Correct size?

const
  ISOFLAG_RETAIN_COMMIT_DC	= 1;
	ISOFLAG_RETAIN_COMMIT	    = 2;
	ISOFLAG_RETAIN_COMMIT_NO	= 3;
	ISOFLAG_RETAIN_ABORT_DC	  = 4;
	ISOFLAG_RETAIN_ABORT	    = 8;
	ISOFLAG_RETAIN_ABORT_NO	  = 12;
	ISOFLAG_RETAIN_DONTCARE	  = ISOFLAG_RETAIN_COMMIT_DC or ISOFLAG_RETAIN_ABORT_DC;
	ISOFLAG_RETAIN_BOTH	      = ISOFLAG_RETAIN_COMMIT or ISOFLAG_RETAIN_ABORT;
	ISOFLAG_RETAIN_NONE       = ISOFLAG_RETAIN_COMMIT_NO or ISOFLAG_RETAIN_ABORT_NO;
	ISOFLAG_OPTIMISTIC	      = 16;

type
			(* size is 2 *)
  TXACTTC = Word;  //!! Correct size?

const
  XACTTC_SYNC_PHASEONE	= 1;
	XACTTC_SYNC_PHASETWO	= 2;
	XACTTC_SYNC	          = 2;
	XACTTC_ASYNC_PHASEONE	= 4;

type
			(* size is 2 *)
  TXACTRM = Word;  //!! Correct size?

const
  XACTRM_OPTIMISTICLASTWINS	= 1;
	XACTRM_NOREADONLYPREPARES	= 2;

type
			(* size is 2 *)
  TXACTCONST = Word;  //!! Correct size?

const
  XACTCONST_TIMEOUTINFINITE	= 0;

			(* size is 2 *)
type
  TXACTHEURISTIC = Word;  //!! Correct size?

const
  XACTHEURISTIC_ABORT	  = 1;
	XACTHEURISTIC_COMMIT	= 2;
	XACTHEURISTIC_DAMAGE	= 3;
	XACTHEURISTIC_DANGER	= 4;

{$IFDEF Win32}
type
			(* size is 2 *)
  TXACTSTAT = Word;  //!! Correct size?

const
  XACTSTAT_NONE	= 0;
	XACTSTAT_OPENNORMAL	= $1;
	XACTSTAT_OPENREFUSED	= $2;
	XACTSTAT_PREPARING	= $4;
	XACTSTAT_PREPARED	= $8;
	XACTSTAT_PREPARERETAINING	= $10;
	XACTSTAT_PREPARERETAINED	= $20;
	XACTSTAT_COMMITTING	= $40;
	XACTSTAT_COMMITRETAINING	= $80;
	XACTSTAT_ABORTING	= $100;
	XACTSTAT_ABORTED	= $200;
	XACTSTAT_COMMITTED	= $400;
	XACTSTAT_HEURISTIC_ABORT	= $800;
	XACTSTAT_HEURISTIC_COMMIT	= $1000;
	XACTSTAT_HEURISTIC_DAMAGE	= $2000;
	XACTSTAT_HEURISTIC_DANGER	= $4000;
	XACTSTAT_FORCED_ABORT	= $8000;
	XACTSTAT_FORCED_COMMIT	= $10000;
	XACTSTAT_INDOUBT	= $20000; 
	XACTSTAT_CLOSED	= $40000; 
	XACTSTAT_OPEN	= $3;
	XACTSTAT_NOTPREPARED	= $7ffc3;
	XACTSTAT_ALL	= $7ffff;
{$ELSE}
const
  XACTSTAT_NONE               = $00000000;
  XACTSTAT_OPENNORMAL         = $00000001;
  XACTSTAT_OPENREFUSED        = $00000002;
  XACTSTAT_PREPARING          = $00000004;
  XACTSTAT_PREPARED           = $00000008;
  XACTSTAT_PREPARERETAINING   = $00000010;
  XACTSTAT_PREPARERETAINED    = $00000020;
  XACTSTAT_COMMITTING         = $00000040;
  XACTSTAT_COMMITRETAINING    = $00000080;
  XACTSTAT_ABORTING           = $00000100;
  XACTSTAT_ABORTED            = $00000200;
  XACTSTAT_COMMITTED          = $00000400;
  XACTSTAT_HEURISTIC_ABORT    = $00000800;
  XACTSTAT_HEURISTIC_COMMIT   = $00001000;
  XACTSTAT_HEURISTIC_DAMAGE   = $00002000;
  XACTSTAT_HEURISTIC_DANGER   = $00004000;
  XACTSTAT_FORCED_ABORT       = $00008000;
  XACTSTAT_FORCED_COMMIT      = $00010000;
  XACTSTAT_INDOUBT            = $00020000;
  XACTSTAT_CLOSED             = $00040000;
  XACTSTAT_OPEN               = $00000003;
  XACTSTAT_NOTPREPARED        = $0007FFC3;
  XACTSTAT_ALL                = $0007FFFF;
{$ENDIF}

			(* size is 44 *)
type
  TXACTOPT =
    record
      ulTimeout : ULONG;
      szDescription : array[0..39] of Char;
    end;

  ITransaction =
    class(IUnknown)
    public
      function Commit(
            (* [in] *) fRetaining : BOOL;
            (* [in] *) grfTC : DWORD;
            (* [in] *) grfRM : DWORD) : HResult; virtual; stdcall; abstract;

      function Abort(
            (* [in] *) pboidReason : PBOID;
            (* [in] *) fRetaining : BOOL;
            (* [in] *) fAsync : BOOL) : HResult; virtual; stdcall; abstract;

      function GetTransactionInfo(
            (* [out] *) var pinfo : TXACTTRANSINFO) : HResult; virtual; stdcall; abstract;
    end;

  ITransactionOptions = class;

  ITransactionDispenser =
    class(IUnknown)
    public
      function GetOptionsObject(
            (* [out] *) var ppOptions : ITransactionOptions) : HResult; virtual; stdcall; abstract;

      function BeginTransaction(
            (* [in] *) punkOuter : IUnknown;
            (* [in] *) isoLevel : TISOLEVEL;
            (* [in] *) isoFlags : ULONG;
            (* [in] *) pOptions : ITransactionOptions;
            (* [out] *) var ppTransaction : ITransaction) : HResult; virtual; stdcall; abstract;
    end;

  ITransactionOptions =
    class(IUnknown)
    public
      function SetOptions(
            (* [in] *) var pOptions : TXACTOPT) : HResult; virtual; stdcall; abstract;

      function GetOptions(
            (* [out][in] *) var pOptions : TXACTOPT) : HResult; virtual; stdcall; abstract;
    end;

  ITransactionOutcomeEvents =
    class(IUnknown)
    public
      function Committed(
            (* [in] *) fRetaining : BOOL;
            (* [in] *) var pNewUOW : TXACTUOW;
            (* [in] *) hr : HResult) : HResult; virtual; stdcall; abstract;

      function Aborted(
            (* [in] *) pboidReason : PBOID;
            (* [in] *) fRetaining : BOOL;
            (* [in] *) var pNewUOW : TXACTUOW;
            (* [in] *) hr : HResult) : HResult; virtual; stdcall; abstract;

      function HeuristicDecision(
            (* [in] *) dwDecision : DWORD;
            (* [in] *) pboidReason : PBOID;
            (* [in] *) hr : HResult) : HResult; virtual; stdcall; abstract;

      function Indoubt : HResult; virtual; stdcall; abstract;
    end;

  ITransactionCompletionEvents =
    class(IUnknown)
    public
      function Committed(
            (* [in] *) fRetaining : BOOL;
            (* [in] *) var pNewUOW : TXACTUOW;
            (* [in] *) hr : HResult) : HResult; virtual; stdcall; abstract;

      function Aborted(
            (* [in] *) pboidReason : PBOID;
            (* [in] *) fRetaining : BOOL;
            (* [in] *) var pNewUOW : TXACTUOW;
            (* [in] *) hr : HResult) : HResult; virtual; stdcall; abstract;

      function HeuristicDecision(
            (* [in] *) dwDecision : DWORD;
            (* [in] *) pboidReason : PBOID;
            (* [in] *) hr : HResult) : HResult; virtual; stdcall; abstract;

      function Indoubt : HResult; virtual; stdcall; abstract;
    end;

const
  XACT_E_FIRST                    = $8004D000;
  XACT_E_LAST                     = $8004D01E;
  XACT_S_FIRST                    = $0004D000;
  XACT_S_LAST                     = $0004D009;

  XACT_E_ABORTED                  = $8004D019;
  XACT_E_ALREADYOTHERSINGLEPHASE  = $8004D000;
  XACT_E_ALREADYINPROGRESS        = $8004D018;
  XACT_E_CANTRETAIN               = $8004D001;
  XACT_E_COMMITFAILED             = $8004D002;
  XACT_E_COMMITPREVENTED          = $8004D003;
  XACT_E_CONNECTION_DENIED        = $8004D01D;
  XACT_E_CONNECTION_DOWN          = $8004D01C;
  XACT_E_HEURISTICABORT           = $8004D004;
  XACT_E_HEURISTICCOMMIT          = $8004D005;
  XACT_E_HEURISTICDAMAGE          = $8004D006;
  XACT_E_HEURISTICDANGER          = $8004D007;
  XACT_E_INDOUBT                  = $8004D016;
  XACT_E_INVALIDCOOKIE            = $8004D015;
  XACT_E_ISOLATIONLEVEL           = $8004D008;
  XACT_E_LOGFULL                  = $8004D01A;
  XACT_E_NOASYNC                  = $8004D009;
  XACT_E_NOENLIST                 = $8004D00A;
  XACT_E_NOIMPORTOBJECT           = $8004D014;
  XACT_E_NOISORETAIN              = $8004D00B;
  XACT_E_NORESOURCE               = $8004D00C;
  XACT_E_NOTCURRENT               = $8004D00D;
  XACT_E_NOTIMEOUT                = $8004D017;
  XACT_E_NOTRANSACTION            = $8004D00E;
  XACT_E_NOTSUPPORTED             = $8004D00F;
  XACT_E_REENLISTTIMEOUT          = $8004D01E;
  XACT_E_TMNOTAVAILABLE           = $8004D01B;
  XACT_E_UNKNOWNRMGRID            = $8004D010;
  XACT_E_WRONGSTATE               = $8004D011;
  XACT_E_WRONGUOW                 = $8004D012;
  XACT_E_XTIONEXISTS              = $8004D013;

  XACT_S_ABORTING                 = $0004D008;
  XACT_S_ALLNORETAIN              = $0004D007;
  XACT_S_ASYNC                    = $0004D000;
  XACT_S_DEFECT                   = $0004D001;
  XACT_S_OKINFORM                 = $0004D004;
  XACT_S_MADECHANGESCONTENT       = $0004D005;
  XACT_S_MADECHANGESINFORM        = $0004D006;
  XACT_S_READONLY                 = $0004D002;
  XACT_S_SINGLEPHASE              = $0004D009;
  XACT_S_SOMENORETAIN             = $0004D003;

///////////////////////////////////////////////////////////////////////
//
// IID definitions for interfaces defined in this header file
//

const
  IID_ITransaction : TGUID                 = (D1 : $0fb15084; D2 : $af41; D3 : $11ce; D4 : ($bd, $2b, $20, $4c, $4f, $4f, $50, $20));
  IID_ITransactionDispenser : TGUID        = (D1 : $3A6AD9E1; D2 : $23B9; D3 : $11cf; D4 : ($AD, $60, $00, $AA, $00, $A7, $4C, $CD));
  IID_ITransactionOptions : TGUID          = (D1 : $3A6AD9E0; D2 : $23B9; D3 : $11cf; D4 : ($AD, $60, $00, $AA, $00, $A7, $4C, $CD));
  IID_ITransactionOutcomeEvents : TGUID    = (D1 : $3A6AD9E2; D2 : $23B9; D3 : $11cf; D4 : ($AD, $60, $00, $AA, $00, $A7, $4C, $CD));
  IID_ITransactionCompletionEvents : TGUID = (D1 : $B38D5220; D2 : $23CE; D3 : $11cf; D4 : ($AD, $60, $00, $AA, $00, $A7, $4C, $CD));

///////////////////////////////////////////////////////////////////////

implementation

end.

