{ Translated 15/11/96 by Alexander Staubo <alex@image.no>. For information
  about the translation, see notes in oledb.pas.
}

unit Oledberr;

//+---------------------------------------------------------------------------
//
//  Microsoft OLE DB
//  Copyright (C) Microsoft Corporation, 1994 - 1996.
//
//----------------------------------------------------------------------------

interface

uses
  Ole2;

//
// ***************************************************************************
// The comment after this block is a message compiler relic and should be
// ignored.  See the OLE 2 documentation for the correct layout:
//
// |S|       Context       |  Fac  |             Code              |
// |3|3 2 2 2 2 2 2 2 2 2 2|1 1 1 1|1 1 1 1 1 1                    |
// |1|0 9 8 7 6 5 4 3 2 1 0|9 8 7 6|5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0|
//
// S       - severity code; 0= $success and 1= $error
// Context - reserved for future use, may or may not be 0
// Fac     - facility code
// Code    - facility's status code
// ***************************************************************************
//

//
//  Values are 32 bit values layed out as follows:
//
//   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
//  +---+-+-+-----------------------+-------------------------------+
//  |Sev|C|R|     Facility          |               Code            |
//  +---+-+-+-----------------------+-------------------------------+
//
//  where
//
//      Sev - is the severity code
//
//          00 - Success
//          01 - Informational
//          10 - Warning
//          11 - Error
//
//      C - is the Customer code flag
//
//      R - is a reserved bit
//
//      Facility - is the facility code
//
//      Code - is the facility's status code
//
//
// Define the facility codes
//
const
  FACILITY_WINDOWS                 = $8;
  FACILITY_ITF                     = $4;


//
// Define the severity codes
//
  STATUS_SEVERITY_SUCCESS          = $0;
  STATUS_SEVERITY_COERROR          = $2;


//
// MessageId: DB_E_BOGUS
//
// MessageText:
//
//  Dummy error - need this error so that mc puts the above defines
//  inside the FACILITY_WINDOWS guard, instead of leaving it empty
//
  DB_E_BOGUS                       = $80040EFF;


//
// Codes $0e00-$0eff are reserved for the OLE DB group of
// interfaces.
//
// Free codes are:
//
//		Error:
//			$0e30
//
//		Success:
//			$0ec9
//			$0ecc
//			$0ed0
//			$0ed7
//


//
// OLEDBVER
//	OLE DB version number ($0100); to use version 2.0 features,
//	  OLEDBVER $0200 before including this file.
//

// If OLEDBVER is not defined, assume version 1.0
const
  OLEDBVER = $0100;

//
// MessageId: DB_E_BADACCESSORHANDLE
//
// MessageText:
//
//  Invalid accessor
//
  DB_E_BADACCESSORHANDLE           = $80040E00;

//
// MessageId: DB_E_ROWLIMITEXCEEDED
//
// MessageText:
//
//  Creating another row would have exceeded the total number of active
//  rows supported by the rowset
//
  DB_E_ROWLIMITEXCEEDED            = $80040E01;

//
// MessageId: DB_E_READONLYACCESSOR
//
// MessageText:
//
//  Unable to write with a read-only accessor
//
  DB_E_READONLYACCESSOR            = $80040E02;

//
// MessageId: DB_E_SCHEMAVIOLATION
//
// MessageText:
//
//  Given values violate the database schema
//
  DB_E_SCHEMAVIOLATION             = $80040E03;

//
// MessageId: DB_E_BADROWHANDLE
//
// MessageText:
//
//  Invalid row handle
//
  DB_E_BADROWHANDLE                = $80040E04;

//
// MessageId: DB_E_OBJECTOPEN
//
// MessageText:
//
//  An object was open
//
  DB_E_OBJECTOPEN                  = $80040E05;


//
// MessageId: DB_E_CANTCONVERTVALUE
//
// MessageText:
//
//  A literal value in the command could not be converted to the
//  correct type due to a reason other than data overflow
//
  DB_E_CANTCONVERTVALUE            = $80040E07;

//
// MessageId: DB_E_BADBINDINFO
//
// MessageText:
//
//  Invalid binding info
//
  DB_E_BADBINDINFO                 = $80040E08;

//
// MessageId: DB_SEC_E_PERMISSIONDENIED
//
// MessageText:
//
//  Permission denied
//
  DB_SEC_E_PERMISSIONDENIED        = $80040E09;

//
// MessageId: DB_E_NOTAREFERENCECOLUMN
//
// MessageText:
//
//  Specified column does not contain bookmarks or chapters
//
  DB_E_NOTAREFERENCECOLUMN         = $80040E0A;


//
// MessageId: DB_E_NOCOMMAND
//
// MessageText:
//
//  No command has been set for the command object
//
  DB_E_NOCOMMAND                   = $80040E0C;


//
// MessageId: DB_E_BADBOOKMARK
//
// MessageText:
//
//  Invalid bookmark
//
  DB_E_BADBOOKMARK                 = $80040E0E;

//
// MessageId: DB_E_BADLOCKMODE
//
// MessageText:
//
//  Invalid lock mode
//
  DB_E_BADLOCKMODE                 = $80040E0F;

//
// MessageId: DB_E_PARAMNOTOPTIONAL
//
// MessageText:
//
//  No value given for one or more required parameters
//
  DB_E_PARAMNOTOPTIONAL            = $80040E10;

//
// MessageId: DB_E_BADCOLUMNID
//
// MessageText:
//
//  Invalid column ID
//
  DB_E_BADCOLUMNID                 = $80040E11;

//
// MessageId: DB_E_BADRATIO
//
// MessageText:
//
//  Invalid ratio
//
  DB_E_BADRATIO                    = $80040E12;


//
// MessageId: DB_E_ERRORSINCOMMAND
//
// MessageText:
//
//  The command contained one or more errors
//
  DB_E_ERRORSINCOMMAND             = $80040E14;

//
// MessageId: DB_E_CANTCANCEL
//
// MessageText:
//
//  The executing command cannot be canceled
//
  DB_E_CANTCANCEL                  = $80040E15;

//
// MessageId: DB_E_DIALECTNOTSUPPORTED
//
// MessageText:
//
//  The provider does not support the specified dialect
//
  DB_E_DIALECTNOTSUPPORTED         = $80040E16;

//
// MessageId: DB_E_DUPLICATEDATASOURCE
//
// MessageText:
//
//  A data source with the specified name already exists
//
  DB_E_DUPLICATEDATASOURCE         = $80040E17;

//
// MessageId: DB_E_CANNOTRESTART
//
// MessageText:
//
//  The rowset was built over a live data feed and cannot be restarted
//
  DB_E_CANNOTRESTART               = $80040E18;

//
// MessageId: DB_E_NOTFOUND
//
// MessageText:
//
//  No key matching the described characteristics could be found within
//  the current range
//
  DB_E_NOTFOUND                    = $80040E19;

//
// MessageId: DB_E_CANNOTFREE
//
// MessageText:
//
//  Ownership of this tree has been given to the provider
//
  DB_E_CANNOTFREE                  = $80040E1A;

//
// MessageId: DB_E_NEWLYINSERTED
//
// MessageText:
//
//  The provider is unable to determine identity for newly inserted
//  rows
//
  DB_E_NEWLYINSERTED               = $80040E1B;


//
// MessageId: DB_E_UNSUPPORTEDCONVERSION
//
// MessageText:
//
//  Requested conversion is not supported
//
  DB_E_UNSUPPORTEDCONVERSION       = $80040E1D;

//
// MessageId: DB_E_BADSTARTPOSITION
//
// MessageText:
//
//  lRowsOffset would position you past either end of the rowset,
//  regardless of the cRows value specified; cRowsObtained is 0
//
  DB_E_BADSTARTPOSITION            = $80040E1E;


//
// MessageId: DB_E_NOTREENTRANT
//
// MessageText:
//
//  Provider called a method from IRowsetNotify in the consumer and	the
//  method has not yet returned
//
  DB_E_NOTREENTRANT                = $80040E20;

//
// MessageId: DB_E_ERRORSOCCURRED
//
// MessageText:
//
//  Errors occurred
//
  DB_E_ERRORSOCCURRED              = $80040E21;

//
// MessageId: DB_E_NOAGGREGATION
//
// MessageText:
//
//  A non-NULL controlling IUnknown was specified and the object being
//  created does not support aggregation
//
  DB_E_NOAGGREGATION               = $80040E22;

//
// MessageId: DB_E_DELETEDROW
//
// MessageText:
//
//  A given HROW referred to a hard- or soft-deleted row
//
  DB_E_DELETEDROW                  = $80040E23;

//
// MessageId: DB_E_CANTFETCHBACKWARDS
//
// MessageText:
//
//  The rowset does not support fetching backwards
//
  DB_E_CANTFETCHBACKWARDS          = $80040E24;

//
// MessageId: DB_E_ROWSNOTRELEASED
//
// MessageText:
//
//  All HROWs must be released before new ones can be obtained
//
  DB_E_ROWSNOTRELEASED             = $80040E25;

//
// MessageId: DB_E_BADSTORAGEFLAG
//
// MessageText:
//
//  One of the specified storage flags was not supported
//
  DB_E_BADSTORAGEFLAG              = $80040E26;

//
// MessageId: DB_E_CANCELLED
//
// MessageText:
//
//  The command was cancelled by a call to Cancel on another thread
//
  DB_E_CANCELLED                   = $80040E27;

//
// MessageId: DB_E_BADSTATUSVALUE
//
// MessageText:
//
//  The specified status flag was neither DBCOLUMNSTATUS_OK nor
//  DBCOLUMNSTATUS_ISNULL
//
  DB_E_BADSTATUSVALUE              = $80040E28;

//
// MessageId: DB_E_CANTSCROLLBACKWARDS
//
// MessageText:
//
//  The rowset cannot scroll backwards
//
  DB_E_CANTSCROLLBACKWARDS         = $80040E29;


//
// MessageId: DB_E_MULTIPLESTATEMENTS
//
// MessageText:
//
//  The provider does not support multi-statement commands
//
  DB_E_MULTIPLESTATEMENTS          = $80040E2E;

//
// MessageId: DB_E_INTEGRITYVIOLATION
//
// MessageText:
//
//  A specified value violated the integrity constraints for a column or
//  table
//
  DB_E_INTEGRITYVIOLATION          = $80040E2F;

//
// MessageId: DB_E_ABORTLIMITREACHED
//
// MessageText:
//
//  Execution aborted because a resource limit has been reached; no
//  results have been returned
//
  DB_E_ABORTLIMITREACHED           = $80040E31;

//
// MessageId: DB_E_ROWSETINCOMMAND
//
// MessageText:
//
//  Cannot clone a command object whose command tree contains a rowset
//  or rowsets
//
  DB_E_ROWSETINCOMMAND             = $80040E32;


//
// MessageId: DB_E_DUPLICATEINDEXID
//
// MessageText:
//
//  The specified index already exists
//
  DB_E_DUPLICATEINDEXID            = $80040E34;

//
// MessageId: DB_E_NOINDEX
//
// MessageText:
//
//  The specified index does not exist
//
  DB_E_NOINDEX                     = $80040E35;

//
// MessageId: DB_E_INDEXINUSE
//
// MessageText:
//
//  The specified index was in use
//
  DB_E_INDEXINUSE                  = $80040E36;

//
// MessageId: DB_E_NOTABLE
//
// MessageText:
//
//  The specified table does not exist
//
  DB_E_NOTABLE                     = $80040E37;

//
// MessageId: DB_E_CONCURRENCYVIOLATION
//
// MessageText:
//
//  The rowset was using optimistic concurrency and the value of a
//  column has been changed since it was last read
//
  DB_E_CONCURRENCYVIOLATION        = $80040E38;

//
// MessageId: DB_E_BADCOPY
//
// MessageText:
//
//  Errors were detected during the copy
//
  DB_E_BADCOPY                     = $80040E39;

//
// MessageId: DB_E_BADPRECISION
//
// MessageText:
//
//  A specified precision was invalid
//
  DB_E_BADPRECISION                = $80040E3A;

//
// MessageId: DB_E_BADSCALE
//
// MessageText:
//
//  A specified scale was invalid
//
  DB_E_BADSCALE                    = $80040E3B;

//
// MessageId: DB_E_BADID
//
// MessageText:
//
//  Invalid table ID
//
  DB_E_BADID                       = $80040E3C;

//
// MessageId: DB_E_BADTYPE
//
// MessageText:
//
//  A specified type was invalid
//
  DB_E_BADTYPE                     = $80040E3D;

//
// MessageId: DB_E_DUPLICATECOLUMNID
//
// MessageText:
//
//  A column ID was occurred more than once in the specification
//
  DB_E_DUPLICATECOLUMNID           = $80040E3E;

//
// MessageId: DB_E_DUPLICATETABLEID
//
// MessageText:
//
//  The specified table already exists
//
  DB_E_DUPLICATETABLEID            = $80040E3F;

//
// MessageId: DB_E_TABLEINUSE
//
// MessageText:
//
//  The specified table was in use
//
  DB_E_TABLEINUSE                  = $80040E40;

//
// MessageId: DB_E_NOLOCALE
//
// MessageText:
//
//  The specified locale ID was not supported
//
  DB_E_NOLOCALE                    = $80040E41;

//
// MessageId: DB_E_BADRECORDNUM
//
// MessageText:
//
//  The specified record number is invalid
//
  DB_E_BADRECORDNUM                = $80040E42;

//
// MessageId: DB_E_BOOKMARKSKIPPED
//
// MessageText:
//
//  Although the bookmark was validly formed, no row could be found to
//  match it
//
  DB_E_BOOKMARKSKIPPED             = $80040E43;

//
// MessageId: DB_E_BADPROPERTYVALUE
//
// MessageText:
//
//  The value of a property was invalid
//
  DB_E_BADPROPERTYVALUE            = $80040E44;

//
// MessageId: DB_E_INVALID
//
// MessageText:
//
//  The rowset was not chaptered
//
  DB_E_INVALID                     = $80040E45;

//
// MessageId: DB_E_BADACCESSORFLAGS
//
// MessageText:
//
//  Invalid accessor
//
  DB_E_BADACCESSORFLAGS            = $80040E46;

//
// MessageId: DB_E_BADSTORAGEFLAGS
//
// MessageText:
//
//  Invalid storage flags
//
  DB_E_BADSTORAGEFLAGS             = $80040E47;

//
// MessageId: DB_E_BYREFACCESSORNOTSUPPORTED
//
// MessageText:
//
//  By-ref accessors are not supported by this provider
//
  DB_E_BYREFACCESSORNOTSUPPORTED   = $80040E48;

//
// MessageId: DB_E_NULLACCESSORNOTSUPPORTED
//
// MessageText:
//
//  Null accessors are not supported by this provider
//
  DB_E_NULLACCESSORNOTSUPPORTED    = $80040E49;

//
// MessageId: DB_E_NOTPREPARED
//
// MessageText:
//
//  The command was not prepared
//
  DB_E_NOTPREPARED                 = $80040E4A;

//
// MessageId: DB_E_BADACCESSORTYPE
//
// MessageText:
//
//  The specified accessor was not a parameter accessor
//
  DB_E_BADACCESSORTYPE             = $80040E4B;

//
// MessageId: DB_E_WRITEONLYACCESSOR
//
// MessageText:
//
//  The given accessor was write-only
//
  DB_E_WRITEONLYACCESSOR           = $80040E4C;

//
// MessageId: DB_SEC_E_AUTH_FAILED
//
// MessageText:
//
//  Authentication failed
//
  DB_SEC_E_AUTH_FAILED             = $80040E4D;

//
// MessageId: DB_E_CANCELED
//
// MessageText:
//
//  The change was canceled during notification; no columns are changed
//
  DB_E_CANCELED                    = $80040E4E;


//
// MessageId: DB_E_BADSOURCEHANDLE
//
// MessageText:
//
//  Invalid source handle
//
  DB_E_BADSOURCEHANDLE             = $80040E50;

//
// MessageId: DB_E_PARAMUNAVAILABLE
//
// MessageText:
//
//  The provider cannot derive parameter info and SetParameterInfo has
//  not been called
//
  DB_E_PARAMUNAVAILABLE            = $80040E51;

//
// MessageId: DB_E_ALREADYINITIALIZED
//
// MessageText:
//
//  The data source object is already initialized
//
  DB_E_ALREADYINITIALIZED          = $80040E52;

//
// MessageId: DB_E_NOTSUPPORTED
//
// MessageText:
//
//  The provider does not support this method
//
  DB_E_NOTSUPPORTED                = $80040E53;

//
// MessageId: DB_E_MAXPENDCHANGESEXCEEDED
//
// MessageText:
//
//  The number of rows with pending changes has exceeded the set limit
//
  DB_E_MAXPENDCHANGESEXCEEDED      = $80040E54;

//
// MessageId: DB_E_BADORDINAL
//
// MessageText:
//
//  The specified column did not exist
//
  DB_E_BADORDINAL                  = $80040E55;

//
// MessageId: DB_E_PENDINGCHANGES
//
// MessageText:
//
//  There are pending changes on a row with a reference count of zero
//
  DB_E_PENDINGCHANGES              = $80040E56;

//
// MessageId: DB_E_DATAOVERFLOW
//
// MessageText:
//
//  A literal value in the command overflowed the range of the type of
//  the associated column
//
  DB_E_DATAOVERFLOW                = $80040E57;

//
// MessageId: DB_E_BADHRESULT
//
// MessageText:
//
//  The supplied HRESULT was invalid
//
  DB_E_BADHRESULT                  = $80040E58;

//
// MessageId: DB_E_BADLOOKUPID
//
// MessageText:
//
//  The supplied LookupID was invalid
//
  DB_E_BADLOOKUPID                 = $80040E59;

//
// MessageId: DB_E_BADDYNAMICERRORID
//
// MessageText:
//
//  The supplied DynamicErrorID was invalid
//
  DB_E_BADDYNAMICERRORID           = $80040E5A;

//
// MessageId: DB_E_PENDINGINSERT
//
// MessageText:
//
//  Unable to get visible data for a newly-inserted row that has not
//  yet been updated
//
  DB_E_PENDINGINSERT               = $80040E5B;

//
// MessageId: DB_E_BADCONVERTFLAG
//
// MessageText:
//
//  Invalid conversion flag
//
  DB_E_BADCONVERTFLAG              = $80040E5C;

//
// MessageId: DB_S_ROWLIMITEXCEEDED
//
// MessageText:
//
//  Fetching requested number of rows would have exceeded total number
//  of active rows supported by the rowset
//
  DB_S_ROWLIMITEXCEEDED            = $00040EC0;

//
// MessageId: DB_S_COLUMNTYPEMISMATCH
//
// MessageText:
//
//  One or more column types are incompatible; conversion errors will
//  occur during copying
//
  DB_S_COLUMNTYPEMISMATCH          = $00040EC1;

//
// MessageId: DB_S_TYPEINFOOVERRIDDEN
//
// MessageText:
//
//  Parameter type information has been overridden by caller
//
  DB_S_TYPEINFOOVERRIDDEN          = $00040EC2;

//
// MessageId: DB_S_BOOKMARKSKIPPED
//
// MessageText:
//
//  Skipped bookmark for deleted or non-member row
//
  DB_S_BOOKMARKSKIPPED             = $00040EC3;


//
// MessageId: DB_S_ENDOFROWSET
//
// MessageText:
//
//  Reached start or end of rowset or chapter
//
  DB_S_ENDOFROWSET                 = $00040EC6;

//
// MessageId: DB_S_COMMANDREEXECUTED
//
// MessageText:
//
//  The provider re-executed the command
//
  DB_S_COMMANDREEXECUTED           = $00040EC7;

//
// MessageId: DB_S_BUFFERFULL
//
// MessageText:
//
//  Variable data buffer full
//
  DB_S_BUFFERFULL                  = $00040EC8;

//
// MessageId: DB_S_CANTRELEASE
//
// MessageText:
//
//  Server cannot release or downgrade a lock until the end of the
//  transaction
//
  DB_S_CANTRELEASE                 = $00040ECA;


//
// MessageId: DB_S_DIALECTIGNORED
//
// MessageText:
//
//  Input dialect was ignored and text was returned in different
//  dialect
//
  DB_S_DIALECTIGNORED              = $00040ECD;

//
// MessageId: DB_S_UNWANTEDPHASE
//
// MessageText:
//
//  Consumer is uninterested in receiving further notification calls for
//  this phase
//
  DB_S_UNWANTEDPHASE               = $00040ECE;

//
// MessageId: DB_S_UNWANTEDREASON
//
// MessageText:
//
//  Consumer is uninterested in receiving further notification calls for
//  this reason
//
  DB_S_UNWANTEDREASON              = $00040ECF;

//
// MessageId: DB_S_COLUMNSCHANGED
//
// MessageText:
//
//  In order to reposition to the start of the rowset, the provider had
//  to reexecute the query; either the order of the columns changed or
//  columns were added to or removed from the rowset
//
  DB_S_COLUMNSCHANGED              = $00040ED1;

//
// MessageId: DB_S_ERRORSRETURNED
//
// MessageText:
//
//  The method had some errors; errors have been returned in the error
//  array
//
  DB_S_ERRORSRETURNED              = $00040ED2;

//
// MessageId: DB_S_BADROWHANDLE
//
// MessageText:
//
//  Invalid row handle
//
  DB_S_BADROWHANDLE                = $00040ED3;

//
// MessageId: DB_S_DELETEDROW
//
// MessageText:
//
//  A given HROW referred to a hard-deleted row
//
  DB_S_DELETEDROW                  = $00040ED4;


//
// MessageId: DB_S_STOPLIMITREACHED
//
// MessageText:
//
//  Execution stopped because a resource limit has been reached; results
//  obtained so far have been returned but execution cannot be resumed
//
  DB_S_STOPLIMITREACHED            = $00040ED6;

//
// MessageId: DB_S_LOCKUPGRADED
//
// MessageText:
//
//  A lock was upgraded from the value specified
//
  DB_S_LOCKUPGRADED                = $00040ED8;

//
// MessageId: DB_S_PROPERTIESCHANGED
//
// MessageText:
//
//  One or more properties were changed as allowed by provider
//
  DB_S_PROPERTIESCHANGED           = $00040ED9;

//
// MessageId: DB_S_ERRORSOCCURRED
//
// MessageText:
//
//  Errors occurred
//
  DB_S_ERRORSOCCURRED              = $00040EDA;

//
// MessageId: DB_S_PARAMUNAVAILABLE
//
// MessageText:
//
//  A specified parameter was invalid
//
  DB_S_PARAMUNAVAILABLE            = $00040EDB;

//
// MessageId: DB_S_MULTIPLECHANGES
//
// MessageText:
//
//  Updating this row caused more than one row to be updated in the
//  data source
//
  DB_S_MULTIPLECHANGES             = $00040EDC;

implementation

end.

