{ Translated 15/11/96 by Alexander Staubo <alex@image.no>

  Translator's notes:
  -------------------
  - Removed many unrelated bits and pieces (MIDL, RPC, DCOM
    and C-specific constructs.)

  - Many enumerated types have been converted to DWORDs
    and the enumerated values converted to constants;
    Delphi enumerated types are always sequential, whereas
    this restriction does not apply to C/C++.

  - Array arguments have been declared as "var" or "const",
    eg.,

      DBBINDSTATUS __RPC_FAR rgStatus[  ]

    will be declared as

      var rgStatus : TDBBINDSTATUS;

    When calling the method, the first element of the array
    must be passed as rgStatus; other method arguments
    specify the actual array count, or similar.

  - I have tried to maintain consistency with the OLE DB
    1.0 Programmer's Reference in using pointers for [out]
    arguments where a nil value may be passed, and "var"
    where a nil value may not be passed.

  - For some reason many (or all? Haven't checked this
    carefully) enumerated types are declared like this:

      THISTYPE = DWORD;
      THISTYPE = ...values...

    Since C/C++ enforces so little type checking, it
    is legal to assign a THISTYPEENUM value to a
    variable declared as THISTYPE; this is not true for
    ObjectPascal, and so the declarations above have
    been translated to the equivalent of:

      TTHISTYPE =
        (
          ...values...
        );

    and the THISTYPEENUM identifier has been removed
    completely. (The exception is TDBPROPENUM, where I
    have preserved the ENUM name to avoid conflicts
    with the TDBPROP type.)

}

{$DEFINE DBINITCONSTANTS}

unit Oledb;

interface

uses
  Ole2, Windows, Transact;

//+---------------------------------------------------------------------------
//
//  Microsoft OLE DB
//  Copyright (C) Microsoft Corporation, 1994 - 1996.
//
//----------------------------------------------------------------------------

{!! Added declarations: }

{ Enums are always DWORDs }
{$MINENUMSIZE 4}

type
  { Conversion types }
  LONG = Longint;
  PLONG = ^LONG;
  PIUnknown = ^IUnknown;
  POleChar = ^TOleChar;

const
  { Interface identifiers not preset in original header files }
  IID_ISequentialStream : TGUID =
    (D1 : $0c733a30; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_IAccessor : TGUID =
    (D1 : $0c733a8c; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_IRowset : TGUID =
    (D1 : $0c733a7c; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_IRowsetInfo : TGUID =
    (D1 : $0c733a55; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_IRowsetLocate : TGUID =
    (D1 : $0c733a7d; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_IRowsetResynch : TGUID =
    (D1 : $0c733a84; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_IRowsetScroll : TGUID =
    (D1 : $0c733a7e; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_IRowsetChange : TGUID =
    (D1 : $0c733a05; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_IRowsetUpdate : TGUID =
    (D1 : $0c733a6d; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_IRowsetIdentity : TGUID =
    (D1 : $0c733a09; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_IRowsetNotify : TGUID =
    (D1 : $0c733a83; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_IRowsetIndex : TGUID =
    (D1 : $0c733a82; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_ICommand : TGUID =
    (D1 : $0c733a63; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_IConvertType : TGUID =
    (D1 : $0c733a88; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_ICommandPrepare : TGUID =
    (D1 : $0c733a26; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_ICommandProperties : TGUID =
    (D1 : $0c733a79; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_ICommandText : TGUID =
    (D1 : $0c733a27; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_ICommandWithParameters : TGUID =
    (D1 : $0c733a64; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_IColumnsRowset : TGUID =
    (D1 : $0c733a10; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_IColumnsInfo : TGUID =
    (D1 : $0c733a11; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_IDBCreateCommand : TGUID =
    (D1 : $0c733a1d; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_IDBCreateSession : TGUID =
    (D1 : $0c733a5d; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_ISourcesRowset : TGUID =
    (D1 : $0c733a1e; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_IDBProperties : TGUID =
    (D1 : $0c733a8a; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_IDBInitialize : TGUID =
    (D1 : $0c733a8b; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_IDBInfo : TGUID =
    (D1 : $0c733a89; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_IDBDataSourceAdmin : TGUID =
    (D1 : $0c733a7a; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_ISessionProperties : TGUID =
    (D1 : $0c733a85; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_IIndexDefinition : TGUID =
    (D1 : $0c733a68; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_ITableDefinition : TGUID =
    (D1 : $0c733a86; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_IOpenRowset : TGUID =
    (D1 : $0c733a69; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_IDBSchemaCommand : TGUID =
    (D1 : $0c733a50; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_IDBSchemaRowset : TGUID =
    (D1 : $0c733a7b; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_IProvideMoniker : TGUID =
    (D1 : $0c733a4d; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_IErrorRecords : TGUID =
    (D1 : $0c733a67; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_IErrorLookup : TGUID =
    (D1 : $0c733a66; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_ISQLErrorInfo : TGUID =
    (D1 : $0c733a74; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_IGetDataSource : TGUID =
    (D1 : $0c733a75; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_ITransactionLocal : TGUID =
    (D1 : $0c733a5f; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_ITransactionJoin : TGUID =
    (D1 : $0c733a5e; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));

  IID_ITransactionObject : TGUID =
    (D1 : $0c733a60; D2 : $2a1c; D3 : $11ce; D4 : ($ad, $e5, $00, $aa, $00, $44, $77, $3d));
    
{$ALIGN ON}  //!! should be equivalent to:
//#include <pshpack2.h>                // 2-byte structure packing

//
// OLEDBVER
//                OLE DB version number ($0100); to use version 2.0 features,
//                #define OLEDBVER $0200 before including this file.
//

// If OLEDBVER is not defined, assume version 1.0
const
  OLEDBVER = $0100;

type
  ISequentialStream =
    class(IUnknown)
    public
      function Read(
          (* [out] *) var pv : Pointer; //!! void __RPC_FAR *pv,
          (* [in] *) cb : ULONG;
          (* [out] *) var pcbRead : ULONG) : HResult; virtual; stdcall; abstract;

      function Write(
          (* [in] *) const pv : Pointer; //!! const void __RPC_FAR *pv,
          (* [in] *) cb : ULONG;
          (* [out] *) var pcbWritten : ULONG) : HResult; virtual; stdcall; abstract;
    end;

  TDBKIND =
    (
      DBKIND_GUID_NAME,
      DBKIND_GUID_PROPID,
      DBKIND_NAME,
      DBKIND_PGUID_NAME,
      DBKIND_PGUID_PROPID,
      DBKIND_PROPID,
      DBKIND_GUID
    );

{!! the uGuid union in the TDBID structure has been declared
    as an external type TGuidUnion }

  TGuidUnion =
    record
      case Integer of
        0 :
          (guid : TGUID);
        1 :
          (pguid : PGUID);
    end;

  PDBID = ^TDBID;  //!! Added
  TDBID =
    record
      uGuid : TGuidUnion;
      eKind : TDBKIND;
      case Integer of
        0 :
          (pwszName : POleStr);
        1 :
          (ulPropid : ULONG);
    end;

  TDB_NUMERIC =
    record
      precision : Byte;
      scale : Byte;
      sign : Byte;
      val : array[0..15] of Byte;
    end;

  TDBVECTOR =
    record
      size : ULONG;
      ptr : Pointer;
    end;

  USHORT = Word;

  TDBDATE =
    record
      year : SHORT;
      month : USHORT;
      day : USHORT;
    end;

  TDBTIME =
    record
      hour : USHORT;
      minute : USHORT;
      second : USHORT;
    end;

  TDBTIMESTAMP =
    record
      year : SHORT;
      month : USHORT;
      day : USHORT;
      hour : USHORT;
      minute : USHORT;
      second : USHORT;
      fraction : ULONG;
    end;

  MIDL_uhyper = ULONG; // ?

  TDB_DECIMAL =
    record
      vt : SHORT;
      sign : SHORT;  //!! ": 8" refers to floating-point?
      scale : SHORT;  //!! --"--
      HiPart : Cardinal;
      LoPart : MIDL_uhyper;
    end;

const
  DBTYPE_NULL                = 1;
  DBTYPE_I2                  = 2;
  DBTYPE_I4                  = 3;
  DBTYPE_R4                  = 4;
  DBTYPE_R8                  = 5;
  DBTYPE_CY                  = 6;
  DBTYPE_DATE                = 7;
  DBTYPE_BSTR                = 8;
  DBTYPE_IDISPATCH           = 9;
  DBTYPE_ERROR               = 10;
  DBTYPE_BOOL                = 11;
  DBTYPE_VARIANT             = 12;
  DBTYPE_IUNKNOWN            = 13;
  DBTYPE_DECIMAL             = 14;
  DBTYPE_UI1                 = 17;
  DBTYPE_ARRAY               = $2000;
  DBTYPE_BYREF               = $4000;
  DBTYPE_I1                  = 16;
  DBTYPE_UI2                 = 18;
  DBTYPE_UI4                 = 19;
  DBTYPE_I8                  = 20;
  DBTYPE_UI8                 = 21;
  DBTYPE_GUID                = 72;
  DBTYPE_VECTOR              = $1000;
  DBTYPE_RESERVED            = $8000;
  DBTYPE_BYTES               = 128;
  DBTYPE_STR                 = 129;
  DBTYPE_WSTR                = 130;
  DBTYPE_NUMERIC             = 131;
  DBTYPE_UDT                 = 132;
  DBTYPE_DBDATE              = 133;
  DBTYPE_DBTIME              = 134;
  DBTYPE_DBTIMESTAMP         = 135;

type
  TDBTYPE = DWORD;

const
  DBPART_INVALID              = 0;
  DBPART_VALUE                = $1;
  DBPART_LENGTH               = $2;
  DBPART_STATUS               = $4;

type
  TDBPART = DWORD;

  TDBPARAMIO =
    (
      DBPARAMIO_NOTPARAM,
      DBPARAMIO_INPUT,
      DBPARAMIO_OUTPUT
    );

  TDBMEMOWNER =
    (
      DBMEMOWNER_CLIENTOWNED,
      DBMEMOWNER_PROVIDEROWNED
    );

  TDBOBJECT =
    record
      dwFlags : DWORD;
      iid : TIID;
    end;

  TDBSTATUS =
    (
      DBSTATUS_S_OK,
      DBSTATUS_E_BADACCESSOR,
      DBSTATUS_E_CANTCONVERTVALUE,
      DBSTATUS_S_ISNULL,
      DBSTATUS_S_TRUNCATED,
      DBSTATUS_E_SIGNMISMATCH,
      DBSTATUS_E_DATAOVERFLOW,
      DBSTATUS_E_CANTCREATE,
      DBSTATUS_E_UNAVAILABLE,
      DBSTATUS_E_PERMISSIONDENIED,
      DBSTATUS_E_INTEGRITYVIOLATION,
      DBSTATUS_E_SCHEMAVIOLATION,
      DBSTATUS_E_BADSTATUS
    );

  TDBBINDEXT =
    record
      pExtension : ^Byte;
      ulExtension : ULONG;
    end;

  PDBBINDING = ^TDBBINDING;
  TDBBINDING =
    record
      iOrdinal : ULONG;
      obValue : ULONG;
      obLength : ULONG;
      obStatus : ULONG;
      pTypeInfo : ITypeInfo;
      pObject : ^TDBOBJECT;
      pBindExt : ^TDBBINDEXT;
      dwPart : TDBPART;
      dwMemOwner : TDBMEMOWNER;
      eParamIO : TDBPARAMIO;
      cbMaxLen : ULONG;
      dwFlags : DWORD;
      wType : TDBTYPE;
      bPrecision : Byte;
      bScale : Byte;
    end;

//!! Unused entries in DBROWSTATUSENUM padded with dummy constants
  TDBROWSTATUS =
    (
       DBROWSTATUS_S_OK,
       DBROWSTATUS_dummy1,
       DBROWSTATUS_S_MULTIPLECHANGES,
       DBROWSTATUS_S_PENDINGCHANGES,
       DBROWSTATUS_E_CANCELED,
       DBROWSTATUS_dummy2,
       DBROWSTATUS_E_CANTRELEASE,
       DBROWSTATUS_E_CONCURRENCYVIOLATION,
       DBROWSTATUS_E_DELETED,
       DBROWSTATUS_E_PENDINGINSERT,
       DBROWSTATUS_E_NEWLYINSERTED,
       DBROWSTATUS_E_INTEGRITYVIOLATION,
       DBROWSTATUS_E_INVALID,
       DBROWSTATUS_E_MAXPENDCHANGESEXCEEDED,
       DBROWSTATUS_E_OBJECTOPEN,
       DBROWSTATUS_E_OUTOFMEMORY,
       DBROWSTATUS_E_PERMISSIONDENIED,
       DBROWSTATUS_E_LIMITREACHED,
       DBROWSTATUS_E_SCHEMAVIOLATION
    );
  PDBROWSTATUS = ^TDBROWSTATUS;
  PPDBROWSTATUS = ^PDBROWSTATUS;

  HACCESSOR = ULONG;

const
  DB_NULL_HACCESSOR = $00;
type
  HROW = ULONG;
  PHROW = ^HROW;  //!! Added
  PPHROW = ^PHROW;  //!! Added

const
  DB_NULL_HROW = $00;
type
  HWATCHREGION = ULONG;

const
  DBWATCHREGION_NULL = nil; //!! was: NULL
type
  HCHAPTER = ULONG;

const
  DB_INVALID_HCHAPTER = $00;

type
  TDBFAILUREINFO =
    record
      hRow : HROW;
      iColumn : ULONG;
      failure : HResult;
    end;

const
  DBCOLUMNFLAGS_ISBOOKMARK           = $1;
  DBCOLUMNFLAGS_MAYDEFER             = $2;
  DBCOLUMNFLAGS_WRITE                = $4;
  DBCOLUMNFLAGS_WRITEUNKNOWN         = $8;
  DBCOLUMNFLAGS_ISFIXEDLENGTH        = $10;
  DBCOLUMNFLAGS_ISNULLABLE           = $20;
  DBCOLUMNFLAGS_MAYBENULL            = $40;
  DBCOLUMNFLAGS_ISLONG               = $80;
  DBCOLUMNFLAGS_ISROWID              = $100;
  DBCOLUMNFLAGS_ISROWVER             = $200;
  DBCOLUMNFLAGS_CACHEDEFERRED        = $1000;

type
  TDBCOLUMNFLAGS = DWORD;

  PDBCOLUMNINFO = ^TDBCOLUMNINFO;  //!! Added
  TDBCOLUMNINFO =
    record
      pwszName : POLESTR;
      pTypeInfo : ITypeInfo;
      iOrdinal : ULONG;
      dwFlags : TDBCOLUMNFLAGS;
      ulColumnSize : ULONG;
      wType : TDBTYPE;
      bPrecision : Byte;
      bScale : Byte;
      columnid : TDBID;
    end;

  TDBBOOKMARK =
    (
      DBBMK_INVALID,
      DBBMK_FIRST,
      DBBMK_LAST
    );

function IsEqualGUIDBase (const rguid1, rguid2 : TGUID) : BOOL;

const
//!! ULONG_MAX has been defined as MaxLongint
  ULONG_MAX = MaxLongint;

  DB_INVALIDCOLUMN = ULONG_MAX;

  DBCIDGUID : TGUID =
    (D1 : $0C733A81; D2 : $2A1C; D3 : $11CE; D4 : ($AD, $E5, $00, $AA, $00, $44, $77, $3D));

  DB_NULLGUID : TGUID =
    (D1 : $00000000; D2 : $0000; D3 : $0000; D4 : ($00, $00, $00, $00, $00, $00, $00, $00));

{$IFDEF DBINITCONSTANTS}
//!! Declarations originally set DBID.uGuid.guid, but here we set pguid instead
const
  DB_NULLID : TDBID                         = (uGuid : ();                   eKind : TDBKIND(0);         ulPropid : 0);
  DBCOLUMN_IDNAME : TDBID                   = (uGuid : (pguid : @DBCIDGUID); eKind : DBKIND_GUID_PROPID; ulPropid : 2);
  DBCOLUMN_NAME : TDBID                     = (uGuid : (pguid : @DBCIDGUID); eKind : DBKIND_GUID_PROPID; ulPropid : 3);
  DBCOLUMN_NUMBER : TDBID                   = (uGuid : (pguid : @DBCIDGUID); eKind : DBKIND_GUID_PROPID; ulPropid : 4);
  DBCOLUMN_TYPE : TDBID                     = (uGuid : (pguid : @DBCIDGUID); eKind : DBKIND_GUID_PROPID; ulPropid : 5);
  DBCOLUMN_PRECISION : TDBID                = (uGuid : (pguid : @DBCIDGUID); eKind : DBKIND_GUID_PROPID; ulPropid : 7);
  DBCOLUMN_SCALE : TDBID                    = (uGuid : (pguid : @DBCIDGUID); eKind : DBKIND_GUID_PROPID; ulPropid : 8);
  DBCOLUMN_FLAGS : TDBID                    = (uGuid : (pguid : @DBCIDGUID); eKind : DBKIND_GUID_PROPID; ulPropid : 9);
  DBCOLUMN_BASECOLMNNAME : TDBID            = (uGuid : (pguid : @DBCIDGUID); eKind : DBKIND_GUID_PROPID; ulPropid : 10);
  DBCOLUMN_BASETABLENAME : TDBID            = (uGuid : (pguid : @DBCIDGUID); eKind : DBKIND_GUID_PROPID; ulPropid : 11);
  DBCOLUMN_COLLATINGSEQUENCE : TDBID        = (uGuid : (pguid : @DBCIDGUID); eKind : DBKIND_GUID_PROPID; ulPropid : 12);
  DBCOLUMN_COMPUTEMODE : TDBID              = (uGuid : (pguid : @DBCIDGUID); eKind : DBKIND_GUID_PROPID; ulPropid : 13);
  DBCOLUMN_DEFAULTVALUE : TDBID             = (uGuid : (pguid : @DBCIDGUID); eKind : DBKIND_GUID_PROPID; ulPropid : 14);
  DBCOLUMN_DOMAINNAME : TDBID               = (uGuid : (pguid : @DBCIDGUID); eKind : DBKIND_GUID_PROPID; ulPropid : 15);
  DBCOLUMN_HASDEFAULT : TDBID               = (uGuid : (pguid : @DBCIDGUID); eKind : DBKIND_GUID_PROPID; ulPropid : 16);
  DBCOLUMN_ISAUTOINCREMENT : TDBID          = (uGuid : (pguid : @DBCIDGUID); eKind : DBKIND_GUID_PROPID; ulPropid : 17);
  DBCOLUMN_ISCASESENSITIVE : TDBID          = (uGuid : (pguid : @DBCIDGUID); eKind : DBKIND_GUID_PROPID; ulPropid : 18);
  DBCOLUMN_ISSEARCHABLE : TDBID             = (uGuid : (pguid : @DBCIDGUID); eKind : DBKIND_GUID_PROPID; ulPropid : 20);
  DBCOLUMN_ISUNIQUE : TDBID                 = (uGuid : (pguid : @DBCIDGUID); eKind : DBKIND_GUID_PROPID; ulPropid : 21);
  DBCOLUMN_BASECATALOGNAME : TDBID          = (uGuid : (pguid : @DBCIDGUID); eKind : DBKIND_GUID_PROPID; ulPropid : 23);
  DBCOLUMN_BASESCHEMANAME : TDBID           = (uGuid : (pguid : @DBCIDGUID); eKind : DBKIND_GUID_PROPID; ulPropid : 24);
  DBCOLUMN_GUID : TDBID                     = (uGuid : (pguid : @DBCIDGUID); eKind : DBKIND_GUID_PROPID; ulPropid : 29);
  DBCOLUMN_PROPID : TDBID                   = (uGuid : (pguid : @DBCIDGUID); eKind : DBKIND_GUID_PROPID; ulPropid : 30);
  DBCOLUMN_TYPEINFO : TDBID                 = (uGuid : (pguid : @DBCIDGUID); eKind : DBKIND_GUID_PROPID; ulPropid : 31);
  DBCOLUMN_DOMAINCATALOG : TDBID            = (uGuid : (pguid : @DBCIDGUID); eKind : DBKIND_GUID_PROPID; ulPropid : 32);
  DBCOLUMN_DOMAINSCHEMA : TDBID             = (uGuid : (pguid : @DBCIDGUID); eKind : DBKIND_GUID_PROPID; ulPropid : 33);
  DBCOLUMN_DATETIMEPRECISION : TDBID        = (uGuid : (pguid : @DBCIDGUID); eKind : DBKIND_GUID_PROPID; ulPropid : 34);
  DBCOLUMN_NUMERICPRECISIONRADIX : TDBID    = (uGuid : (pguid : @DBCIDGUID); eKind : DBKIND_GUID_PROPID; ulPropid : 35);
  DBCOLUMN_OCTETLENGTH : TDBID              = (uGuid : (pguid : @DBCIDGUID); eKind : DBKIND_GUID_PROPID; ulPropid : 36);
  DBCOLUMN_COLUMNSIZE : TDBID               = (uGuid : (pguid : @DBCIDGUID); eKind : DBKIND_GUID_PROPID; ulPropid : 37);
  DBCOLUMN_CLSID : TDBID                    = (uGuid : (pguid : @DBCIDGUID); eKind : DBKIND_GUID_PROPID; ulPropid : 38);
{$ELSE}
var
  DB_NULLID,
  DBCOLUMN_IDNAME,
  DBCOLUMN_NAME,
  DBCOLUMN_NUMBER,
  DBCOLUMN_TYPE,
  DBCOLUMN_PRECISION,
  DBCOLUMN_SCALE,
  DBCOLUMN_FLAGS,
  DBCOLUMN_BASECOLUMNNAME,
  DBCOLUMN_BASETABLENAME,
  DBCOLUMN_COLLATINGSEQUENCE,
  DBCOLUMN_COMPUTEMODE,
  DBCOLUMN_DEFAULTVALUE,
  DBCOLUMN_DOMAINNAME,
  DBCOLUMN_HASDEFAULT,
  DBCOLUMN_ISAUTOINCREMENT,
  DBCOLUMN_ISCASESENSITIVE,
  DBCOLUMN_ISSEARCHABLE,
  DBCOLUMN_ISUNIQUE,
  DBCOLUMN_BASECATALOGNAME,
  DBCOLUMN_BASESCHEMANAME,
  DBCOLUMN_GUID,
  DBCOLUMN_PROPID,
  DBCOLUMN_TYPEINFO,
  DBCOLUMN_DOMAINCATALOG,
  DBCOLUMN_DOMAINSCHEMA,
  DBCOLUMN_DATETIMEPRECISION,
  DBCOLUMN_NUMERICPRECISIONRADIX,
  DBCOLUMN_OCTETLENGTH,
  DBCOLUMN_COLUMNSIZE,
  DBCOLUMN_CLSID : TDBID;
{$ENDIF}

{$IFDEF DBINITCONSTANTS}
const
  DB_PROPERTY_CHECK_OPTION               : TGUID = (D1 : $c8b5220b; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DB_PROPERTY_CONSTRAINT_CHECK_DEFERRED  : TGUID = (D1 : $c8b521f0; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DB_PROPERTY_DROP_CASCADE               : TGUID = (D1 : $c8b521f3; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DB_PROPERTY_UNIQUE                     : TGUID = (D1 : $c8b521f5; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DB_PROPERTY_ON_COMMIT_PRESERVE_ROWS    : TGUID = (D1 : $c8b52230; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DB_PROPERTY_PRIMARY                    : TGUID = (D1 : $c8b521fc; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DB_PROPERTY_CLUSTERED                  : TGUID = (D1 : $c8b521ff; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DB_PROPERTY_NONCLUSTERED               : TGUID = (D1 : $c8b52200; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DB_PROPERTY_BTREE                      : TGUID = (D1 : $c8b52201; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DB_PROPERTY_HASH                       : TGUID = (D1 : $c8b52202; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DB_PROPERTY_FILLFACTOR                 : TGUID = (D1 : $c8b52203; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DB_PROPERTY_INITIALSIZE                : TGUID = (D1 : $c8b52204; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DB_PROPERTY_DISALLOWNULL               : TGUID = (D1 : $c8b52205; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DB_PROPERTY_IGNORENULL                 : TGUID = (D1 : $c8b52206; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DB_PROPERTY_IGNOREANYNULL              : TGUID = (D1 : $c8b52207; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DB_PROPERTY_SORTBOOKMARKS              : TGUID = (D1 : $c8b52208; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DB_PROPERTY_AUTOMATICUPDATE            : TGUID = (D1 : $c8b52209; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DB_PROPERTY_EXPLICITUPDATE             : TGUID = (D1 : $c8b5220a; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBSCHEMA_ASSERTIONS                    : TGUID = (D1 : $c8b52210; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBSCHEMA_CATALOGS                      : TGUID = (D1 : $c8b52211; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBSCHEMA_CHARACTER_SETS                : TGUID = (D1 : $c8b52212; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBSCHEMA_COLLATIONS                    : TGUID = (D1 : $c8b52213; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBSCHEMA_COLUMNS                       : TGUID = (D1 : $c8b52214; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBSCHEMA_CHECK_CONSTRAINTS             : TGUID = (D1 : $c8b52215; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBSCHEMA_CONSTRAINT_COLUMN_USAGE       : TGUID = (D1 : $c8b52216; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBSCHEMA_CONSTRAINT_TABLE_USAGE        : TGUID = (D1 : $c8b52217; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBSCHEMA_KEY_COLUMN_USAGE              : TGUID = (D1 : $c8b52218; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBSCHEMA_REFERENTIAL_CONSTRAINTS       : TGUID = (D1 : $c8b52219; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBSCHEMA_TABLE_CONSTRAINTS             : TGUID = (D1 : $c8b5221a; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBSCHEMA_COLUMN_DOMAIN_USAGE           : TGUID = (D1 : $c8b5221b; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBSCHEMA_INDEXES                       : TGUID = (D1 : $c8b5221e; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBSCHEMA_COLUMN_PRIVILEGES             : TGUID = (D1 : $c8b52221; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBSCHEMA_TABLE_PRIVILEGES              : TGUID = (D1 : $c8b52222; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBSCHEMA_USAGE_PRIVILEGES              : TGUID = (D1 : $c8b52223; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBSCHEMA_PROCEDURES                    : TGUID = (D1 : $c8b52224; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBSCHEMA_SCHEMATA                      : TGUID = (D1 : $c8b52225; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBSCHEMA_SQL_LANGUAGES                 : TGUID = (D1 : $c8b52226; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBSCHEMA_STATISTICS                    : TGUID = (D1 : $c8b52227; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBSCHEMA_TABLES                        : TGUID = (D1 : $c8b52229; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBSCHEMA_TRANSLATIONS                  : TGUID = (D1 : $c8b5222a; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBSCHEMA_PROVIDER_TYPES                : TGUID = (D1 : $c8b5222c; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBSCHEMA_VIEWS                         : TGUID = (D1 : $c8b5222d; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBSCHEMA_VIEW_COLUMN_USAGE             : TGUID = (D1 : $c8b5222e; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBSCHEMA_VIEW_TABLE_USAGE              : TGUID = (D1 : $c8b5222f; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBSCHEMA_PROCEDURE_PARAMETERS          : TGUID = (D1 : $c8b522b8; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBSCHEMA_FOREIGN_KEYS                  : TGUID = (D1 : $c8b522c4; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBSCHEMA_PRIMARY_KEYS                  : TGUID = (D1 : $c8b522c5; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBSCHEMA_PROCEDURE_COLUMNS             : TGUID = (D1 : $c8b522c9; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBCOL_SELFCOLUMNS                      : TGUID = (D1 : $c8b52231; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBCOL_SPECIALCOL                       : TGUID = (D1 : $c8b52232; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  PSGUID_QUERY                           : TGUID = (D1 : $49691c90; D2 : $7e17; D3 : $101a; D4 : ($a9,$1c,$08,$00,$2b,$2e,$cd,$a9));
  DBPROPSET_COLUMN                       : TGUID = (D1 : $c8b522b9; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBPROPSET_DATASOURCE                   : TGUID = (D1 : $c8b522ba; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBPROPSET_DATASOURCEINFO               : TGUID = (D1 : $c8b522bb; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBPROPSET_DBINIT                       : TGUID = (D1 : $c8b522bc; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBPROPSET_INDEX                        : TGUID = (D1 : $c8b522bd; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBPROPSET_ROWSET                       : TGUID = (D1 : $c8b522be; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBPROPSET_TABLE                        : TGUID = (D1 : $c8b522bf; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBPROPSET_DATASOURCEALL                : TGUID = (D1 : $c8b522c0; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBPROPSET_DATASOURCEINFOALL            : TGUID = (D1 : $c8b522c1; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBPROPSET_ROWSETALL                    : TGUID = (D1 : $c8b522c2; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBPROPSET_SESSION                      : TGUID = (D1 : $c8b522c6; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBPROPSET_SESSIONALL                   : TGUID = (D1 : $c8b522c7; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBPROPSET_DBINITALL                    : TGUID = (D1 : $c8b522ca; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBPROPSET_PROPERTIESINERROR            : TGUID = (D1 : $c8b522d4; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
  DBGUID_DBSQL                           : TGUID = (D1 : $c8b521fb; D2 : $5cf3; D3 : $11ce; D4 : ($ad,$e5,$00,$aa,$00,$44,$77,$3d));
{$ELSE}
  DB_PROPERTY_CHECK_OPTION,
  DB_PROPERTY_CONSTRAINT_CHECK_DEFERRED,
  DB_PROPERTY_DROP_CASCADE,
  DB_PROPERTY_ON_COMMIT_PRESERVE_ROWS,
  DB_PROPERTY_UNIQUE,
  DB_PROPERTY_PRIMARY,
  DB_PROPERTY_CLUSTERED,
  DB_PROPERTY_NONCLUSTERED,
  DB_PROPERTY_BTREE,
  DB_PROPERTY_HASH,
  DB_PROPERTY_FILLFACTOR,
  DB_PROPERTY_INITIALSIZE,
  DB_PROPERTY_DISALLOWNULL,
  DB_PROPERTY_IGNORENULL,
  DB_PROPERTY_IGNOREANYNULL,
  DB_PROPERTY_SORTBOOKMARKS,
  DB_PROPERTY_AUTOMATICUPDATE,
  DB_PROPERTY_EXPLICITUPDATE,
  DBSCHEMA_ASSERTIONS,
  DBSCHEMA_CATALOGS,
  DBSCHEMA_CHARACTER_SETS,
  DBSCHEMA_COLLATIONS,
  DBSCHEMA_COLUMNS,
  DBSCHEMA_CHECK_CONSTRAINTS,
  DBSCHEMA_CONSTRAINT_COLUMN_USAGE,
  DBSCHEMA_CONSTRAINT_TABLE_USAGE,
  DBSCHEMA_KEY_COLUMN_USAGE,
  DBSCHEMA_REFERENTIAL_CONSTRAINTS,
  DBSCHEMA_TABLE_CONSTRAINTS,
  DBSCHEMA_COLUMN_DOMAIN_USAGE,
  DBSCHEMA_INDEXES,
  DBSCHEMA_COLUMN_PRIVILEGES,
  DBSCHEMA_TABLE_PRIVILEGES,
  DBSCHEMA_USAGE_PRIVILEGES,
  DBSCHEMA_PROCEDURES,
  DBSCHEMA_SCHEMATA,
  DBSCHEMA_SQL_LANGUAGES,
  DBSCHEMA_STATISTICS,
  DBSCHEMA_TABLES,
  DBSCHEMA_TRANSLATIONS,
  DBSCHEMA_PROVIDER_TYPES,
  DBSCHEMA_VIEWS,
  DBSCHEMA_VIEW_COLUMN_USAGE,
  DBSCHEMA_VIEW_TABLE_USAGE,
  DBSCHEMA_PROCEDURE_PARAMETERS,
  DBSCHEMA_FOREIGN_KEYS,
  DBSCHEMA_PRIMARY_KEYS,
  DBSCHEMA_PROCEDURE_COLUMNS,
  DBCOL_SELFCOLUMNS,
  DBCOL_SPECIALCOL,
  PSGUID_QUERY,
  DBPROPSET_COLUMN,
  DBPROPSET_DATASOURCE,
  DBPROPSET_DATASOURCEINFO,
  DBPROPSET_DBINIT,
  DBPROPSET_INDEX,
  DBPROPSET_ROWSET,
  DBPROPSET_TABLE,
  DBPROPSET_DATASOURCEALL,
  DBPROPSET_DATASOURCEINFOALL,
  DBPROPSET_ROWSETALL,
  DBPROPSET_SESSION,
  DBPROPSET_SESSIONALL,
  DBPROPSET_DBINITALL,
  DBPROPSET_PROPERTIESINERROR,
  DBGUID_DBSQL : TGUID;
{$ENDIF}

const
  DBPROP_ABORTPRESERVE                        = $2;
  DBPROP_ACTIVESESSIONS                       = $3;
  DBPROP_APPENDONLY                           = $bb;
  DBPROP_ASYNCTXNABORT                        = $a8;
  DBPROP_ASYNCTXNCOMMIT                       = $4;
  DBPROP_AUTH_CACHE_AUTHINFO                  = $5;
  DBPROP_AUTH_ENCRYPT_PASSWORD                = $6;
  DBPROP_AUTH_INTEGRATED                      = $7;
  DBPROP_AUTH_MASK_PASSWORD                   = $8;
  DBPROP_AUTH_PASSWORD                        = $9;
  DBPROP_AUTH_PERSIST_ENCRYPTED               = $a;
  DBPROP_AUTH_PERSIST_SENSITIVE_AUTHINFO      = $b;
  DBPROP_AUTH_USERID                          = $c;
  DBPROP_BLOCKINGSTORAGEOBJECTS               = $d;
  DBPROP_BOOKMARKS                            = $e;
  DBPROP_BOOKMARKSKIPPED                      = $f;
  DBPROP_BOOKMARKTYPE                         = $10;
  DBPROP_BYREFACCESSORS                       = $78;
  DBPROP_CACHEDEFERRED                        = $11;
  DBPROP_CANFETCHBACKWARDS                    = $12;
  DBPROP_CANHOLDROWS                          = $13;
  DBPROP_CANSCROLLBACKWARDS                   = $15;
  DBPROP_CATALOGLOCATION                      = $16;
  DBPROP_CATALOGTERM                          = $17;
  DBPROP_CATALOGUSAGE                         = $18;
  DBPROP_CHANGEINSERTEDROWS                   = $bc;
  DBPROP_CLSID                                = $19;
  DBPROP_COL_AUTOINCREMENT                    = $1a;
  DBPROP_COL_DEFAULT                          = $1b;
  DBPROP_COL_DESCRIPTION                      = $1c;
  DBPROP_COL_FIXEDLENGTH                      = $a7;
  DBPROP_COL_NULLABLE                         = $1d;
  DBPROP_COL_PRIMARYKEY                       = $1e;
  DBPROP_COL_UNIQUE                           = $1f;
  DBPROP_COLUMNDEFINITION                     = $20;
  DBPROP_COLUMNRESTRICT                       = $21;
  DBPROP_COMMANDTIMEOUT                       = $22;
  DBPROP_COMMITPRESERVE                       = $23;
  DBPROP_CONCATNULLBEHAVIOR                   = $24;
  DBPROP_CURRENTCATALOG                       = $25;
  DBPROP_DATASOURCENAME                       = $26;
  DBPROP_DATASOURCEREADONLY                   = $27;
  DBPROP_DBMSNAME                             = $28;
  DBPROP_DBMSVER                              = $29;
  DBPROP_DEFERRED                             = $2a;
  DBPROP_DELAYSTORAGEOBJECTS                  = $2b;
  DBPROP_DSOTHREADMODEL                       = $a9;
  DBPROP_GROUPBY                              = $2c;
  DBPROP_HETEROGENEOUSTABLES                  = $2d;
  DBPROP_IAccessor                            = $79;
  DBPROP_IColumnsInfo                         = $7a;
  DBPROP_IColumnsRowset                       = $7b;
  DBPROP_IConnectionPointContainer            = $7c;
  DBPROP_IConvertType                         = $c2;
  DBPROP_IRowset                              = $7e;
  DBPROP_IRowsetChange                        = $7f;
  DBPROP_IRowsetIdentity                      = $80;
  DBPROP_IRowsetIndex                         = $9f;
  DBPROP_IRowsetInfo                          = $81;
  DBPROP_IRowsetLocate                        = $82;
  DBPROP_IRowsetResynch                       = $84;
  DBPROP_IRowsetScroll                        = $85;
  DBPROP_IRowsetUpdate                        = $86;
  DBPROP_ISupportErrorInfo                    = $87;
  DBPROP_ILockBytes                           = $88;
  DBPROP_ISequentialStream                    = $89;
  DBPROP_IStorage                             = $8a;
  DBPROP_IStream                              = $8b;
  DBPROP_IDENTIFIERCASE                       = $2e;
  DBPROP_IMMOBILEROWS                         = $2f;
  DBPROP_INDEX_AUTOUPDATE                     = $30;
  DBPROP_INDEX_CLUSTERED                      = $31;
  DBPROP_INDEX_FILLFACTOR                     = $32;
  DBPROP_INDEX_INITIALSIZE                    = $33;
  DBPROP_INDEX_NULLCOLLATION                  = $34;
  DBPROP_INDEX_NULLS                          = $35;
  DBPROP_INDEX_PRIMARYKEY                     = $36;
  DBPROP_INDEX_SORTBOOKMARKS                  = $37;
  DBPROP_INDEX_TEMPINDEX                      = $a3;
  DBPROP_INDEX_TYPE                           = $38;
  DBPROP_INDEX_UNIQUE                         = $39;
  DBPROP_INIT_DATASOURCE                      = $3b;
  DBPROP_INIT_HWND                            = $3c;
  DBPROP_INIT_IMPERSONATION_LEVEL             = $3d;
  DBPROP_INIT_LCID                            = $ba;
  DBPROP_INIT_LOCATION                        = $3e;
  DBPROP_INIT_MODE                            = $3f;
  DBPROP_INIT_PROMPT                          = $40;
  DBPROP_INIT_PROTECTION_LEVEL                = $41;
  DBPROP_INIT_PROVIDERSTRING                  = $a0;
  DBPROP_INIT_TIMEOUT                         = $42;
  DBPROP_LITERALBOOKMARKS                     = $43;
  DBPROP_LITERALIDENTITY                      = $44;
  DBPROP_MAXINDEXSIZE                         = $46;
  DBPROP_MAXOPENROWS                          = $47;
  DBPROP_MAXPENDINGROWS                       = $48;
  DBPROP_MAXROWS                              = $49;
  DBPROP_MAXROWSIZE                           = $4a;
  DBPROP_MAXROWSIZEINCLUDESBLOB               = $4b;
  DBPROP_MAXTABLESINSELECT                    = $4c;
  DBPROP_MAYWRITECOLUMN                       = $4d;
  DBPROP_MEMORYUSAGE                          = $4e;
  DBPROP_MONIKER                              = $4f;
  DBPROP_MULTIPLEPARAMSETS                    = $bf;
  DBPROP_MULTIPLESTORAGEOBJECTS               = $50;
  DBPROP_MULTITABLEUPDATE                     = $51;
  DBPROP_NOTIFICATIONPHASES                   = $52;
  DBPROP_NOTIFYCOLUMNRECALCULATED             = $aa;
  DBPROP_NOTIFYCOLUMNSET                      = $ab;
  DBPROP_NOTIFYROWACTIVATE                    = $ac;
  DBPROP_NOTIFYROWDELETE                      = $ad;
  DBPROP_NOTIFYROWFIRSTCHANGE                 = $ae;
  DBPROP_NOTIFYROWINSERT                      = $af;
  DBPROP_NOTIFYROWRELEASE                     = $b0;
  DBPROP_NOTIFYROWRESYNCH                     = $b1;
  DBPROP_NOTIFYROWSETRELEASE                  = $b2;
  DBPROP_NOTIFYROWSETFETCHPOSITIONCHANGE      = $b3;
  DBPROP_NOTIFYROWUNDOCHANGE                  = $b4;
  DBPROP_NOTIFYROWUNDODELETE                  = $b5;
  DBPROP_NOTIFYROWUNDOINSERT                  = $b6;
  DBPROP_NOTIFYROWUPDATE                      = $b7;
  DBPROP_NULLCOLLATION                        = $53;
  DBPROP_OLEOBJECTS                           = $54;
  DBPROP_ORDERBYCOLUMNSINSELECT               = $55;
  DBPROP_ORDEREDBOOKMARKS                     = $56;
  DBPROP_OTHERINSERT                          = $57;
  DBPROP_OTHERUPDATEDELETE                    = $58;
  DBPROP_OUTPUTPARAMETERAVAILABILITY          = $b8;
  DBPROP_OWNINSERT                            = $59;
  DBPROP_OWNUPDATEDELETE                      = $5a;
  DBPROP_PERSISTENTIDTYPE                     = $b9;
  DBPROP_PREPAREABORTBEHAVIOR                 = $5b;
  DBPROP_PREPARECOMMITBEHAVIOR                = $5c;
  DBPROP_PROCEDURETERM                        = $5d;
  DBPROP_PROVIDERNAME                         = $60;
  DBPROP_PROVIDEROLEDBVER                     = $61;
  DBPROP_PROVIDERVER                          = $62;
  DBPROP_QUICKRESTART                         = $63;
  DBPROP_QUOTEDIDENTIFIERCASE                 = $64;
  DBPROP_REENTRANTEVENTS                      = $65;
  DBPROP_REMOVEDELETED                        = $66;
  DBPROP_REPORTMULTIPLECHANGES                = $67;
  DBPROP_RETURNPENDINGINSERTS                 = $bd;
  DBPROP_ROWRESTRICT                          = $68;
  DBPROP_ROWSETCONVERSIONSONCOMMAND           = $c0;
  DBPROP_ROWTHREADMODEL                       = $69;
  DBPROP_SCHEMATERM                           = $6a;
  DBPROP_SCHEMAUSAGE                          = $6b;
  DBPROP_SERVERCURSOR                         = $6c;
  DBPROP_SESS_AUTOCOMMITISOLEVELS             = $be;
  DBPROP_SQLSUPPORT                           = $6d;
  DBPROP_STRING                               = $6e;
  DBPROP_STRONGIDENTITY                       = $77;
  DBPROP_STRUCTUREDSTORAGE                    = $6f;
  DBPROP_SUBQUERIES                           = $70;
  DBPROP_SUPPORTEDTXNDDL                      = $a1;
  DBPROP_SUPPORTEDTXNISOLEVELS                = $71;
  DBPROP_SUPPORTEDTXNISORETAIN                = $72;
  DBPROP_TABLETERM                            = $73;
  DBPROP_TBL_TEMPTABLE                        = $8c;
  DBPROP_TRANSACTEDOBJECT                     = $74;
  DBPROP_UPDATABILITY                         = $75;
  DBPROP_USERNAME                             = $76;

type
  TDBPROPENUM = DWORD;

const
  DBPROPVAL_BMK_NUMERIC                             = $00000001;
  DBPROPVAL_BMK_KEY                                 = $00000002;
  DBPROPVAL_CL_START                                = $00000001;
  DBPROPVAL_CL_END                                  = $00000002;
  DBPROPVAL_CU_DML_STATEMENTS                       = $00000001;
  DBPROPVAL_CU_TABLE_DEFINITION                     = $00000002;
  DBPROPVAL_CU_INDEX_DEFINITION                     = $00000004;
  DBPROPVAL_CU_PRIVILEGE_DEFINITION                 = $00000008;
  DBPROPVAL_CD_NOTNULL                              = $00000001;
  DBPROPVAL_CB_NULL                                 = $00000001;
  DBPROPVAL_CB_NON_NULL                             = $00000002;
  DBPROPVAL_FU_NOT_SUPPORTED                        = $00000001;
  DBPROPVAL_FU_COLUMN                               = $00000002;
  DBPROPVAL_FU_TABLE                                = $00000004;
  DBPROPVAL_FU_CATALOG                              = $00000008;
  DBPROPVAL_GB_NOT_SUPPORTED                        = $00000001;
  DBPROPVAL_GB_EQUALS_SELECT                        = $00000002;
  DBPROPVAL_GB_CONTAINS_SELECT                      = $00000004;
  DBPROPVAL_GB_NO_RELATION                          = $00000008;
  DBPROPVAL_HT_DIFFERENT_CATALOGS                   = $00000001;
  DBPROPVAL_HT_DIFFERENT_PROVIDERS                  = $00000002;
  DBPROPVAL_IC_UPPER                                = $00000001;
  DBPROPVAL_IC_LOWER                                = $00000002;
  DBPROPVAL_IC_SENSITIVE                            = $00000004;
  DBPROPVAL_IC_MIXED                                = $00000008;
  DBPROPVAL_LM_NONE                                 = $00000001;
  DBPROPVAL_LM_READ                                 = $00000002;
  DBPROPVAL_LM_INTENT                               = $00000004;
  DBPROPVAL_LM_WRITE                                = $00000008;

  DBPROPVAL_NP_OKTODO                               = $00000001;
  DBPROPVAL_NP_ABOUTTODO                            = $00000002;
  DBPROPVAL_NP_SYNCHAFTER                           = $00000004;
  DBPROPVAL_NP_FAILEDTODO                           = $00000008;
  DBPROPVAL_NP_DIDEVENT                             = $00000010;
  DBPROPVAL_NC_END                                  = $00000001;
  DBPROPVAL_NC_HIGH                                 = $00000002;
  DBPROPVAL_NC_LOW                                  = $00000004;
  DBPROPVAL_NC_START                                = $00000008;
  DBPROPVAL_OO_BLOB                                 = $00000001;
  DBPROPVAL_OO_IPERSIST                             = $00000002;
  DBPROPVAL_CB_DELETE                               = $00000001;
  DBPROPVAL_CB_PRESERVE                             = $00000002;
  DBPROPVAL_SU_DML_STATEMENTS                       = $00000001;
  DBPROPVAL_SU_TABLE_DEFINITION                     = $00000002;
  DBPROPVAL_SU_INDEX_DEFINITION                     = $00000004;
  DBPROPVAL_SU_PRIVILEGE_DEFINITION                 = $00000008;
  DBPROPVAL_SO_CORRELATEDSUBQUERIES                 = $00000001;
  DBPROPVAL_SO_COMPARISON                           = $00000002;
  DBPROPVAL_SO_EXISTS                               = $00000004;
  DBPROPVAL_SO_IN                                   = $00000008;
  DBPROPVAL_SO_QUANTIFIED                           = $00000010;
  DBPROPVAL_SS_ISEQUENTIALSTREAM                    = $00000001;
  DBPROPVAL_SS_ISTREAM                              = $00000002;
  DBPROPVAL_SS_ISTORAGE                             = $00000004;
  DBPROPVAL_SS_ILOCKBYTES                           = $00000008;
  DBPROPVAL_TI_CHAOS                                = $00000010;
  DBPROPVAL_TI_READUNCOMMITTED                      = $00000100;
  DBPROPVAL_TI_BROWSE                               = $00000100;
  DBPROPVAL_TI_CURSORSTABILITY                      = $00001000;
  DBPROPVAL_TI_READCOMMITTED                        = $00001000;
  DBPROPVAL_TI_REPEATABLEREAD                       = $00010000;
  DBPROPVAL_TI_SERIALIZABLE                         = $00100000;
  DBPROPVAL_TI_ISOLATED                             = $00100000;
  DBPROPVAL_TR_COMMIT_DC                            = $00000001;
  DBPROPVAL_TR_COMMIT                               = $00000002;
  DBPROPVAL_TR_COMMIT_NO                            = $00000004;
  DBPROPVAL_TR_ABORT_DC                             = $00000008;
  DBPROPVAL_TR_ABORT                                = $00000010;
  DBPROPVAL_TR_ABORT_NO                             = $00000020;
  DBPROPVAL_TR_DONTCARE                             = $00000040;
  DBPROPVAL_TR_BOTH                                 = $00000080;
  DBPROPVAL_TR_NONE                                 = $00000100;
  DBPROPVAL_TR_OPTIMISTIC                           = $00000200;
  DBPROPVAL_RT_FREETHREAD                           = $00000001;
  DBPROPVAL_RT_APTMTTHREAD                          = $00000002;
  DBPROPVAL_RT_SINGLETHREAD                         = $00000004;
  DBPROPVAL_UP_CHANGE                               = $00000001;
  DBPROPVAL_UP_DELETE                               = $00000002;
  DBPROPVAL_UP_INSERT                               = $00000004;
  DBPROPVAL_SQL_NONE                                = $00000000;
  DBPROPVAL_SQL_ODBC_MINIMUM                        = $00000001;
  DBPROPVAL_SQL_ODBC_CORE                           = $00000002;
  DBPROPVAL_SQL_ODBC_EXTENDED                       = $00000004;
  DBPROPVAL_SQL_ANSI89_IEF                          = $00000008;
  DBPROPVAL_SQL_ANSI92_ENTRY                        = $00000010;
  DBPROPVAL_SQL_FIPS_TRANSITIONAL                   = $00000020;
  DBPROPVAL_SQL_ANSI92_INTERMEDIATE                 = $00000040;
  DBPROPVAL_SQL_ANSI92_FULL                         = $00000080;
  DBPROPVAL_SQL_ESCAPECLAUSES                       = $00000100;
  DBPROPVAL_IT_BTREE                                = $00000001;
  DBPROPVAL_IT_HASH                                 = $00000002;
  DBPROPVAL_IT_CONTENT                              = $00000003;
  DBPROPVAL_IT_OTHER                                = $00000004;
  DBPROPVAL_IN_DISALLOWNULL                         = $00000001;
  DBPROPVAL_IN_IGNORENULL                           = $00000002;
  DBPROPVAL_IN_IGNOREANYNULL                        = $00000004;
  DBPROPVAL_TC_NONE                                 = $00000000;
  DBPROPVAL_TC_DML                                  = $00000001;
  DBPROPVAL_TC_DDL_COMMIT                           = $00000002;
  DBPROPVAL_TC_DDL_IGNORE                           = $00000004;
  DBPROPVAL_TC_ALL                                  = $00000008;

{
  DBPROPVAL_NP_OKTODO                               = $00000001;
  DBPROPVAL_NP_ABOUTTODO                            = $00000002;
  DBPROPVAL_NP_SYNCHAFTER                           = $00000004;
}

  DBPROPVAL_OA_NOTSUPPORTED                         = $00000001;
  DBPROPVAL_OA_ATEXECUTE                            = $00000002;
  DBPROPVAL_OA_ATROWRELEASE                         = $00000004;
  DBPROPVAL_PT_GUID_NAME                            = $00000001;
  DBPROPVAL_PT_GUID_PROPID                          = $00000002;
  DBPROPVAL_PT_NAME                                 = $00000004;
  DBPROPVAL_PT_GUID                                 = $00000008;
  DB_IMP_LEVEL_ANONYMOUS                            = $00;
  DB_IMP_LEVEL_IDENTIFY                             = $01;
  DB_IMP_LEVEL_IMPERSONATE                          = $02;
  DB_IMP_LEVEL_DELEGATE                             = $03;
  DBPROMPT_PROMPT                                   = $01;
  DBPROMPT_COMPLETE                                 = $02;
  DBPROMPT_COMPLETEREQUIRED                         = $03;
  DBPROMPT_NOPROMPT                                 = $04;
  DB_PROT_LEVEL_NONE                                = $00;
  DB_PROT_LEVEL_CONNECT                             = $01;
  DB_PROT_LEVEL_CALL                                = $02;
  DB_PROT_LEVEL_PKT                                 = $03;
  DB_PROT_LEVEL_PKT_INTEGRITY                       = $04;
  DB_PROT_LEVEL_PKT_PRIVACY                         = $05;
  DB_MODE_READ                                      = $01;
  DB_MODE_WRITE                                     = $02;
  DB_MODE_READWRITE                                 = $03;
  DB_MODE_SHARE_DENY_READ                           = $04;
  DB_MODE_SHARE_DENY_WRITE                          = $08;
  DB_MODE_SHARE_EXCLUSIVE                           = $0c;
  DB_MODE_SHARE_DENY_NONE                           = $10;

type
  TDBPARAMS =
    record
      pData : Pointer;
      cParamSets : ULONG;
      hAccessor : HACCESSOR;
    end;

  TDBPARAMFLAGS = DWORD;

const
  DBPARAMFLAGS_ISINPUT               = $1;
  DBPARAMFLAGS_ISOUTPUT              = $2;
  DBPARAMFLAGS_ISSIGNED              = $10;
  DBPARAMFLAGS_ISNULLABLE            = $40;
  DBPARAMFLAGS_ISLONG                = $80;

type
  PDBPARAMINFO = ^TDBPARAMINFO;  //!! Added
  TDBPARAMINFO =
    record
      dwFlags : TDBPARAMFLAGS;
      iOrdinal : ULONG;
      pwszName : POleStr;
      pTypeInfo : ITypeInfo;
      ulParamSize : ULONG;
      wType : TDBTYPE;
      bPrecision : Byte;
      bScale : Byte;
    end;

  TDBPROPID = DWORD;

  PDBPROPIDSET = ^TDBPROPIDSET;  //!! Added
  TDBPROPIDSET =
    record
      rgPropertyIDs : ^TDBPROPID;
      cPropertyIDs : ULONG;
      guidPropertySet : TGUID;
    end;

  TDBPROPFLAGS = DWORD;

const
  DBPROPFLAGS_NOTSUPPORTED        = 0;
  DBPROPFLAGS_COLUMN              = $1;
  DBPROPFLAGS_DATASOURCE          = $2;
  DBPROPFLAGS_DATASOURCECREATE    = $4;
  DBPROPFLAGS_DATASOURCEINFO      = $8;
  DBPROPFLAGS_DBINIT              = $10;
  DBPROPFLAGS_INDEX               = $20;
  DBPROPFLAGS_ROWSET              = $40;
  DBPROPFLAGS_TABLE               = $80;
  DBPROPFLAGS_COLUMNOK            = $100;
  DBPROPFLAGS_READ                = $200;
  DBPROPFLAGS_WRITE               = $400;
  DBPROPFLAGS_REQUIRED            = $800;
  DBPROPFLAGS_SESSION             = $1000;

type
  TDBPROPINFO =
    record
      pwszDescription : POleStr;
      dwPropertyID : TDBPROPID;
      dwFlags : TDBPROPFLAGS;
      vtType : TVarType;
      vValues : PVariant; //!! was: VARIANT
    end;

  PDBPROPINFOSET = ^TDBPROPINFOSET;
  TDBPROPINFOSET =
    record
      rgPropertyInfos : ^TDBPROPINFO;
      cPropertyInfos : ULONG;
      guidPropertySet : TGUID;
    end;

  TDBPROPOPTIONS =
    (
      DBPROPOPTIONS_REQUIRED,
      DBPROPOPTIONS_SETIFCHEAP
    );

  TDBPROPSTATUS =
    (
      DBPROPSTATUS_OK,
      DBPROPSTATUS_NOTSUPPORTED,
      DBPROPSTATUS_BADVALUE,
      DBPROPSTATUS_BADOPTION,
      DBPROPSTATUS_BADCOLUMN,
      DBPROPSTATUS_NOTALLSETTABLE,
      DBPROPSTATUS_NOTSETTABLE,
      DBPROPSTATUS_NOTSET,
      DBPROPSTATUS_CONFLICTING
    );

  TDBPROP =
    record
      dwPropertyID : TDBPROPID;
      dwOptions : TDBPROPOPTIONS;
      dwStatus : TDBPROPSTATUS;
      colid : TDBID;
      vValue : PVariant; //!! was: VARIANT
    end;

  PPDBPROPSET = ^PDBPROPSET;  //!! Added
  PDBPROPSET = ^TDBPROPSET;  //!! Added
  TDBPROPSET =
    record
      rgProperties : ^TDBPROP;
      cProperties : ULONG;
      guidPropertySet : TGUID;
    end;

const
  DBPARAMTYPE_INPUT          = $01;
  DBPARAMTYPE_INPUTOUTPUT    = $02;
  DBPARAMTYPE_OUTPUT         = $03;
  DBPARAMTYPE_RETURNVALUE    = $04;

  DB_PT_UNKNOWN              = $01;
  DB_PT_PROCEDURE            = $02;
  DB_PT_FUNCTION             = $03;
  DB_REMOTE                  = $01;
  DB_LOCAL_SHARED            = $02;
  DB_LOCAL_EXCLUSIVE         = $03;
  DB_COLLATION_ASC           = $01;
  DB_COLLATION_DESC          = $02;
  DB_UNSEARCHABLE            = $01;
  DB_LIKE_ONLY               = $02;
  DB_ALL_EXCEPT_LIKE         = $03;
  DB_SEARCHABLE              = $04;

type
  TDBINDEX_COL_ORDER =
    (
      DBINDEX_COL_ORDER_ASC,
      DBINDEX_COL_ORDER_DESC
    );

  PDBINDEXCOLUMNDESC = ^TDBINDEXCOLUMNDESC;  //!! Added
  TDBINDEXCOLUMNDESC =
    record
      pColumnID : ^TDBID;
      eIndexColOrder : TDBINDEX_COL_ORDER;
    end;

  TDBCOLUMNDESC =
    record
      pwszTypeName : POleStr;
      pTypeInfo : ITypeInfo;
      rgPropertySets : ^TDBPROPSET;
      pclsid : ^TCLSID;
      cPropertySets : ULONG;
      ulColumnSize : ULONG;
      dbcid : TDBID;
      wType : TDBTYPE;
      bPrecision : Byte;
      bScale : Byte;
    end;

  TDBACCESSORFLAGS = DWORD;

const
  DBACCESSOR_INVALID                = 0;
  DBACCESSOR_PASSBYREF              = $1;
  DBACCESSOR_ROWDATA                = $2;
  DBACCESSOR_PARAMETERDATA          = $4;
  DBACCESSOR_OPTIMIZED              = $8;

type
  TDBBINDSTATUS =
    (
      DBBINDSTATUS_OK,
      DBBINDSTATUS_BADORDINAL,
      DBBINDSTATUS_UNSUPPORTEDCONVERSION,
      DBBINDSTATUS_BADBINDINFO,
      DBBINDSTATUS_BADSTORAGEFLAGS,
      DBBINDSTATUS_NOINTERFACE
    );

  IAccessor =
    class(IUnknown)
    public
      function AddRefAccessor(
            (* [in] *) hAccessor : HACCESSOR;
            (* [out] *) var pcRefCount : ULONG) : HResult; virtual; stdcall; abstract;

      function CreateAccessor( 
            (* [in] *) dwAccessorFlags : TDBACCESSORFLAGS;
            (* [in] *) cBindings : ULONG;
            (* [size_is][in] *) const rgBindings : TDBBINDING;//!! const DBBINDING __RPC_FAR rgBindings[  ],
            (* [in] *) cbRowSize : ULONG;
            (* [out] *) var phAccessor : HACCESSOR;
            (* [size_is][out] *) var rgStatus : TDBBINDSTATUS{!! DBBINDSTATUS __RPC_FAR rgStatus[  ]}) : HResult; virtual; stdcall; abstract;

      function GetBindings(
            (* [in] *) hAccessor : HACCESSOR;
            (* [out] *) var pdwAccessorFlags : TDBACCESSORFLAGS;
            (* [out][in] *) var pcBindings : ULONG;
            (* [size_is][size_is][out] *) var prgBindings : PDBBINDING{!! __RPC_FAR *__RPC_FAR *prgBindings}) : HResult; virtual; stdcall; abstract;

      function ReleaseAccessor(
            (* [in] *) hAccessor : HACCESSOR;
            (* [out] *) var pcRefCount : ULONG) : HResult; virtual; stdcall; abstract;
    end;

  TDBROWOPTIONS = DWORD;

  IRowset =
    class(IUnknown)
    public
      function AddRefRows(
            (* [in] *) cRows : ULONG;
            (* [size_is][in] *) var rghRows : HROW;//!! var rghRows : HROW;
            (* [size_is][out] *) rgRefCounts : PULONG;//!! ULONG __RPC_FAR rgRefCounts[  ],
            (* [size_is][out] *) var rgRowStatus : TDBROWSTATUS{!!DBROWSTATUS __RPC_FAR rgRowStatus[  ]}) : HResult; virtual; stdcall; abstract;

      function GetData(
            (* [in] *) hRow : HROW;
            (* [in] *) hAccessor : HACCESSOR;
            (* [out] *) var pData{!!void __RPC_FAR *pData}) : HResult; virtual; stdcall; abstract;

      function GetNextRows(
            (* [in] *) hReserved : HCHAPTER;
            (* [in] *) lRowsOffset : LONG;
            (* [in] *) cRows : LONG;
            (* [out] *) var pcRowsObtained : ULONG;
            (* [size_is][size_is][out] *) var prghRows : PHROW) : HResult; virtual; stdcall; abstract;

      function ReleaseRows( 
            (* [in] *) cRows : ULONG;
            (* [size_is][in] *) const rghRows : HROW;{!!var rghRows : HROW;}
            (* [size_is][in] *) var rgRowOptions : TDBROWOPTIONS;{!!DBROWOPTIONS __RPC_FAR rgRowOptions[  ],}
            (* [size_is][out] *) rgRefCounts : PULONG;{!!ULONG __RPC_FAR rgRefCounts[  ],}
            (* [size_is][out] *) var rgRowStatus : TDBROWSTATUS{!!DBROWSTATUS __RPC_FAR rgRowStatus[  ]}) : HResult; virtual; stdcall; abstract;

      function RestartPosition(
            (* [in] *) hReserved : HCHAPTER) : HResult; virtual; stdcall; abstract;
    end;

  IRowsetInfo =
    class(IUnknown)
    public
      function GetProperties(
            (* [in] *) const cPropertyIDSets : ULONG;
            (* [size_is][in] *) const rgPropertyIDSets : TDBPROPIDSET;{!!const DBPROPIDSET __RPC_FAR rgPropertyIDSets[  ],}
            (* [out][in] *) var pcPropertySets : ULONG;
            (* [size_is][size_is][out] *) prgPropertySets : PPDBPROPSET{!!DBPROPSET __RPC_FAR *__RPC_FAR *prgPropertySets}) : HResult; virtual; stdcall; abstract;

      function GetReferencedRowset(
            (* [in] *) iOrdinal : ULONG;
            (* [in] *) const riid : TIID;
            (* [iid_is][out] *) var ppReferencedRowset : IUnknown{!!IUnknown __RPC_FAR *__RPC_FAR *ppReferencedRowset}) : HResult; virtual; stdcall; abstract;

      function GetSpecification(
            (* [in] *) const riid : TIID;
            (* [iid_is][out] *)  var ppSpecification : IUnknown{!!IUnknown __RPC_FAR *__RPC_FAR *ppSpecification}) : HResult; virtual; stdcall; abstract;
    end;

  TDBCOMPARE =
    (
      DBCOMPARE_LT,
      DBCOMPARE_EQ,
      DBCOMPARE_GT,
      DBCOMPARE_NE,
      DBCOMPARE_NOTCOMPARABLE
    );

  IRowsetLocate =
    class(IRowset)
    public
      function Compare(
            (* [in] *) hReserved : HCHAPTER;
            (* [in] *) cbBookmark1 : ULONG;
            (* [size_is][in] *) pBookmark1 : PByte;{!!const BYTE __RPC_FAR *pBookmark1,}
            (* [in] *) cbBookmark2 : ULONG;
            (* [size_is][in] *) pBookmark2 : PByte;{!!const BYTE __RPC_FAR *pBookmark2,}
            (* [out] *) var pComparison : TDBCOMPARE{!!DBCOMPARE __RPC_FAR *pComparison}) : HResult; virtual; stdcall; abstract;

      function GetRowsAt(
            (* [in] *) hReserved1 : HWATCHREGION;
            (* [in] *) hReserved : HCHAPTER;
            (* [in] *) cbBookmark : ULONG;
            (* [size_is][in] *) pBookmark : PByte;{!!const BYTE __RPC_FAR *pBookmark,}
            (* [in] *) lRowsOffset : LONG;
            (* [in] *) cRows : LONG;
            (* [out] *) var pcRowsObtained : ULONG;{!!ULONG __RPC_FAR *pcRowsObtained,}
            (* [size_is][size_is][out] *) var prghRows : PHROW{!!HROW __RPC_FAR *__RPC_FAR *prghRows}) : HResult; virtual; stdcall; abstract;

      function GetRowsByBookmark(
            (* [in] *) hReserved : HCHAPTER;
            (* [in] *) cRows : ULONG;
            (* [size_is][in] *) var rgcbBookmarks : ULONG;{!!const ULONG __RPC_FAR rgcbBookmarks[  ],}
            (* [size_is][in] *) var rgbpBookmarks : Byte;{!!const BYTE __RPC_FAR *__RPC_FAR rgpBookmarks[  ],}
            (* [size_is][out] *) var rghRows : HROW;{!!HROW __RPC_FAR rghRows[  ],}
            (* [size_is][out] *) rgRowStatus : PDBROWSTATUS{!!DBROWSTATUS __RPC_FAR rgRowStatus[  ]}) : HResult; virtual; stdcall; abstract;

      function Hash(
            (* [in] *) hReserved : HCHAPTER;
            (* [in] *) cBookmarks : ULONG;
            (* [size_is][in] *) var rgcbBookmarks : ULONG;{!!const ULONG __RPC_FAR rgcbBookmarks[  ],}
            (* [size_is][in] *) var rgpBookmarks : Byte;{!!const BYTE __RPC_FAR *__RPC_FAR rgpBookmarks[  ],}
            (* [size_is][out] *) var rgHashedValues : DWORD;{!!DWORD __RPC_FAR rgHashedValues[  ],}
            (* [size_is][out] *) rgBookmarkStatus : PDBROWSTATUS{!!DBROWSTATUS __RPC_FAR rgBookmarkStatus[  ]}) : HResult; virtual; stdcall; abstract;
    end;

  IRowsetResynch =
    class(IUnknown)
    public
      function GetVisibleData(
            (* [in] *) hRow : HROW;
            (* [in] *) hAccessor : HACCESSOR;
            (* [out] *) var pData) : HResult; virtual; stdcall; abstract;

      function ResynchRows(
            (* [in] *) cRows : ULONG;
            (* [size_is][in] *) var rghRows : HROW;
            (* [out] *)  pcRowsResynched : PULONG;
            (* [size_is][size_is][out] *) var prghRowsResynched : PHROW;
            (* [size_is][size_is][out] *) prgRowStatus : PPDBROWSTATUS) : HResult; virtual; stdcall; abstract;
    end;

  IRowsetScroll =
    class(IRowsetLocate)
    public
      function GetApproximatePosition(
            (* [in] *) hReserved : HCHAPTER;
            (* [in] *) cbBookmark : ULONG;
            (* [size_is][in] *) var pBookmark : Byte;{!!const BYTE __RPC_FAR *pBookmark,}
            (* [out] *) pulPosition : PULONG;
            (* [out] *) pcRows : PULONG) : HResult; virtual; stdcall; abstract;

      function GetRowsAtRatio(
            (* [in] *) hReserved1 : HWATCHREGION;
            (* [in] *) hReserved2 : HCHAPTER;
            (* [in] *) ulNumerator : ULONG;
            (* [in] *) ulDenominator : ULONG;
            (* [in] *) cRows : LONG;
            (* [out] *) var pcRowsObtained : ULONG;
            (* [size_is][size_is][out] *) var prghRows : PHROW) : HResult; virtual; stdcall; abstract;
    end;

  IRowsetChange =
    class(IUnknown)
    public
      function DeleteRows(
            (* [in] *) hReserved : HCHAPTER;
            (* [in] *) cRows : ULONG;
            (* [size_is][in] *) var rghRows : HROW;
            (* [size_is][out] *) rgRowStatus : PDBROWSTATUS) : HResult; virtual; stdcall; abstract;

      function SetData(
            (* [in] *) hRow : HROW;
            (* [in] *) hAccessor : HACCESSOR;
            (* [in] *) var pData) : HResult; virtual; stdcall; abstract;

      function InsertRow(
            (* [in] *) hReserved : HCHAPTER;
            (* [in] *) hAccessor : HACCESSOR;
            (* [in] *) var pData;
            (* [out] *) phRow : PHROW) : HResult; virtual; stdcall; abstract;
    end;

  TDBPENDINGSTATUS = DWORD;
  PDBPENDINGSTATUS = ^TDBPENDINGSTATUS;
  PPDBPENDINGSTATUS = ^PDBPENDINGSTATUS;

const
  DBPENDINGSTATUS_NEW                = $1;
  DBPENDINGSTATUS_CHANGED            = $2;
  DBPENDINGSTATUS_DELETED            = $4;
  DBPENDINGSTATUS_UNCHANGED          = $8;
  DBPENDINGSTATUS_INVALIDROW         = $10;

type
  IRowsetUpdate =
    class(IRowsetChange)
    public
      function GetOriginalData(
            (* [in] *) hRow : HROW;
            (* [in] *) hAccessor : HACCESSOR;
            (* [out] *) var pData) : HResult; virtual; stdcall; abstract;

      function GetPendingRows(
            (* [in] *) hReserved : HCHAPTER;
            (* [in] *) dwRowStatus : TDBPENDINGSTATUS;
            (* [out][in] *) pcPendingRows : PULONG;
            (* [size_is][size_is][out] *) prgPendingRow : PPHROW;
            (* [size_is][size_is][out] *) prgPendingStatus : PPDBPENDINGSTATUS) : HResult; virtual; stdcall; abstract;

      function GetRowStatus(
            (* [in] *) hReserved : HCHAPTER;
            (* [in] *) cRows : ULONG;
            (* [size_is][in] *) var rghRows : HROW;
            (* [size_is][out] *) var rgPendingStatus : TDBPENDINGSTATUS) : HResult; virtual; stdcall; abstract;

      function Undo( 
            (* [in] *) hReserved : HCHAPTER;
            (* [in] *) cRows : ULONG;
            (* [size_is][in] *) var rghRows : HROW;
            (* [out][in] *) pcRowsUndone : PULONG;
            (* [size_is][size_is][out] *) prgRowsUndone : PPHROW;
            (* [size_is][size_is][out] *) prgRowStatus : PPDBROWSTATUS) : HResult; virtual; stdcall; abstract;

      function Update(
            (* [in] *) hReserved : HCHAPTER;
            (* [in] *) cRows : ULONG;
            (* [size_is][in] *) var rghRows : HROW;
            (* [out][in] *) pcRows : PULONG;
            (* [size_is][size_is][out] *) prgRows : PPHROW;
            (* [size_is][size_is][out] *) prgRowStatus : PPDBROWSTATUS) : HResult; virtual; stdcall; abstract;
    end;

  IRowsetIdentity =
    class(IUnknown)
    public
      function IsSameRow(
            (* [in] *) hThisRow : HROW;
            (* [in] *) hThatRow : HROW) : HResult; virtual; stdcall; abstract;
    end;

  TDBEVENTPHASE =
    (
      DBEVENTPHASE_OKTODO,
      DBEVENTPHASE_ABOUTTODO,
      DBEVENTPHASE_SYNCHAFTER,
      DBEVENTPHASE_FAILEDTODO,
      DBEVENTPHASE_DIDEVENT
    );

  TDBREASON =
    (
      DBREASON_ROWSET_FETCHPOSITIONCHANGE,
      DBREASON_ROWSET_RELEASE,
      DBREASON_COLUMN_SET,
      DBREASON_COLUMN_RECALCULATED,
      DBREASON_ROW_ACTIVATE,
      DBREASON_ROW_RELEASE,
      DBREASON_ROW_DELETE,
      DBREASON_ROW_FIRSTCHANGE,
      DBREASON_ROW_INSERT,
      DBREASON_ROW_RESYNCH,
      DBREASON_ROW_UNDOCHANGE,
      DBREASON_ROW_UNDOINSERT,
      DBREASON_ROW_UNDODELETE,
      DBREASON_ROW_UPDATE
    );

  IRowsetNotify =
    class(IUnknown)
    public
      function OnFieldChange(
            (* [in] *) pRotset : IRowset;
            (* [in] *) hRow : HROW;
            (* [in] *) cColumns : ULONG;
            (* [size_is][in] *) var rgColumns : ULONG;
            (* [in] *) eReason : TDBREASON;
            (* [in] *) ePhase : TDBEVENTPHASE;
            (* [in] *) fCantDeny : BOOL) : HResult; virtual; stdcall; abstract;

      function OnRowChange(
            (* [in] *) pRotset : IRowset;
            (* [in] *) cRows : ULONG;
            (* [size_is][in] *) var rghRows : HROW;
            (* [in] *) eReason : TDBREASON;
            (* [in] *) ePhase : TDBEVENTPHASE;
            (* [in] *) fCantDeny : BOOL) : HResult; virtual; stdcall; abstract;

      function OnRowsetChange(
            (* [in] *) pRotset : IRowset;
            (* [in] *) eReason : TDBREASON;
            (* [in] *) ePhase : TDBEVENTPHASE;
            (* [in] *) fCantDeny : BOOL) : HResult; virtual; stdcall; abstract;
    end;

  TDBSEEK = DWORD;

const
  DBSEEK_INVALID           = 0;
  DBSEEK_FIRSTEQ           = $1;
  DBSEEK_LASTEQ            = $2;
  DBSEEK_GE                = $4;
  DBSEEK_GT                = $8;
  DBSEEK_LE                = $10;
  DBSEEK_LT                = $20;

type
  TDBRANGE = DWORD;

const
  DBRANGE_INCLUSIVESTART       = 0;
  DBRANGE_INCLUSIVEEND         = 0;
  DBRANGE_EXCLUSIVESTART       = $1;
  DBRANGE_EXCLUSIVEEND         = $2;
  DBRANGE_EXCLUDENULLS         = $4;
  DBRANGE_PREFIX               = $8;
  DBRANGE_MATCH                = $10;

type
  IRowsetIndex =
    class(IUnknown)
    public
      function GetIndexInfo(
            (* [out][in] *) var pcKeyColumns : ULONG;
            (* [size_is][size_is][out] *) var prgIndexColumnDesc : PDBINDEXCOLUMNDESC;
            (* [out][in] *) var pcIndexProperties : ULONG;
            (* [size_is][size_is][out] *) var prgIndexProperties : PDBPROPSET) : HResult; virtual; stdcall; abstract;

      function Seek(
            (* [in] *) hAccessor : HACCESSOR;
            (* [in] *) cKeyValues : ULONG;
            (* [in] *) var pData;
            (* [in] *) dwSeekOptions : TDBSEEK) : HResult; virtual; stdcall; abstract;

      function SetRange(
            (* [in] *) hAccessor : HACCESSOR;
            (* [in] *) cStartKeyColumns : ULONG;
            (* [in] *) var pStartData;
            (* [in] *) cEndKeyColumns : ULONG;
            (* [in] *) var pEndData;
            (* [in] *) dwRangeOptions : TDBRANGE) : HResult; virtual; stdcall; abstract;
    end;

  ICommand =
    class(IUnknown)
    public
      function Cancel : HResult; virtual; stdcall; abstract;

      function Execute(
            (* [in] *) pUnkOuter : IUnknown;
            (* [in] *) const riid : TIID;
            (* [out][in] *) var pParams : TDBPARAMS;
            (* [out] *) pcRowsAffected : PLONG;
            (* [iid_is][out] *) ppRowset : PIUnknown) : HResult; virtual; stdcall; abstract;

      function GetDBSession(
            (* [in] *) const riid : TIID;
            (* [iid_is][out] *) var ppSession : IUnknown) : HResult; virtual; stdcall; abstract;
    end;

  TDBCONVERTFLAGS =
    (
      DBCONVERTFLAGS_COLUMN,
      DBCONVERTFLAGS_PARAMETER
    );

  IConvertType =
    class(IUnknown)
    public
      function CanConvert(
            (* [in] *) wFromType : TDBTYPE;
            (* [in] *) wToType : TDBTYPE;
            (* [in] *) dwConvertFlags : TDBCONVERTFLAGS) : HResult; virtual; stdcall; abstract;

    end;

  ICommandPrepare =
    class(IUnknown)
    public
      function Prepare(
            (* [in] *) cExpectedRuns : ULONG) : HResult; virtual; stdcall; abstract;

      function Unprepare : HResult; virtual; stdcall; abstract;
    end;

  ICommandProperties =
    class(IUnknown)
    public
      function GetProperties(
            (* [in] *) cPropertyIDSets : ULONG;
            (* [size_is][in] *) rgPropertyIDSets : PDBPROPIDSET;
            (* [out] *) var pcPropertySets : ULONG;
            (* [size_is][size_is][out] *) var prgPropertySets : PDBPROPSET) : HResult; virtual; stdcall; abstract;

      function SetProperties(
            (* [in] *) cPropertySets : ULONG;
            (* [size_is][out][in] *) var rgPropertySets : TDBPROPSET) : HResult; virtual; stdcall; abstract;

    end;

  ICommandText =
    class(ICommand)
    public
      function GetCommandText(
            (* [out][in] *) const pguidDialect : TGUID;
            (* [out] *) var ppwszCommand : POleStr) : HResult; virtual; stdcall; abstract;

      function SetCommandText(
            (* [in] *) const rguidDialect : TGUID;
            (* [in] *) pwszCommand : POleStr) : HResult; virtual; stdcall; abstract;

    end;

  TDBPARAMBINDINFO =
    record
      pwszDataSourceType : POleStr;
      pwszName : POleStr;
      ulParamSize : ULONG;
      dwFlags : TDBPARAMFLAGS;
      bPrecision : Byte;
      bScale : Byte;
    end;

  ICommandWithParameters =
    class(IUnknown)     
    public
      function GetParameterInfo(
            (* [out][in] *) var pcParams : ULONG;
            (* [size_is][size_is][out] *) var prgParamInfo : PDBPARAMINFO;
            (* [out] *) var ppNamesBuffer : TOleChar{!! ?}) : HResult; virtual; stdcall; abstract;

      function MapParameterNames(
            (* [in] *) cParamNames : ULONG;
            (* [size_is][in] *) var rgParamNames : TOleChar;{!! ?}
            (* [size_is][out] *) var rgParamOrdinals : LONG) : HResult; virtual; stdcall; abstract;

      function SetParameterInfo(
            (* [in] *) cParams : ULONG;
            (* [size_is][in] *) var rgParamOrdinals : LONG;
            (* [size_is][in] *) var rgParamBindInfo : TDBPARAMBINDINFO) : HResult; virtual; stdcall; abstract;

    end;

  IColumnsRowset =
    class(IUnknown)
    public
      function GetAvailableColumns(
            (* [out][in] *) var pcOptColumns : ULONG;
            (* [size_is][size_is][out] *) var prgOptColumns : PDBID) : HResult; virtual; stdcall; abstract;

      function GetColumnsRowset(
            (* [in] *) pUnkOuter : IUnknown;
            (* [in] *) cOptColumns : ULONG;
            (* [size_is][in] *) var rgOptColumns : TDBID;
            (* [in] *) const riid : TIID;
            (* [in] *) cPropertySets : ULONG;
            (* [size_is][out][in] *) var rgPropertySets : TDBPROPSET;
            (* [iid_is][out] *) var ppColRowset : IUnknown) : HResult; virtual; stdcall; abstract;

    end;

  IColumnsInfo =
    class(IUnknown)
    public
      function GetColumnInfo(
            (* [out][in] *) var pcColumns : ULONG;
            (* [size_is][size_is][out] *) var prgInfo : PDBCOLUMNINFO;
            (* [out] *) var ppStringsBuffer : TOleChar{!! ?}) : HResult; virtual; stdcall; abstract;

      function MapColumnIDs(
            (* [in] *) cColumnIDs : ULONG;
            (* [size_is][in] *) var rgColumnIDs : TDBID;
            (* [size_is][out] *) var rgColumns : ULONG) : HResult; virtual; stdcall; abstract;

    end;

  IDBCreateCommand =
    class(IUnknown)
    public
      function CreateCommand(
            (* [in] *) pUnkOuter : IUnknown;
            (* [in] *) const riid : TIID;
            (* [iid_is][out] *) var ppvCommand : IUnknown) : HResult; virtual; stdcall; abstract;

    end;

  IDBCreateSession =
    class(IUnknown)
    public
      function CreateSession(
            (* [in] *) pUnkOuter : IUnknown;
            (* [in] *) const riid : TIID;
            (* [iid_is][out] *) var ppDBSession : IUnknown) : HResult; virtual; stdcall; abstract;

    end;

const
  DBSOURCETYPE_DATASOURCE                = 1;
  DBSOURCETYPE_ENUMERATOR                = 2;

type
  TDBSOURCETYPE = DWORD;

  ISourcesRowset =
    class(IUnknown)
    public
      function GetSourcesRowset(
            (* [in] *) pUnkOuter : IUnknown;
            (* [in] *) const riid : TIID;
            (* [in] *) cProperties : ULONG;
            (* [size_is][out][in] *) var rgProperties : TDBPROPSET;
            (* [iid_is][out] *) var ppSourcesRowset : IUnknown) : HResult; virtual; stdcall; abstract;

    end;

  IDBProperties =
    class(IUnknown)
    public
      function GetProperties(
            (* [in] *) cPropertyIDSets : ULONG;
            (* [size_is][in] *) var rgPropertyIDSets : TDBPROPIDSET;
            (* [out][in] *) var pcPropertySets : ULONG;
            (* [size_is][size_is][out] *) var prgPropertySets : PDBPROPSET) : HResult; virtual; stdcall; abstract;

      function GetPropertyInfo(
            (* [in] *) cPropertyIDSets : ULONG;
            (* [size_is][in] *) var rgPropertyIDSets : TDBPROPIDSET;
            (* [out][in] *) var pcPropertyInfoSets : ULONG;
            (* [size_is][size_is][out] *) var prgPropertyInfoSets : PDBPROPINFOSET;
            (* [out] *) var ppDescBuffer : TOleChar{!! ?}) : HResult; virtual; stdcall; abstract;

      function SetProperties(
            (* [in] *) cPropertySets : ULONG;
            (* [size_is][out][in] *) var rgPropertySets : TDBPROPSET) : HResult; virtual; stdcall; abstract;

    end;

  IDBInitialize =
    class(IUnknown)
    public
      function Initialize : HResult; virtual; stdcall; abstract;

      function Uninitialize : HResult; virtual; stdcall; abstract;
    end;

  TDBLITERAL =
    (
      DBLITERAL_INVALID,
      DBLITERAL_BINARY_LITERAL,
      DBLITERAL_CATALOG_NAME,
      DBLITERAL_CATALOG_SEPARATOR,
      DBLITERAL_CHAR_LITERAL,
      DBLITERAL_COLUMN_ALIAS,
      DBLITERAL_COLUMN_NAME,
      DBLITERAL_CORRELATION_NAME,
      DBLITERAL_CURSOR_NAME,
      DBLITERAL_ESCAPE_PERCENT,
      DBLITERAL_ESCAPE_UNDERSCORE,
      DBLITERAL_INDEX_NAME,
      DBLITERAL_LIKE_PERCENT,
      DBLITERAL_LIKE_UNDERSCORE,
      DBLITERAL_PROCEDURE_NAME,
      DBLITERAL_QUOTE,
      DBLITERAL_SCHEMA_NAME,
      DBLITERAL_TABLE_NAME,
      DBLITERAL_TEXT_COMMAND,
      DBLITERAL_USER_NAME,
      DBLITERAL_VIEW_NAME
    );

  PDBLITERALINFO = ^TDBLITERALINFO;
  TDBLITERALINFO =
    record
      pwszLiteralValue : POleStr;
      pwszInvalidChars : POleStr;
      pwszInvalidStartingChars : POleStr;
      lt : TDBLITERAL;
      fSupported : BOOL;
      cchMaxLen : ULONG;
    end;

  IDBInfo =
    class(IUnknown)
    public
      function GetKeywords(
            (* [out] *) var ppwszKeywords : POleStr) : HResult; virtual; stdcall; abstract;

      function GetLiteralInfo(
            (* [in] *) cLiterals : ULONG;
            (* [size_is][in] *) var rgLiterals : TDBLITERAL;
            (* [out][in] *) var pcLiteralInfo : ULONG;
            (* [size_is][size_is][out] *) var prgLiteralInfo : PDBLITERALINFO;
            (* [out] *) var ppCharBuffer : TOleChar{!! ?}) : HResult; virtual; stdcall; abstract;

    end;

  IDBDataSourceAdmin =
    class(IUnknown)
    public
      function CreateDataSource(
            (* [in] *) cPropertySets : ULONG;
            (* [size_is][out][in] *) var rgPropertySets : TDBPROPSET;
            (* [in] *) pUnkOuter : IUnknown;
            (* [in] *) const riid : TIID;
            (* [iid_is][out] *) var ppDBSession : IUnknown) : HResult; virtual; stdcall; abstract;

      function DestroyDataSource : HResult; virtual; stdcall; abstract;

      function GetCreationProperties(
            (* [in] *) cPropertyIDSets : ULONG;
            (* [size_is][in] *) var rgPropertyIDSets : TDBPROPIDSET;
            (* [out][in] *) var pcPropertyInfoSets : ULONG;
            (* [size_is][size_is][out] *) var rgPropertyInfoSets : PDBPROPINFOSET;
            (* [out] *) var ppDescBuffer : TOleChar{!! ?}) : HResult; virtual; stdcall; abstract;

      function ModifyDataSource(
            (* [in] *) cPropertySets : ULONG;
            (* [size_is][in] *) var rgPropertySets : TDBPROPSET) : HResult; virtual; stdcall; abstract;

    end;

  ISessionProperties =
    class(IUnknown)
    public
      function GetProperties(
            (* [in] *) cPropertyIDSets : ULONG;
            (* [size_is][in] *) var rgPropertyIDSets : TDBPROPIDSET;
            (* [out][in] *) var pcPropertySets : ULONG;
            (* [size_is][size_is][out] *) var prgPropertySets : PDBPROPSET) : HResult; virtual; stdcall; abstract;

      function SetProperties(
            (* [in] *) cPropertySets : ULONG;
            (* [size_is][out][in] *) var rgPropertySets : TDBPROPSET) : HResult; virtual; stdcall; abstract;

    end;

  IIndexDefinition =
    class(IUnknown)
    public
      function CreateIndex(
            (* [in] *) var pTableID : TDBID;
            (* [in] *) var pIndexID : TDBID;
            (* [in] *) cIndexColumnDescs : ULONG;
            (* [size_is][in] *) var rgIndexColumnDescs : TDBINDEXCOLUMNDESC;
            (* [in] *) cPropertySets : ULONG;
            (* [size_is][out][in] *) var rgPropertySets : TDBPROPSET;
            (* [out] *) var ppIndexID : PDBID) : HResult; virtual; stdcall; abstract;

      function DropIndex(
            (* [in] *) var pTableID : TDBID;
            (* [in] *) var pIndexID : TDBID) : HResult; virtual; stdcall; abstract;

    end;

  ITableDefinition =
    class(IUnknown)
    public
      function CreateTable(
            (* [in] *) pUnkOuter : IUnknown;
            (* [in] *) var pTableID : TDBID;
            (* [in] *) cColumnDescs : ULONG;
            (* [size_is][in] *) var rgColumnDescs : TDBCOLUMNDESC;
            (* [in] *) const riid : TIID;
            (* [in] *) cPropertySets : ULONG;
            (* [size_is][out][in] *) var rgPropertySets : TDBPROPSET;
            (* [out] *) var ppTableID : PDBID;
            (* [iid_is][out] *) var ppRowset : IUnknown) : HResult; virtual; stdcall; abstract;

      function DropTable(
            (* [in] *) var pTableID : TDBID) : HResult; virtual; stdcall; abstract;

      function AddColumn(
            (* [in] *) var pTableID : TDBID;
            (* [in] *) var pColumnDesc : TDBCOLUMNDESC;
            (* [out] *) var ppColumnID : PDBID) : HResult; virtual; stdcall; abstract;

      function DropColumn(
            (* [in] *) var pTableID : TDBID;
            (* [in] *) var pColumnID : TDBID) : HResult; virtual; stdcall; abstract;

    end;

  IOpenRowset =
    class(IUnknown)
    public
      function OpenRowset(
            (* [in] *) pUnkOuter : IUnknown;
            (* [in] *) var pTableID : TDBID;
            (* [in] *) var pIndexID : TDBID;
            (* [in] *) const riid : TIID;
            (* [in] *) cPropertySets : ULONG;
            (* [size_is][out][in] *) var rgPropertySets : TDBPROPSET;
            (* [iid_is][out] *) var ppRowset : IUnknown) : HResult; virtual; stdcall; abstract;

    end;

const
  CRESTRICTIONS_DBSCHEMA_ASSERTIONS                      = 3;
  CRESTRICTIONS_DBSCHEMA_CATALOGS                        = 1;
  CRESTRICTIONS_DBSCHEMA_CHARACTER_SETS                  = 3;
  CRESTRICTIONS_DBSCHEMA_COLLATIONS                      = 3;
  CRESTRICTIONS_DBSCHEMA_COLUMNS                         = 4;
  CRESTRICTIONS_DBSCHEMA_CHECK_CONSTRAINTS               = 3;
  CRESTRICTIONS_DBSCHEMA_CONSTRAINT_COLUMN_USAGE         = 4;
  CRESTRICTIONS_DBSCHEMA_CONSTRAINT_TABLE_USAGE          = 3;
  CRESTRICTIONS_DBSCHEMA_KEY_COLUMN_USAGE                = 7;
  CRESTRICTIONS_DBSCHEMA_REFERENTIAL_CONSTRAINTS         = 3;
  CRESTRICTIONS_DBSCHEMA_TABLE_CONSTRAINTS               = 7;
  CRESTRICTIONS_DBSCHEMA_COLUMN_DOMAIN_USAGE             = 4;
  CRESTRICTIONS_DBSCHEMA_INDEXES                         = 5;
  CRESTRICTIONS_DBSCHEMA_OBJECT_ACTIONS                  = 1;
  CRESTRICTIONS_DBSCHEMA_OBJECTS                         = 1;
  CRESTRICTIONS_DBSCHEMA_COLUMN_PRIVILEGES               = 6;
  CRESTRICTIONS_DBSCHEMA_TABLE_PRIVILEGES                = 5;
  CRESTRICTIONS_DBSCHEMA_USAGE_PRIVILEGES                = 6;
  CRESTRICTIONS_DBSCHEMA_PROCEDURES                      = 4;
  CRESTRICTIONS_DBSCHEMA_SCHEMATA                        = 3;
  CRESTRICTIONS_DBSCHEMA_SQL_LANGUAGES                   = 0;
  CRESTRICTIONS_DBSCHEMA_STATISTICS                      = 3;
  CRESTRICTIONS_DBSCHEMA_TABLES                          = 4;
  CRESTRICTIONS_DBSCHEMA_TRANSLATIONS                    = 3;
  CRESTRICTIONS_DBSCHEMA_PROVIDER_TYPES                  = 2;
  CRESTRICTIONS_DBSCHEMA_VIEWS                           = 3;
  CRESTRICTIONS_DBSCHEMA_VIEW_COLUMN_USAGE               = 3;
  CRESTRICTIONS_DBSCHEMA_VIEW_TABLE_USAGE                = 3;
  CRESTRICTIONS_DBSCHEMA_PROCEDURE_PARAMETERS            = 4;
  CRESTRICTIONS_DBSCHEMA_FOREIGN_KEYS                    = 6;
  CRESTRICTIONS_DBSCHEMA_PRIMARY_KEYS                    = 3;
  CRESTRICTIONS_DBSCHEMA_PROCEDURE_COLUMNS               = 4;

type
  IDBSchemaRowset =
    class(IUnknown)
    public
      function GetRowset(
            (* [in] *) pUnkOuter : IUnknown;
            (* [in] *) const rguidSchema : TGUID;
            (* [in] *) cRestrictions : ULONG;
            (* [size_is][in] *) var rgRestrictions : PVariant;{!!was: const VARIANT __RPC_FAR rgRestrictions[  ],}
            (* [in] *) const riid : TIID;
            (* [in] *) cPropertySets : ULONG;
            (* [size_is][out][in] *) var rgPropertySets : TDBPROPSET;
            (* [iid_is][out] *) var ppRowset : IUnknown) : HResult; virtual; stdcall; abstract;

      function GetSchemas(
            (* [out][in] *) var pcSchemas : ULONG;
            (* [size_is][size_is][out] *) var prgSchemas : PGUID;
            (* [size_is][size_is][out] *) var prgRestrictionSupport : PULONG) : HResult; virtual; stdcall; abstract;

    end;

  IProvideMoniker =
    class(IUnknown)
    public
      function GetMoniker(
            (* [out] *) var ppIMoniker : IMoniker) : HResult; virtual; stdcall; abstract;

    end;

const
  IDENTIFIER_SDK_MASK                = $F0000000;
  IDENTIFIER_SDK_ERROR               = $10000000;

type
  TERRORINFO =
    record
      hrError : HResult;
      dwMinor : DWORD;
      clsid : TCLSID;
      iid : TIID;
      dispid : TDispId;
    end;

  IErrorRecords =
    class(IUnknown)
    public
      function AddErrorRecord(
            (* [in] *) var pErrorInfo : TERRORINFO;
            (* [in] *) dwLookupID : DWORD;
            (* [in] *) var pdispparams : TDispParams;
            (* [in] *) punkCustomError : IUnknown;
            (* [in] *) dwDynamicErrorID : DWORD) : HResult; virtual; stdcall; abstract;

      function GetBasicErrorInfo(
            (* [in] *) ulRecordNum : ULONG;
            (* [out] *) var pErrorInfo : TERRORINFO) : HResult; virtual; stdcall; abstract;

      function GetCustomErrorObject(
            (* [in] *) ulRecordNum : ULONG;
            (* [in] *) const riid : TIID;
            (* [iid_is][out] *) var ppObject : IUnknown) : HResult; virtual; stdcall; abstract;

      function GetErrorInfo(
            (* [in] *) ulRecordNum : ULONG;
            (* [in] *) lcid : TLCID;
            (* [out] *) var ppErrorInfo : IErrorInfo) : HResult; virtual; stdcall; abstract;

      function GetErrorParameters(
            (* [in] *) ulRecordNum : ULONG;
            (* [out] *) var pdispparams : TDispParams) : HResult; virtual; stdcall; abstract;

      function GetRecordCount(
            (* [out] *) var pcRecords : ULONG) : HResult; virtual; stdcall; abstract;

    end;

  IErrorLookup =
    class(IUnknown)
    public
      function GetErrorDescription(
            (* [in] *) hrError : HResult;
            (* [in] *) dwLookupID : DWORD;
            (* [in] *) var pdispparams : TDispParams;
            (* [in] *) lcid : TLCID;
            (* [out] *) var pbstrSource : TBStr;{!! PBStr ? }
            (* [out] *) var pbstrDescription : TBStr{!! PBStr ? }) : HResult; virtual; stdcall; abstract;

      function GetHelpInfo(
            (* [in] *) hrError : HResult;
            (* [in] *) dwLookupID : DWORD;
            (* [in] *) lcid : TLCID;
            (* [out] *) var pbstrHelpFile : TBStr;{!! PBStr? }
            (* [out] *) var pdwHelpContext : DWORD) : HResult; virtual; stdcall; abstract;

      function ReleaseErrors(
            (* [in] *) dwDynamicErrorID : DWORD) : HResult; virtual; stdcall; abstract;

    end;

  ISQLErrorInfo =
    class(IUnknown)
    public
      function GetSQLInfo(
            (* [out] *) var pbstrSQLState : TBStr;{!! PBStr? }
            (* [out] *) var plNativeError : LONG) : HResult; virtual; stdcall; abstract;

    end;

  IGetDataSource =
    class(IUnknown)
    public
      function GetDataSource(
            (* [in] *) const riid : TIID;
            (* [iid_is][out] *) var ppDataSource : IUnknown) : HResult; virtual; stdcall; abstract;

    end;

  ITransactionLocal =
    class(ITransaction)
    public
      function GetOptionsObject(
            (* [out] *) var ppOptions : ITransactionOptions) : HResult; virtual; stdcall; abstract;

      function StartTransaction(
            (* [in] *) isoLevel : TISOLEVEL;
            (* [in] *) isoFlags : ULONG;
            (* [in] *) pOtherOptions : ITransactionOptions;
            (* [out] *) var pulTransactionLevel : ULONG) : HResult; virtual; stdcall; abstract;

    end;

  ITransactionJoin =
    class(IUnknown)
    public
      function GetOptionsObject(
            (* [out] *) var ppOptions : ITransactionOptions) : HResult; virtual; stdcall; abstract;

      function JoinTransaction(
            (* [in] *) var punkTransactionCoord : IUnknown;
            (* [in] *) isoLevel : TISOLEVEL;
            (* [in] *) isoFlags : ULONG;
            (* [in] *) pOtherOptions : ITransactionOptions) : HResult; virtual; stdcall; abstract;

    end;

  ITransactionObject =
    class(IUnknown)
    public
      function GetTransactionObject(
            (* [in] *) ulTransactionLevel : ULONG;
            (* [out] *) var ppTransactionObject : ITransaction) : HResult; virtual; stdcall; abstract;

    end;

implementation

function IsEqualGUIDBase (const rguid1, rguid2 : TGUID) : BOOL;
begin
  Result:=IsEqualGUID(rguid1, rguid2);
end;

end.

