unit CpApplet;

{$R ctlpnl.res}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

function CPlApplet(hwndCPl: Integer; uMsg: Integer;
  lParam1, lParam2: Longint): Longint; stdcall;

type
  TAppletForm = class(TForm)
    Label1: TLabel;
    Button1: TButton;
  end;

var
  AppletForm: TAppletForm;

implementation

{$R *.DFM}

uses
  Cpl;


function CPlApplet(hwndCPl: Integer; uMsg: Integer;
  lParam1, lParam2: Longint): Longint; stdcall;
var
  P: PNewCPLInfo;
begin
//  ShowMessage(IntToStr(uMsg));

  case uMsg of
    CPL_INIT: begin
      { This message is sent to indicate CPlApplet() was found. Return TRUE
        or FALSE indicating whether the control panel should proceed. }
      // Free Form1 and create it anew with new Application.Handle
      AppletForm.Free;
      HINSTANCE := GetModuleHandle('ctrlpanl.cpl');
      Application.Handle := HINSTANCE;
      AppletForm := TAppletForm.Create(Application);
      Result := 1;
    end;
    CPL_GETCOUNT: begin
      { Return the number of applets to display in the control panel window. }
      Result := 1;
    end;
    CPL_DBLCLK: begin
      { This message is sent when the applet's icon has been double-clicked
        upon.  lParam1 is the applet number which was selected.  lParam2 is the
        applet's lData value. This message should initiate the applet's dialog box. }
      AppletForm.ShowModal;
      Result := 0;
    end;
    CPL_INQUIRE: begin
      { This message is sent for information about each applet. lParam1 is the
        applet number to register, a value from 0 to (CPL_GETCOUNT - 1).
        lParam2 is a far ptr to a CPLINFO structure. Fill in CPL_INFO's idIcon,
        idName, idInfo and lData fields with the resource id for an icon to
        display, name and description string ids, and a long data item
        associated with applet #lParam1. }
      Result := 0;
    end;
    CPL_NEWINQUIRE: begin
      { This is the same as CPL_INQUIRE execpt lParam2 is a pointer to a
        NEWCPLINFO structure.  This will be sent before the CPL_INQUIRE
        and if it is responed to (return != 0) CPL_INQUIRE will not be sent. }
      P := PNewCPLInfo(lParam2);
      FillChar(P^, SizeOf(TNewCPLInfo), 0);
      P.dwSize := SizeOf(TNewCPLInfo);
      P.hIcon := LoadIcon(HINSTANCE, 'CTLICON');
      P.szName := 'Yo! CPL Test';
      P.szInfo := 'This is a test';
      Result := 1;
    end;
    CPL_STARTWPARMS: begin
//      ShowMessage('lParam1: ' + IntToStr(lParam1));
      Result := 0;
    end;
    CPL_STOP: begin
      AppletForm.Free;
      Result := 0;
    end;
    CPL_EXIT: begin
      Result := 0;
    end;
    CPL_SELECT:
    begin
      Result := 0;
    end;
  else
    Result := 0;
  end;
end;

end.

