unit fmTest;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, adCpuUsage, ExtCtrls;

type
  TTestForm = class(TForm)
    MInfo: TMemo;
    LbAldynUrl: TLabel;
    Timer: TTimer;
    procedure LbAldynUrlClick(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  TestForm: TTestForm;

implementation

{$R *.DFM}

uses shellapi;

procedure TTestForm.LbAldynUrlClick(Sender: TObject);
begin
    ShellExecute(Application.Handle, 'open', 'http://www.aldyn.ru/',
        nil, nil, SW_SHOWDEFAULT);
end;

procedure TTestForm.TimerTimer(Sender: TObject);
var i: Integer;
begin
    CollectCPUData;
    MInfo.Lines.BeginUpdate;
    for i:=0 to GetCPUCount-1 do
        MInfo.Lines[i+1]:=Format('CPU #%d - %5.2f%%',[i,GetCPUUsage(i)*100]);
    MInfo.Lines.EndUpdate;
end;

procedure TTestForm.FormCreate(Sender: TObject);
var i: Integer;
begin
    MInfo.Lines.Clear;

    MInfo.Lines.Add(Format('There are %d total CPU in your system',[GetCPUCount]));

    for i:=0 to GetCPUCount-1 do MInfo.Lines.Add('');
end;

end.
