(* ----------------------------------------------------------------------------

 This component can be freely used and distributed in commercial and private
 environments, provided this notice is not modified in any way.
 Feel free to contact us if you have any questions, comments or suggestions at
 TRSOFT@Menden.net

    Copyright  1997 by TRSOFT  All Rights Reserved.
    Thomas Radtke Software Entwicklung.
    http://www.abcnet.de/TRSOFT/

  THIS SOFTWARE IS PROVIDED AS IS AND WITHOUT WARRANTY OF ANY KIND,
  EITHER EXPRESSED OR IMPLIED.

-----------------------------------------------------------------------------*)

UNIT Whetston;

INTERFACE

USES
    Windows, SysUtils, Classes, Controls, DsgnIntf;

TYPE ARRAY4 = ARRAY [1..4] OF DOUBLE;

TYPE
    TWHETSTONE= class(TComponent)
PRIVATE
    PROCEDURE DoIt;
    PROCEDURE PA (VAR E : ARRAY4);
    PROCEDURE P0;
    PROCEDURE P3 (X,Y : DOUBLE; VAR Z : DOUBLE);
PUBLIC
    CONSTRUCTOR Create(AOwner:TComponent); override;
    DESTRUCTOR Destroy; override;
    FUNCTION Index : REAL;

END;

PROCEDURE Register;

IMPLEMENTATION

VAR
   T, T1, T2, Y1, X1, X2, X3, X4, X, Y, Z  : DOUBLE;
   J, J1, K, L, NLoop, II, N1, N2, N3,
      N4, N5, N6, N7, N8, N9, N10, N11     : LONGINT;
   time0, time1                            : DWORD;
   E1                                      : ARRAY4;
   Res                                     : REAL;

PROCEDURE Register;
BEGIN
  RegisterComponents('TRSOFT', [TWHETSTONE]);
END;


PROCEDURE TWhetstone.PA (VAR E : ARRAY4);

BEGIN
        J1 := 0;
        REPEAT
                E [1] := ( E [1] + E [2] + E [3] - E [4]) * T;
                E [2] := ( E [1] + E [2] - E [3] + E [4]) * T;
                E [3] := ( E [1] - E [2] + E [3] + E [4]) * T;
                E [4] := (-E [1] + E [2] + E [3] + E [4]) / T2;
                J1 := J1 + 1;
        UNTIL J1 >= 6;
END;

PROCEDURE TWhetstone.P0;
BEGIN
        E1 [J] := E1 [K]; E1 [K] := E1 [L]; E1 [L] := E1 [J];
END;

PROCEDURE TWhetstone.P3 (X,Y : DOUBLE; VAR Z : DOUBLE);

BEGIN
        X1 := X;
        Y1 := Y;
        X1 := T * (X1 + Y1);
        Y1 := T * (X1 + Y1);
        Z := (X1 + Y1) / T2;
END;


PROCEDURE TWhetstone.DoIt;
VAR
   I, JJ : LONGINT;
BEGIN
     time0 := GetTickcount;

(* The actual benchmark starts here. *)
        T  := 0.499975;
        T1 := 0.50025;
        T2 := 2.0;
(* With loopcount NLoop=10, one million Whetstone instructions
   will be executed in each major loop.
   A major loop is executed 'II' times to increase wall-clock timing accuracy *)
        NLoop := 10;
        II    := 80;
        FOR JJ:=1 TO II DO
            BEGIN
(* Establish the relative loop counts of each module. *)
                N1 := 0;
                N2 := 12 * NLoop;
                N3 := 14 * NLoop;
                N4 := 345 * NLoop;
                N5 := 0;
                N6 := 210 * NLoop;
                N7 := 32 * NLoop;
                N8 := 899 * NLoop;
                N9 := 616 * NLoop;
                N10 := 0;
                N11 := 93 * NLoop;
(* Module 1: Simple identifiers *)
                X1 := 1.0;
                X2 := -1.0;
                X3 := -1.0;
                X4 := -1.0;
                FOR I:=1 TO N1 DO
                    BEGIN
                         X1 := (X1 + X2 + X3 - X4)*T;
                         X2 := (X1 + X2 - X3 + X4)*T;
                         X3 := (X1 - X2 + X3 + X4)*T;
                         X4 := (-X1 + X2 + X3 + X4)*T;
                    END;

(* Module 2: Array elements *)
                E1 [1] :=  1.0;
                E1 [2] := -1.0;
                E1 [3] := -1.0;
                E1 [4] := -1.0;
                FOR I:=1 TO N2 DO
                    BEGIN
                         E1 [1] := (E1 [1] + E1 [2] + E1 [3] - E1 [4])*T;
                         E1 [2] := (E1 [1] + E1 [2] - E1 [3] + E1 [4])*T;
                         E1 [3] := (E1 [1] - E1 [2] + E1 [3] + E1 [4])*T;
                         E1 [4] := (-E1 [1] + E1 [2] + E1 [3] + E1 [4])*T;
                    END;

(* Module 3: Array as parameter *)
                FOR I:=1 TO N3 DO
                    BEGIN
                         PA (E1);
                    END;

(* Module 4: Conditional jumps *)
                J := 1;
                FOR I:=1 TO N4 DO
                    BEGIN
                         IF (J <> 1) THEN J := 3 ELSE J := 2;
                         IF (J <= 2) THEN J := 1 ELSE J := 0;
                         IF (J >= 1) THEN J := 0 ELSE J := 1;
                    END;

(* Module 5: Omitted; Module 6: Integer arithmetic *)
                J := 1;
                K := 2;
                L := 3;
                FOR I:=1 TO N6 DO
                    BEGIN
                         J := J * (K-J) * (L-K);
                         K := L * K - (L-J) * K;
                         L := (L - K) * (K + J);
                         E1 [L-1] := (J + K + L);
                         E1 [K-1] := (J * K * L);
                    END;

(* Module 7: Trigonometric functions *)
                X := 0.5;
                Y := 0.5;
                FOR I:=1 TO N7 DO
                    BEGIN
                         X:=T*arctan(T2*sin(X)*cos(X)/(cos(X+Y)+cos(X-Y)-1.0));
                         Y:=T*arctan(T2*sin(Y)*cos(Y)/(cos(X+Y)+cos(X-Y)-1.0));
                    END;

(* Module 8: Procedure calls *)
                X := 1.0;
                Y := 1.0;
                Z := 1.0;
                FOR I:=1 TO N8 DO
                    BEGIN
                         P3 (X,Y,Z);
                    END;

(* Module 9: Array references *)
                J := 1;
                K := 2;
                L := 3;
                E1 [1] := 1.0;
                E1 [2] := 2.0;
                E1 [3] := 3.0;
                FOR I:=1 TO N9 DO
                    BEGIN
                         P0;
                    END;

(* Module 10: Integer arithmetic *)
                J := 2;
                K := 3;
                FOR I:=1 TO N10 DO
                    BEGIN
                         J := J + K;
                         K := J + K;
                         J := K - J;
                         K := K - J - J;
                    END;

(* Module 11: Standard functions *)
                X := 0.75;
                FOR I:=1 TO N11 DO
                    BEGIN
                         X := sqrt (exp (ln (X)/T1))
                    END;

(* THIS IS THE END OF THE MAJOR LOOP. *)
        END;
(* Stop benchmark timing at this point. *)
        time1 := GetTickCount;
(*----------------------------------------------------------------
      Performance in Whetstone KIP's per second is given by
       (100*NLoop*II)/TIME
      where TIME is in seconds.
--------------------------------------------------------------------*)

   Res:=(100.0 * NLoop * II /((1.0 * time1 - 1.0 * time0)/1000));

END;

FUNCTION TWhetstone.Index:Real;
BEGIN
     Doit;
     Result:=Res;
END;

CONSTRUCTOR TWhetstone.Create(aOwner:TComponent);
BEGIN
     inherited Create(aOwner);
     Res:=0;
END;

DESTRUCTOR TWhetstone.Destroy;
BEGIN
     inherited Destroy;
END;
END.
