unit Plus;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
   Dialogs;

type
  TPlusForm = class(TForm)
  private
         titel : String;
         procedure AppMessage(var Msg: TMsg; var Erledigt: Boolean);
         procedure WMSysCommand(var Message: TMessage); message WM_SYSCOMMAND;
         procedure CreateParams(var Params: TCreateParams); override;
         procedure ZoomMinimized;
  public
        constructor Create(AOwner: TComponent); override;
        destructor Destroy; override;
    { Public-Deklarationen }
  end;

var
  PlusForm: TPlusForm;

implementation

{$R *.DFM}

constructor TPlusForm.Create(AOwner: TComponent);
begin
if FormStyle=fsMDIChild then
 begin
      inherited Create(AOwner);
 end
 else
     Titel := Application.Title;
     Application.OnMessage := AppMessage;
     inherited Create(AOwner);
end;
{---------------------------------------------------------------------------}
destructor TPlusForm.Destroy;
begin
     inherited Destroy;
end;
{---------------------------------------------------------------------------}
procedure TPlusForm.CreateParams(var Params: TCreateParams);
begin
if FormStyle=fsMDIChild then
 begin
 inherited CreateParams(Params);
 Params.ExStyle := Params.ExStyle or WS_EX_CLIENTEDGE;
 end
 else
{immer die ererbte Methode zuerst aufrufen!!}
inherited CreateParams(Params);
Params.ExStyle := Params.ExStyle ;

end;
{---------------------------------------------------------------------------}
procedure TPlusForm.AppMessage(var Msg: TMsg; var Erledigt: Boolean);
begin
if FormStyle=fsMDIChild then
 else
if Msg.Message = WM_SYSCOMMAND then
  if Msg.WParam = SC_RESTORE then
    begin
      SetActiveWindow(Application.Handle);
      Application.Title := Application.MainForm.Caption;
      ShowWindow(Application.Handle, SW_RESTORE);
      SetWindowPos(Application.Handle, HWND_TOP,
       Screen.Width div 2, Screen.Height div 2, 0, 0, SWP_NOZORDER);
      Application.RestoreTopMosts;
      Erledigt := True;
    end;

end;
{---------------------------------------------------------------------------}
procedure TPlusForm.ZoomMinimized;
begin
if FormStyle=fsMDIChild then
  else
  Application.NormalizeTopMosts;
  SetActiveWindow(Application.Handle);
  SetWindowPos(Application.Handle, HWND_BOTTOM,
      Left, Top, Width, Height, SWP_NOZORDER);
  Application.Title := Application.MainForm.Caption;
  ShowWindow(Application.Handle, SW_MINIMIZE);
  Application.Title := titel;

end;
{---------------------------------------------------------------------------}
procedure TPlusForm.WMSysCommand(var Message: TMessage);
begin
if FormStyle=fsMDIChild then
 begin
  inherited;
 end
 else
   if Message.WParam = (SC_MINIMIZE or SC_ICON) then
     ZoomMinimized
  else
    inherited;

end;
{---------------------------------------------------------------------------}
end.
