(* ----------------------------------------------------------------------------

 This component can be freely used and distributed in commercial and private
 environments, provided this notice is not modified in any way.
 Feel free to contact us if you have any questions, comments or suggestions at
 TRSOFT@Menden.net

    Copyright  1997 by TRSOFT  All Rights Reserved.
    Thomas Radtke Software Entwicklung.
    http://www.abcnet.de/TRSOFT/

  THIS SOFTWARE IS PROVIDED AS IS AND WITHOUT WARRANTY OF ANY KIND,
  EITHER EXPRESSED OR IMPLIED.

-----------------------------------------------------------------------------*)

unit CPU32;
{$O+,S-,W-}
interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  Forms, Dialogs,DsgnIntf;
  
type
   TCPUType = integer;
   TCPU32 = class(TComponent)

private
    procedure Dummy(aString:String); 
    function CpuType: TCPUType;
    function GetCPUType: String;

public
    constructor Create(AOwner:TComponent);override;
    destructor Destroy;override;

published	
    property CPU: String read GetCPUType write Dummy stored false;

end;

   procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('TRSOFT', [TCPU32]);
end;

function TCPU32.GetCPUType: String;
var
  kind: TCPUType;
begin
   kind := CpuType;
      case kind of
      3:
        Result := '80386';
      4:
        Result := '80486';
      5:
        Result := 'Pentium';
      else
       Result := Format('P%2d', [byte(kind)]);//  Future TRY for P6

end;
end;

Function TCPU32.CpuType: TCPUType; assembler;
asm
  push EBX
  push ECX
  push EDX

  mov ebx,esp
  and esp,0FFFFFFFCh  //align down to nearest dword
  pushfd              //save original flags

  { i386 CPU check }
  { The AC bit, bit #18, is a new bit introduced in the EFLAGS }
  { register on the i486 DX CPU to generate alignment faults. }
  { This bit can not be set on the i386 CPU. }

  pushfd
  pop eax
  mov ecx,eax
  xor eax,40000h   //toggle AC bit
  push eax
  popfd
  pushfd
  pop eax
  xor eax,ecx
  mov eax,3          //assume 80386
  je @@End_CpuType   //it's a 386

  { i486 DX CPU / i487 SX MCP and i486 SX CPU checking }
  { Checking for ability to set/clear ID flag (Bit 21) in EFLAGS }
  { which indicates the presence of a processor }
  { with the ability to use the CPUID instruction. }

  pushfd
  pop	eax
  mov	ecx,eax
  xor	eax,200000h   //toggle ID bit
  push eax
  popfd
  pushfd
  pop eax
  xor eax, ecx
  mov eax,4
  je @@End_CpuType   //it's a 486 w/o support for CPUID

  { Execute CPUID instruction to determine vendor, family, }
  { model and stepping.  The use of the CPUID instruction used }
  { in this program can be used for B0 and later steppings }
  { of the P5 processor. }
  push ebx         // !!! CPUID modifies EBX  !!!
  mov eax, 1
  db 0Fh,0a2h      //CPUID opcode
  mov al,ah
  and eax, 0FH
  pop ebx

@@End_CpuType:
  popfd            // restore original flags
  mov esp,ebx      // restore original ESP
  pop EDX
  pop ECX
  pop EBX
  end;

{Visuel components event}

constructor TCPU32.Create(aOwner:TComponent);
begin
  inherited Create(aOwner);
end;

Destructor TCPU32.Destroy;
begin
   inherited Destroy;
end;

Procedure TCPU32.Dummy(aString:String);
begin
end;

End.