(* ----------------------------------------------------------------------------

 This component can be freely used and distributed in commercial and private
 environments, provided this notice is not modified in any way.
 Feel free to contact us if you have any questions, comments or suggestions at
 TRSOFT@Menden.net

    Copyright  1997 by TRSOFT  All Rights Reserved.
    Thomas Radtke Software Entwicklung.
    http://www.abcnet.de/TRSOFT/

  THIS SOFTWARE IS PROVIDED AS IS AND WITHOUT WARRANTY OF ANY KIND,
  EITHER EXPRESSED OR IMPLIED.

-----------------------------------------------------------------------------*)

unit CPU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TCPU_Speed = class(TComponent)

  private
         procedure Dummy(aString:String);
         function GetSpeed: String;

  public
        constructor Create(AOwner:TComponent);override;
        destructor Destroy;override;
        function Now:Word;
  published
        property Speed: String read GetSpeed write Dummy stored false;

  end;

procedure Register;

implementation

var
   hInst16: THandle;
   GFSR: Pointer;

function LoadLibrary16(LibraryName: PChar): THandle;
                  stdcall; external kernel32 index 35;
procedure FreeLibrary16(HInstance: THandle);
                   stdcall; external kernel32 index 36;
function GetProcAddress16(Hinstance: THandle; ProcName: PChar): Pointer;
                  stdcall; external kernel32 index 37;
procedure QT_Thunk;cdecl; external kernel32 name 'QT_Thunk';

procedure Register;
begin
  RegisterComponents('TRSOFT', [TCPU_Speed]);
end;

constructor TCPU_Speed.Create(aOwner:TComponent);
begin
  inherited Create(aOwner);
end;

Destructor TCPU_Speed.Destroy;
begin
   inherited Destroy;
end;

function TCPU_Speed.GetSpeed:String;
begin
Result:='Now = ' +  FormatFloat('#,###.#0',(Now / 100));
end;

function TCPU_Speed.Now:Word;
var
  ThunkTrash: array[0..$20] of Word;
begin
  ThunkTrash[0] := hInst16;

hInst16 := LoadLibrary16('CPU.dll');
  if hInst16 < 32 then
    raise Exception.Create('Cannot load CPU.dll ');

GFSR := GetProcAddress16(hInst16,'Speed');
  if not Assigned(GFSR) then
    raise Exception.Create('Cannot get address of SPEED');

  asm
    mov edx, GFSR
    call QT_Thunk
    mov Result,ax
  end;
FreeLibrary16(hInst16);
end;

Procedure TCPU_Speed.Dummy(aString:String);
begin
end;


end.
