// TComPort component ver. 2.00 for Delphi 2, 3, 4, 5
// written by Dejan Crnila, 1998 - 1999
// email: dejancrn@yahoo.com

unit CPortReg;

interface

uses
  DsgnIntf, Classes, CPort, CPortFrm;

type
  TComPortEditor = class(TComponentEditor)
  public
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;

procedure Register;

implementation

{$R CPortImg.res}

{ TComPortEditor }

procedure TComPortEditor.ExecuteVerb(Index: Integer);
begin
  if Index = 0 then begin
    (Component as TComPort).ShowSetupDialog;
    Designer.Modified;
  end;
end;

function TComPortEditor.GetVerb(Index: Integer): string;
begin
  case Index of
    0: Result := 'Edit Properties';
  end;
end;

function TComPortEditor.GetVerbCount: Integer;
begin
  Result := 1;
end;

procedure Register;
begin
  RegisterComponents('CommLib', [TComPort]);
  RegisterComponentEditor(TComPort, TComPortEditor);
end;

end.
