unit MainFrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, CPort;

type
  TForm1 = class(TForm)
    ComPort: TComPort;
    Memo: TMemo;
    Button_Open: TButton;
    Button_Settings: TButton;
    Edit_Data: TEdit;
    Button_Send: TButton;
    NewLine_CB: TCheckBox;
    Panel1: TPanel;
    L_OutputFull: TLabel;
    L_CTS: TLabel;
    L_DSR: TLabel;
    L_RLSD: TLabel;
    Label1: TLabel;
    Edit_Event: TEdit;
    Label2: TLabel;
    L_Time: TLabel;
    procedure Button_OpenClick(Sender: TObject);
    procedure Button_SettingsClick(Sender: TObject);
    procedure Button_SendClick(Sender: TObject);
    procedure ComPortOpen(Sender: TObject);
    procedure ComPortClose(Sender: TObject);
    procedure ComPortRxChar(Sender: TObject; Count: Integer);
    procedure ComPortTxEmpty(Sender: TObject);
    procedure ComPortCTSChange(Sender: TObject; OnOff: Boolean);
    procedure ComPortDSRChange(Sender: TObject; OnOff: Boolean);
    procedure ComPortRLSDChange(Sender: TObject; OnOff: Boolean);
    procedure Edit_EventExit(Sender: TObject);
    procedure ComPortRxFlag(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    EventCh: Integer;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button_OpenClick(Sender: TObject);
begin
  if ComPort.Connected then
    ComPort.Close
  else
    ComPort.Open;
end;

procedure TForm1.Button_SettingsClick(Sender: TObject);
begin
  ComPort.ShowSetupDialog;
end;

procedure TForm1.Button_SendClick(Sender: TObject);
var
  Str: String;
begin
  Str := Edit_Data.Text;
  if NewLine_CB.Checked then
    Str := Str + #13#10;
  if Length(Str) > 0 then
    L_OutputFull.Enabled := True;
  Application.ProcessMessages;
  try
    ComPort.WriteStr(Str);
  except
    L_OutputFull.Enabled := False;
    raise;
  end;
end;

procedure TForm1.ComPortOpen(Sender: TObject);
begin
  Button_Open.Caption := 'Close';
end;

procedure TForm1.ComPortClose(Sender: TObject);
begin
  Button_Open.Caption := 'Open';
end;

procedure TForm1.ComPortRxChar(Sender: TObject; Count: Integer);
var
  Str: String;
begin
  ComPort.ReadStr(Str, Count);
  Memo.Text := Memo.Text + Str;
end;

procedure TForm1.ComPortTxEmpty(Sender: TObject);
begin
  L_OutputFull.Enabled := False;
end;

procedure TForm1.ComPortCTSChange(Sender: TObject; OnOff: Boolean);
begin
  L_CTS.Enabled := OnOff;
end;

procedure TForm1.ComPortDSRChange(Sender: TObject; OnOff: Boolean);
begin
  L_DSR.Enabled := OnOff;
end;

procedure TForm1.ComPortRLSDChange(Sender: TObject; OnOff: Boolean);
begin
  L_RLSD.Enabled := OnOff;
end;

procedure TForm1.Edit_EventExit(Sender: TObject);
begin
  try
    EventCh := StrToInt(Edit_Event.Text);
  except
    EventCh := 0;
  end;
  if EventCh > 256 then
    EventCh := 256;
  if EventCh < 0 then
    EventCh := 0;
  Edit_Event.Text := IntToStr(EventCh);
  ComPort.EventChar := EventCh;
end;

procedure TForm1.ComPortRxFlag(Sender: TObject);
begin
  L_Time.Caption := TimeToStr(Time);
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  ComPort.SetDTR(true);
end;

end.
