unit CopyFile;

{ This component are freeware. You may use it, distribute it and modify it, but
you may not charge for it.
In case of modifications you must mail me (Lars_Nielsen@dk-online.dk) a copy of
the modifications. The reason are simple: Any changes that improve this free-
ware component should be to benefit for everybody, not only you. That way you
can be pretty sure, that this component has few errors and much functionality.
In case of modifications, you will be on the credits list beneath:}

{ Version 1.0 by Lars Fle Nielsen:
          This version is the base version. You can copy and move. The following
          properties are included:
                     Caption
                     CopyFrom
                     CopyTo
                     MoveFile
                     Name
                     OnNotExists
                     Progress
                     ShowFileNames
                     Tag}

{ Version 1.1. (10-04-97) Bug found and corrected by Jinsuck, Choi, South Korea:
          The component can now copy from a network drive where your rights are
          Read-only. Before this, the component made an exception-error. }

{ Version 1.2 (21-04-97) Bas Swemle, Netherlands added lines to the component:
          The component can now checks if the directory exists. If not, a
          dialog pop up, asking you if you want to create the dir. If not, a
          warning will be displayed.}
{ Version 1.2 (21-04-97) Russel Havens, USA. Suggested the following:
          A line that could transfer the file's original time and date to the
          destination file.
          It's not all the time the user want's this, so I added a new property
          TransferTimeDate of Boolean, which by default is set to True.}
{ Version 1.2 (21-04-97) Lars Fle Nielsen. Complete help file added to the
          component.}
{ Version 1.3 (09-05-97) David Pilcher, ???. He found a fatal bug. If you
          want to move the file, but by some unexpected error it cannot, you
          may loose the original. The reason is simple: The delete call was
          in the finally, which means that the file would be deleted in every
          case. The Delete call is now still in the finally, but will only be
          executed if the try was exited normally.}


{$IFNDEF WIN32}
  ERROR! This unit should only be used on 32 - bits systems!
{$ENDIF}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Extctrls, Consts, Filectrl;

type
  TCopyFile = class(TComponent) { This class is a new base class }
  private
    { Private declarations }
    FCopyFrom : String;         { Source file }
    FCopyTo   : String;         { Target file }
    FShowProgress : Boolean;    { If True the progress bar is shown }
    FProcessed : Longint;       { How much is processed is stored here
                                 (in percent 1% to 100%). This is mostly for
                                 the user which want to make his own progress
                                 bar }
    FOnNotExists : String;      { Errormessage if the file do not exists }
    FShowFileNames : Boolean;   { File names if true and FShowProgress is true}
    FCaption : String;          { Caption on the progress bar form}
    FMoveFile : Boolean;        { Moves the file if true }
    FTransferTimeDate : Boolean;{ Transfers the file time and date if true }
  protected
    { Protected declarations }
  public
    constructor Create(AOWner: TComponent); override; { MUST BE IN EVERY COMPONENT }
    destructor Destroy; override;                     { MUST BE IN EVERY COMPONENT }
    procedure Copynow;                                { Main procedure }
  published
    { Below is the properties as created in the component }
    property CopyFrom: string read FCopyFrom write FCopyFrom;
    property CopyTo: string read FCopyTo write FCopyTo;
    property Progress: Boolean read FShowProgress write FShowProgress;
    property OnNotExists : String read FOnNotExists write FOnNotExists;
    property ShowFileNames : Boolean read FShowFileNames write FShowFileNames;
    property Caption : String read FCaption write FCaption;
    property Movefile : Boolean read FMovefile write FMovefile;
    property Processed : Longint read FProcessed;
    property TransferTimeDate : Boolean read FTransferTimeDate write FTransferTimeDate;
  end;

procedure Register;

implementation

uses
  prgform; { PrgForm is the progress bar form }

procedure Register;
begin
  RegisterComponents('Samples', [TCopyFile]);
end;

constructor TCopyFile.Create(AOwner: TComponent);
begin
  FShowProgress := True;
  FTransferTimeDate := True;
  progress := FShowProgress;
  inherited Create(AOwner);
end;

destructor TCopyFile.Destroy;
begin
  inherited Destroy;
end;

procedure TCopyFile.CopyNow;
var
  Copybuffer     : Pointer;
  BytesCopied    : Longint;
  Source, Dest   : Integer;
  ProgressForm   : TProgform;
  processing     : Longint;
  size           : Longint;
  F              : File of Byte;
  D_Dir          : string; { <- Suggested by Bas Swemle, Netherlands}
  CanDelete      : Boolean;
const
  ChunkSize : Integer = 8192;
begin
  CanDelete := False;
  { - The following was suggested by Bas Swemle, Netherlands - }
  if (Fileexists(CopyFrom)) and (FCopyFrom<>'') then
  begin
    D_dir := ExtractFilePath(FCopyTo);
    if not DirectoryExists(D_Dir) then
      if messagedlg('Destination Directory '+d_dir+' doesn''t exists...'+#13#13+
                    'Do you want to create the directory ?',mtConfirmation,
                    [mbYes,mbNo],0) = mrYes then
                      ForceDirectories(D_Dir) else
                      begin
                        messagedlg('Process Aborted',mtWarning,[mbOk],0);
                        exit;
                      end;
  end;
  { ----- End of suggestion from Bas Swemle, Netherlands ----- }

  if (fileexists(FCopyFrom)) and (FCopyTo<>'') then
  begin
    { Compute the length of the FCopyFrom file }
    assignfile(F,FCopyFrom);
    try
      FileMode := 0;{ <- This line was suggested by Jinsuck, Choi, South Korea }
      reset(F);
      Size := FileSize(F); {The length of the file}
      processing := 0;
    finally
      closefile(F);
    end;
    { Show the progressform if this is what the user wants }
    if progress = True then
    begin
      ProgressForm := TProgForm.Create(Application);
      ProgressForm.Show;
      if FShowFileNames = TRUE then ProgressForm.Lfilename.Caption :=
        ExtractFilename(FCopyFrom)+' -> '+ExtractFileName(FCopyTo) Else
          ProgressForm.Lfilename.Caption := '';
      ProgressForm.Caption := FCaption;
    end;

    GetMem(Copybuffer, Chunksize);
    try
      source := FileOpen(FCopyFrom, fmShareDenyWrite);
      if Source<0 then raise EFOpenError.Create(FmtLoadStr(SFCreateError,[FCopyTo]));
      try
        Dest := FileCreate(FCopyTo);
        if Dest<0 then raise EFCreateError.Create(FmtLoadStr(SFCreateError,[FCopyTo]));
        try
          repeat
            BytesCopied := FileRead(Source, Copybuffer^, ChunkSize);
            if BytesCopied>0 then
            begin
              FileWrite(Dest, Copybuffer^, BytesCopied);
              processing := processing + bytescopied;
              FProcessed := Round(Processing/Size*100);
              if progress = true then
              begin
                progressform.progressbar1.position:=Round(FProcessed);
                progressform.update;
              end;
            end;
          until BytesCopied<ChunkSize;
          If FTransferTimeDate=True then FileSetDate(Dest,FileGetDate(Source));
             { Above line was suggested by Russel Havens, USA.}
          CanDelete := True;
        finally
          FileClose(Dest);
        end;
      finally
        FileClose(Source);
      end;
    finally
      freemem(Copybuffer, Chunksize);
      If (FMoveFile=True) and (CanDelete=True) Then deletefile(FCopyFrom);
    end;
    if progress = true then
    begin
      progressform.close;
      ProgressForm.Free;
    end;
  end
  else
    If FOnNotExists <> '' then Showmessage(FOnNotExists);
end;

end.
