{*******************************************************************************
*  TCornerPanel version 0.1                                                    *
********************************************************************************
* Author: Raoul Snyman                                                         *
* ---------------------------------------------------------------------------- *
* E-Mail: components@saturnlaboratories.gq.nu                                  *
* ---------------------------------------------------------------------------- *
* Copyright: 2002 Saturn Laboratories, All rights reserved.                   *
* ---------------------------------------------------------------------------- *
* Description: TCornerPanel is a panel similar to those found in setup apps,   *
*              having a basic L-shape. Includes 3D, line or no borders.        *
********************************************************************************
* This component is FREEWARE.                                                  *
* ---------------------------------------------------------------------------- *
* Please let me know if you find it useful!!                                   *
* ---------------------------------------------------------------------------- *
* It may be used for commercial purposes on the condition that you give me     *
* credit (i.e. place it in your credits list).                                 *
* ---------------------------------------------------------------------------- *
* If used in freeware, it's not necessary to give me credit, although it would *
* be appreciated.                                                              *
* ---------------------------------------------------------------------------- *
* If you modify this code, please send me an e-mail with a copy of the code    *
* attached, letting me know what it was that you modified/added.               *
* Please use the structure below to specify what you modified. Add the ref-    *
* erence to the end of the line you inserted/modified. Thanks.                 *
********************************************************************************
* Modified: (first name) (last name)     Reference: // (initials)              *
*           (version), (date)                                                  *
*           (description of modification)                                      *
*******************************************************************************}

unit CornerPanel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TCPBorderStyle = (cp_bsNone, cp_bsLine, cp_bsSingle);
  TCornerPanel = class(TGraphicControl)
  private
    { Private declarations }
    FHBarHeight: Integer;
    FVBarWidth: Integer;
    FColor: TColor;
    FBorderStyle: TCPBorderStyle;
    FBorderColor: TColor;
    procedure SetHBarHeight(Value: Integer);
    procedure SetVBarWidth(Value: Integer);
    procedure SetColor(Value: TColor);
    procedure SetBorderStyle(Value: TCPBorderStyle);
    procedure SetBorderColor(Value: TColor);
  protected
    { Protected declarations }
    property Canvas;
    procedure Paint; override;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
  published
    { Published declarations }
    property HBarHeight: Integer read FHBarHeight write SetHBarHeight;
    property VBarWidth: Integer read FVBarWidth write SetVBarWidth;
    property Color: TColor read FColor write SetColor;
    property BorderStyle: TCPBorderStyle read FBorderStyle write SetBorderStyle;
    property BorderColor: TColor read FBorderColor write SetBorderColor;
  end;

procedure Register;

implementation

constructor TCornerPanel.Create(AOwner: TComponent);
begin
 inherited;
 FVBarWidth := 152;
 FHBarHeight := 64;
 FBorderStyle := cp_bsSingle;
 FColor := clWindow;
 Width := 361;
 Height := 265;
end;

procedure TCornerPanel.SetHBarHeight(Value: Integer);
begin
 FHBarHeight := Value;
 Invalidate;
end;

procedure TCornerPanel.SetVBarWidth(Value: Integer);
begin
 FVBarWidth := Value;
 Invalidate;
end;

procedure TCornerPanel.SetColor(Value: TColor);
begin
 FColor := Value;
 Invalidate;
end;

procedure TCornerPanel.SetBorderStyle(Value: TCPBorderStyle);
begin
 FBorderStyle := Value;
 Invalidate;
end;

procedure TCornerPanel.SetBorderColor(Value: TColor);
begin
 FBorderColor := Value;
 Invalidate;
end;

procedure TCornerPanel.Paint;
var R: TRect;
begin
 inherited;
 with Canvas do
  begin
   Brush.Color := FColor;
   Pen.Color := FColor;
   Brush.Style := bsSolid;
   FillRect(Rect(0, 0, Width, FHBarHeight));
   FillRect(Rect(0, 0, FVBarWidth, Height));
  end;
 if FBorderStyle = cp_bsSingle
  then
   with Canvas do
    begin
     Pen.Color := clBtnShadow;
     MoveTo(0, 0);
     LineTo(Width-1, 0);
     Pen.Color := clBtnHighlight;
     LineTo(Width-1, FHBarHeight);
     LineTo(FVBarWidth, FHBarHeight);
     LineTo(FVBarWidth, Height-1);
     LineTo(0, Height-1);
     Pen.Color := clBtnShadow;
     LineTo(0, 0);
     Pen.Color := cl3DDkShadow;
     MoveTo(1, 1);
     LineTo(Width-2, 1);
     Pen.Color := clBtnFace;
     LineTo(Width-2, FHBarHeight-1);
     LineTo(FVBarWidth-1, FHBarHeight-1);
     LineTo(FVBarWidth-1, Height-2);
     LineTo(1, Height-2);
     Pen.Color := cl3DDkShadow;
     LineTo(1, 1);
    end
  else if FBorderStyle = cp_bsLine
   then
    with Canvas do
     begin
      Pen.Color := FBorderColor;
      MoveTo(0, 0);
      LineTo(Width-1, 0);
      LineTo(Width-1, FHBarHeight);
      LineTo(FVBarWidth, FHBarHeight);
      LineTo(FVBarWidth, Height-1);
      LineTo(0, Height-1);
      LineTo(0, 0);
     end;
end;

procedure Register;
begin
  RegisterComponents('Extras', [TCornerPanel]);
end;

end.
