unit cp_s22en;

interface

uses {$IFDEF WIN32} BDE,Windows,ComCtrls,{$ELSE}Winprocs,{$ENDIF}
  SysUtils, WinTypes, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, DB, DBTables, DbiProcs, DbiErrs,
  DbiTypes, DBConsts, ExtCtrls, Mask, Grids, DBGrids, FileCtrl, DBCtrls,
  TabNotBk,Menus,Printers, LibCs;

type
  TCopia_Dbf = class(TForm)
    Table2: TTable;
    DS1: TDataSource;
    DS2: TDataSource;
    Query1: TQuery;
    DataSource1: TDataSource;
    TN1: TTabbedNotebook;
    DBNavigator1: TDBNavigator;
    DBGrid1: TDBGrid;
    Label6: TLabel;
    CbTipoTabla: TComboBox;
    Label5: TLabel;
    EditFic: TEdit;
    EditDirectory: TEdit;
    Label3: TLabel;
    DriveComboBox1: TDriveComboBox;
    Directory1: TDirectoryListBox;
    Panel1: TPanel;
    Edit1: TEdit;
    Edit2: TEdit;
    DBNavigator2: TDBNavigator;
    DBGrid2: TDBGrid;
    BMove1: TBatchMove;
    MainMenu1: TMainMenu;
    Copiar1: TMenuItem;
    TablassinIndices1: TMenuItem;
    TablasIndices1: TMenuItem;
    Exportar1: TMenuItem;
    Tablaordebnada1: TMenuItem;
    FiltroSQL1: TMenuItem;
    Ordenar1: TMenuItem;
    TablaporunIndice1: TMenuItem;
    Ver1: TMenuItem;
    Filtros1: TMenuItem;
    Salida1: TMenuItem;
    Sql1: TMenuItem;
    Query2: TMenuItem;
    Utilidades1: TMenuItem;
    Indexar1: TMenuItem;
    Empaquetar1: TMenuItem;
    Acercade1: TMenuItem;
    Salir1: TMenuItem;
    Estructura1: TMenuItem;
    SQL2: TMenuItem;
    Ejecutar1: TMenuItem;
    Memo2: TMemo;
    Memo1: TMemo;
    Label8: TLabel;
    EditRecordQuery: TEdit;
    Label10: TLabel;
    Label9: TLabel;
    BBSql: TBitBtn;
    Label12: TLabel;
    Buffer: TEdit;
    Heap: TEdit;
    Controladores: TEdit;
    Clientes: TEdit;
    Sesiones: TEdit;
    BasesDatos: TEdit;
    Cursores: TEdit;
    Compartir: TEdit;
    TipoRed: TEdit;
    NombreUsuario: TEdit;
    ArchivoConfiguracion: TEdit;
    ControladorLenguaje: TEdit;
    Timer1: TTimer;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    GroupBox1: TGroupBox;
    CBAlias: TComboBox;
    Label2: TLabel;
    CBTable: TComboBox;
    Label7: TLabel;
    EditRegistros: TEdit;
    Label4: TLabel;
    CBIndex: TComboBox;
    EditAlias: TEdit;
    EditTable: TEdit;
    EditIndex: TEdit;
    Label1: TLabel;
    Label11: TLabel;
    Label13: TLabel;
    Database1: TDatabase;
    Label14: TLabel;
    Imprimir1: TMenuItem;
    PrintSql: TBitBtn;
    EditRegistro: TEdit;
    Label18: TLabel;
    CheckBox1: TCheckBox;
    SGrid1: TStringGrid;
    EditNear: TEdit;
    Label15: TLabel;
    Label16: TLabel;
    EditRanStart: TEdit;
    Label17: TLabel;
    EditRanEnd: TEdit;
    SpeedButton1: TSpeedButton;
    N1: TMenuItem;
    IndexInfo: TComboBox;
    Label19: TLabel;
    Label20: TLabel;
    MaskEdit1: TMaskEdit;
    Label21: TLabel;
    OpenDialog1: TOpenDialog;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    Label22: TLabel;
    Table1: TTable;
    IndexInNewForm1: TMenuItem;
    PackwithNewForm1: TMenuItem;
    Session1: TSession;
    procedure FormCreate(Sender: TObject);
    procedure CBAliasChange(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CBTableChange(Sender: TObject);
    procedure EditFicKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure DirectoryEnter(Sender: TObject);
    procedure DirectoryExit(Sender: TObject);
    procedure RbCopySortKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure CBAliasKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure CBTableKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure CBIndexKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure CBAliasEnter(Sender: TObject);
    procedure CBAliasExit(Sender: TObject);
    procedure CBTableEnter(Sender: TObject);
    procedure CBTableExit(Sender: TObject);
    procedure CBIndexEnter(Sender: TObject);
    procedure CBIndexExit(Sender: TObject);
    procedure RbCopiarSoloDatosKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure RbCopiarTodoKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure CbTipoTablaEnter(Sender: TObject);
    procedure CbTipoTablaExit(Sender: TObject);
    procedure CbTipoTablaKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Directory1Change(Sender: TObject);
    procedure BBSQLClick(Sender: TObject);
    procedure TN1Click(Sender: TObject);
    procedure TablassinIndices1Click(Sender: TObject);
    procedure TablaporunIndice1Click(Sender: TObject);
    procedure FiltroSQL1Click(Sender: TObject);
    procedure Tablaordebnada1Click(Sender: TObject);
    procedure TablasIndices1Click(Sender: TObject);
    procedure Ejecutar1Click(Sender: TObject);
    procedure Salir1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure CBIndexChange(Sender: TObject);
    procedure Filtros1Click(Sender: TObject);
    procedure Sql1Click(Sender: TObject);
    procedure Query2Click(Sender: TObject);
    procedure Estructura1Click(Sender: TObject);
    procedure Explorer1Click(Sender: TObject);
    procedure Indexar1Click(Sender: TObject);
    procedure Empaquetar1Click(Sender: TObject);
    procedure Acercade1Click(Sender: TObject);
    procedure DS1DataChange(Sender: TObject; Field: TField);
    procedure CheckBox1Click(Sender: TObject);
    procedure EditNearChange(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure EditRanStartKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure PrintSqlClick(Sender: TObject);
    procedure Imprimir1Click(Sender: TObject);
    procedure MaskEdit1Change(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure IndexInNewForm1Click(Sender: TObject);
    procedure PackwithNewForm1Click(Sender: TObject);
  public
    Contador,NTablas,k : Integer;
    Alias_S,Table_S,Index_S,Directory_T,Table_T : String;
    TableType_T : TTableType;
    function SortTable(Alias_S,Table_S,Index_S :String; var Retorno :String):Boolean;
    function CopySort(Alias_S,Table_S,Index_S,Directory_T,Table_T :String;
                      var Retorno :String; TableType_T : TTableType):Boolean;
    function CopyTableFull(Alias_S, Table_S, Table_T: String; var Retorno :String): Boolean;
    procedure InicioCopia;
    procedure Mensaje(Escribe : String);
    procedure HandleExcepcion(Sender: TObject; E: Exception);
    procedure ChangeDataBaseName;
  end;

var
  Copia_Dbf  : TCopia_Dbf;
  RecordToCopy, RecordCopy : Integer;

implementation

uses ToolsDb, Index, Pack;

{$R *.DFM}

procedure TCopia_Dbf.HandleExcepcion(Sender: Tobject; E: Exception);
begin
 if E.Message <> '' then begin
  Screen.Cursor := crArrow;
  MessageDlg(E.Message, mtError, [mbOK], 0);
 end;
end;

procedure TCopia_Dbf.Mensaje(Escribe : String);
begin
 Edit1.Text := Escribe;
 Edit1.Refresh;
end;

procedure TCopia_Dbf.FormCreate(Sender: TObject);
begin
 Application.OnException := HandleExcepcion;
 Screen.Cursor           := CrHourGlass;
 try
  Session.GetAliasNames(CbAlias.Items);
  CbAlias.ItemIndex := 0;
 finally
  Screen.Cursor     := CrDefault;
 end;

 {To launch the procedures of data update}
 CbAliasChange(nil);
 CbTipoTabla.ItemIndex := 0;
 EditDirectory.Text    := Directory1.Directory;
 if Copy(EditDirectory.Text,Length(EditDirectory.Text),1) <> '\'
 then EditDirectory.Text := EditDirectory.Text + '\';

 with SGrid1 do begin
  Cells[0,0]   := 'Field';
  Cells[1,0]   := 'Type';
  Cells[2,0]   := 'Size';
  Cells[3,0]   := 'Required';
  ColWidths[0] := Round(DefaultColWidth * 1.65);
  ColWidths[2] := Round(DefaultColWidth / 1.5);
  ColWidths[3] := Round(DefaultColWidth / 1.5);
  Width        := 379;
 end;
end;

procedure TCopia_Dbf.CBAliasChange(Sender: TObject);
begin
 Screen.Cursor  := CrHourGlass;
 EditAlias.Text := CbAlias.Items[CbALias.ItemIndex];
 ChangeDataBaseName;
end;

procedure TCopia_Dbf.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 Release;
end;

procedure TCopia_Dbf.CBTableChange(Sender: TObject);
var
 k       : integer;
 Table_S : String;
begin
 {To refresh data upon changing of table}
 Screen.Cursor         := CrHourGlass;
 CbTable.Refresh;
 if CbTable.ItemIndex > 0 then begin
  k := 1;
  while CbIndex.Items[k] <> '' do CbIndex.Items.Delete(k);

  with Table1 do begin
   DisableControls;
   Close;
   DatabaseName := EditAlias.Text;
   TableName    := CbTable.Items[CbTable.ItemIndex];
   IndexName    := '';
   Open;
   EditRegistros.Text  := IntToStr(RecordCount);
   GetIndexNames(CbIndex.Items);

   {To happen the characteristic of the fields to the grid}
   with SGrid1 do begin
    Cells[0,0] := 'Fields';
    Cells[1,0] := 'Type';
    Cells[2,0] := 'Size';
    Cells[3,0] := 'Required';
    RowCount := FieldCount + 1;
    for K := 0 to FieldCount - 1 do begin
     Cells[0,k+1] := FieldDefs.Items[k].Name;
     Cells[1,k+1] := GetFieldType(FieldDefs.Items[k].DataType);

     case FieldDefs.Items[k].DataType of
      ftString, ftBCD, ftBytes, ftVarBytes, ftBlob,
      ftMemo , ftGraphic : Cells[2,k+1] := IntToStr(Table1.FieldDefs.Items[K].Size);
     else
      Cells[2,k+1] := '';
     end;
     if FieldDefs.Items[K].Required then Cells[3,k+1] := 'True'
     else Cells[3,k+1] := 'False';
    end;
   end;

    Close;
    EnableControls;
   end;

   if CbIndex.Items[0] <> '< Natural Order >' then
    CbIndex.Items.Insert(0, '< Natural Order >');

   CbIndex.ItemIndex := 0;
   EditTable.Text    := CbTable.Items[CbTable.ItemIndex];
   EditIndex.Text    := '< Natural Order >';
 end;
 Screen.Cursor      := CrDefault;

 {To configure the head-board of the SQL text and tables and fields information}
 if CbTable.Items[CbTable.ItemIndex] <> '< All Tables >' then begin
  with Memo1 do begin
   Text := '';
   Lines.Add('Select * ');
   Table_S := CbTable.Items[CbTable.ItemIndex];
   if Pos('.',Table_S) > 0 then Table_S := Copy(Table_S,1,Pos('.',Table_S)-1);
   Lines.Add('From ' + Table_S);
   Lines.Add('Where ');
   Lines.Add(' Like ' + Chr(39) + '%%' + Chr(39));
  end;
 end;
end;

procedure TCopia_Dbf.EditFicKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 if Key = VK_RETURN then CbTipoTabla.SetFocus;
end;

procedure TCopia_Dbf.DirectoryEnter(Sender: TObject);
begin
 Directory1.Color := clWhite;
end;

procedure TCopia_Dbf.DirectoryExit(Sender: TObject);
begin
 Directory1.Color := clSilver;
end;

procedure TCopia_Dbf.RbCopySortKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 if Key = VK_RETURN then CbAlias.SetFocus;
end;

procedure TCopia_Dbf.CBAliasKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 if Key = VK_RETURN then CbTable.SetFocus;
end;

procedure TCopia_Dbf.CBTableKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 if (Key = VK_RETURN)then Directory1.SetFocus
 else CbIndex.SetFocus;
end;

procedure TCopia_Dbf.CBIndexKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 if Key = VK_RETURN then EditFic.SetFocus;
end;

procedure TCopia_Dbf.CBAliasEnter(Sender: TObject);
begin
 Screen.Cursor           := CrHourGlass;
 try
  Session.Close;
  Session.GetAliasNames(CbAlias.Items);
  CbAlias.ItemIndex := 0;
 finally
  Screen.Cursor     := CrDefault;
 end;
 CbAlias.Color := clWhite;
end;

procedure TCopia_Dbf.CBAliasExit(Sender: TObject);
begin
 CbAlias.Color := clSilver;
end;

procedure TCopia_Dbf.CBTableEnter(Sender: TObject);
begin
 CbTable.Color := clWhite;
end;

procedure TCopia_Dbf.CBTableExit(Sender: TObject);
begin
 CbTable.Color := clSilver;
end;

procedure TCopia_Dbf.CBIndexEnter(Sender: TObject);
begin
 CbIndex.Color := clWhite;
end;

procedure TCopia_Dbf.CBIndexExit(Sender: TObject);
begin
 CbIndex.Color := clSilver;
end;

procedure TCopia_Dbf.RbCopiarSoloDatosKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 if Key = VK_RETURN then CbAlias.SetFocus;
end;

procedure TCopia_Dbf.RbCopiarTodoKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 if Key = VK_RETURN then CbAlias.SetFocus;
end;

function TCopia_Dbf.SortTable(Alias_S,Table_S,Index_S :String;var Retorno :String):Boolean;
var
 Field_Number : Integer;
begin

 {Ctrl. Alias}
 if Length(Alias_S) = 0 then begin
  Retorno := ('The data Alias must be selected.');
  Result  := False;
  Exit;
 end;

 {Ctrl. Tabla}
 if (Length(Table_S) = 0) or (Table_S = '< All Tables >') then begin
  Retorno := 'To select Table to Sort.';
  Result  := False;
  Exit;
 end;

 {Ctrl. Index}
 if (Length(Index_S) = 0) or (Index_S = '< Natural Order >') then begin
  Retorno := 'To select the Index to order.';
  Result  := False;
  Exit;
 end;

 {# Config tables Source and Target}
 try
  with Table1 do begin
   Close;
   DatabaseName  := Alias_S;
   TableName     := Table_S;
   IndexName     := '';
   Open;
   RecordToCopy  := RecordCount;
   Close;
   IndexName     := Index_S;
   Open;
  end;

 except
  Table1.Close;
  Retorno := 'Error upon copying data to temporary Table.';
  Result  := False;
  Exit;
 end;

 if not CopyTableFull(Alias_S,      {Alias Source}
                      Table_S,      {Table Source}
                      'Tmp.Dbf',    {Table Target temporary}
                      Retorno)      {Message of result}
 then begin
  Retorno := 'Error produced upon copying ' + Alias_S + ' in tmp.dbf.';
  Result  := False;
  Exit;
 end;

 with Table2 do begin
  Close;
  DatabaseName := Alias_S;
  TableName    := 'Tmp.Dbf';
  IndexName    := Index_S;
 end;

 Table2.Open;
 Edit2.Text := IntToStr(Table2.RecordCount);
 Edit2.Refresh;

 {# Ctrl. of the fact that temporary table has records before erasing the previous}
 if Table2.RecordCount = 0 then begin
  Result  := False;
  Retorno := 'Error upon adding data in Tmp.dbf . 0 register copied';
  Exit;
 end;

 Table2.First;
 RecordCopy := 0;
 while not Table2.Eof do begin
  RecordCopy := RecordCopy + 1;
  Table2.Next;
 end;

 {# Control of the fact that it has copied less records of those which tape-worm
    in origin by be an  index with conditions UNIQUE}
 if RecordCopy < RecordToCopy then
  if MessageDlg('The selected Indexs condition is ++UNIQUE' + #13 +
                'and will lose data. Cancel the operation ?',
                mtInformation, [mbYes, mbNo], 0) = mrYes then
  begin
   Result  := False;
   Retorno := 'Operation aborted by having condition UNIQUE';
   Table2.Close;
   Exit;
  end;

 Table2.Close;

 {# To erase table of origin after proving that we have copied the all records}
 with Table1 do begin
  try
   Close;
   Exclusive := True;
   Open;
   EmptyTable;
   Close;
   Exclusive := False;
   Open;
  except
   Close;
   Retorno := 'Error upon erasing Table ' + TableName;
   Result  := False;
   Exit;
  end;
 end;

 {# To happen the data of temporary table tmp.dbf-Table2 to Table1}
 Table2.Open;
 Table2.First;
 RecordCopy := 0;
 try
  while not Table2.Eof do begin
   Table1.Edit;
   Table1.Insert;
   for Field_Number := 0 to Table2.FieldCount - 1 do
    Table1.Fields[Field_Number].Assign(Table2.Fields[Field_Number]);

   Table1.Post;
   RecordCopy := RecordCopy + 1;
   Table2.next;
  end;
 except
  Table1.Close;
  Table2.Close;
  Retorno := 'Error upon ordering data and to copy in ' + Table1.TableName;
  Result  := False;
  Exit;
 end;
 Retorno := 'Sort of Tabla - ' + Table_S + ' - finish.' +
            IntToStr(RecordCopy) + ' Register copied';
 Table1.Close;
 Table2.Close;
 Result  := True;

end;

function TCopia_Dbf.CopySort(Alias_S,Table_S,Index_S,Directory_T,Table_T :String;
                             var Retorno :String; TableType_T : TTableType):Boolean;
begin

 {Ctrl. Alias}
 if Length(Alias_S) = 0 then begin
  Retorno := ('To select the Alias or directory of Data.');
  Result  := False;
  Exit;
 end;

 {Ctrl. Tabla}
 if (Length(Table_S) = 0) or (Table_S = '< All Tables >') then begin
  Retorno := 'To select Table to order.';
  Result  := False;
  Exit;
 end;

 {# Ctrl. Index. Also it is possible to export table by Orden Natural }
 if (Length(Index_S) = 0) or (Index_S = '< Natural Order >') then begin
  Index_S := '';
 end;

 {# Ctrl. of the extension of the file. It is acquittance if it has}
 if Pos('.',Table_T) > 0 then begin
  while Pos('.',Table_T) = 1 do Table_T := Copy(Table_T,2,Length(Table_T) - 1);
  while pos('.',Table_T) > 0 do Table_T := Copy(Table_T,1,Pos('.',Table_T)-1);
 end;

 {# Config Tables}
 try
  with Table1 do begin
   Close;
   DatabaseName := Alias_S;
   TableName    := Table_S;
   IndexName    := Index_S;
   Open;
  end;

  with Table2 do begin
   Close;
   DatabaseName := Directory_T;
   TableName    := Table_T;
   TableType    := TableType_T;
  end;

  {# Execute the data copy

   ## The component TBatchMove has some Bug and not always works well.
      In some occasions and in the same conditions not copy nothing.}

  RecordCopy := Table2.BatchMove(Table1, BatCopy);
  Retorno    := 'Copy ordered to the file - ' + Table_T + ' - finish. ' +
                IntToStr(RecordCopy) + ' Register copied.';
  Result     := True;
 except
  Table1.Close;
  Table2.Close;
  Result  := False;
  Retorno := 'Error upon making the ordered copy';
 end;
end;

procedure TCopia_Dbf.CbTipoTablaEnter(Sender: TObject);
begin
 CbTipoTabla.Color := clWhite;
end;

procedure TCopia_Dbf.CbTipoTablaExit(Sender: TObject);
begin
 CbTipoTabla.Color := clSilver;
end;

procedure TCopia_Dbf.CbTipoTablaKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 Directory1.SetFocus;
end;

function TCopia_Dbf.CopyTableFull(Alias_S, Table_S, Table_T: String; var Retorno :String): Boolean;
var
 pTable_S, pTable_T : array[0..80] of char;
 ResultCopy         : DBIResult;
begin
 {# Table_T it must contain the full Path of D.O.S. of the file}
 Result := False;

 {# To convert of String to Pchar the Destination table}
 StrPCopy(pTable_T, Table_T);

 {# Config and copy the table}
 with Table1 do begin
  try
   Close;
   DataBaseName := Alias_S;
   TableName    := Table_S;
   TableType    := ttDefault;
   StrPCopy(pTable_S, TableName);
   Open;

   ResultCopy   := DbiCopyTable(DBHandle, True, pTable_S, nil, pTable_T);
   Result       := not (ResultCopy <> DBIERR_NONE);
   if Result then Retorno := 'Table - ' + Table_S + ' - it has been successfully copied'
   else Retorno := 'Error produced upon copying table';
  except
   on E: EDBEngineError do Retorno := E.Message;
   on E: Exception      do Retorno := E.Message;
  end;
 end;
end;

procedure TCopia_Dbf.Directory1Change(Sender: TObject);
begin
 EditDirectory.Text := Directory1.Directory;
 if Copy(EditDirectory.Text,Length(EditDirectory.Text),1) <> '\'
 then EditDirectory.Text := EditDirectory.Text + '\';
 EditDirectory.Refresh;
end;

procedure TCopia_Dbf.BBSQLClick(Sender: TObject);
begin
 Ejecutar1Click(nil);
end;

procedure TCopia_Dbf.TN1Click(Sender: TObject);
var Table_S,Index_S : String;
begin

 if TN1.ActivePage = 'Data' then begin

  Table_S := AllTrim(CbTable.Items[CbTable.ItemIndex]);
  Index_S := AllTrim(CbIndex.Items[CbIndex.ItemIndex]);

  with Table1 do begin
   DisableControls;
   Close;
   DatabaseName := EditAlias.Text;

   if (Table_S <> '< All Tables >') and (Length(LTrim(Table_S)) > 0) then
    TableName    := Table_S
   else Exit;

   if (Index_S <> '< Natural Order >') and (Length(LTrim(Index_S)) > 0) then
    IndexName   := Index_S;

   Open;
   EnableControls;
  end;
  DbGrid2.Refresh;
  if not Table1.Eof then EditRegistro.Text := IntToStr(Recno(Table1));
 end;
end;

procedure TCopia_Dbf.TablassinIndices1Click(Sender: TObject);
var
 Contador : Integer;
begin
{To Copy Tables without Indices. Alone the data}
 InicioCopia;

 if CbTable.ItemIndex > 0 then begin
  if Length(AllTrim(Directory1.Directory)) > 2 then begin
   Mensaje('Copying ' + CbTable.Items[CbTable.ItemIndex]);

   if Length(AllTrim(EditFic.Text)) = 0 then EditFic.Text := CbTable.Items[CbTable.ItemIndex];

   if not CopySort(CbAlias.Items[CbAlias.ItemIndex], {Alias Source}
                   CbTable.Items[CbTable.ItemIndex], {Table Source}
                   '',                               {Index Source}
                   Directory1.Directory,             {Alias Target}
                   AllTrim(EditFic.Text),            {Table Target}
                   Retorno,                          {Message of result}
                   TableType_T)                      {Table Type to copy}

   then MessageDlg('Unable to Copy ' + CbTable.Items[ CbTable.ItemIndex ] +
                   '.  Motive: ' +  '. ' + #10 + #10 + Retorno, mtError, [mbOK], 0);

  end else ShowMessage('The destination Directory must be indicated.');

 end else begin
  NTablas := CbTable.Items.Count;
  for Contador := 1 to CbTable.Items.Count - 1 do begin
   Mensaje('Copying ' + CbTable.Items[Contador]);
   Edit2.Text := IntToStr(NTablas - Contador);
   Edit2.Refresh;

   if Length(AllTrim(Directory1.Directory)) > 2 then begin
    if not CopySort(CbAlias.Items[CbAlias.ItemIndex], {Alias Source}
                    CbTable.Items[Contador],          {Table Source}
                    '',                               {Index Source}
                    Directory1.Directory,             {Alias Target}
                    CbTable.Items[Contador],          {Table Target}
                    Retorno,                          {Mensaje de resultado}
                    TableType_T)                      {Tipo de Tabla a copiar}
    then MessageDlg('Impossible to copy ' + CbTable.Items[Contador] +
                      '.  Motive: ' +  '. ' + #10 + #10 + Retorno, mtError, [mbOK], 0);

   end else ShowMessage('The destination Directory must be indicated.');

   Edit2.Text := '';
   Edit2.Refresh;
  end;
  Mensaje('Copying finished.');
 end;
end;

procedure TCopia_Dbf.InicioCopia;
begin
 DbiInit(nil);
 Retorno := ''; {# Messages Ok or Nok returned by the functions}
 Mensaje('');

 {TableType Target}
 if      CbTipoTabla.Text = 'dBase'   then TableType_T := ttDBase
 else if CbTipoTabla.Text = 'Paradox' then TableType_T := ttParadox
 else if CbTipoTabla.Text = 'ASCII'   then TableType_T := ttASCII;
end;

procedure TCopia_Dbf.TablaporunIndice1Click(Sender: TObject);
begin
 (*
 {But forward it is included the original function of the Bde that permits to
  order by a field, but is not used in this example}
 function fDbiSortTable(SrcTbl, DestTbl: TTable; SortField: TField): longint;
 *)

 {To Order Table by an Index}
 InicioCopia;

 Alias_S := AllTrim(CbAlias.Items[CbAlias.ItemIndex]);
 Table_S := AllTrim(CbTable.Items[CbTable.ItemIndex]);
 Index_S := AllTrim(CbIndex.Items[CbIndex.ItemIndex]);

 {# The function of ordering SortTable() returns 1 if has sucess and 0 if defect}
 if not SortTable(Alias_S, Table_S, Index_S, Retorno) then begin
  ShowMessage(Retorno);
  Exit;
 end else begin
  Edit1.Text  := Retorno;
  Edit1.Color := clWhite;
 end;
 Exit;
end;

procedure TCopia_Dbf.FiltroSQL1Click(Sender: TObject);
var
 k : Integer;
begin
 InicioCopia;
 {# To export by the Query SQL Filter}

 {Ctrl. of the existence of the name of the file}
 if Length(AllTrim(EditFic.Text)) = 0 then begin
  ShowMessage('The destination file must be indicated.');
  Exit;
 end;

 if Length(Directory1.Directory) < 3 then begin
  Directory1.SetFocus;
  Exit;
 end;

 {Execute Query}
 BBSQLClick(nil);
 if StrToInt(EditRecordQuery.Text) = 0 then begin
  ShowMessage('The are no records originating from the filter SQL to copy.');
  Exit;
 end;

{To create new table in the indicated directorate}
 with Table2 do begin
  Close;
  DataBaseName := Directory1.Directory;
  TableName    := AllTrim(EditFic.Text);
  TableType    := TableType_T;
  FieldDefs.clear;
  for k := 0 to Query1.FieldDefs.Count-1 do
   FieldDefs.Add(Query1.FieldDefs.Items[k].Name,
                 Query1.FieldDefs.Items[k].DataType,
                 Query1.FieldDefs.Items[k].Size,
                 Query1.FieldDefs.Items[k].Required);
  IndexDefs.Clear;
 end;
 try
  Table2.CreateTable;
 except
  MessageDlg( 'An error has ocurred while creating the table', mtError,[mbCancel], 0 );
 end;

 {# Execute the query copy}
 BMove1.Execute;

 Table2.Open;
 Edit1.Text := 'Process of filter SQL copy ended. ' +
               IntToStr(Table2.RecordCount) +
               ' register copied';
 Table2.Close;
 TN1.ActivePage := 'Filter';
end;

procedure TCopia_Dbf.Tablaordebnada1Click(Sender: TObject);
begin
 {Export - Orderer Table}
 InicioCopia;

 {Ctrl. of the existence of the name of the file}
 if Length(AllTrim(EditFic.Text)) = 0 then begin
  ShowMessage('I need to know the destination file.');
  Exit;
 end;

 {Ctrl. Directory Target}
 EditDirectory.Text := AllTrim(EditDirectory.Text);

 if Length(EditDirectory.Text) < 3 then begin
  Directory1.SetFocus;
  Exit;
 end;

 Alias_S     := AllTrim(CbAlias.Items[CbAlias.ItemIndex]);
 Table_S     := AllTrim(CbTable.Items[CbTable.ItemIndex]);
 Index_S     := AllTrim(CbIndex.Items[CbIndex.ItemIndex]);
 Directory_T := AllTrim(Directory1.Directory);
 Table_T     := AllTrim(EditFic.Text);

 if not CopySort(Alias_S, Table_S, Index_S, Directory_T,
                 Table_T, Retorno, TableType_T) then begin
  ShowMessage(Retorno);
  Exit;
 end else begin
  Edit1.Text  := Retorno;
  Edit1.Color := clWhite;
 end;
end;

procedure TCopia_Dbf.TablasIndices1Click(Sender: TObject);
var
 Contador : Integer;
begin
 {To Copy complete Tables. dbf + mdx}
 InicioCopia;

 if CbTable.ItemIndex > 0 then begin
  {Copy an table}
  if Length(AllTrim(Directory1.Directory)) > 2 then begin
   Mensaje('Copying ' + CbTable.Items[CbTable.ItemIndex]);

   if Length(AllTrim(EditFic.Text)) = 0 then EditFic.Text := CbTable.Items[CbTable.ItemIndex];

    if not CopyTableFull(CbAlias.Items[CbAlias.ItemIndex],      {Alias Source}
                         CbTable.Items[CbTable.ItemIndex],      {Table Source}
                         EditDirectory.Text + AllTrim(EditFic.Text),{Alias + Table Target}
                         Retorno)                               {Message of result}
    then MessageDlg('Unable to Copy ' + CbTable.Items[ CbTable.ItemIndex ] +
                    '.  Motive: ' +  '. ' + #10 + #10 + Retorno, mtError, [mbOK], 0);

  end else ShowMessage('The destination Directory must be indicated.');

 end else begin
  NTablas := CbTable.Items.Count;
  for Contador := 1 to CbTable.Items.Count - 1 do begin
   Mensaje('Copying ' + CbTable.Items[Contador]);
   Edit2.Text := IntToStr(NTablas - Contador);
   Edit2.Refresh;
   if Length(AllTrim(Directory1.Directory)) > 2 then begin
    if not CopyTableFull(CbAlias.Items[CbALias.ItemIndex],
                         CbTable.Items[Contador],
                         EditDirectory.Text + CbTable.Items[Contador],
                         Retorno)
    then MessageDlg('Impossible to copy ' + CbTable.Items[ CbTable.ItemIndex ] +
                    '.  Motive: ' +  '. ' + #10 + #10 + Retorno, mtError, [mbOK], 0);
   end else ShowMessage('The destination Directory must be indicated.');
  end;

  Edit2.Text := '';
  Edit2.Refresh;
 end;
 Mensaje('Copying finished.');

end;

procedure TCopia_Dbf.Ejecutar1Click(Sender: TObject);
begin
  try
   Screen.Cursor := crHourglass;
   if Query1.Active then Query1.Close;
   Query1.DatabaseName := AllTrim(CbAlias.Items[CbAlias.ItemIndex]);
   Query1.SQL.clear;
   Query1.SQL.Add(Memo1.Text);
   Query1.Active := True;
   Screen.Cursor := crDefault;

   if Query1.Active then begin
    { If the query didn't return any records, there's no point in
    displaying the form.  In that event, raise an exception. }
    if Query1.RecordCount < 1 then
     ShowMessage('There is no data for the filter selected.');
   end;
  finally
   Screen.Cursor := crDefault;
  end;
 EditRecordQuery.Text := IntToStr(Query1.RecordCount);
 TN1.ActivePage := 'Query';
end;

procedure TCopia_Dbf.Salir1Click(Sender: TObject);
begin
 Close;
end;

procedure TCopia_Dbf.Timer1Timer(Sender: TObject);
var
 InformacionSistema: SYSInfo;
 InformacionConfiguracion: SYSConfig;
begin
 {Procedure originating from the book of Fernando Charte, advanced Programming
  with Delphi 2}

 {We obtain updated information }
 DbiGetSysInfo(InformacionSistema);
 DbiGetSysConfig(InformacionConfiguracion);

 {and we show it in the controls disposed in the chip for such end}
 with InformacionSistema do begin
  Buffer.Text        := IntToStr(iBufferSpace);
  Heap.Text          := IntToStr(iHeapSpace);
  Controladores.Text := IntToStr(iDrivers);
  Clientes.Text      := IntToStr(iClients);
  Sesiones.Text      := IntToStr(iSessions);
  BasesDatos.Text    := IntToStr(iDatabases);
  Cursores.Text      := IntToStr(iCursors);
 end;

 with InformacionConfiguracion do begin
  if bLocalShare then Compartir.Text := 'YES' else Compartir.Text := 'NO';

  TipoRed.Text              := szNetType;
  NombreUsuario.Text        := szUserName;
  ArchivoConfiguracion.Text := szIniFile;
  ControladorLenguaje.Text  := szLangDriver;
 end;
end;

procedure TCopia_Dbf.BitBtn1Click(Sender: TObject);
begin
 DbiInit(nil); {Init BDE}
end;


procedure TCopia_Dbf.BitBtn2Click(Sender: TObject);
begin
 DbiExit; {Closed BDE}
end;

procedure TCopia_Dbf.CBIndexChange(Sender: TObject);
function BoolVal(InBool: Boolean): String;
  begin
    if InBool = True then Result:= 'True'
    else Result:= 'False';
  end;

var
 IndexDesc : IDXDesc;
 KeyArray  : String;
 x         : Integer;
begin
 Table1.Open;
 EditIndex.Text := CbIndex.Items[CbIndex.ItemIndex];
 {To obtain the data related to each one from the index}
 if EditIndex.Text <> '< Natural Order >' then begin
  Table1.IndexName := EditIndex.Text;
  DbiGetIndexDesc(Table1.Handle,0,IndexDesc);
  IndexInfo.Clear;
  IndexInfo.Items.Add('Key Expression : ' + IndexDesc.szKeyExp);
  IndexInfo.Items.Add('Index Name : ' + IndexDesc.szname);
  IndexInfo.Items.Add('Tag Name (dBASE) : ' + IndexDesc.szTagName);
  IndexInfo.Items.Add('Index Format : ' + IndexDesc.szformat);
  IndexInfo.Items.Add('Primary : ' + BoolVal(IndexDesc.bPrimary));
  IndexInfo.Items.Add('Descending : ' + BoolVal(IndexDesc.bDescending));
  IndexInfo.Items.Add('Maintained : ' + BoolVal(IndexDesc.bMaintained));
  IndexInfo.Items.Add('Subset : ' + BoolVal(IndexDesc.bSubset));
  IndexInfo.Items.Add('ExpIdx : ' + BoolVal(IndexDesc.bExpIdx));
  IndexInfo.Items.Add('Fields In Key : ' + IntToStr(IndexDesc.iFldsInKey));
  IndexInfo.Items.Add('Key Length : ' + IntToStr(IndexDesc.iKeyLen));
  IndexInfo.Items.Add('Out of Date : ' + BoolVal(IndexDesc.bOutofDate));
  IndexInfo.Items.Add('Key Expression Type : ' + IntToStr(IndexDesc.iKeyExpType));
  KeyArray := '';
  for x:= 0 to IndexDesc.iFldsInKey -1 do
    KeyArray := KeyArray + IntToStr(IndexDesc.aiKeyFld[x]) + ', ';
  IndexInfo.Items.Add('Field Numbers used in Key : ' + KeyArray);
  IndexInfo.Items.Add('Key Condition : ' + IndexDesc.szKeyCond);

  IndexInfo.Items.Add('Case Insensitive : ' + BoolVal(IndexDesc.bCaseInsensitive));
  IndexInfo.Items.Add('iBlockSize : ' + IntToStr(IndexDesc.iBlockSize));
  IndexInfo.Items.Add('iRestrNum : ' + IntToStr(IndexDesc.iRestrNum));
  IndexInfo.Text := 'Key Expression : ' + IndexDesc.szKeyExp;
 end;
 Table1.Close;
end;

procedure TCopia_Dbf.Filtros1Click(Sender: TObject);
begin
 TN1.ActivePage := 'Filter';
end;

procedure TCopia_Dbf.Sql1Click(Sender: TObject);
begin
 TN1.ActivePage := 'Data';
end;

procedure TCopia_Dbf.Query2Click(Sender: TObject);
begin
 TN1.ActivePage := 'Query';
end;

procedure TCopia_Dbf.Estructura1Click(Sender: TObject);
begin
 TN1.ActivePage := 'Bde';
end;

procedure TCopia_Dbf.Explorer1Click(Sender: TObject);
begin
 TN1.ActivePage := 'Explorer';
end;

procedure TCopia_Dbf.Indexar1Click(Sender: TObject);
var
 Contador, NTablas : Integer;
begin
 TN1.ActivePage := 'Filter';

 if CbTable.Items.Count = 1 then Exit; {There is no tables for reindex}

 if (CbTable.Items[CbTable.ItemIndex] <> '< All Tables >') then begin {Index an Table alone}
  Retorno := '';
  Table1.Close;
  Table1.DataBaseName := CbAlias.Items[CbAlias.ItemIndex];
  Table1.TableName    := CbTable.Items[CbTable.ItemIndex];
  Table1.Exclusive    := True;
  Table1.Open;
  Edit1.Text          := ' Indexanding the Tabla ' + Table1.TableName;
  Edit1.Refresh;

  if not fDbiRegenIndexes(Table1, Retorno) then ShowMessage(Retorno);

 end else begin {Index all tables}
  NTablas             := cbTable.Items.Count;
  for Contador := 1 to NTablas - 1 do begin
   Table1.Close;
   Table1.DataBaseName := CbAlias.Items[CbAlias.ItemIndex];
   Table1.TableName    := CbTable.Items[Contador];
   Table1.Exclusive    := True;
   Table1.Open;
   Edit1.Text          := ' Indexanding the Table ' + Table1.TableName;
   Edit2.Text          := IntToStr(Contador);
   Edit1.Refresh;
   Edit2.Refresh;

   if not fDbiRegenIndexes(Table1, Retorno) then ShowMessage(Retorno);

  end;
 end;

 Table1.CLose;
 Table1.Exclusive := False;
 Table1.Open;

 Edit2.Text := '';
 Edit1.Text       := 'Reindex ended.' + IntToStr(Contador) + ' Register index';
end;

procedure TCopia_Dbf.Empaquetar1Click(Sender: TObject);
var
 Contador, NTablas : Integer;
begin
 TN1.ActivePage := 'Filter';

 if CbTable.Items.Count = 1 then Exit; {There is no tables to Packet}

 if (CbTable.Items[CbTable.ItemIndex] <> '< All Tables >') then begin {To Pack an alone Table}
  Retorno := '';
  Table1.Close;
  Table1.DataBaseName := CbAlias.Items[CbAlias.ItemIndex];
  Table1.TableName    := CbTable.Items[CbTable.ItemIndex];
  Table1.Exclusive    := True;
  Table1.Open;
  Edit1.Text          := ' Indexando la Tabla ' + Table1.TableName;
  Edit1.Refresh;

  if not fDbiPackTable(Table1,
                       True,      {Index upon ending, True o False}
                       Retorno) then ShowMessage(Retorno);
  Contador := 1;

 end else begin {Pack all tables}
  NTablas             := cbTable.Items.Count;
  for Contador := 1 to NTablas - 1 do begin
   Table1.Close;
   Table1.DataBaseName := CbAlias.Items[CbAlias.ItemIndex];
   Table1.TableName    := CbTable.Items[Contador];
   Table1.Exclusive    := True;
   Table1.Open;
   Edit1.Text          := ' Packing the Table ' + Table1.TableName;
   Edit2.Text          := IntToStr(Contador);
   Edit1.Refresh;
   Edit2.Refresh;

   if not fDbiPackTable(Table1,
                        True,      {Index upon ending, True o False}
                        Retorno) then ShowMessage(Retorno);

  end;
 end;

 Table1.CLose;
 Table1.Exclusive := False;
 Table1.Open;

 Edit2.Text := '';
 Edit1.Text       := 'Packing finished. ' + IntToStr(Contador) + ' tables Pack';
end;

procedure TCopia_Dbf.Acercade1Click(Sender: TObject);
begin
 ShowMessage('CopySort Version 2.2' + #13 +
             'Delphi 2,3,4' + #13 +
             'Autor: Jose Maria Gias' + #13 +
             'sigecom@arrakis.es' + #13 +
             'Freeware 26.12.1998');
end;

procedure TCopia_Dbf.DS1DataChange(Sender: TObject; Field: TField);
begin
  if not Table1.Eof then EditRegistro.Text := IntToStr(Recno(Table1));
end;

procedure TCopia_Dbf.CheckBox1Click(Sender: TObject);
begin
 if CheckBox1.Checked then begin
  Query1.RequestLive := True;
  DbGrid1.ReadOnly   := False;
 end else begin
  Query1.RequestLive := False;
  DbGrid1.ReadOnly   := True;
 end;
end;

procedure TCopia_Dbf.EditNearChange(Sender: TObject);
var
 k      : Integer;
 Existe : Boolean;
begin
 Existe := False;
 {Control of the existence of the index of the field}
 for k := 1 to SGrid1.RowCount do
  if UpperCase(AllTrim(sGrid1.Cells[0,k])) = UpperCase(AllTrim(EditIndex.Text)) then
   Existe := True;

 if not Existe then begin
  ShowMessage('In this project can be sought by indices of a field');
  Exit;
 end;

 EditRanStart.Text := '';
 EditRanEnd.Text   := '';

 {Example of applying search brandish accordant we wrote text}
  with Table1 do begin
   CancelRange;
   SetKey;
   FieldByName(AllTrim(EditIndex.Text)).AsString := AllTrim(EditNear.Text);
   GotoNearest;
  end;
end;

procedure TCopia_Dbf.SpeedButton1Click(Sender: TObject);
var
 k      : Integer;
 Existe : Boolean;
 Tipo   : String;
begin
 Existe := False;
 Tipo := '';
 {Control of the existence of the index of the field}
 for k := 1 to SGrid1.RowCount do
  if UpperCase(AllTrim(sGrid1.Cells[0,k])) = UpperCase(AllTrim(EditIndex.Text))
  then begin
   Existe := True;
   Tipo   := sGrid1.Cells[1,k];
  end;

 if not Existe then begin
  ShowMessage('In this project alone can be filter by the index of a field.');
  Exit;
 end;

 {For this application, alone are filtered the String fields}
 if Tipo <> 'String' then begin
  ShowMessage('In this application only the String fields are filtered.');
  Exit;
 end;

 {Control of the text existence to filter}
 if (Length(AllTrim(EditRanStart.Text)) = 0) then begin
  ShowMessage('The text to filter must be indicated.');
 end;

 {Example of applying data filters }
  with Table1 do begin
   CancelRange;

   SetRangeStart;
   FieldByName(AllTrim(EditIndex.Text)).AsString := AllTrim(EditRanStart.Text);

   if (Length(AllTrim(EditRanEnd.Text)) > 0) then begin
    SetRangeEnd;
    FieldByName(AllTrim(EditIndex.Text)).AsString := AllTrim(EditRanEnd.Text);
   end;

   ApplyRange;
  end;
end;

procedure TCopia_Dbf.EditRanStartKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 EditNear.Text := '';
end;

procedure TCopia_Dbf.PrintSqlClick(Sender: TObject);
var
 k   : Integer;
 f : System.Text;
 Cad : String;
begin

 if not Query1.Active then begin
  ShowMessage('There ar no records to print.');
  Exit;
 end;
 if Query1.RecordCount = 0 then begin
  ShowMessage('There ar no records originating from the SQL filter to copy.');
  Exit;
 end;

 Screen.Cursor            := CrHourGlass;
 Printer.Canvas.Font.Name := 'Courier';
 Printer.Canvas.Font.Size := 9;
 try
  AssignPrn(f);
  Rewrite(f);

  {Headed and Query}
  WriteLn(f,'List of Query') ;
  WriteLn(f,'----------------');
  WriteLn(f,Memo1.Text);
  WriteLn(f,'');

  {Fields and types}
  Cad := '';
  WriteLn(f,'Fields definition');
  WriteLn(f,'--------------------');
  for k := 0 to Query1.FieldDefs.Count-1 do begin
   Cad := AlineaIzqda(IntToStr(k+1),4) + '  ' +
          AlineaIzqda(Query1.FieldDefs.Items[k].Name,20) + '  ' +
          AlineaIzqda(GetFieldType(Query1.FieldDefs.Items[k].DataType),10) + '  ' +
          AllTrim(IntToStr(Query1.FieldDefs.Items[k].Size));
   WriteLn(f,Cad);
  end;
  WriteLn(f,'');

  {Data of the Query}
  WriteLn(f,'Data');
  WriteLn(f,'-----');
  Query1.First;
  Query1.DisableControls;
  while not Query1.Eof do begin
   Cad := '';
   for k := 0 to Query1.FieldDefs.Count - 1 do
    Cad := Cad +  AlineaIzqda(Query1.Fields[k].AsString,
                              Query1.FieldDefs.Items[k].Size) + '  ';

   WriteLn(f,Cad);
   Query1.Next;
  end;

  System.Close(f);
 except
  ShowMessage('An exception has been produced upon creating the list');
 end;

 Query1.First;
 Query1.EnableControls;
 Screen.Cursor  := CrDefault;

end;

procedure TCopia_Dbf.Imprimir1Click(Sender: TObject);
begin
 PrintSqlClick(nil);
end;

procedure TCopia_Dbf.MaskEdit1Change(Sender: TObject);
begin
 if AllTrim(MaskEdit1.Text) = '' then MaskEdit1.Text := '1';
 if not GotoRecno(Table1, StrToInt(AllTrim(MaskEdit1.Text)),Retorno) then
  ShowMessage(Retorno);
end;

procedure TCopia_Dbf.SpeedButton2Click(Sender: TObject);
var
 s : String;
begin
 if OpenDialog1.Execute then begin
  s := UpperCase(OpenDialog1.FileName);

  {Get path only}
   while (s[Length(s)] <> '\') and (Length(s) > 0) do s := Copy(s,1,Length(s)-1);

  CbAlias.Items.Insert(0, s);
  CbAlias.ItemIndex := 0;
  EditAlias.Text    := s;
  ChangeDataBaseName;
 end;
end;

procedure TCopia_Dbf.ChangeDataBaseName;
begin
 try
  Session.GetTableNames(EditAlias.Text,'',True,False,CbTable.Items);
  CbTable.Items.Insert(0, '< All Tables >');
  CbTable.ItemIndex := 0;
 finally
  Screen.Cursor      := CrDefault;
 end;
 sGrid1.RowCount   := 2;
 sGrid1.Cells[0,1] := '';
 sGrid1.Cells[1,1] := '';
 sGrid1.Cells[2,1] := '';
 sGrid1.Cells[3,1] := '';
end;

procedure TCopia_Dbf.SpeedButton3Click(Sender: TObject);
begin
 Form2.Show;
end;

procedure TCopia_Dbf.IndexInNewForm1Click(Sender: TObject);
begin
 Indexa.Show;
end;

procedure TCopia_Dbf.PackwithNewForm1Click(Sender: TObject);
begin
 FPack.Show;
end;

end.
