library ContrPan;

uses
  SysUtils,
  Windows,
  Messages,
  MainForm in 'MainForm.pas' {frmMain};

{$E cpl}

const NUM_APPLETS = 1;
const CPL_INIT = 1;
const CPL_GETCOUNT = 2;
const CPL_INQUIRE = 3;
const CPL_SELECT = 4;
const CPL_DBLCLK = 5;
const CPL_STOP = 6;
const CPL_EXIT = 7;
const CPL_NEWINQUIRE = 8;

type TNewCplInfoA = record
       dwSize : DWORD;
       dwFlags : DWORD;
       dwHelpContext : DWORD;
       lData : LongInt;
       IconH : HIcon;
       szName : array [0..31] of char;
       szInfo : array [0..63] of char;
       szHelpFile : array [0..127] of char;
     end;
     PNewCplInfoA = ^TNewCplInfoA;

type TNewCplInfo = TNewCplInfoA;
type PNewCplInfo = ^TNewCplInfoA;

function CPlApplet(hWndCPL : hWnd;
                   iMessage : Integer;
                   lParam1 : Longint;
                   lParam2 : Longint) : LongInt stdcall; export;
begin
  case iMessage of
    CPL_INIT : begin
      frmMain:=TfrmMain.Create(frmMain);
      Result := 1;
      exit;
    end;
    CPL_GetCount : begin
      Result := NUM_APPLETS;
      exit;
    end;
    CPL_NewInquire : begin
      PNewCplInfo(lParam2)^.dwSize := sizeof(TNewCplInfo);
      PNewCplInfo(lParam2)^.dwHelpContext := 0;
      PNewCplInfo(lParam2)^.lData := 0;
      PNewCplInfo(lParam2)^.IconH := frmMain.Icon.Handle;
      lStrCpy(@PNewCplInfo(lParam2)^.szName,PChar(frmMain.Caption));
      lStrCpy(PNewCplInfo(lParam2)^.szInfo,PChar(frmMain.Caption));
      PNewCplInfo(lParam2)^.szHelpFile[0] := #0;
      Result := 1;
      exit;
    end;
    CPL_SELECT : begin
      Result := 0;
      exit;
    end;
    CPL_DBLCLK : begin
      frmMain.ShowModal;
      Result := 1;
      exit;
    end;
    CPL_STOP : begin
      Result := 0;
      exit;
    end;
    CPL_EXIT : begin
      frmMain.Free;
      Result := 0;
      exit;
    end else begin
      Result := 0;
      exit;
    end;
  end;
end;

exports CPlApplet name 'CPlApplet';

begin
end.

 
 



