unit Memory;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Grids, Buttons, MPlayer, Placemnt;


Const NumTries : Integer = 2;

type
  TSequence = Class(TObject)
    Index : Integer;
    Constructor Create(anIndex : Integer);
  end;

  TPlayer = Class(TObject)
  Private
    FTries    : Integer;
    FScore    : LongInt;
    FLevel    : Integer;
    FMiss     : integer;

    Procedure SetTries(aTries : Integer);
    Procedure SetScore(aScore : LongInt);
    Procedure SetLevel(aLevel : Integer);
    Procedure SetMiss(aMiss : Integer);

  Public
    Grid     : TStringGrid;
    Row      : LongInt;
    Sequence : TList;
    IsAdd    : Boolean;

    constructor Create;
    Destructor Destroy; Override;

    Property Tries : Integer Read FTries Write SetTries;
    Property Score : LongInt Read FScore Write SetScore;
    Property Level : Integer Read FLevel Write SetLevel;
    Property Miss  : Integer Read FMiss  Write SetMiss;
  end;

  TGameForm = class(TForm)
    Shape1: TShape;
    Shape2: TShape;
    Shape3: TShape;
    Shape4: TShape;
    Shape5: TShape;
    Timer1: TTimer;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    PlayerLabel: TLabel;
    PlayerName: TLabel;
    LevelLabel: TLabel;
    LevelName: TLabel;
    SampleTimer: TTimer;
    Label6: TLabel;
    IndexLabel: TLabel;
    Label8: TLabel;
    TotalLabel: TLabel;
    Bevel1: TBevel;
    Label7: TLabel;
    ScoreLabel: TLabel;
    Label9: TLabel;
    TryLabel: TLabel;
    MediaPlayer1: TMediaPlayer;
    MediaPlayer2: TMediaPlayer;
    MediaPlayer3: TMediaPlayer;
    MediaPlayer4: TMediaPlayer;
    MediaPlayer5: TMediaPlayer;
    procedure Timer1Timer(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure SampleTimerTimer(Sender: TObject);
    Procedure DeHiLight;
    Procedure ClearSequence;
    procedure Shape1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
    AddOnly : Boolean;
    Number : integer;
    Sequence  : TList;
    Level : Integer;
    PlayedIndex : integer;
    SampleIndex : Integer;
    LastLevel   : Integer;
    CurrentPlayer : TPlayer;
    Score         : LongInt;

    Procedure Hilight(Index : Integer);
    Procedure GenerateSequence;
    Procedure PlaySample;
    procedure StartPlaying;
    procedure Regenerate(aRow : Integer);
    Procedure GenerateOne(aRow : integer);
    Procedure WriteStatus(isSuccess : Boolean);
  public
    { Public declarations }
    Grid   : TStringGrid;
    PlayerNumber : Integer;
    NumberPlayers  : Integer;
    NoSound        : Boolean;
    Constructor Create(AOwner : TComponent); Override;
    Destructor Destroy; Override;
    Procedure BeginGame(StartLevel,FinalLevel : integer);
  end;

var
  GameForm: TGameForm;

implementation

{$R *.DFM}

Constructor TSequence.Create(anIndex : Integer);
begin
  Index := anIndex;
end;
{----------------------------------------------------------}
constructor TPlayer.Create;
begin
  Inherited Create;
  Sequence := Tlist.Create;
end;

Destructor TPlayer.Destroy;
var
  I : integer;
begin
  For I := 0 To Sequence.Count - 1 Do
    TSequence(Sequence[I]).Free;
  Sequence.Free;
  Inherited Destroy;
end;

Procedure TPlayer.SetTries(aTries : Integer);
begin
  FTries := aTries;
  Grid.Cells[3,Row] := intToStr(FTries);
  Grid.Invalidate;
end;

Procedure TPlayer.SetScore(aScore : LongInt);
begin
  FScore := aScore;
  Grid.Cells[4,Row] := IntToStr(FScore);
  Grid.Invalidate;
end;

Procedure TPlayer.SetLevel(aLevel : Integer);
Begin
  FLevel := aLevel;
  Grid.Cells[2,Row] := IntToStr(FLevel);
  Grid.Invalidate;
end;

Procedure TPlayer.SetMiss(aMiss : Integer);
Begin
  FMiss := aMiss;
  Grid.Cells[1,Row] := IntToStr(FMiss);
  Grid.Invalidate;
end;
{----------------------------------------------------------}
Constructor TGameForm.Create(AOwner : TComponent);
begin
  Inherited Create(AOwner);
  NoSound := FALSe;
end;

Destructor TGameForm.Destroy;
begin
  Inherited Destroy;
end;

Procedure TGameForm.ClearSequence;
var
  I : Integer;
begin
  For I := 0 To Sequence.Count - 1 Do
    TSequence(Sequence[I]).Free;
  Sequence.Clear;
end;

Procedure TGameForm.DeHiLight;
begin
  if (Number < 1) OR (Number > 5) Then Exit;
  Case Number Of
    1: Shape1.Brush.Color := clMaroon;
    2: Shape2.Brush.Color := clTeal;
    3: Shape3.Brush.Color := clNavy;
    4: Shape4.Brush.Color := clGreen;
    5: Shape5.Brush.Color := clPurple;
  end;
  Timer1.Enabled := FALSE;
end;

procedure TGameForm.Timer1Timer(Sender: TObject);
begin
  DeHiLight;
end;

Procedure TGameForm.Hilight(Index : Integer);
begin
  if (Index < 1) OR (Index > 5) Then Exit;
  Number := Index;
  Case Index OF
    1:
      Begin
        Shape1.Brush.Color := clRed;
        If NOT NoSound THen
             MediaPlayer1.Play;
      end;
    2:
      Begin
        Shape2.Brush.Color := clAqua;
        If NOT NoSound THen
          MediaPlayer2.Play;
      end;
    3:
      begin
        Shape3.Brush.Color := clBlue;
        If NOT NoSound THen
          MediaPlayer3.Play;
      end;
    4:
      begin
        Shape4.Brush.Color := clLime;
        If NOT NoSound THen
          MediaPlayer4.Play;
      end;
    5:
      begin
        Shape5.Brush.Color := clFuchsia;
        If NOT NoSound THen
          MediaPlayer5.Play;
      end;
  end;
  Timer1.Enabled := TRUE;
end;

Procedure TGameForm.WriteStatus(isSuccess : Boolean);
begin
  if IsSuccess Then
    begin
      CurrentPlayer.IsAdd := TRUE;
      CurrentPlayer.Level := Level + 1;
      CurrentPlayer.Score := Score;
    end
  Else
    begin
      CurrentPlayer.IsAdd := FALSE;
      CurrentPlayer.Tries := CurrentPlayer.Tries + 1;
      CurrentPlayer.Miss := CurrentPlayer.Miss + 1;
    end;
end;

procedure TGameForm.FormKeyPress(Sender: TObject; var Key: Char);
begin
  If Key in ['1'..'5'] Then
    begin
      Inc(PlayedIndex);
      IndexLabel.Caption := IntToStr(PlayedIndex+1);
      Hilight(StrToInt(Key));
      Score := Score + Level;
      ScoreLabel.Caption := intToStr(CurrentPlayer.Score+Level);

      If TSequence(Sequence[PlayedIndex]).Index <> StrToInt(Key) Then
        Begin
          MessageDlg('Oops! wrong one.',mtInformation,[mbOK],0);
          WriteStatus(FALSE);
          StartPlaying;
        end
      Else
        if PlayedIndex = Sequence.Count-1 Then
          begin
            MessageDlg('Success!!!!',mtInformation,[mbOK],0);
            WriteStatus(TRUE);
            StartPlaying;
          end;
    End;
end;

procedure TGameForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_ESCAPE Then Close
  Else Key := 0;

end;

Procedure TGameForm.GenerateSequence;
var  I : LongInt;
  H,M,S,s100 : WORD;
  N : integer;
begin
  DecodeTime(Time,H,M,S,S100);

  Repeat
    I := Random(5)+1;
    N := Round(S100/100);
    If (I + N) > 5 Then
      I := ABS(I-N)
    Else
      I := I + N;

    While I > 5 Do
      I := I - 5;
  Until I <> 0;

  Sequence.Add(TSequence.Create(I));
end;

Procedure TGameForm.PlaySample;
begin
  SampleTimer.Enabled := TRUE;
end;

procedure TGameForm.SampleTimerTimer(Sender: TObject);
var
  anIndex : integer;
begin
  Inc(SampleIndex);
  if SampleIndex >= Sequence.Count Then
    begin
      SampleTimer.Enabled := FALSE;
      SampleIndex := 0;
    end
  Else
    begin
      IndexLabel.Caption := IntToStr(SampleIndex+1);
      anIndex := TSequence(Sequence[SampleIndex]).Index;
      If SampleIndex > 0 Then
        Begin
          Number := TSequence(Sequence[SampleIndex - 1]).Index;
          DeHiLight;
        end;
      Hilight(anIndex);
    end;
end;

procedure TGameForm.Shape1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  Inc(PlayedIndex);
  IndexLabel.Caption := IntToStr(PlayedIndex+1);
  Hilight(TShape(Sender).Tag);

  Score := Score + Level;
  ScoreLabel.Caption := intToStr(CurrentPlayer.Score+Level);

  If TSequence(Sequence[PlayedIndex]).Index <> TShape(Sender).Tag Then
    Begin
      MessageDlg('Oops! wrong one.',mtInformation,[mbOK],0);
      WriteStatus(FALSE);
      StartPlaying;
    end
  Else
    if PlayedIndex = Sequence.Count-1 Then
      begin
        MessageDlg('Success!!!!',mtInformation,[mbOK],0);
        WriteStatus(TRUE);
        StartPlaying;
      end;
end;

procedure TGameForm.StartPlaying;

Function GetNextPlayer(PN : Integer) : Integer;
var
  I : integer;
  aPlayer : TPlayer;
begin
  Result := -1;
  FOR I := PN To Grid.RowCount  DO
    if Grid.Cells[0,I] <> '' Then
      begin
        aPlayer := TPlayer(Grid.Objects[0,I]);
        If assigned(aPlayer) Then
          If aPlayer.Tries <= NumTries Then
            begin
              Result := I;
              Break;
            end
      end;
end;

var
  CurNum : Integer;
  aPlayer : TPlayer;

begin
  Inc(PlayerNumber);
  if PlayerNumber > NumberPlayers Then
    begin
      Inc(Level);
      If Level > LastLevel Then
        begin
          Close;
          Exit;
        end
      Else
        begin
          PlayerNumber := 1;
          AddOnly := TRUE;
        end;
    end;

  CurNum := GetNextPlayer(PlayerNumber);
  If CurNum <= 0 Then
    begin
      PlayerNumber := 1;
      CurNum := GetNextPlayer(PlayerNumber);
      if curNum <= 0 Then
        begin
          Close;
          Exit;
        end;
    end;


  If AddOnly Then
    GenerateOne(CurNum)
  Else
    Regenerate(CurNum);

  Score := 0;
  Level := CurrentPlayer.level;

  LevelName.Caption := IntToStr(Level);
  PlayerName.Caption := Grid.Cells[0,CurNum];

  TryLabel.Caption := intToStr(CurrentPlayer.Tries);

  PlayedIndex := -1;
  SampleIndex := -1;
  PlaySample;
  Number := 0;
end;

procedure TGameForm.GenerateOne(aRow : Integer);
begin
  CurrentPlayer := TPlayer(Grid.Objects[0,aRow]);
  Sequence := CurrentPlayer.Sequence;
  if CurrentPlayer.IsAdd Then
    GenerateSequence;
end;

procedure TGameForm.Regenerate(aRow : Integer);
var I : Integer;
  aPlayer : TPlayer;
begin
  aPlayer := TPlayer(Grid.Objects[0,aRow]);
  CurrentPlayer := aPlayer;
  Sequence := aPlayer.Sequence;
  ClearSequence;
  For I := 1 To Level Do
    GenerateSequence;
end;

Procedure TGameForm.BeginGame(StartLevel,FinalLevel : integer);
var I : integer;
  aPlayer : TPlayer;
begin
  Level := StartLevel;
  LastLevel := FinalLevel;
  TotalLabel.Caption := IntToStr(FinalLevel);
  PlayerNumber := 0;
  AddOnly := FALSE;


  For I := 1 To Grid.RowCount DO
    If Grid.Cells[0,I] <> '' Then
      Begin
        aPlayer := TPlayer.Create;
        aPlayer.Grid := Grid;
        aPlayer.Row := I;
        aPlayer.Level := Level;
        aPlayer.Tries := 1;
        Grid.Objects[0,I] := aPlayer;
      end;

  StartPlaying;
end;


end.
