unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, Grids, Spin, ExtCtrls;

type
  TMainForm = class(TForm)
    PlayerGrid: TStringGrid;
    BitBtn1: TBitBtn;
    PlayBtn: TBitBtn;
    StartLabel: TLabel;
    StartLevel: TSpinEdit;
    Label1: TLabel;
    FinalLevel: TSpinEdit;
    SoundCheckBox: TCheckBox;
    Bevel1: TBevel;
    procedure FormCreate(Sender: TObject);
    procedure PlayBtnClick(Sender: TObject);
    procedure FinalLevelChange(Sender: TObject);
    procedure StartLevelChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Constructor Create(AOwner : TComponent); Override;
    Destructor Destroy; Override;
  end;

var
  MainForm: TMainForm;

implementation

uses Memory;

{$R *.DFM}
Constructor TMainForm.Create(AOwner : TComponent);
begin
  Inherited Create(AOwner);
end;

Destructor TMainForm.Destroy;
var
  I,J : integer;
  aPlayer : TPlayer;
begin
  For I := 1 To PlayerGrid.RowCount Do
    If PlayerGrid.Cells[0,I] <> '' Then
      begin
        aPlayer := TPlayer(PlayerGrid.Objects[0,I]);
        aPlayer.Free;
      end;
  Inherited Destroy;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  PlayerGrid.Cells[0,0] := 'Player name';
  PlayerGrid.Cells[1,0] := 'Miss';
  PlayerGrid.Cells[2,0] := 'Level';
  PlayerGrid.Cells[3,0] := 'Tries';
  PlayerGrid.Cells[4,0] := 'Score';
end;


procedure TMainForm.PlayBtnClick(Sender: TObject);
var I :integer;
    Count : Integer;
begin
  GameForm.NoSound := NOT SoundCheckBox.Checked;

  Count := 0;
  For I := 1 To PlayerGrid.RowCount Do
    if PlayerGrid.Cells[0,I] <> '' Then
       Inc(Count);

  If Count <= 0 Then
     PlayerGrid.Cells[0,1] := 'Guests';

  GameForm.NumberPlayers := 0;

  For I := 1 To PlayerGrid.RowCount DO
    if PlayerGrid.Cells[0,I] <> '' Then
      begin
        PlayerGrid.Cells[1,I] := '0';
        PlayerGrid.Cells[2,I] := IntToStr(StartLevel.Value);
        PlayerGrid.Cells[3,I] := '0';
        PlayerGrid.Cells[4,I] := '0';
        Inc(GameForm.NumberPlayers);
      end;

  GameForm.Grid := PlayerGrid;
  GameForm.PlayerNumber := 1;
  GameForm.Show;
  GameForm.BeginGame(StartLevel.Value,FinalLevel.Value);
end;

procedure TMainForm.FinalLevelChange(Sender: TObject);
begin
  if FinalLevel.Value < StartLevel.Value Then
    StartLevel.Value := FinalLevel.Value;
end;

procedure TMainForm.StartLevelChange(Sender: TObject);
begin
  If StartLevel.Value > FinalLevel.Value Then
    FinalLevel.Value := StartLevel.Value;
end;

end.
