unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, 
  complex, Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Button1: TButton;
    Edit4: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
    test: TComplex;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
     test := TComplex.Create(self);
     // put your predefined goodies here
     // Remember that the program is CASE SENSITIVE!!!!!
     test.InString := 'polar(m, a) = (m * cos(a), m * sin(a))';
     test.Execute;
     test.InString := 'root(z, n, k) = abs(z) ^ (1/n) * e ^ (j * (arg(z) + 2 * k * pi) / n)';
     test.Execute;
end;                                                           

procedure TForm1.Button1Click(Sender: TObject);
begin
     edit2.text := ''; // clear the error string
     edit3.text := ''; // clear the real result
     edit4.text := ''; // clear the imaginary result  
     test.InString := edit1.text;                
     test.Execute;
     //    Use IsError to test for an error
     //    Use a font like courier for input and the label below it
     //    That is to get the caret in the right position
     if test.IsError = true then
     begin
          edit2.text := test.ErrorString;
          //    Use ErrorPosition to locate position of error
          //    Put a caret sign under the error in instring
          Label1.Caption := format('%*s^', [test.ErrorPosition, '']);
          exit;                                             
     end;   
     // No mistakes; so show the result  
     // also remove the caret if its still visible from a previous error
     Label1.Caption := '';
     // Turn off message about using the tab key 
     Label2.Caption := '';
     // Only display results after calculation or assignment
     // IsDefinition is true after defining a function
     // IsAssignment is true after an assignment
     // IsCalcuation is true after a calculation
     if test.IsDefinition = false then
     begin
          edit3.text := 're: ' + floattostr(test.ReVal);
          edit4.text := 'im: ' + floattostr(test.ImVal);
     end
     else edit3.text := 'Ok';
end;     

procedure TForm1.FormKeyPress(Sender: TObject; var Key: Char);
begin
     if key = #13 then Button1Click(Sender);
end;

end.
 