
{*******************************************************}
{                                                       }
{       Delphi Run-time Library                         }
{       Windows 32bit API Interface Unit                }
{                                                       }
{       Copyright (c) 1996 Borland International        }
{                                                       }
{                                                       }
{*******************************************************}

{**********************************************************************}
{                                                                      }
{ Conversion of COMMCTRL.H v1.2 by Keith Patrick    Dec. 31, 1996      }
{                                  kpatrick@basil.stthom.edu           }
{                                                                      }
{ Note: this header contains all the new controls, but only the rebar  }
{       has been tested(not fully, though), so USE AT YOUR OWN RISK.   }
{       I am pretty positive that there are some type mismatches in    }
{       here, too(esp. DateTime Pick Control).  If you find any bugs,  }
{       please e-mail me with detailed info on duplicating the bug and }
{       I will try to fix it.                                          }
{**********************************************************************}

unit CommCtrl;

interface

uses Messages, Windows;

{ Interface for the Windows Property Sheet Pages }

const
  MAXPROPPAGES = 100;

  PSP_DEFAULT             = $0000;
  PSP_DLGINDIRECT         = $0001;
  PSP_USEHICON            = $0002;
  PSP_USEICONID           = $0004;
  PSP_USETITLE            = $0008;

  PSP_HASHELP             = $0020;
  PSP_USEREFPARENT        = $0040;
  PSP_USECALLBACK         = $0080;

  PSPCB_RELEASE           = 1;
  PSPCB_CREATE            = 2;

  PSH_DEFAULT             = $0000;
  PSH_PROPTITLE           = $0001;
  PSH_USEHICON            = $0002;
  PSH_USEICONID           = $0004;
  PSH_PROPSHEETPAGE       = $0008;
  PSH_MULTILINETABS       = $0010;
  PSH_WIZARD              = $0020;
  PSH_USEPSTARTPAGE       = $0040;
  PSH_NOAPPLYNOW          = $0080;
  PSH_USECALLBACK         = $0100;
  PSH_HASHELP             = $0200;
  PSH_MODELESS            = $0400;

  PSCB_INITIALIZED  = 1;

  PSN_FIRST               = -200;
  PSN_LAST                = -299;

  PSN_SETACTIVE           = PSN_FIRST - 0;
  PSN_KILLACTIVE          = PSN_FIRST - 1;
  PSN_APPLY               = PSN_FIRST - 2;
  PSN_RESET               = PSN_FIRST - 3;
  PSN_HELP                = PSN_FIRST - 5;
  PSN_WIZBACK             = PSN_FIRST - 6;
  PSN_WIZNEXT             = PSN_FIRST - 7;
  PSN_WIZFINISH           = PSN_FIRST - 8;
  PSN_QUERYCANCEL         = PSN_FIRST - 9;

  PSNRET_NOERROR              = 0;
  PSNRET_INVALID              = 1;
  PSNRET_INVALID_NOCHANGEPAGE = 2;

  PSM_SETCURSEL           = WM_USER + 101;
  PSM_REMOVEPAGE          = WM_USER + 102;
  PSM_ADDPAGE             = WM_USER + 103;
  PSM_CHANGED             = WM_USER + 104;
  PSM_RESTARTWINDOWS      = WM_USER + 105;
  PSM_REBOOTSYSTEM        = WM_USER + 106;
  PSM_CANCELTOCLOSE       = WM_USER + 107;
  PSM_QUERYSIBLINGS       = WM_USER + 108;
  PSM_UNCHANGED           = WM_USER + 109;
  PSM_APPLY               = WM_USER + 110;
  PSM_SETTITLE            = WM_USER + 111;
  PSM_SETTITLEW           = WM_USER + 120;
  PSM_SETWIZBUTTONS       = WM_USER + 112;
  PSM_PRESSBUTTON         = WM_USER + 113;
  PSM_SETCURSELID         = WM_USER + 114;
  PSM_SETFINISHTEXT       = WM_USER + 115;
  PSM_SETFINISHTEXTW      = WM_USER + 121;
  PSM_GETTABCONTROL       = WM_USER + 116;
  PSM_ISDIALOGMESSAGE     = WM_USER + 117;

  PSWIZB_BACK             = $00000001;
  PSWIZB_NEXT             = $00000002;
  PSWIZB_FINISH           = $00000004;
  PSWIZB_DISABLEDFINISH   = $00000008;

  PSBTN_BACK              = 0;
  PSBTN_NEXT              = 1;
  PSBTN_FINISH            = 2;
  PSBTN_OK                = 3;
  PSBTN_APPLYNOW          = 4;
  PSBTN_CANCEL            = 5;
  PSBTN_HELP              = 6;
  PSBTN_MAX               = 6;

  ID_PSRESTARTWINDOWS     = 2;
  ID_PSREBOOTSYSTEM       = ID_PSRESTARTWINDOWS or 1;

  WIZ_CXDLG               = 276;
  WIZ_CYDLG               = 140;

  WIZ_CXBMP               = 80;

  WIZ_BODYX               = 92;
  WIZ_BODYCX              = 184;

  PROP_SM_CXDLG           = 212;
  PROP_SM_CYDLG           = 188;

  PROP_MED_CXDLG          = 227;
  PROP_MED_CYDLG          = 215;

  PROP_LG_CXDLG           = 252;
  PROP_LG_CYDLG           = 218;

type
  HPropSheetPage = Pointer;

  PPropSheetPageA = ^TPropSheetPageA;
  PPropSheetPageW = ^TPropSheetPageW;
  PPropSheetPage = PPropSheetPageA;

  TFNPSPCallbackA = function(Wnd: HWnd; Msg: Integer;
    PPSP: PPropSheetPageA): Integer stdcall;
  TFNPSPCallbackW = function(Wnd: HWnd; Msg: Integer;
    PPSP: PPropSheetPageW): Integer stdcall;
  TFNPSPCallback = TFNPSPCallbackA;

  TPropSheetPageA = record
    dwSize: Longint;
    dwFlags: Longint;
    hInstance: THandle;
    case Integer of
      0: (
        pszTemplate: PAnsiChar);
      1: (
        pResource: Pointer;
        case Integer of
          0: (
            hIcon: THandle);
          1: (
            pszIcon: PAnsiChar;
            pszTitle: PAnsiChar;
            pfnDlgProc: Pointer;
            lParam: Longint;
            pfnCallback: TFNPSPCallbackA;
            pcRefParent: PInteger));
  end;
  TPropSheetPageW = record
    dwSize: Longint;
    dwFlags: Longint;
    hInstance: THandle;
    case Integer of
      0: (
        pszTemplate: PWideChar);
      1: (
        pResource: Pointer;
        case Integer of
          0: (
            hIcon: THandle);
          1: (
            pszIcon: PWideChar;
            pszTitle: PWideChar;
            pfnDlgProc: Pointer;
            lParam: Longint;
            pfnCallback: TFNPSPCallbackW;
            pcRefParent: PInteger));
  end;
  TPropSheetPage = TPropSheetPageA;

  TFNPropSheetCallback = function(Wnd: HWnd; Msg: Integer;
    LParam: Integer): Integer stdcall;

  PPropSheetHeaderA = ^TPropSheetHeaderA;
  PPropSheetHeaderW = ^TPropSheetHeaderW;
  PPropSheetHeader = PPropSheetHeaderA;
  TPropSheetHeaderA = record
    dwSize: Longint;
    dwFlags: Longint;
    hwndParent: HWnd;
    hInstance: THandle;
    case Integer of
      0: (
        hIcon: THandle);
      1: (
        pszIcon: PAnsiChar;
        pszCaption: PAnsiChar;
        nPages: Integer;
        case Integer of
          0: (
            nStartPage: Integer);
          1: (
            pStartPage: PAnsiChar;
            case Integer of
              0: (
                ppsp: PPropSheetPageA);
              1: (
                phpage: Pointer;
                pfnCallback: TFNPropSheetCallback)));
  end;
  TPropSheetHeaderW = record
    dwSize: Longint;
    dwFlags: Longint;
    hwndParent: HWnd;
    hInstance: THandle;
    case Integer of
      0: (
        hIcon: THandle);
      1: (
        pszIcon: PWideChar;
        pszCaption: PWideChar;
        nPages: Integer;
        case Integer of
          0: (
            nStartPage: Integer);
          1: (
            pStartPage: PWideChar;
            case Integer of
              0: (
                ppsp: PPropSheetPageW);
              1: (
                phpage: Pointer;
                pfnCallback: TFNPropSheetCallback)));
  end;
  TPropSheetHeader = TPropSheetHeaderA;

  TFNAddPropSheetPage = function(hPSP: HPropSheetPage;
    lParam: Longint): BOOL stdcall;

function CreatePropertySheetPageA(var PSP: TPropSheetPageA): HPropSheetPage; stdcall;
function CreatePropertySheetPageW(var PSP: TPropSheetPageW): HPropSheetPage; stdcall;
function CreatePropertySheetPage(var PSP: TPropSheetPage): HPropSheetPage; stdcall;
function DestroyPropertySheetPage(hPSP: HPropSheetPage): BOOL; stdcall;
function PropertySheetA(var PSH: TPropSheetHeaderA): Integer; stdcall;
function PropertySheetW(var PSH: TPropSheetHeaderW): Integer; stdcall;
function PropertySheet(var PSH: TPropSheetHeader): Integer; stdcall;

procedure InitCommonControls; stdcall;

type
    lpInitCommonControlsEx = ^tagInitCommonControlsEx;
    tagINITCOMMONCONTROLSEX = record
       dwSize: DWORD;          // size of this structure
       dwICC : DWORD;          // flags indicating which classes to be initialized
    end;

const
  IMAGE_BITMAP = 0;

  ICC_LISTVIEW_CLASSES = $00000001;
  ICC_TREEVIEW_CLASSES = $00000002;
  ICC_BAR_CLASSES      = $00000004;
  ICC_TAB_CLASSES      = $00000008;
  ICC_UPDOWN_CLASS     = $00000010;
  ICC_PROGRESS_CLASS   = $00000020;
  ICC_HOTKEY_CLASS     = $00000040;
  ICC_ANIMATE_CLASS    = $00000080;
  ICC_WIN95_CLASSES    = $000000FF;
  ICC_DATE_CLASSES     = $00000100;
  ICC_USEREX_CLASSES    = $00000200;
  ICC_COOL_CLASSES     = $00000400;

function InitCommonControlsEx(InitStuff: lpINITCOMMONCONTROLSEX): Boolean; stdcall;

const
  ODT_HEADER              = 100;
  ODT_TAB                 = 101;
  ODT_LISTVIEW            = 102;


{ ====== Ranges for control message IDs ======================= }

const
  LVM_FIRST               = $1000;      { ListView messages }
  TV_FIRST                = $1100;      { TreeView messages }
  HDM_FIRST               = $1200;      { Header messages }



{ ====== WM_NOTIFY codes (NMHDR.code values) ================== }

const
  NM_FIRST                 = 0-  0;       { generic to all controls }
  NM_LAST                  = 0- 99;
  LVN_FIRST                = 0-100;       { listview }
  LVN_LAST                 = 0-199;
  HDN_FIRST                = 0-300;       { header }
  HDN_LAST                 = 0-399;

  TVN_FIRST                = 0-400;       { treeview }
  TVN_LAST                 = 0-499;

  TTN_FIRST                = 0-520;       { tooltips }
  TTN_LAST                 = 0-549;

  TCN_FIRST                = 0-550;       { tab control }
  TCN_LAST                 = 0-580;

{ Shell reserved           (0-580) -  (0-589)

  CDN_FIRST                = 0-601;       { common dialog (new) }
  CDN_LAST                 = 0-699;

  TBN_FIRST                = 0-700;       { toolbar }
  TBN_LAST                 = 0-720;

  UDN_FIRST                = 0-721;        { updown }
  UDN_LAST                 = 0-740;

  MCN_FIRST                = 0-750;       { monthcal }
  MCN_LAST                 = 0-759;

  DTN_FIRST                = 0-760;       { datetimepick}
  DTN_LAST                 = 0-799;

  CBEN_FIRST               = 0-800;       { combo box ex }
  CBEN_LAST                = 0-830;

  RBN_FIRST                = 0-831;       { rebar }
  RBN_LAST                 = 0-859;

  MSGF_COMMCTRL_BEGINDRAG     = $4200;
  MSGF_COMMCTRL_SIZEHEADER    = $4201;
  MSGF_COMMCTRL_DRAGSELECT    = $4202;
  MSGF_COMMCTRL_TOOLBARCUST   = $4203;


{ ====== Generic WM_NOTIFY notification codes ================= }

const
  NM_OUTOFMEMORY           = NM_FIRST-1;
  NM_CLICK                 = NM_FIRST-2;
  NM_DBLCLK                = NM_FIRST-3;
  NM_RETURN                = NM_FIRST-4;
  NM_RCLICK                = NM_FIRST-5;
  NM_RDBLCLK               = NM_FIRST-6;
  NM_SETFOCUS              = NM_FIRST-7;
  NM_KILLFOCUS             = NM_FIRST-8;
  NM_STARTWAIT             = NM_FIRST-9;
  NM_ENDWAIT               = NM_FIRST-10;
  NM_BTNCLK                = NM_FIRST-10;
  NM_CUSTOMDRAW            = NM_FIRST-12;
  NM_HOVER                 = NM_FIRST-13;


{ ================CUSTOM DRAW ================================= }

// custom draw return flags
// values under $00010000 are reserved for global draw values above that are
// for specific controls
const
    CDRF_DODEFAULT            = $00000000;
    CDRF_NEWFONT              = $00000002;
    CDRF_SKIPDEFAULT          = $00000004;

    CDRF_NOTIFYPOSTPAINT      = $00000010;
    CDRF_NOTIFYITEMDRAW       = $00000020;
    CDRF_NOTIFYPOSTERASE      = $00000040;
    CDRF_NOTIFYITEMERASE      = $00000080;

// drawstage flags
// values under $00010000 are reserved for global draw values
// that are for specific controls
    CDDS_PREPAINT             = $00000001;
    CDDS_POSTPAINT            = $00000002;
    CDDS_PREERASE             = $00000003;
    CDDS_POSTERASE            = $00000004;
// the $000020000 bit means that it's individual item specific
    CDDS_ITEM                 = $00010000;
    CDDS_ITEMPREPAINT         = (CDDS_ITEM OR CDDS_PREPAINT);
    CDDS_ITEMPOSTPAINT        = (CDDS_ITEM OR CDDS_POSTPAINT);
    CDDS_ITEMPREERASE         = (CDDS_ITEM OR CDDS_PREERASE);
    CDDS_ITEMPOSTERASE        = (CDDS_ITEM OR CDDS_POSTERASE);


// itemState flags
    CDIS_SELECTED             = $0001;
    CDIS_GRAYED               = $0002;
    CDIS_DISABLED             = $0004;
    CDIS_CHECKED              = $0008;
    CDIS_FOCUS                = $0010;
    CDIS_DEFAULT              = $0020;
    CDIS_HOT                  = $0040;

type
    PNMCustomDraw = ^TNMCustomDrawInfo;
    TNMCUSTOMDRAWINFO = record
        hdr: TNMHDR;
        dwDrawStage: DWORD;
        hdc: HDC;
        rc: TRect;
        dwItemSpec: DWORD; //this is control specific, but it's how to specify an item.  valid only with CDDS_ITEM bit set
	uItemState: UINT;
        lItemParam: LPARAM;
    end;
    TNMCustomDraw = TNMCustomDrawInfo;

{ for tooltips }
type
    lpNMTTCustomDraw = ^tagNMTTCustomDraw;
    tagNMTTCUSTOMDRAW = record
        nmcd: TNMCustomDraw;
        uDrawFlags: UINT; 
    end;
    NMTTCustomDraw = tagNMTTCustomDraw;


{ ====== IMAGE LIST =========================================== }


const
  CLR_NONE                = $FFFFFFFF;
  CLR_DEFAULT             = $FF000000;

type
  HImageList = THandle;

  ImageListDrawParams = record
     cbSize: DWord;
     himl: HimageList;
     i: Integer;
     hdcDst: HDC;
     x,y,cx,cy,xBitmap,yBitmap: Integer;
     rgbBk: ColorRef;
     rgbFg: ColorRef;
     fStyle: UInt;
     dwRop: DWord;
  end;

const
  ILC_MASK                = $0001;
  ILC_COLOR               = $00FE;
  ILC_COLORDDB            = $00FE;
  ILC_COLOR4              = $0004;
  ILC_COLOR8              = $0008;
  ILC_COLOR16             = $0010;
  ILC_COLOR24             = $0018;
  ILC_COLOR32             = $0020;
  ILC_PALETTE             = $0800;

function ImageList_Create(CX, CY: Integer; Flags: UINT;
  Initial, Grow: Integer): HImageList; stdcall;
function ImageList_Destroy(ImageList: HImageList): Bool; stdcall;
function ImageList_GetImageCount(ImageList: HImageList): Integer; stdcall;
function ImageList_Add(ImageList: HImageList; Image, Mask: HBitmap): Integer; stdcall;
function ImageList_ReplaceIcon(ImageList: HImageList; Index: Integer;
  Icon: HIcon): Integer; stdcall;
function ImageList_SetBkColor(ImageList: HImageList; ClrBk: TColorRef): TColorRef; stdcall;
function ImageList_GetBkColor(ImageList: HImageList): TColorRef; stdcall;
function ImageList_SetOverlayImage(ImageList: HImageList; Image: Integer;
  Overlay: Integer): Bool; stdcall;

function ImageList_AddIcon(ImageList: HImageList; Icon: HIcon): Integer;

const
  ILD_NORMAL              = $0000;
  ILD_TRANSPARENT         = $0001;
  ILD_MASK                = $0010;
  ILD_IMAGE               = $0020;
  ILD_ROP                 = $0040;  
  ILD_BLEND               = $000E;
  ILD_BLEND25             = $0002;
  ILD_BLEND50             = $0004;
  ILD_OVERLAYMASK         = $0F00;

function IndexToOverlayMask(Index: Integer): Integer;

const
  ILD_SELECTED            = ILD_BLEND50;
  ILD_FOCUS               = ILD_BLEND25;
  CLR_HILIGHT             = CLR_DEFAULT;

function ImageList_Draw(ImageList: HImageList; Index: Integer;
  Dest: HDC; X, Y: Integer; Style: UINT): Bool; stdcall;

function ImageList_Replace(ImageList: HImageList; Index: Integer;
  Image, Mask: HBitmap): Bool; stdcall;
function ImageList_AddMasked(ImageList: HImageList; Image: HBitmap;
  Mask: TColorRef): Integer; stdcall;
function ImageList_DrawEx(ImageList: HImageList; Index: Integer;
  Dest: HDC; X, Y, DX, DY: Integer; Bk, Fg: TColorRef; Style: Cardinal): Bool; stdcall;
function ImageList_DrawIndirect(pimldp: IMAGELISTDRAWPARAMS): Bool; stdcall;
function ImageList_Remove(ImageList: HImageList; Index: Integer): Bool; stdcall;
function ImageList_GetIcon(ImageList: HImageList; Index: Integer;
  Flags: Cardinal): HIcon; stdcall;
function ImageList_LoadImage(Instance: THandle; Bmp: LPCSTR; CX, Grow: Integer;
  Mask: TColorRef; pType, Flags: Cardinal): HImageList; stdcall;
function ImageList_Copy(himlDst: HImageList; iDst: Integer; himlSrc: HImageList; ISrc: Integer; uFlags: UINT): Bool; stdcall;
function ImageList_BeginDrag(ImageList: HImageList; Track: Integer;
  XHotSpot, YHotSpot: Integer): Bool; stdcall;
function ImageList_EndDrag: Bool; stdcall;
function ImageList_DragEnter(LockWnd: HWnd; X, Y: Integer): Bool; stdcall;
function ImageList_DragLeave(LockWnd: HWnd): Bool; stdcall;
function ImageList_DragMove(X, Y: Integer): Bool; stdcall;
function ImageList_SetDragCursorImage(ImageList: HImageList; Drag: Integer;
  XHotSpot, YHotSpot: Integer): Bool; stdcall;
function ImageList_DragShowNolock(Show: Bool): Bool; stdcall;
function ImageList_GetDragImage(Point, HotSpot: PPoint): HImageList; stdcall;

const
  ILCF_MOVE   = 00000000;
  ILCF_SWAP   = 00000001;

{ macros }
procedure ImageList_RemoveAll(ImageList: HImageList);
function ImageList_ExtractIcon(Instance: THandle; ImageList: HImageList;
  Image: Integer): HIcon;
function ImageList_LoadBitmap(Instance: THandle; Bmp: PChar;
  CX, Grow: Integer; MasK: TColorRef): HImageList;

type
  PImageInfo = ^TImageInfo;
  TImageInfo = packed record
    hbmImage: HBitmap;
    hbmMask: HBitmap;
    Unused1: Integer;
    Unused2: Integer;
    rcImage: TRect;
  end;

function ImageList_GetIconSize(ImageList: HImageList; var CX, CY: Integer): Bool; stdcall;
function ImageList_SetIconSize(ImageList: HImageList; CX, CY: Integer): Bool; stdcall;
function ImageList_GetImageInfo(ImageList: HImageList; Index: Integer;
  var ImageInfo: TImageInfo): Bool; stdcall;
function ImageList_Merge(ImageList1: HImageList; Index1: Integer;
  ImageList2: HImageList; Index2: Integer; DX, DY: Integer): Bool; stdcall;


{ ====== HEADER CONTROL ========================== }

const
  WC_HEADER = 'SysHeader32';

  HDS_HORZ                = $00000000;
  HDS_BUTTONS             = $00000002;
  HDS_HOTTRACK            = $00000004;
  HDS_HIDDEN              = $00000008;
  HDS_DRAGDROP            = $00000040;
  HDS_FULLDRAG            = $00000080;

type
  PHDItemA = ^THDItemA;
  PHDItemW = ^THDItemW;
  PHDItem = PHDItemA;
  THDItemA = packed record
    Mask: Cardinal;
    cxy: Integer;
    pszText: PAnsiChar;
    hbm: HBITMAP;
    cchTextMax: Integer;
    fmt: Integer;
    lParam: LPARAM;
    iImage: Integer;      // index of bitmap in ImageList
    iOrder: Integer;      // where to draw this item
  end;
  THDItemW = packed record
    Mask: Cardinal;
    cxy: Integer;
    pszText: PWideChar;
    hbm: HBITMAP;
    cchTextMax: Integer;
    fmt: Integer;
    lParam: LPARAM;
    iImage: Integer;       // index of bitmpap in ImageList
    iOrder: Integer;       // where to draw this item
  end;
  THDItem = THDItemA;

  HD_ITEMA                = THDITEMA;
  HD_ITEMW                = THDITEMW;
  HD_ITEM                 = THDITEM;

const
  HDI_WIDTH               = $0001;
  HDI_HEIGHT              = HDI_WIDTH;
  HDI_TEXT                = $0002;
  HDI_FORMAT              = $0004;
  HDI_LPARAM              = $0008;
  HDI_BITMAP              = $0010;
  HDI_IMAGE               = $0020;
  HDI_DI_SETITEM          = $0040;
  HID_ORDER               = $0080;

  HDF_LEFT                = 0;
  HDF_RIGHT               = 1;
  HDF_CENTER              = 2;
  HDF_JUSTIFYMASK         = $0003;
  HDF_RTLREADING          = 4;

  HDF_OWNERDRAW           = $8000;
  HDF_STRING              = $4000;
  HDF_BITMAP              = $2000;
  HDF_BITMAP_ON_RIGHT     = $1000;

  HDF_IMAGE               = $0800;

  HDM_GETITEMCOUNT        = HDM_FIRST + 0;

function Header_GetItemCount(Header: HWnd): Integer;

const
  HDM_INSERTITEMW          = HDM_FIRST + 10;
  HDM_INSERTITEMA          = HDM_FIRST + 1;
  HDM_INSERTITEM           = HDM_INSERTITEMA;

function Header_InsertItem(Header: HWnd; Index: Integer;
  const Item: THDItem): Integer;

const
  HDM_DELETEITEM          = HDM_FIRST + 2;

function Header_DeleteItem(Header: HWnd; Index: Integer): Bool;

const
  HDM_GETITEMW             = HDM_FIRST + 11;
  HDM_GETITEMA             = HDM_FIRST + 3;
  HDM_GETITEM              = HDM_GETITEMA;

function Header_GetItem(Header: HWnd; Index: Integer;
  var Item: THDItem): Bool;

const
  HDM_SETITEMA            = HDM_FIRST + 4;
  HDM_SETITEMW            = HDM_FIRST + 12;
  HDM_SETITEM             = HDM_SETITEMA;

function Header_SetItem(Header: HWnd; Index: Integer; const Item: THDItem): Bool;

type
  PHDLayout = ^THDLayout;
  THDLayout = packed record
    Rect: ^TRect;
    WindowPos: PWindowPos;
  end;

const
  HDM_LAYOUT              = HDM_FIRST + 5;

function Header_Layout(Header: HWnd; Layout: PHDLayout): Bool;

const
  HHT_NOWHERE             = $0001;
  HHT_ONHEADER            = $0002;
  HHT_ONDIVIDER           = $0004;
  HHT_ONDIVOPEN           = $0008;
  HHT_ABOVE               = $0100;
  HHT_BELOW               = $0200;
  HHT_TORIGHT             = $0400;
  HHT_TOLEFT              = $0800;

type
  PHDHitTestInfo = ^THDHitTestInfo;
  THDHitTestInfo = packed record
    Point: TPoint;
    Flags: Cardinal;
    Item: Integer;
  end;
  HD_HITTESTINFO          = THDHITTESTINFO;

const
   HDM_HITTEST             = HDM_FIRST + 6;
   HDM_GETITEMRECT         = HDM_FIRST + 7;
   HDM_SETIMAGELIST        = HDM_FIRST + 8;
   HDM_GETIMAGELIST        = HDM_FIRST + 9;
   HDM_ORDERTOINDEX        = HDM_FIRST + 15;
   HDM_CREATEDRAGIMAGE     = HDM_FIRST + 16;
   HDM_GETORDERARRAY       = HDM_FIRST + 17;
   HDM_SETORDERARRAY       = HDM_FIRST + 18;

   function Header_GetItemRect(Header: HWnd; Item: Integer; Prc: lparam): Boolean;
   function Header_SetImageList(Header: HWnd; ImageList: HImagelist): HImageList;
   function Header_GetImageList(Header: HWnd): HImageList;
   function Header_OrderToIndex(Header: HWnd; I: Integer): Integer;
   function Header_CreateDragImage(Header: HWnd; I: Integer): HImageList;
   function Header_GetOrderArray(Header: HWnd; Count: WParam; lp: lparam): Bool;
   function Header_SetOrderArray(Header: HWnd; Count: WParam; lp: lparam): Bool;

   // lparam = int array of size HDM_GETITEMCOUNT
   //  e.g.  (2, 0, 1) says the index 2 item should be shown in the 0ths
   //  position, 0 should be in the 1st position, 1 should be in the 2nd position
const
   HDM_SETHOTDIVIDER       = HDM_FIRST + 19;
   function Header_SetHotDivider(Header: HWnd; Position: WParam; Divider: LParam): integer;
   // convenience message for external dragdrop
   // wParam = Bool specifying whether the lParam is a dwPos of the cursor
   // position or the index of which divider to hotlight
   // lParam = depends on wParam (-1 and wParm = False turns off hotlight)

const
  HDN_ITEMCHANGINGA        = HDN_FIRST-0;
  HDN_ITEMCHANGEDA         = HDN_FIRST-1;
  HDN_ITEMCLICKA           = HDN_FIRST-2;
  HDN_ITEMDBLCLICKA        = HDN_FIRST-3;
  HDN_DIVIDERDBLCLICKA     = HDN_FIRST-5;
  HDN_BEGINTRACKA          = HDN_FIRST-6;
  HDN_ENDTRACKA            = HDN_FIRST-7;
  HDN_TRACKA               = HDN_FIRST-8;

  HDN_ITEMCHANGINGW        = HDN_FIRST-20;
  HDN_ITEMCHANGEDW         = HDN_FIRST-21;
  HDN_ITEMCLICKW           = HDN_FIRST-22;
  HDN_ITEMDBLCLICKW        = HDN_FIRST-23;
  HDN_DIVIDERDBLCLICKW     = HDN_FIRST-25;
  HDN_BEGINTRACKW          = HDN_FIRST-26;
  HDN_ENDTRACKW            = HDN_FIRST-27;
  HDN_TRACKW               = HDN_FIRST-28;

  HDN_GETDISPINFOA         = HDN_FIRST-9;
  HDN_GETDISPINFOW         = HDN_FIRST-29;
  HDN_BEGINDRAG            = HDN_FIRST-10;
  HDN_ENDDRAG              = HDN_FIRST-11;

  HDN_ITEMCHANGING        = HDN_ITEMCHANGINGA;
  HDN_ITEMCHANGED         = HDN_ITEMCHANGEDA;
  HDN_ITEMCLICK           = HDN_ITEMCLICKA;
  HDN_ITEMDBLCLICK        = HDN_ITEMDBLCLICKA;
  HDN_DIVIDERDBLCLICK     = HDN_DIVIDERDBLCLICKA;
  HDN_BEGINTRACK          = HDN_BEGINTRACKA;
  HDN_ENDTRACK            = HDN_ENDTRACKA;
  HDN_TRACK               = HDN_TRACKA;
  HND_GETDISPINFO         = HDN_GETDISPINFOW;

type
  PHDNotifyA = ^THDNotifyA;
  PHDNotifyW = ^THDNotifyW;
  PHDNotify = PHDNotifyA;
  THDNotifyA = packed record
    Hdr: TNMHDR;
    Item: Integer;
    Button: Integer;
    PItem: PHDItemA;
  end;
  THDNotifyW = packed record
    Hdr: TNMHDR;
    Item: Integer;
    Button: Integer;
    PItem: PHDItemW;
  end;
  THDNotify = THDNotifyA;

type
  NMHEADER                 = THDNotifyW;
  LPNMHEADER               = PHDNotifyW;

  HD_NOTIFYA               = THDNotifyA;
  HD_NOTIFYW               = THDNotifyW;
  HD_NOTIFY                = THDNotify;

{ ====== TOOLBAR CONTROL =================== }

const
  TOOLBARCLASSNAME = 'ToolbarWindow32';

type
  PTBButton = ^TTBButton;
  TTBButton = packed record
    iBitmap: Integer;
    idCommand: Integer;
    fsState: Byte;
    fsStyle: Byte;
    bReserved: array[1..2] of Byte;
    dwData: Longint;
    iString: Integer;
  end;

  PColorMap = ^TColorMap;
  TColorMap = packed record
    cFrom: TColorRef;
    cTo: TColorRef;
  end;

function CreateToolBarEx(Wnd: HWnd; ws: Longint; ID: UINT;
  Bitmaps: Integer; BMInst: THandle; BMID: Cardinal; Buttons: PTBButton;
  NumButtons: Integer; dxButton, dyButton: Integer;
  dxBitmap, dyBitmap: Integer; StructSize: UINT): HWnd; stdcall;

function CreateMappedBitmap(Instance: THandle; Bitmap: Integer;
  Flags: UINT; ColorMap: PColorMap; NumMaps: Integer): HBitmap; stdcall;

const

  CMB_MASKED              = $02;

  TBSTATE_CHECKED         = $01;
  TBSTATE_PRESSED         = $02;
  TBSTATE_ENABLED         = $04;
  TBSTATE_HIDDEN          = $08;
  TBSTATE_INDETERMINATE   = $10;
  TBSTATE_WRAP            = $20;
  TBSTATE_ELLIPSES        = $40;

  TBSTYLE_BUTTON          = $00;
  TBSTYLE_SEP             = $01;
  TBSTYLE_CHECK           = $02;
  TBSTYLE_GROUP           = $04;
  TBSTYLE_CHECKGROUP      = TBSTYLE_GROUP or TBSTYLE_CHECK;
  TBSTYLE_DROPDOWN        = $08;

  TBSTYLE_TOOLTIPS        = $0100;
  TBSTYLE_WRAPABLE        = $0200;
  TBSTYLE_ALTDRAG         = $0400;
  TBSTYLE_FLAT            = $0800;
  TBSTYLE_LIST            = $1000;
  TBSTYLE_CUSTOMERASE     = $2000;

  TB_ENABLEBUTTON         = WM_USER + 1;
  TB_CHECKBUTTON          = WM_USER + 2;
  TB_PRESSBUTTON          = WM_USER + 3;
  TB_HIDEBUTTON           = WM_USER + 4;
  TB_INDETERMINATE        = WM_USER + 5;
  TB_ISBUTTONENABLED      = WM_USER + 9;
  TB_ISBUTTONCHECKED      = WM_USER + 10;
  TB_ISBUTTONPRESSED      = WM_USER + 11;
  TB_ISBUTTONHIDDEN       = WM_USER + 12;
  TB_ISBUTTONINDETERMINATE = WM_USER + 13;
  TB_SETSTATE             = WM_USER + 17;
  TB_GETSTATE             = WM_USER + 18;
  TB_ADDBITMAP            = WM_USER + 19;

type
  PTBAddBitmap = ^TTBAddBitmap;
  TTBAddBitmap = packed record
    hInst: THandle;
    nID: UINT;
  end;

const
  HINST_COMMCTRL = THandle(-1);

  IDB_STD_SMALL_COLOR     = 0;
  IDB_STD_LARGE_COLOR     = 1;
  IDB_VIEW_SMALL_COLOR    = 4;
  IDB_VIEW_LARGE_COLOR    = 5;
  IDB_HIST_SMALL_COLOR    = 8;
  IDB_HIST_LARGE_COLOR    = 9;

{ icon indexes for standard bitmap }
  STD_CUT                 = 0;
  STD_COPY                = 1;
  STD_PASTE               = 2;
  STD_UNDO                = 3;
  STD_REDOW               = 4;
  STD_DELETE              = 5;
  STD_FILENEW             = 6;
  STD_FILEOPEN            = 7;
  STD_FILESAVE            = 8;
  STD_PRINTPRE            = 9;
  STD_PROPERTIES          = 10;
  STD_HELP                = 11;
  STD_FIND                = 12;
  STD_REPLACE             = 13;
  STD_PRINT               = 14;

{ icon indexes for standard view bitmap }

  VIEW_LARGEICONS         = 0;
  VIEW_SMALLICONS         = 1;
  VIEW_LIST               = 2;
  VIEW_DETAILS            = 3;
  VIEW_SORTNAME           = 4;
  VIEW_SORTSIZE           = 5;
  VIEW_SORTDATE           = 6;
  VIEW_SORTTYPE           = 7;
  VIEW_PARENTFOLDER       = 8;
  VIEW_NETCONNECT         = 9;
  VIEW_NETDISCONNECT      = 10;
  VIEW_NEWFOLDER          = 11;

  HIST_BACK               = 0;
  HIST_FORWARD            = 1;
  HIST_FAVORITES          = 2;
  HIST_ADDTOFAVORITES     = 3;
  HIST_VIEWTREE           = 4;

  TB_ADDBUTTONS           = WM_USER + 20;
  TB_INSERTBUTTON         = WM_USER + 21;
  TB_DELETEBUTTON         = WM_USER + 22;
  TB_GETBUTTON            = WM_USER + 23;
  TB_BUTTONCOUNT          = WM_USER + 24;
  TB_COMMANDTOINDEX       = WM_USER + 25;

type
  PTBSaveParamsA = ^TTBSaveParamsA;
  PTBSaveParamsW = ^TTBSaveParamsW;
  PTBSaveParams = PTBSaveParamsA;
  TTBSaveParamsA = packed record
    hkr: THandle;
    pszSubKey: PAnsiChar;
    pszValueName: PAnsiChar;
  end;
  TTBSaveParamsW = packed record
    hkr: THandle;
    pszSubKey: PWideChar;
    pszValueName: PWideChar;
  end;
  TTBSaveParams = TTBSaveParamsA;

const
  TB_SAVERESTOREA          = WM_USER + 26;
  TB_SAVERESTOREW          = WM_USER + 76;   // MAYBE WM_USER + 47
  TB_CUSTOMIZE             = WM_USER + 27;
  TB_ADDSTRINGA            = WM_USER + 28;
  TB_ADDSTRINGW            = WM_USER + 77;   // maybe WM_USER + 48
  TB_GETITEMRECT           = WM_USER + 29;
  TB_BUTTONSTRUCTSIZE      = WM_USER + 30;
  TB_SETBUTTONSIZE         = WM_USER + 31;
  TB_SETBITMAPSIZE         = WM_USER + 32;
  TB_AUTOSIZE              = WM_USER + 33;
  TB_GETTOOLTIPS           = WM_USER + 35;
  TB_SETTOOLTIPS           = WM_USER + 36;
  TB_SETPARENT             = WM_USER + 37;
  TB_SETROWS               = WM_USER + 39;
  TB_GETROWS               = WM_USER + 40;
  TB_SETCMDID              = WM_USER + 42;
  TB_CHANGEBITMAP          = WM_USER + 43;
  TB_GETBITMAP             = WM_USER + 44;
  TB_GETBUTTONTEXTA        = WM_USER + 45;
  TB_GETBUTTONTEXTW        = WM_USER + 75;  // maybe WM_USER + 46
  TB_REPLACEBITMAP         = WM_USER + 46;
  TB_SETINDENT             = WM_USER + 47;
  TB_SETIMAGELIST          = WM_USER + 48;
  TB_GETIMAGELIST          = WM_USER + 49;
  TB_LOADIMAGES            = WM_USER + 50;
  TB_GETRECT               = WM_USER + 51; //wParam is the cmd instead of index
  TB_SETHOTIMAGELIST       = WM_USER + 52;
  TB_GETHOTIMAGELIST       = WM_USER + 53;
  TB_SETDISABLEDIMAGELIST  = WM_USER + 54;
  TB_GETDISABLEDIMAGELIST  = WM_USER + 55;
  TB_SETSTYLE              = WM_USER + 56;
  TB_GETSTYLE              = WM_USER + 57;
  TB_GETBUTTONSIZE         = WM_USER + 58;
  TB_SETBUTTONWIDTH        = WM_USER + 59;
  TB_SETMAXTEXTROWS        = WM_USER + 60;
  TB_GETTEXTROWS           = WM_USER + 61;

  TBN_GETBUTTONINFOA       = TBN_FIRST-0;

  TBN_GETBUTTONINFOW       = TBN_FIRST-20;

  TB_SAVERESTORE          = TB_SAVERESTOREA;
  TB_ADDSTRING            = TB_ADDSTRINGA;
  TB_GETBUTTONTEXT        = TB_GETBUTTONTEXTA;
  TBN_GETBUTTONINFO       = TBN_GETBUTTONINFOA;

  TB_SETBUTTONTYPE        = WM_USER + 34;

  TB_GETBITMAPFLAGS       = WM_USER + 41;

  TBN_BEGINDRAG           = TBN_FIRST-1;
  TBN_ENDDRAG             = TBN_FIRST-2;
  TBN_BEGINADJUST         = TBN_FIRST-3;
  TBN_ENDADJUST           = TBN_FIRST-4;
  TBN_RESET               = TBN_FIRST-5;
  TBN_QUERYINSERT         = TBN_FIRST-6;
  TBN_QUERYDELETE         = TBN_FIRST-7;
  TBN_TOOLBARCHANGE       = TBN_FIRST-8;
  TBN_CUSTHELP            = TBN_FIRST-9;
  TBN_DROPDOWN            = TBN_FIRST-10;
  TBN_CLOSEUP             = TBN_FIRST-11;

  TBBF_LARGE              = $0001;

type
  PTBNotifyA = ^TTBNotifyA;
  PTBNotifyW = ^TTBNotifyW;
  PTBNotify = PTBNotifyA;
  TTBNotifyA = packed record
    hdr: TNMHdr;
    tbButton: TTBButton;
    cchText: Integer;
    pszText: PAnsiChar;
  end;
  TTBNotifyW = packed record
    hdr: TNMHdr;
    tbButton: TTBButton;
    cchText: Integer;
    pszText: PWideChar;
  end;
  TTBNotify   = TTBNotifyA;
  NMToolbarA  = TTBNotifyA;
  NMToolbarW  = TTBNotifyW;
  NMToolbar   = TTBNotify;
  PNMToolbar  = PTBNotify;
  PNMToolbarA = PTBNotifyA;
  PNMToolbarW = PTBNotifyW;

{ ====== REBAR CONTROL ============================= }
const
  REBARCLASSNAME = 'ReBarWindow32';

const
  RBIM_IMAGELIST              = $00000001;

  RBS_TOOLTIPS                = $00000100;
  RBS_VARHEIGHT               = $00000200;
  RBS_BANDBORDERS             = $00000400;
  RBS_FIXEDORDER              = $00000800;

type
    PRebarInfo = ^TRebarInfo;
    TRebarInfo = packed record
       cbSize: UINT;
       fMask: UINT;
       himl: HImageList;
    end;
    RebarInfo = TRebarInfo;

const
     RBBS_BREAK               = $00000001; // break to new line
     RBBS_FIXEDSIZE           = $00000002; // band can't be sized
     RBBS_CHILDEDGE           = $00000004; // edge around top & bottom of child window
     RBBS_HIDDEN              = $00000008; // don't show
     RBBS_NOVERT              = $00000010; // don't show when vertical
     RBBS_FIXEDBMP            = $00000020; // bitmap doesn"t move during band resize

     RBBIM_STYLE              = $00000001;
     RBBIM_COLORS             = $00000002;
     RBBIM_TEXT               = $00000004;
     RBBIM_IMAGE              = $00000008;
     RBBIM_CHILD              = $00000010;
     RBBIM_CHILDSIZE          = $00000020;
     RBBIM_SIZE               = $00000040;
     RBBIM_BACKGROUND         = $00000080;
     RBBIM_ID                 = $00000100;

type
    PRebarBandInfoA = ^TRebarBandInfoA;
    PRebarBandInfoW = ^TRebarBandInfoW;
    TRebarBandInfoA = packed record
       cbSize: UINT;
       fMask: UINT;
       fStyle: UINT;
       clrFore: TColorRef;
       clrBack: TColorRef;
       pText: PAnsiChar;
       cch: UINT;
       iImage: Integer;
       hwndChild: HWnd;
       cxMinChild: UINT;
       cyMinChild: UINT;
       cx: UINT;
       hbmBack: HBitmap;
       wID: UINT;
    end;
    TRebarBandInfoW = packed record
       cbSize: UINT;
       fMask: UINT;
       clrFore: TColorRef;
       clrBack: TColorRef;
       pText: PAnsiChar;
       cch: UINT;
       iImage: Integer;
       hwndChild: HWnd;
       cxMinChild: UINT;
       cyMinChild: UINT;
       cx: UINT;
       hbmBack: HBitmap;
       wID: UINT;
    end;
    TRebarBandInfo = TRebarBandInfoA;
    PRebarBandInfo = PRebarBandInfoA;
    PCRebarBandInfo = PRebarBandInfoA;

const
   RB_INSERTBANDA              = WM_USER +  1;
   RB_DELETEBAND               = WM_USER +  2;
   RB_GETBARINFO               = WM_USER +  3;
   RB_SETBARINFO               = WM_USER +  4;
   RB_GETBANDINFO              = WM_USER +  5;
   RB_SETBANDINFOA             = WM_USER +  6;
   RB_SETPARENT                = WM_USER +  7;
   RB_INSERTBANDW              = WM_USER +  10;
   RB_SETBANDINFOW             = WM_USER +  11;
   RB_GETBANDCOUNT             = WM_USER +  12;
   RB_GETROWCOUNT              = WM_USER +  13;
   RB_GETROWHEIGHT             = WM_USER +  14;

   RB_INSERTBAND               = RB_INSERTBANDA;
   RB_SETBANDINFO              = RB_SETBANDINFOA;

   RBN_HEIGHTCHANGE            = RBN_FIRST - 0;
   
{ ====== TOOLTIPS CONTROL ========================== }

const
  TOOTIPS_CLASS = 'tooltips_class32';

type
  PToolInfoA = ^TToolInfoA;
  PToolInfoW = ^TToolInfoW;
  PToolInfo = PToolInfoA;
  TToolInfoA = packed record
    cbSize: UINT;
    uFlags: UINT;
    hwnd: HWND;
    uId: UINT;
    Rect: TRect;
    hInst: THandle;
    lpszText: PAnsiChar;
    Parameter: LParam;
  end;
  TToolInfoW = packed record
    cbSize: UINT;
    uFlags: UINT;
    hwnd: HWND;
    uId: UINT;
    Rect: TRect;
    hInst: THandle;
    lpszText: PWideChar;
    Parameter: LParam;
  end;
  TToolInfo = TToolInfoA;

const
  TTS_ALWAYSTIP           = $01;
  TTS_NOPREFIX            = $02;

  TTF_IDISHWND            = $01;

  // Use this to center around trackpoint in trackmode
  // -OR- to center around tool in normal mode.
  // Use TTF_ABSOLUTE to place the tip exactly at the track coords when
  // in tracking mode.  TTF_ABSOLUTE can be used in conjunction with TTF_CENTERTIP
  // to center the tip absolutely about the track point.

  TTF_CENTERTIP           = $02;
  TTF_RTLREADING          = $04;
  TTF_SUBCLASS            = $0010;
  TTF_TRACK               = $0020;
  TTF_ABSOLUTE            = $0080;
  TTF_TRANSPARENT         = $0100;
  TTF_DI_SETITEM          = $8000;

  TTDT_AUTOMATIC          = 0;
  TTDT_RESHOW             = 1;
  TTDT_AUTOPOP            = 2;
  TTDT_INITIAL            = 3;

  TTM_ACTIVATE            = WM_USER + 1;
  TTM_SETDELAYTIME        = WM_USER + 3;

  TTM_ADDTOOLA             = WM_USER + 4;
  TTM_DELTOOLA             = WM_USER + 5;
  TTM_NEWTOOLRECTA         = WM_USER + 6;
  TTM_GETTOOLINFOA         = WM_USER + 8;
  TTM_SETTOOLINFOA         = WM_USER + 9;
  TTM_HITTESTA             = WM_USER + 10;
  TTM_GETTEXTA             = WM_USER + 11;
  TTM_UPDATETIPTEXTA       = WM_USER + 12;
  TTM_ENUMTOOLSA           = WM_USER + 14;
  TTM_GETCURRENTTOOLA      = WM_USER + 15;

  TTM_ADDTOOLW             = WM_USER + 50;
  TTM_DELTOOLW             = WM_USER + 51;
  TTM_NEWTOOLRECTW         = WM_USER + 52;
  TTM_GETTOOLINFOW         = WM_USER + 53;
  TTM_SETTOOLINFOW         = WM_USER + 54;
  TTM_HITTESTW             = WM_USER + 55;
  TTM_GETTEXTW             = WM_USER + 56;
  TTM_UPDATETIPTEXTW       = WM_USER + 57;
  TTM_ENUMTOOLSW           = WM_USER + 58;
  TTM_GETCURRENTTOOLW      = WM_USER + 59;
  TTM_WINDOWFROMPOINT      = WM_USER + 16;
  TTM_TRACKACTIVATE        = WM_USER + 17;
  TTM_TRACKPOSITION        = WM_USER + 18;
  TTM_SETTIPBKCOLOR        = WM_USER + 19;
  TTM_SETTIPTEXTCOLOR      = WM_USER + 20;
  TTM_GETDELAYTIME         = WM_USER + 21;
  TTM_GETTIPBKCOLOR        = WM_USER + 22;
  TTM_GETTIPTEXTCOLOR      = WM_USER + 23;
  TTM_SETMAXTIPWIDTH       = WM_USER + 24;
  TTM_GETMAXTIPWIDTH       = WM_USER + 25;
  TTM_SETMARGIN            = WM_USER + 26;
  TTM_GETMARGIN            = WM_USER + 27;
  TTM_POP                  = WM_USER + 28;

  TTM_ADDTOOL             = TTM_ADDTOOLA;
  TTM_DELTOOL             = TTM_DELTOOLA;
  TTM_NEWTOOLRECT         = TTM_NEWTOOLRECTA;
  TTM_GETTOOLINFO         = TTM_GETTOOLINFOA;
  TTM_SETTOOLINFO         = TTM_SETTOOLINFOA;
  TTM_HITTEST             = TTM_HITTESTA;
  TTM_GETTEXT             = TTM_GETTEXTA;
  TTM_UPDATETIPTEXT       = TTM_UPDATETIPTEXTA;
  TTM_ENUMTOOLS           = TTM_ENUMTOOLSA;
  TTM_GETCURRENTTOOL      = TTM_GETCURRENTTOOLA;

  TTM_RELAYEVENT          = WM_USER + 7;
  TTM_GETTOOLCOUNT        = WM_USER +13;


type
  PTTHitTestInfoA = ^TTTHitTestInfoA;
  PTTHitTestInfoW = ^TTTHitTestInfoW;
  PTTHitTestInfo = PTTHitTestInfoA;
  TTTHitTestInfoA = packed record
    hwnd: HWND;
    pt: TPoint;
    ti: TToolInfoA;
  end;
  TTTHitTestInfoW = packed record
    hwnd: HWND;
    pt: TPoint;
    ti: TToolInfoW;
  end;
  TTTHitTestInfo = TTTHitTestInfoA;


const
  TTN_GETDISPINFOA         = TTN_FIRST - 0;
  TTN_GETDISPINFOW         = TTN_FIRST - 10;
  TTN_GETDISPINFO          = TTN_GETDISPINFOA;

  TTN_NEEDTEXTA            = TTN_FIRST - 0;
  TTN_NEEDTEXTW            = TTN_FIRST - 10;

  TTN_NEEDTEXT            = TTN_NEEDTEXTA;

  TTN_SHOW                = TTN_FIRST - 1;
  TTN_POP                 = TTN_FIRST - 2;

type
  PToolTipTextA = ^TToolTipTextA;
  PToolTipTextW = ^TToolTipTextW;
  PToolTipText = PToolTipTextA;
  TToolTipTextA = packed record
    hdr: TNMHDR;
    lpszText: PAnsiChar;
    szText: array[0..79] of Char;
    hinst: THandle;
    uFlags: UINT;
  end;
  TToolTipTextW = packed record
    hdr: TNMHDR;
    lpszText: PWideChar;
    szText: array[0..79] of Char;
    hinst: THandle;
    uFlags: UINT;
  end;
  TToolTipText = TToolTipTextA;
  NMTTDispInfoW = TToolTipTextW;
  NMTTDispInfoA = TToolTipTextA;
  NMTTDispInfo  = TToolTipText;
  PNMTTDispInfo = PToolTipText;
  PNMTTDispInfoA = PToolTipTextA;
  PNMTTDispInfoW = PToolTipTextW;

{ ====== STATUS BAR CONTROL ================= }

const
  SBARS_SIZEGRIP          = $0100;

procedure DrawStatusTextA(hDC: HDC; lprc: PRect; pzsText: PAnsiChar;
  uFlags: UINT); stdcall;
procedure DrawStatusTextW(hDC: HDC; lprc: PRect; pzsText: PWideChar;
  uFlags: UINT); stdcall;
procedure DrawStatusText(hDC: HDC; lprc: PRect; pzsText: PChar;
  uFlags: UINT); stdcall;
function CreateStatusWindowA(Style: Longint; lpszText: PAnsiChar;
  hwndParent: HWND; wID: UINT): HWND; stdcall;
function CreateStatusWindowW(Style: Longint; lpszText: PWideChar;
  hwndParent: HWND; wID: UINT): HWND; stdcall;
function CreateStatusWindow(Style: Longint; lpszText: PChar;
  hwndParent: HWND; wID: UINT): HWND; stdcall;

const
  STATUSCLASSNAME = 'msctls_statusbar32';

const
  SB_SETTEXTA             = WM_USER+1;
  SB_GETTEXTA             = WM_USER+2;
  SB_GETTEXTLENGTHA       = WM_USER+3;

  SB_SETTEXTW             = WM_USER+11;
  SB_GETTEXTW             = WM_USER+13;
  SB_GETTEXTLENGTHW       = WM_USER+12;

  SB_SETTEXT             = SB_SETTEXTA;
  SB_GETTEXT             = SB_GETTEXTA;
  SB_GETTEXTLENGTH       = SB_GETTEXTLENGTHA;

  SB_SETPARTS             = WM_USER+4;
  SB_GETPARTS             = WM_USER+6;
  SB_GETBORDERS           = WM_USER+7;
  SB_SETMINHEIGHT         = WM_USER+8;
  SB_SIMPLE               = WM_USER+9;
  SB_GETRECT              = WM_USER + 10;
  SB_ISSIMPLE             = WM_USER + 14;

  SBT_OWNERDRAW            = $1000;
  SBT_NOBORDERS            = $0100;
  SBT_POPOUT               = $0200;
  HBT_SPRING               = $0400;


{ ====== MENU HELP ========================== }

procedure MenuHelp(Msg: UINT; wParam: WPARAM; lParam: LPARAM;
  hMainMenu: HMENU; hInst: THandle; hwndStatus: HWND; lpwIDs: PUINT); stdcall;
function ShowHideMenuCtl(hWnd: HWND; uFlags: UINT; lpInfo: PINT): Bool; stdcall;
procedure GetEffectiveClientRect(hWnd: HWND; lprc: PRect; lpInfo: PINT); stdcall;

const
  MINSYSCOMMAND   = SC_SIZE;


{ ====== TRACKBAR CONTROL =================== }

  TRACKBAR_CLASS = 'msctls_trackbar32';

const
  TBS_AUTOTICKS           = $0001;
  TBS_VERT                = $0002;
  TBS_HORZ                = $0000;
  TBS_TOP                 = $0004;
  TBS_BOTTOM              = $0000;
  TBS_LEFT                = $0004;
  TBS_RIGHT               = $0000;
  TBS_BOTH                = $0008;
  TBS_NOTICKS             = $0010;
  TBS_ENABLESELRANGE      = $0020;
  TBS_FIXEDLENGTH         = $0040;
  TBS_NOTHUMB             = $0080;
  TBS_TOOLTIPS            = $0100;

  TBM_GETPOS              = WM_USER;
  TBM_GETRANGEMIN         = WM_USER+1;
  TBM_GETRANGEMAX         = WM_USER+2;
  TBM_GETTIC              = WM_USER+3;
  TBM_SETTIC              = WM_USER+4;
  TBM_SETPOS              = WM_USER+5;
  TBM_SETRANGE            = WM_USER+6;
  TBM_SETRANGEMIN         = WM_USER+7;
  TBM_SETRANGEMAX         = WM_USER+8;
  TBM_CLEARTICS           = WM_USER+9;
  TBM_SETSEL              = WM_USER+10;
  TBM_SETSELSTART         = WM_USER+11;
  TBM_SETSELEND           = WM_USER+12;
  TBM_GETPTICS            = WM_USER+14;
  TBM_GETTICPOS           = WM_USER+15;
  TBM_GETNUMTICS          = WM_USER+16;
  TBM_GETSELSTART         = WM_USER+17;
  TBM_GETSELEND           = WM_USER+18;
  TBM_CLEARSEL            = WM_USER+19;
  TBM_SETTICFREQ          = WM_USER+20;
  TBM_SETPAGESIZE         = WM_USER+21;
  TBM_GETPAGESIZE         = WM_USER+22;
  TBM_SETLINESIZE         = WM_USER+23;
  TBM_GETLINESIZE         = WM_USER+24;
  TBM_GETTHUMBRECT        = WM_USER+25;
  TBM_GETCHANNELRECT      = WM_USER+26;
  TBM_SETTHUMBLENGTH      = WM_USER+27;
  TBM_GETTHUMBLENGTH      = WM_USER+28;
  TBM_SETTOOLTIPS         = WM_USER+29;
  TBM_GETTOOLTIPS         = WM_USER+30;
  TBM_SETTIPSIDE          = WM_USER+31;
  // Trackbar Tip Side Flags
  TBTS_TOP                = 0;
  TBTS_LEFT               = 1;
  TBTS_BOTTOM             = 2;
  TBTS_RIGHT              = 3;

  TBM_SETBUDDY            = WM_USER + 32; //wparam = BOOL fLeft; (or right)
  TBM_GETBUDDY            = WM_USER + 33; //wparam = BOOL fLeft; (or right)

  TB_LINEUP               = 0;
  TB_LINEDOWN             = 1;
  TB_PAGEUP               = 2;
  TB_PAGEDOWN             = 3;
  TB_THUMBPOSITION        = 4;
  TB_THUMBTRACK           = 5;
  TB_TOP                  = 6;
  TB_BOTTOM               = 7;
  TB_ENDTRACK             = 8;

  // custom draw item specs
  TBCD_TICS               = $0001;
  TBCD_THUMB              = $0002;
  TBCD_CHANNEL            = $0003;

{ ====== DRAG LIST CONTROL ================== }

type
  PDragListInfo = ^TDragListInfo;
  TDragListInfo = packed record
    uNotification: UINT;
    hWnd: HWND;
    ptCursor: TPoint;
  end;

const
  DL_BEGINDRAG            = WM_USER+133;
  DL_DRAGGING             = WM_USER+134;
  DL_DROPPED              = WM_USER+135;
  DL_CANCELDRAG           = WM_USER+136;

  DL_CURSORSET            = 0;
  DL_STOPCURSOR           = 1;
  DL_COPYCURSOR           = 2;
  DL_MOVECURSOR           = 3;

const
  DRAGLISTMSGSTRING = 'commctrl_DragListMsg';

procedure MakeDragList(hLB: HWND); stdcall;
procedure DrawInsert(hwndParent: HWND; hLB: HWND; nItem: Integer); stdcall;
function LBItemFromPt(hLB: HWND; pt: TPoint; bAutoScroll: Bool): Integer; stdcall;


{ ====== UPDOWN CONTROL ========================== }

const
  UPDOWN_CLASS = 'msctls_updown32';

type
  PUDAccel = ^TUDAccel;
  TUDAccel = packed record
    nSec: UINT;
    nInc: UINT;
  end;

const
  UD_MAXVAL               = $7fff;
  UD_MINVAL               = -UD_MAXVAL;

  UDS_WRAP                = $0001;
  UDS_SETBUDDYINT         = $0002;
  UDS_ALIGNRIGHT          = $0004;
  UDS_ALIGNLEFT           = $0008;
  UDS_AUTOBUDDY           = $0010;
  UDS_ARROWKEYS           = $0020;
  UDS_HORZ                = $0040;
  UDS_NOTHOUSANDS         = $0080;
  UDS_HOTTRACK            = $0100;

  UDM_SETRANGE            = WM_USER+101;
  UDM_GETRANGE            = WM_USER+102;
  UDM_SETPOS              = WM_USER+103;
  UDM_GETPOS              = WM_USER+104;
  UDM_SETBUDDY            = WM_USER+105;
  UDM_GETBUDDY            = WM_USER+106;
  UDM_SETACCEL            = WM_USER+107;
  UDM_GETACCEL            = WM_USER+108;
  UDM_SETBASE             = WM_USER+109;
  UDM_GETBASE             = WM_USER+110;

function CreateUpDownControl(dwStyle: Longint; X, Y, CX, CY: Integer;
  hParent: HWND;  nID: Integer; hInst: THandle; hBuddy: HWND;
  nUpper, nLower, nPos: Integer): HWND; stdcall;

type
  PNMUpDown = ^TNMUpDown;
  TNMUpDown = packed record
    hdr: TNMHDR;
    iPos: Integer;
    iDelta: Integer;
  end;
  NM_UPDOWN = TNMUpDown;
  PNM_UpDown = PNMUpDown;

const
  UDN_DELTAPOS = UDN_FIRST - 1;


{ ====== PROGRESS CONTROL ========================= }

const
  PROGRESS_CLASS = 'msctls_progress32';

const
  PBM_SMOOTH              = $01;
  PBM_VERTICAL            = $04;

  PBM_SETRANGE            = WM_USER+1;
  PBM_SETPOS              = WM_USER+2;
  PBM_DELTAPOS            = WM_USER+3;
  PBM_SETSTEP             = WM_USER+4;
  PBM_STEPIT              = WM_USER+5;
  PBM_SETRANGE32          = WM_USER+6; // lParam = high, wParam = low

type
  PPBRange = ^PBRange;
  PBrange = packed record
     iLow: Integer;
     iHigh: Integer;
  end;

const
  PBM_GETRANGE            = WM_USER+7; // wParam = return (TRUE ? low : high). lParam = PPBRANGE or NULL
  PBM_GETPOS              = WM_USER+8;

{  ====== HOTKEY CONTROL ========================== }

const
  HOTKEYF_SHIFT           = $01;
  HOTKEYF_CONTROL         = $02;
  HOTKEYF_ALT             = $04;
  HOTKEYF_EXT             = $08;

  HKCOMB_NONE             = $0001;
  HKCOMB_S                = $0002;
  HKCOMB_C                = $0004;
  HKCOMB_A                = $0008;
  HKCOMB_SC               = $0010;
  HKCOMB_SA               = $0020;
  HKCOMB_CA               = $0040;
  HKCOMB_SCA              = $0080;


  HKM_SETHOTKEY           = WM_USER+1;
  HKM_GETHOTKEY           = WM_USER+2;
  HKM_SETRULES            = WM_USER+3;

const
  HOTKEYCLASS = 'msctls_hotkey32';


{ ====== COMMON CONTROL STYLES ================ }

const
  CCS_TOP                 = $00000001;
  CCS_NOMOVEY             = $00000002;
  CCS_BOTTOM              = $00000003;
  CCS_NORESIZE            = $00000004;
  CCS_NOPARENTALIGN       = $00000008;
  CCS_NOHILITE            = $00000010;
  CCS_ADJUSTABLE          = $00000020;
  CCS_NODIVIDER           = $00000040;
  CCS_VERT                = $00000080;
  CCS_LEFT                = (CCS_VERT OR CCS_TOP);
  CCS_RIGHT               = (CCS_VERT OR CCS_BOTTOM);
  CCS_NOMOVEX             = (CCS_VERT OR CCS_NOMOVEY);

{ ====== LISTVIEW CONTROL ====================== }

const
  WC_LISTVIEW = 'SysListView32';

const
  LVS_ICON                = $0000;
  LVS_REPORT              = $0001;
  LVS_SMALLICON           = $0002;
  LVS_LIST                = $0003;
  LVS_TYPEMASK            = $0003;
  LVS_SINGLESEL           = $0004;
  LVS_SHOWSELALWAYS       = $0008;
  LVS_SORTASCENDING       = $0010;
  LVS_SORTDESCENDING      = $0020;
  LVS_SHAREIMAGELISTS     = $0040;
  LVS_NOLABELWRAP         = $0080;
  LVS_AUTOARRANGE         = $0100;
  LVS_EDITLABELS          = $0200;
  LVS_NOSCROLL            = $2000;

  LVS_TYPESTYLEMASK       = $FC00;

  LVS_ALIGNTOP            = $0000;
  LVS_ALIGNLEFT           = $0800;
  LVS_ALIGNMASK           = $0c00;

  LVS_OWNERDRAWFIXED      = $0400;
  LVS_NOCOLUMNHEADER      = $4000;
  LVS_NOSORTHEADER        = $8000;

const
  LVM_GETBKCOLOR          = LVM_FIRST + 0;

function ListView_GetBkColor(hWnd: HWND): TColorRef;

const
  LVM_SETBKCOLOR          = LVM_FIRST + 1;

function ListView_SetBkColor(hWnd: HWND; clrBk: TColorRef): Bool;

const
  LVM_GETIMAGELIST        = LVM_FIRST + 2;

function ListView_GetImageList(hWnd: HWND; iImageList: Integer): HImageList;

const
  LVSIL_NORMAL            = 0;
  LVSIL_SMALL             = 1;
  LVSIL_STATE             = 2;

const
  LVM_SETIMAGELIST        = LVM_FIRST + 3;

function ListView_SetImageList(hWnd: HWND; himl: HImageList;
  iImageList: Integer): HImageList;

const
  LVM_GETITEMCOUNT        = LVM_FIRST + 4;

function ListView_GetItemCount(hWnd: HWND): Integer;

const
  LVIF_TEXT               = $0001;
  LVIF_IMAGE              = $0002;
  LVIF_PARAM              = $0004;
  LVIF_STATE              = $0008;
  LVIF_INDENT             = $0010;
  LVIF_NORECOMPUTE        = $0800;

  LVIS_FOCUSED            = $0001;
  LVIS_SELECTED           = $0002;
  LVIS_CUT                = $0004;
  LVIS_DROPHILITED        = $0008;
  LVIS_LINK               = $0040;

  LVIS_OVERLAYMASK        = $0F00;
  LVIS_STATEIMAGEMASK     = $F000;

  I_INDENTCALLBACK        = (-1);

function IndexToStateImageMask(I: Longint): Longint;

type
  PLVItemA = ^TLVItemA;
  PLVItemW = ^TLVItemW;
  PLVItem = PLVItemA;
  TLVItemA = packed record
    mask: UINT;
    iItem: Integer;
    iSubItem: Integer;
    state: UINT;
    stateMask: UINT;
    pszText: PAnsiChar;
    cchTextMax: Integer;
    iImage: Integer;
    lParam: LPARAM;
    iIndent: Integer;
  end;
  TLVItemW = packed record
    mask: UINT;
    iItem: Integer;
    iSubItem: Integer;
    state: UINT;
    stateMask: UINT;
    pszText: PWideChar;
    cchTextMax: Integer;
    iImage: Integer;
    lParam: LPARAM;
    iIndent: Integer;
  end;
  TLVItem = TLVItemA;

const
  LPSTR_TEXTCALLBACKA = LPSTR(-1);
  LPSTR_TEXTCALLBACKW = LPWSTR(-1);

  LPSTR_TEXTCALLBACK = LPSTR_TEXTCALLBACKA;

  I_IMAGECALLBACK         = -1;

const
  LVM_GETITEMA            = LVM_FIRST + 5;
  LVM_SETITEMA            = LVM_FIRST + 6;
  LVM_INSERTITEMA         = LVM_FIRST + 7;

  LVM_GETITEMW            = LVM_FIRST + 75;
  LVM_SETITEMW            = LVM_FIRST + 76;
  LVM_INSERTITEMW         = LVM_FIRST + 77;

  LVM_GETITEM            = LVM_GETITEMA;
  LVM_SETITEM            = LVM_SETITEMA;
  LVM_INSERTITEM         = LVM_INSERTITEMA;

  LVM_DELETEITEM          = LVM_FIRST + 8;
  LVM_DELETEALLITEMS      = LVM_FIRST + 9;
  LVM_GETCALLBACKMASK     = LVM_FIRST + 10;
  LVM_SETCALLBACKMASK     = LVM_FIRST + 11;

function ListView_GetItemA(hWnd: HWND; var pItem: TLVItemA): Bool;
function ListView_GetItemW(hWnd: HWND; var pItem: TLVItemW): Bool;
function ListView_GetItem(hWnd: HWND; var pItem: TLVItem): Bool;
function ListView_SetItemA(hWnd: HWND; const pItem: TLVItemA): Bool;
function ListView_SetItemW(hWnd: HWND; const pItem: TLVItemW): Bool;
function ListView_SetItem(hWnd: HWND; const pItem: TLVItem): Bool;
function ListView_InsertItemA(hWnd: HWND; const pItem: TLVItemA): Integer;
function ListView_InsertItemW(hWnd: HWND; const pItem: TLVItemW): Integer;
function ListView_InsertItem(hWnd: HWND; const pItem: TLVItem): Integer;
function ListView_DeleteItem(hWnd: HWND; i: Integer): Bool;
function ListView_DeleteAllItems(hWnd: HWND): Bool;
function ListView_GetCallbackMask(hWnd: HWND): UINT;
function ListView_SetCallbackMask(hWnd: HWND; mask: UINT): Bool;

const
  LVNI_ALL                = $0000;
  LVNI_FOCUSED            = $0001;
  LVNI_SELECTED           = $0002;
  LVNI_CUT                = $0004;
  LVNI_DROPHILITED        = $0008;
  LVNI_PREVIOUS           = $0020;

  LVNI_ABOVE              = $0100;
  LVNI_BELOW              = $0200;
  LVNI_TOLEFT             = $0400;
  LVNI_TORIGHT            = $0800;


const
  LVM_GETNEXTITEM         = LVM_FIRST + 12;

function ListView_GetNextItem(hWnd: HWND; iStart: Integer; Flags: UINT): Integer;

const
  LVFI_PARAM              = $0001;
  LVFI_STRING             = $0002;
  LVFI_PARTIAL            = $0008;
  LVFI_WRAP               = $0020;
  LVFI_NEARESTXY          = $0040;


type
  PLVFindInfoA = ^TLVFindInfoA;
  PLVFindInfoW = ^TLVFindInfoW;
  PLVFindInfo = PLVFindInfoA;
  TLVFindInfoA = packed record
    flags: UINT;
    psz: PAnsiChar;
    lParam: LPARAM;
    pt: TPoint;
    vkDirection: UINT;
  end;
  TLVFindInfoW = packed record
    flags: UINT;
    psz: PWideChar;
    lParam: LPARAM;
    pt: TPoint;
    vkDirection: UINT;
  end;
  TLVFindInfo = TLVFindInfoA;

const
  LVM_FINDITEMA            = LVM_FIRST + 13;
  LVM_FINDITEMW            = LVM_FIRST + 83;
  LVM_FINDITEM            = LVM_FINDITEMA;

function ListView_FindItemA(hWnd: HWND; iStart: Integer;
  const plvfi: TLVFindInfoA): Integer;
function ListView_FindItemW(hWnd: HWND; iStart: Integer;
  const plvfi: TLVFindInfoW): Integer;
function ListView_FindItem(hWnd: HWND; iStart: Integer;
  const plvfi: TLVFindInfo): Integer;

const
  LVIR_BOUNDS             = 0;
  LVIR_ICON               = 1;
  LVIR_LABEL              = 2;
  LVIR_SELECTBOUNDS       = 3;


const
  LVM_GETITEMRECT         = LVM_FIRST + 14;

function ListView_GetItemRect(hWnd: HWND; i: Integer; var prc: TRect;
  Code: Integer): Bool;

const
  LVM_SETITEMPOSITION     = LVM_FIRST + 15;

function ListView_SetItemPosition(hWnd: HWND; i, x, y: Integer): Bool;

const
  LVM_GETITEMPOSITION     = LVM_FIRST + 16;

function ListView_GetItemPosition(hwndLV: HWND; i: Integer; var ppt: TPoint): Bool;

const
  LVM_GETSTRINGWIDTHA      = LVM_FIRST + 17;
  LVM_GETSTRINGWIDTHW      = LVM_FIRST + 87;
  LVM_GETSTRINGWIDTH      = LVM_GETSTRINGWIDTHA;

function ListView_GetStringWidthA(hwndLV: HWND; psz: PAnsiChar): Integer;
function ListView_GetStringWidthW(hwndLV: HWND; psz: PWideChar): Integer;
function ListView_GetStringWidth(hwndLV: HWND; psz: PChar): Integer;

const
  LVHT_NOWHERE            = $0001;
  LVHT_ONITEMICON         = $0002;
  LVHT_ONITEMLABEL        = $0004;
  LVHT_ONITEMSTATEICON    = $0008;
  LVHT_ONITEM             = LVHT_ONITEMICON or LVHT_ONITEMLABEL or
                            LVHT_ONITEMSTATEICON;
  LVHT_ABOVE              = $0008;
  LVHT_BELOW              = $0010;
  LVHT_TORIGHT            = $0020;
  LVHT_TOLEFT             = $0040;

type
  PLVHitTestInfo = ^TLVHitTestInfo;
  TLVHitTestInfo = packed record
    pt: TPoint;
    flags: UINT;
    iItem: Integer;

    iSubItem: Integer; // this is was NOT in Win95.  valid only for LVM_SUBITEMHITTEST
  end;

const
  LVM_HITTEST             = LVM_FIRST + 18;

function ListView_HitTest(hwndLV: HWND; var pinfo: TLVHitTestInfo): Integer;

const
  LVM_ENSUREVISIBLE       = LVM_FIRST + 19;

function ListView_EnsureVisible(hwndLV: HWND; i: Integer; fPartialOK: Bool): Bool;

const
  LVM_SCROLL              = LVM_FIRST + 20;

function ListView_Scroll(hwndLV: HWnd; DX, DY: Integer): Bool;

const
  LVM_REDRAWITEMS         = LVM_FIRST + 21;

function ListView_RedrawItems(hwndLV: HWND; iFirst, iLast: Integer): Bool;

const
  LVA_DEFAULT             = $0000;
  LVA_ALIGNLEFT           = $0001;
  LVA_ALIGNTOP            = $0002;
  LVA_ALIGNRIGHT          = $0003;
  LVA_ALIGNBOTTOM         = $0004;
  LVA_SNAPTOGRID          = $0005;

  LVA_SORTASCENDING       = $0100;
  LVA_SORTDESCENDING      = $0200;

const
  LVM_ARRANGE             = LVM_FIRST + 22;

function ListView_Arrange(hwndLV: HWND; Code: UINT): Bool;


const
  LVM_EDITLABELA           = LVM_FIRST + 23;
  LVM_EDITLABELW           = LVM_FIRST + 118;
  LVM_EDITLABEL           = LVM_EDITLABELA;

function ListView_EditLabelA(hwndLV: HWND; i: Integer): HWND;
function ListView_EditLabelW(hwndLV: HWND; i: Integer): HWND;
function ListView_EditLabel(hwndLV: HWND; i: Integer): HWND;

const
  LVM_GETEDITCONTROL      = LVM_FIRST + 24;

function ListView_GetEditControl(hwndLV: HWND): HWND;

type
  PLVColumnA = ^TLVColumnA;
  PLVColumnW = ^TLVColumnW;
  PLVColumn = PLVColumnA;
  TLVColumnA = packed record
    mask: UINT;
    fmt: Integer;
    cx: Integer;
    pszText: PAnsiChar;
    cchTextMax: Integer;
    iSubItem: Integer;
    iImage: Integer;
    iOrder: Integer;
  end;
  TLVColumnW = packed record
    mask: UINT;
    fmt: Integer;
    cx: Integer;
    pszText: PWideChar;
    cchTextMax: Integer;
    iSubItem: Integer;
    iImage: Integer;
    iOrder: Integer;
  end;
  TLVColumn = TLVColumnA;

const
  LVCF_FMT                = $0001;
  LVCF_WIDTH              = $0002;
  LVCF_TEXT               = $0004;
  LVCF_SUBITEM            = $0008;
  LVCF_IMAGE              = $0010;
  LVCF_ORDER              = $0020;

  LVCFMT_LEFT             = 0;
  LVCFMT_RIGHT            = 1;
  LVCFMT_CENTER           = 2;
  LVCFMT_JUSTIFYMASK      = 3;
  LVCFMT_IMAGE            = $0800;
  LVCFMT_BITMAP_ON_RIGHT  = $1000;
  LVCFMT_COL_HAS_IMAGES   = $8000;

  LVM_GETCOLUMNA          = LVM_FIRST + 25;
  LVM_GETCOLUMNW          = LVM_FIRST + 95;
  LVM_GETCOLUMN           = LVM_GETCOLUMNA;

function ListView_GetColumnA(hwnd: HWND; iCol: Integer;
  var pcol: TLVColumnA): Bool;
function ListView_GetColumnW(hwnd: HWND; iCol: Integer;
  var pcol: TLVColumnW): Bool;
function ListView_GetColumn(hwnd: HWND; iCol: Integer;
  var pcol: TLVColumn): Bool;

const
  LVM_SETCOLUMNA           = LVM_FIRST + 26;
  LVM_SETCOLUMNW           = LVM_FIRST + 96;
  LVM_SETCOLUMN           = LVM_SETCOLUMNA;

function ListView_SetColumnA(hwnd: HWnd; iCol: Integer; const pcol: TLVColumnA): Bool;
function ListView_SetColumnW(hwnd: HWnd; iCol: Integer; const pcol: TLVColumnW): Bool;
function ListView_SetColumn(hwnd: HWnd; iCol: Integer; const pcol: TLVColumn): Bool;

const
  LVM_INSERTCOLUMNA        = LVM_FIRST + 27;
  LVM_INSERTCOLUMNW        = LVM_FIRST + 97;
  LVM_INSERTCOLUMN        = LVM_INSERTCOLUMNA;

function ListView_InsertColumnA(hwnd: HWND; iCol: Integer;
  const pcol: TLVColumnA): Integer;
function ListView_InsertColumnW(hwnd: HWND; iCol: Integer;
  const pcol: TLVColumnW): Integer;
function ListView_InsertColumn(hwnd: HWND; iCol: Integer;
  const pcol: TLVColumn): Integer;

const
  LVM_DELETECOLUMN        = LVM_FIRST + 28;

function ListView_DeleteColumn(hwnd: HWND; iCol: Integer): Bool;

const
  LVM_GETCOLUMNWIDTH      = LVM_FIRST + 29;

function ListView_GetColumnWidth(hwnd: HWND; iCol: Integer): Integer;

const
  LVSCW_AUTOSIZE              = -1;
  LVSCW_AUTOSIZE_USEHEADER    = -2;
  LVM_SETCOLUMNWIDTH          = LVM_FIRST + 30;

function ListView_SetColumnWidth(hwnd: HWnd; iCol: Integer; cx: Integer): Bool;

const
  LVM_GETHEADER               = LVM_FIRST + 31;

function ListView_GetHeader(hwndLV: HWnd): Hwnd;

const
  LVM_CREATEDRAGIMAGE     = LVM_FIRST + 33;

function ListView_CreateDragImage(hwnd: HWND; i: Integer;
  const lpptUpLeft: TPoint): HImageList;

const
  LVM_GETVIEWRECT         = LVM_FIRST + 34;

function ListView_GetViewRect(hwnd: HWND; var prc: TRect): Bool;

const
  LVM_GETTEXTCOLOR        = LVM_FIRST + 35;

function ListView_GetTextColor(hwnd: HWND): TColorRef;

const
  LVM_SETTEXTCOLOR        = LVM_FIRST + 36;

function ListView_SetTextColor(hwnd: HWND; clrText: TColorRef): Bool;

const
  LVM_GETTEXTBKCOLOR      = LVM_FIRST + 37;

function ListView_GetTextBkColor(hwnd: HWND): TColorRef;

const
  LVM_SETTEXTBKCOLOR      = LVM_FIRST + 38;

function ListView_SetTextBkColor(hwnd: HWND; clrTextBk: TColorRef): Bool;

const
  LVM_GETTOPINDEX         = LVM_FIRST + 39;

function ListView_GetTopIndex(hwndLV: HWND): Integer;

const
  LVM_GETCOUNTPERPAGE     = LVM_FIRST + 40;

function ListView_GetCountPerPage(hwndLV: HWND): Integer;

const
  LVM_GETORIGIN           = LVM_FIRST + 41;

function ListView_GetOrigin(hwndLV: HWND; var ppt: TPoint): Bool;

const
  LVM_UPDATE              = LVM_FIRST + 42;

function ListView_Update(hwndLV: HWND; i: Integer): Bool;

const
  LVM_SETITEMSTATE        = LVM_FIRST + 43;

function ListView_SetItemState(hwndLV: HWND; i: Integer; data, mask: UINT): Bool;

const
  LVM_GETITEMSTATE        = LVM_FIRST + 44;

function ListView_GetItemState(hwndLV: HWND; i, mask: Integer): Integer;

function ListView_GetCheckState(hwndLV: HWND; i: Integer): Integer;
const
  LVM_GETITEMTEXTA         = LVM_FIRST + 45;
  LVM_GETITEMTEXTW         = LVM_FIRST + 115;
  LVM_GETITEMTEXT         = LVM_GETITEMTEXTA;

function ListView_GetItemTextA(hwndLV: HWND; i, iSubItem: Integer;
  pszText: PAnsiChar; cchTextMax: Integer): Integer;
function ListView_GetItemTextW(hwndLV: HWND; i, iSubItem: Integer;
  pszText: PWideChar; cchTextMax: Integer): Integer;
function ListView_GetItemText(hwndLV: HWND; i, iSubItem: Integer;
  pszText: PChar; cchTextMax: Integer): Integer;

const
  LVM_SETITEMTEXTA         = LVM_FIRST + 46;
  LVM_SETITEMTEXTW         = LVM_FIRST + 116;
  LVM_SETITEMTEXT         = LVM_SETITEMTEXTA;

function ListView_SetItemTextA(hwndLV: HWND; i, iSubItem: Integer;
  pszText: PAnsiChar): Bool;
function ListView_SetItemTextW(hwndLV: HWND; i, iSubItem: Integer;
  pszText: PWideChar): Bool;
function ListView_SetItemText(hwndLV: HWND; i, iSubItem: Integer;
  pszText: PChar): Bool;

const
  // these flags only apply to LVS_OWNERDATA listviews in report or list mode
  LVSICF_NOINVALIDDATEALL = $00000001;
  LVSICF_NOSCROLL         = $00000002;

  LVM_SETITEMCOUNT        = LVM_FIRST + 47;

procedure ListView_SetItemCount(hwndLV: HWND; cItems: Integer);
procedure ListView_SetItemCountEx(hwndLV: HWnd; cItems: Integer; dwFlags: LParam);

type
  TLVCompare = function(lParam1, lParam2, lParamSort: Integer): Integer stdcall;

const
  LVM_SORTITEMS           = LVM_FIRST + 48;

function ListView_SortItems(hwndLV: HWND; pfnCompare: TLVCompare;
  lPrm: Longint): Bool;

const
  LVM_SETITEMPOSITION32   = LVM_FIRST + 49;

procedure ListView_SetItemPosition32(hwndLV: HWND; i, x, y: Integer);

const
  LVM_GETSELECTEDCOUNT    = LVM_FIRST + 50;

function ListView_GetSelectedCount(hwndLV: HWND): UINT;

const
  LVM_GETITEMSPACING      = LVM_FIRST + 51;

function ListView_GetItemSpacing(hwndLV: HWND; fSmall: Integer): Longint;


const
  LVM_GETISEARCHSTRINGA    = LVM_FIRST + 52;
  LVM_GETISEARCHSTRINGW    = LVM_FIRST + 117;
  LVM_GETISEARCHSTRING    = LVM_GETISEARCHSTRINGA;

function ListView_GetISearchStringA(hwndLV: HWND; lpsz: PAnsiChar): Bool;
function ListView_GetISearchStringW(hwndLV: HWND; lpsz: PWideChar): Bool;
function ListView_GetISearchString(hwndLV: HWND; lpsz: PChar): Bool;

const
  LVM_SETICONSPACING            = LVM_FIRST + 53;
  LVM_SETEXTENDEDLISTVIEWSTYLE  = LVM_FIRST + 54;
  LVM_GETEXTENDEDLISTVIEWSTYLE  = LVM_FIRST + 55;

function ListView_SetIconSpacing(hwndLV: HWND; cx: Integer; cy: Integer): DWord;
function ListView_SetExtendedListViewStyle(hwndLV: HWND; dw: Integer): DWord;
function ListView_GetExtendedListViewStyle(hwndLV: HWND): DWord;

const
  LVS_EX_GRIDLINES              = $00000001;
  LVS_EX_SUBITEMIMAGES          = $00000002;
  LVS_EX_CHECKBOXES             = $00000004;
  LVS_EX_TRACKSELECT            = $00000008;
  LVS_EX_HEADERDRAGDROP         = $00000010;
  LVS_EX_FULLROWSELECT          = $00000020; // applies to report mode only
  LVS_EX_ONECLICKACTIVATE       = $00000040;
  LVS_EX_TWOCLICKACTIVATE       = $00000080;

const
  LVM_GETSUBITEMRECT            = LVM_FIRST + 56;
  LVM_SUBITEMHITTEST            = LVM_FIRST + 57;
  LVM_SETCOLUMNORDERARRAY       = LVM_FIRST + 58;
  LVM_GETCOLUMNORDERARRAY       = LVM_FIRST + 59;
  LVM_SETHOTITEM                = LVM_FIRST + 60;
  LVM_GETHOTITEM                = LVM_FIRST + 61;
  LVM_SETHOTCURSOR              = LVM_FIRST + 62;
  LVM_GETHOTCURSOR              = LVM_FIRST + 63;
  LVM_APPROXIMATEVIEWRECT       = LVM_FIRST + 64;
  LVM_SETWORKAREA               = LVM_FIRST + 65;

function ListView_GetSubItemRect(Handle: HWnd; iItem: Integer; iSubItem: Integer; code: Integer; var prc: TRect): Boolean;
function ListView_SubItemHitTest(Handle: HWnd; plvhti: Integer): Integer;
function ListView_SetColumnOrderArray(Handle: HWnd; iCount: Integer; pi: Integer): Bool;
function ListView_GetColumnOrderArray(Handle: HWnd; iCount: Integer; pi: Integer): Bool;
function ListView_SetHotItem(Handle: HWnd; i: Integer): Integer;
function ListView_GetHotItem(Handle: Hwnd): Integer;
function ListView_SetHotCursor(Handle: HWnd; hCur: HCursor): HCursor;
function ListView_GetHotCursor(Handle: HWnd): HCursor;
function ListView_ApproximateViewRect(Handle: HWnd; iWidth: Integer; iHeight: Integer; iCount: Integer): DWord;
function ListView_SetWorkArea(Handle: HWnd; var prc: TRect): Bool;

type
  PNMListView = ^TNMListView;
  TNMListView = packed record
    hdr: TNMHDR;
    iItem: Integer;
    iSubItem: Integer;
    uNewState: UINT;
    uOldState: UINT;
    uChanged: UINT;
    ptAction: TPoint;
    lParam: LPARAM;
  end;
  PNMList_View = PNMListView;
  TNMList_View = TNMListView;

  PNMLVCustomDraw = ^TNMLVCustomDraw;
  TNMLVCustomDraw = packed record
    nmcd: TNMCustomDraw;
    clrText: TColorRef;
    clrTextBk: TColorRef;
  end;

  PNMLVCacheHint = ^TNMLVCacheHint;
  TNMLVCacheHint = packed record
    hdr: TNMHDR;
    iFrom: Integer;
    iTo: Integer;
  end;
  PNM_CacheHint = PNMLVCacheHint;
  TNM_CacheHint = PNMLVCacheHint;

  PNMLVFindItem = ^TNMLVFindItem;
  TNMLVFindItem = packed record
    hdr: TNMHDR;
    iStart: Integer;
    lvfi: TLVFindInfo;
  end;
  PNM_FindItem = PNMLVFindItem;
  TNM_FindItem  = TNMLVFindItem;

  PNMLVodStateChange = ^TNMLVodStateChange;
  TNMLVodStateChange = packed record
    hdr: TNMHDR;
    iFrom: Integer;
    iTo: Integer;
    uNewState: UINT;
    uOldState: UINT;
  end;
  PNM_ODStateChange = PNMLVodStateChange;
  TNM_OdStateChange = TNMLVodStateChange;

const
  LVN_ITEMCHANGING        = LVN_FIRST-0;
  LVN_ITEMCHANGED         = LVN_FIRST-1;
  LVN_INSERTITEM          = LVN_FIRST-2;
  LVN_DELETEITEM          = LVN_FIRST-3;
  LVN_DELETEALLITEMS      = LVN_FIRST-4;
  LVN_COLUMNCLICK         = LVN_FIRST-8;
  LVN_BEGINDRAG           = LVN_FIRST-9;
  LVN_ENDDRAG             = LVN_FIRST-10;
  LVN_BEGINRDRAG          = LVN_FIRST-11;
  LVN_ENDRDRAG            = LVN_FIRST-12;
  LVN_ODCACHEHINT         = LVN_FIRST-13;
  LVN_ODFINDITEMA         = LVN_FIRST-52;
  LVN_ODFINDITEMW         = LVN_FIRST-79;

  LVN_ITEMACTIVATE        = LVN_FIRST-14;
  LVN_ODSTATECHANGED      = LVN_FIRST-15;

  LVN_ODFINDITEM          = LVN_ODFINDITEMA;

  LVN_BEGINLABELEDITA      = LVN_FIRST-5;
  LVN_ENDLABELEDITA        = LVN_FIRST-6;
  LVN_BEGINLABELEDITW      = LVN_FIRST-75;
  LVN_ENDLABELEDITW        = LVN_FIRST-76;
  LVN_BEGINLABELEDIT      = LVN_BEGINLABELEDITA;
  LVN_ENDLABELEDIT        = LVN_ENDLABELEDITA;


const
  LVN_GETDISPINFOA        = LVN_FIRST-50;
  LVN_SETDISPINFOA        = LVN_FIRST-51;
  LVN_GETDISPINFOW        = LVN_FIRST-77;
  LVN_SETDISPINFOW        = LVN_FIRST-78;
  LVN_GETDISPINFO        = LVN_GETDISPINFOA;
  LVN_SETDISPINFO        = LVN_SETDISPINFOA;

  LVIF_DI_SETITEM         = $1000;

type
  PLVDispInfoA = ^TLVDispInfoA;
  TLVDispInfoA = packed record
    hdr: TNMHDR;
    item: TLVItemA;
  end;
  PLVDispInfoW = ^TLVDispInfoW;
  TLVDispInfoW = packed record
    hdr: TNMHDR;
    item: TLVItemW;
  end;
  PLVDispInfo = PLVDispInfoA;
  TLVDispInfo = TLVDispInfoA;

  TLV_DispInfoA = TLVDispInfoA;
  TLV_DispInfoW = TLVDispInfoW;
  TLV_DispInfo  = TLVDispInfo;

const
  LVN_KEYDOWN             = LVN_FIRST-55;

type
  PLVKeyDown = ^TLVKeyDown;
  TLVKeyDown = packed record
    hdr: TNMHDR;
    wVKey: Word;
    flags: UINT;
  end;
  TLV_KeyDown                = TLVKeyDown;

const
  LVN_MARQUEEBEGIN           = LVN_FIRST - 56;

{ ====== TREEVIEW CONTROL =================== }

const
  WC_TREEVIEW = 'SysTreeView32';

const
  TVS_HASBUTTONS          = $0001;
  TVS_HASLINES            = $0002;
  TVS_LINESATROOT         = $0004;
  TVS_EDITLABELS          = $0008;
  TVS_DISABLEDRAGDROP     = $0010;
  TVS_SHOWSELALWAYS       = $0020;
  TVS_RTLREADING          = $0040;

  TVS_NOTOOLTIPS          = $0080;
  TVS_CHECKBOXES          = $0100;
  TVS_TRACKSELECT         = $0200;

  TVS_SHAREDIMAGELISTS    = $0000;
  TVS_PRIVATEIMAGELISTS   = $0400;

type
  HTreeItem = ^_TreeItem;
  _TreeItem = packed record
  end;

const
  TVIF_TEXT               = $0001;
  TVIF_IMAGE              = $0002;
  TVIF_PARAM              = $0004;
  TVIF_STATE              = $0008;
  TVIF_HANDLE             = $0010;
  TVIF_SELECTEDIMAGE      = $0020;
  TVIF_CHILDREN           = $0040;

  TVIS_FOCUSED            = $0001;
  TVIS_SELECTED           = $0002;
  TVIS_CUT                = $0004;
  TVIS_DROPHILITED        = $0008;
  TVIS_BOLD               = $0010;
  TVIS_EXPANDED           = $0020;
  TVIS_EXPANDEDONCE       = $0040;
  TVIS_EXPANDEDPARTIAL    = $0080;

  TVIS_OVERLAYMASK        = $0F00;
  TVIS_STATEIMAGEMASK     = $F000;
  TVIS_USERMASK           = $F000;


const
  I_CHILDRENCALLBACK  = -1;

type
  PTVItemA = ^TTVItemA;
  PTVItemW = ^TTVItemW;
  PTVItem = PTVItemA;
  TTVItemA = packed record
    mask: UINT;
    hItem: HTreeItem;
    state: UINT;
    stateMask: UINT;
    pszText: PAnsiChar;
    cchTextMax: Integer;
    iImage: Integer;
    iSelectedImage: Integer;
    cChildren: Integer;
    lParam: LPARAM;
  end;
  TTVItemW = packed record
    mask: UINT;
    hItem: HTreeItem;
    state: UINT;
    stateMask: UINT;
    pszText: PWideChar;
    cchTextMax: Integer;
    iImage: Integer;
    iSelectedImage: Integer;
    cChildren: Integer;
    lParam: LPARAM;
  end;
  TTVItem = TTVItemA;

  PTV_ItemW              = PTVItemW;
  PTV_ItemA              = PTVItemA;
  PTV_Item               = PTVItem;
  TTV_ItemW              = TTVItemW;
  TTV_ItemA              = TTVItemA;
  TTV_Item               = TTVItem;

const
  TVI_ROOT                = HTreeItem($FFFF0000);
  TVI_FIRST               = HTreeItem($FFFF0001);
  TVI_LAST                = HTreeItem($FFFF0002);
  TVI_SORT                = HTreeItem($FFFF0003);

type
  PTVInsertStructA = ^TTVInsertStructA;
  PTVInsertStructW = ^TTVInsertStructW;
  PTVInsertStruct = PTVInsertStructA;
  TTVInsertStructA = packed record
    hParent: HTreeItem;
    hInsertAfter: HTreeItem;
    item: TTVItemA;
  end;
  TTVInsertStructW = packed record
    hParent: HTreeItem;
    hInsertAfter: HTreeItem;
    item: TTVItemW;
  end;
  TTVInsertStruct = TTVInsertStructA;

  PTV_InsertStructA = PTVInsertStructA;
  PTV_InsertStructW = PTVInsertStructW;
  PTV_InsertStruct  = PTVInsertStruct;
  TTV_InsertStructA = TTVInsertStructA;
  TTV_InsertStructW = TTVInsertStructW;
  TTV_InsertStruct  = TTVInsertStruct;

const
  TVM_INSERTITEMA          = TV_FIRST + 0;
  TVM_INSERTITEMW          = TV_FIRST + 50;
  TVM_INSERTITEM          = TVM_INSERTITEMA;

function TreeView_InsertItem(hwnd: HWND; const lpis: TTVInsertStruct): HTreeItem;

const
  TVM_DELETEITEM          = TV_FIRST + 1;

function TreeView_DeleteItem(hwnd: HWND; hitem: HTreeItem): Bool;

function TreeView_DeleteAllItems(hwnd: HWND): Bool;

const
  TVM_EXPAND              = TV_FIRST + 2;

function TreeView_Expand(hwnd: HWND; hitem: HTreeItem; code: Integer): Bool;

const
  TVE_COLLAPSE            = $0001;
  TVE_EXPAND              = $0002;
  TVE_TOGGLE              = $0003;
  TVE_EXPANDPARTIAL       = $4000;
  TVE_COLLAPSERESET       = $8000;

const
  TVM_GETITEMRECT         = TV_FIRST + 4;

function TreeView_GetItemRect(hwnd: HWND; hitem: HTreeItem;
  var prc: TRect; code: Bool): Bool;

const
  TVM_GETCOUNT            = TV_FIRST + 5;

function TreeView_GetCount(hwnd: HWND): UINT;

const
  TVM_GETINDENT           = TV_FIRST + 6;

function TreeView_GetIndent(hwnd: HWND): UINT;

const
  TVM_SETINDENT           = TV_FIRST + 7;

function TreeView_SetIndent(hwnd: HWND; indent: Integer): Bool;

const
  TVM_GETIMAGELIST        = TV_FIRST + 8;

function TreeView_GetImageList(hwnd: HWND; iImage: Integer): HImageList;

const
  TVSIL_NORMAL            = 0;
  TVSIL_STATE             = 2;


const
  TVM_SETIMAGELIST        = TV_FIRST + 9;

function TreeView_SetImageList(hwnd: HWND; himl: HImageList;
  iImage: Integer): HImageList;

const
  TVM_GETNEXTITEM         = TV_FIRST + 10;

function TreeView_GetNextItem(hwnd: HWND; hitem: HTreeItem;
  code: Integer): HTreeItem;

const
  TVGN_ROOT               = $0000;
  TVGN_NEXT               = $0001;
  TVGN_PREVIOUS           = $0002;
  TVGN_PARENT             = $0003;
  TVGN_CHILD              = $0004;
  TVGN_FIRSTVISIBLE       = $0005;
  TVGN_NEXTVISIBLE        = $0006;
  TVGN_PREVIOUSVISIBLE    = $0007;
  TVGN_DROPHILITE         = $0008;
  TVGN_CARET              = $0009;

function TreeView_GetChild(hwnd: HWND; hitem: HTreeItem): HTreeItem;
function TreeView_GetNextSibling(hwnd: HWND; hitem: HTreeItem): HTreeItem;
function TreeView_GetPrevSibling(hwnd: HWND; hitem: HTreeItem): HTreeItem;
function TreeView_GetParent(hwnd: HWND; hitem: HTreeItem): HTreeItem;
function TreeView_GetFirstVisible(hwnd: HWND): HTreeItem;
function TreeView_GetNextVisible(hwnd: HWND; hitem: HTreeItem): HTreeItem;
function TreeView_GetPrevVisible(hwnd: HWND; hitem: HTreeItem): HTreeItem;
function TreeView_GetSelection(hwnd: HWND): HTreeItem;
function TreeView_GetDropHilite(hwnd: HWND): HTreeItem;
function TreeView_GetRoot(hwnd: HWND): HTreeItem;

const
  TVM_SELECTITEM          = TV_FIRST + 11;

function TreeView_Select(hwnd: HWND; hitem: HTreeItem;
  code: Integer): HTreeItem;

function TreeView_SelectItem(hwnd: HWND; hitem: HTreeItem): HTreeItem;
function TreeView_SelectDropTarget(hwnd: HWND; hitem: HTreeItem): HTreeItem;
function TreeView_SelectSetFirstVisible(hwnd: HWND; hitem: HTreeItem): HTreeItem;

const
  TVM_GETITEMA             = TV_FIRST + 12;
  TVM_GETITEMW             = TV_FIRST + 62;
  TVM_GETITEM             = TVM_GETITEMA;

function TreeView_GetItemA(hwnd: HWND; var pitem: TTVItemA): Bool;
function TreeView_GetItemW(hwnd: HWND; var pitem: TTVItemW): Bool;
function TreeView_GetItem(hwnd: HWND; var pitem: TTVItem): Bool;

const
  TVM_SETITEMA             = TV_FIRST + 13;
  TVM_SETITEMW             = TV_FIRST + 63;
  TVM_SETITEM             = TVM_SETITEMA;

function TreeView_SetItemA(hwnd: HWND; const pitem: TTVItemA): Bool;
function TreeView_SetItemW(hwnd: HWND; const pitem: TTVItemW): Bool;
function TreeView_SetItem(hwnd: HWND; const pitem: TTVItem): Bool;

const
  TVM_EDITLABELA           = TV_FIRST + 14;
  TVM_EDITLABELW           = TV_FIRST + 65;
  TVM_EDITLABEL           = TVM_EDITLABELA;

function TreeView_EditLabelA(hwnd: HWND; hitem: HTreeItem): HWND;
function TreeView_EditLabelW(hwnd: HWND; hitem: HTreeItem): HWND;
function TreeView_EditLabel(hwnd: HWND; hitem: HTreeItem): HWND;

const
  TVM_GETEDITCONTROL      = TV_FIRST + 15;

function TreeView_GetEditControl(hwnd: HWND): HWND;


const
  TVM_GETVISIBLECOUNT     = TV_FIRST + 16;

function TreeView_GetVisibleCount(hwnd: HWND): UINT;

const
  TVM_HITTEST             = TV_FIRST + 17;

type
  PTVHitTestInfo = ^TTVHitTestInfo;
  TTVHitTestInfo = packed record
    pt: TPoint;
    flags: UINT;
    hItem: HTreeItem;
  end;
  PTV_HitTestInfo        = PTVHitTestInfo;
  TTV_HitTestInfo       = TTVHitTestInfo;

function TreeView_HitTest(hwnd: HWND; var lpht: TTVHitTestInfo): HTreeItem;

const
  TVHT_NOWHERE            = $0001;
  TVHT_ONITEMICON         = $0002;
  TVHT_ONITEMLABEL        = $0004;
  TVHT_ONITEMINDENT       = $0008;
  TVHT_ONITEMBUTTON       = $0010;
  TVHT_ONITEMRIGHT        = $0020;
  TVHT_ONITEMSTATEICON    = $0040;

  TVHT_ONITEM             = TVHT_ONITEMICON or TVHT_ONITEMLABEL or
                              TVHT_ONITEMSTATEICON;

  TVHT_ABOVE              = $0100;
  TVHT_BELOW              = $0200;
  TVHT_TORIGHT            = $0400;
  TVHT_TOLEFT             = $0800;

const
  TVM_CREATEDRAGIMAGE     = TV_FIRST + 18;

function TreeView_CreateDragImage(hwnd: HWND; hitem: HTreeItem): HimageList;

const
  TVM_SORTCHILDREN        = TV_FIRST + 19;

function TreeView_SortChildren(hwnd: HWND; hitem: HTreeItem;
  recurse: Integer): Bool;

const
  TVM_ENSUREVISIBLE       = TV_FIRST + 20;

function TreeView_EnsureVisible(hwnd: HWND; hitem: HTreeItem): Bool;

const
  TVM_SORTCHILDRENCB      = TV_FIRST + 21;

type
  TTVCompare = function(lParam1, lParam2, lParamSort: Longint): Integer stdcall;

type
  PTVSortCB = ^TTVSortCB;
  TTVSortCB = packed record
    hParent: HTreeItem;
    lpfnCompare: TTVCompare;
    lParam: LPARAM;
  end;
  PTV_SortCB                = PTVSortCB;
  TTV_SortCB                = TTVSortCB;

function TreeView_SortChildrenCB(hwnd: HWND; const psort: TTVSortCB;
  recurse: Integer): Bool;

const
  TVM_ENDEDITLABELNOW     = TV_FIRST + 22;

function TreeView_EndEditLabelNow(hwnd: HWND; fCancel: Bool): Bool;

const
  TVM_GETISEARCHSTRINGA    = TV_FIRST + 23;
  TVM_GETISEARCHSTRINGW    = TV_FIRST + 64;
  TVM_GETISEARCHSTRING    = TVM_GETISEARCHSTRINGA;

function TreeView_GetISearchStringA(hwndTV: HWND; lpsz: PAnsiChar): Bool;
function TreeView_GetISearchStringW(hwndTV: HWND; lpsz: PWideChar): Bool;
function TreeView_GetISearchString(hwndTV: HWND; lpsz: PChar): Bool;

const
  TVM_SETTOOLTIPS          = TV_FIRST + 24;
  TVM_GETTOOLTIPS          = TV_FIRST + 25;
  
type
  PNMTreeViewA = ^TNMTreeViewA;
  PNMTreeViewW = ^TNMTreeViewW;
  PNMTreeView = PNMTreeViewA;
  TNMTreeViewA = packed record
    hdr: TNMHDR;
    action: UINT;
    itemOld: TTVItemA;
    itemNew: TTVItemA;
    ptDrag: TPoint;
  end;
  TNMTreeViewW = packed record
    hdr: TNMHDR;
    action: UINT;
    itemOld: TTVItemW;
    itemNew: TTVItemW;
    ptDrag: TPoint;
  end;
  TNMTreeView = TNMTreeViewA;

  PNM_TreeViewA               = PNMTreeViewA;
  PNM_TreeViewW               = PNMTreeViewW;
  PNM_TreeView                = PNMTreeView;
  TNM_TreeViewA               = TNMTreeViewA;
  TNM_TreeViewW               = TNMTreeViewW;
  TNM_TreeView                = TNMTreeView;


const
  TVN_SELCHANGINGA         = TVN_FIRST-1;
  TVN_SELCHANGEDA          = TVN_FIRST-2;
  TVN_SELCHANGINGW         = TVN_FIRST-50;
  TVN_SELCHANGEDW          = TVN_FIRST-51;
  TVN_SELCHANGING         = TVN_SELCHANGINGA;
  TVN_SELCHANGED          = TVN_SELCHANGEDA;

const
  TVC_UNKNOWN             = $0000;
  TVC_BYMOUSE             = $0001;
  TVC_BYKEYBOARD          = $0002;

const
  TVN_GETDISPINFOA         = TVN_FIRST-3;
  TVN_SETDISPINFOA         = TVN_FIRST-4;
  TVN_GETDISPINFOW         = TVN_FIRST-52;
  TVN_SETDISPINFOW         = TVN_FIRST-53;
  TVN_GETDISPINFO         = TVN_GETDISPINFOA;
  TVN_SETDISPINFO         = TVN_SETDISPINFOA;

  TVIF_DI_SETITEM         = $1000;

type
  PTVDispInfoA = ^TTVDispInfoA;
  PTVDispInfoW = ^TTVDispInfoW;
  TTVDispInfoA = packed record
    hdr: TNMHDR;
    item: TTVItemA;
  end;
  TTVDispInfoW = packed record
    hdr: TNMHDR;
    item: TTVItemW;
  end;
  TTVDispInfo = TTVDispInfoA;
  PTVDispInfo = PTVDispInfoA;

  PTV_DispInfoA                = PTVDispInfoA;
  PTV_DispInfoW                = PTVDispInfoW;
  PTV_DispInfo                 = PTVDispInfo;
  TTV_DispInfoA                = TTVDispInfoA;
  TTV_DispInfoW                = TTVDispInfoW;
  TTV_DispInfo                 = TTVDispInfo;

const
  TVN_ITEMEXPANDINGA       = TVN_FIRST-5;
  TVN_ITEMEXPANDEDA        = TVN_FIRST-6;
  TVN_BEGINDRAGA           = TVN_FIRST-7;
  TVN_BEGINRDRAGA          = TVN_FIRST-8;
  TVN_DELETEITEMA          = TVN_FIRST-9;
  TVN_BEGINLABELEDITA      = TVN_FIRST-10;
  TVN_ENDLABELEDITA        = TVN_FIRST-11;
  TVN_ITEMEXPANDINGW       = TVN_FIRST-54;
  TVN_ITEMEXPANDEDW        = TVN_FIRST-55;
  TVN_BEGINDRAGW           = TVN_FIRST-56;
  TVN_BEGINRDRAGW          = TVN_FIRST-57;
  TVN_DELETEITEMW          = TVN_FIRST-58;
  TVN_BEGINLABELEDITW      = TVN_FIRST-59;
  TVN_ENDLABELEDITW        = TVN_FIRST-60;
  TVN_ITEMEXPANDING       = TVN_ITEMEXPANDINGA;
  TVN_ITEMEXPANDED        = TVN_ITEMEXPANDEDA;
  TVN_BEGINDRAG           = TVN_BEGINDRAGA;
  TVN_BEGINRDRAG          = TVN_BEGINRDRAGA;
  TVN_DELETEITEM          = TVN_DELETEITEMA;
  TVN_BEGINLABELEDIT      = TVN_BEGINLABELEDITA;
  TVN_ENDLABELEDIT        = TVN_ENDLABELEDITA;

const
  TVN_KEYDOWN             = TVN_FIRST-12;

type
  PTVKeyDown = ^TTVKeyDown;
  TTVKeyDown = packed record
    hdr: TNMHDR;
    wVKey: Word;
    flags: UINT;
  end;
  TTV_KeyDown            = TTVKeyDown;
  PTV_KeyDown            = PTVKeyDown;

  PNMTVCustomDraw = ^TNMTVCustomDraw;
  TNMTVCustomDraw = packed record
    nmcd: TNMCustomDraw;
    clrText: TColorRef;
    clrTextBk: TColorRef;
  end;

/////////// ComboBoxEx /////////////////////
const
     WC_COMBOBOXEX           = 'ComboBoxEx32';

const
  CBEIF_TEXT                 = $00000001;
  CBEIF_IMAGE                = $00000002;
  CBEIF_SELECTEDIMAGE        = $00000004;
  CBEIF_OVERLAY              = $00000008;
  CBEIF_INDENT               = $00000010;
  CBEIF_LPARAM               = $00000020;

  CBEIF_DI_SETITEM           = $10000000;

type
  PCComboBoxExItemA = ^TComboBoxExItemA;
  PComboBoxExItemA = ^TComboBoxExItemA;
  TComboBoxExItemA = packed record
    mask: UINT;
    iItem: Integer;
    pszText: PChar;
    cchTextMax: Integer;
    iImage: Integer;
    iSelectedImage: Integer;
    iOverlay: Integer;
    iIndent: Integer;
    Parameter: LParam;
  end;

  PComboBoxExItemW = ^TComboBoxExItemW;
  PCComboBoxExItemW = ^TComboBoxExItemW;
  TComboBoxExItemW = packed record
    mask: UINT;
    iItem: Integer;
    pszText: PChar;
    cchTextMax: Integer;
    iImage: Integer;
    iSelectedImage: Integer;
    iOverlay: Integer;
    iIndent: Integer;
    Parameter: LParam;
  end;
  TComboBoxExItem = TComboBoxExItemA;
  PComboBoxExItem = PComboBoxExItemA;
  PCComboBoxExItem = PCComboBoxExItemA;

const  
  CBEM_INSERTITEMA         = WM_USER + 1;
  CBEM_SETIMAGELIST        = WM_USER + 2;
  CBEM_GETIMAGELIST        = WM_USER + 3;
  CBEM_GETITEMA            = WM_USER + 4;
  CBEM_SETITEMA            = WM_USER + 5;
  CBEM_DELETEITEM          = CB_DELETESTRING;
  CBEM_GETCOMBOCONTROL     = WM_USER + 6;
  CBEM_GETEDITCONTROL      = WM_USER + 7;
  CBEM_SETEXSTYLE          = WM_USER + 8;
  CBEM_GETEXSTYLE          = WM_USER + 9;
  CBEM_HASEDITCHANGED      = WM_USER + 10;
  CBEM_INSERTITEMW         = WM_USER + 11;
  CBEM_SETITEMW            = WM_USER + 12;
  CBEM_GETITEMW            = WM_USER + 13;

  CBEM_INSERTITEM          = CBEM_INSERTITEMA;
  CBEM_SETITEM             = CBEM_SETITEMA;
  CBEM_GETITEM             = CBEM_GETITEMA;

  CBES_EX_NOEDITIMAGE      = $00000001;
  CBES_EX_NOEDITIMAGEINDENT = $00000002;
  CBES_EX_PATHWORDBREAKPROC = $00000004;

type
  PNMComboBoxEx = ^TNMComboBoxEx;
  TNMComboBoxEx = packed record
    hdr: TNMHDR;
    ceItem: TComboBoxExItem;
  end;

const
  CBEN_GETDISPINFO           = CBEN_FIRST - 0;
  CBEN_INSERTITEM            = CBEN_FIRST - 1;
  CBEN_DELETEITEM            = CBEN_FIRST - 2;
  CBEN_BEGINEDIT             = CBEN_FIRST - 4;
  CBEN_ENDEDITA              = CBEN_FIRST - 5;
  CBEN_ENDEDITW              = CBEN_FIRST - 6;

  // lParam specifies why the endedit is happening
  CBEN_ENDEDIT               = CBEN_ENDEDITA;

  CBENF_KILLFOCUS            = 1;
  CBENF_RETURN               = 2;
  CBENF_ESCAPE               = 3;
  CBENF_DROPDOWN             = 4;

  CBEMAXSTRLEN               = 260;

// CBEN_ENDEDIT sends this information...
// fChanged if the user actually did anything
// iNewSelection gives what would be the new selection unless the notify is failed
//                      iNewSelection may be CB_ERR if there is no match
type
  PNMCBEEndEditW = ^TNMCBEEndEditW;
  TNMCBEEndEditW = packed record
    hdr: TNMHDR;
    fChanged: Boolean;
    iNewSelection: Integer;
    szText: Array[0..CBEMAXSTRLEN-1] of WChar;
    iWhy: Integer;
  end;

  PNMCBEEndEditA = ^TNMCBEEndEditA;
  TNMCBEEndEditA = packed record
    hdr: TNMHDR;
    fChanged: Boolean;
    iNewSelection: Integer;
    szText: Array[0..CBEMAXSTRLEN-1] of WChar;
    iWhy: Integer;
  end;

  TNMCBEEndEdit = TNMCBEEndEditA;
  PNMCBEEndEdit = PNMCBEEndEditA;
  
{ ====== TAB CONTROL ======================== }

const
  WC_TABCONTROL = 'SysTabControl32';

const
  TCS_SCROLLOPPOSITE    = $0001;  // assumes multiline tab
  TCS_BOTTOM            = $0002;
  TCS_RIGHT             = $0002;
  TCS_MULTISELECT       = $0004; // allow multi-select in button mode
  TCS_FORCEICONLEFT     = $0010;
  TCS_FORCELABELLEFT    = $0020;
  TCS_HOTTRACK          = $0040;
  TCS_VERTICAL          = $0080;
  TCS_SHAREIMAGELISTS   = $0040;
  TCS_TABS              = $0000;
  TCS_BUTTONS           = $0100;
  TCS_SINGLELINE        = $0000;
  TCS_MULTILINE         = $0200;
  TCS_RIGHTJUSTIFY      = $0000;
  TCS_FIXEDWIDTH        = $0400;
  TCS_RAGGEDRIGHT       = $0800;
  TCS_FOCUSONBUTTONDOWN = $1000;
  TCS_OWNERDRAWFIXED    = $2000;
  TCS_TOOLTIPS          = $4000;
  TCS_FOCUSNEVER        = $8000;

const
  TCM_FIRST              = $1300;
  TCM_GETBKCOLOR         = TCM_FIRST + 0;
  TCM_SETBKCOLOR         = TCM_FIRST + 1;
  TCM_GETIMAGELIST       = TCM_FIRST + 2;
  TCM_SETIMAGELIST       = TCM_FIRST + 3;
  TCM_GETITEMCOUNT       = TCM_FIRST + 4;
  TCM_DELETEITEM         = TCM_FIRST + 8;
  TCM_DELETEALLITEMS     = TCM_FIRST + 9;
  TCM_GETITEMRECT        = TCM_FIRST + 10;
  TCM_GETCURSEL          = TCM_FIRST + 11;
  TCM_SETCURSEL          = TCM_FIRST + 12;
  TCM_HITTEST            = TCM_FIRST + 13;
  TCM_SETITEMEXTRA       = TCM_FIRST + 14;
  TCM_ADJUSTRECT         = TCM_FIRST + 40;
  TCM_SETITEMSIZE        = TCM_FIRST + 41;
  TCM_REMOVEIMAGE        = TCM_FIRST + 42;
  TCM_SETPADDING         = TCM_FIRST + 43;
  TCM_GETROWCOUNT        = TCM_FIRST + 44;
  TCM_GETTOOLTIPS        = TCM_FIRST + 45;
  TCM_SETTOOLTIPS        = TCM_FIRST + 46;
  TCM_GETCURFOCUS        = TCM_FIRST + 47;
  TCM_SETCURFOCUS        = TCM_FIRST + 48;

const
  TCIF_TEXT  = $0001;
  TCIF_IMAGE = $0002;
  TCIF_PARAM = $0008;
  TCIF_STATE = $0010;

  TCIS_BUTTONPRESSED = $0001;

type
  PTCItemHeaderA = ^TTCItemHeaderA;
  PTCItemHeaderW = ^TTCItemHeaderW;
  TTCItemHeaderA = packed record
    mask: UINT;
    lpReserved1: UINT;
    lpReserved2: UINT;
    pszText: PAnsiChar;
    cchTextMax: Integer;
    iImage: Integer;
  end;
  TTCItemHeaderW = packed record
    mask: UINT;
    lpReserved1: UINT;
    lpReserved2: UINT;
    pszText: PWideChar;
    cchTextMax: Integer;
    iImage: Integer;
  end;
  TTCItemHeader = TTCItemHeaderA;
  PTCItemHeader = PTCItemHeaderA;

  PTC_ItemHeader  = PTCItemHeader;
  PTC_ItemHeaderW = PTCItemHeaderW;
  PTC_ItemHeaderA = PTCItemHeaderA;
  TTC_ItemHeader  = TTCItemHeader;
  TTC_ItemHeaderW = TTCItemHeaderW;
  TTC_ItemHeaderA = TTCItemHeaderA;



  PTCItemA = ^TTCItemA;
  PTCItemW = ^TTCItemW;
  TTCItemA = packed record
    mask: UINT;
    lpReserved1: UINT;
    lpReserved2: UINT;
    pszText: PAnsiChar;
    cchTextMax: Integer;
    iImage: Integer;
    lParam: LPARAM;
  end;
  TTCItemW = packed record
    mask: UINT;
    lpReserved1: UINT;
    lpReserved2: UINT;
    pszText: PWideChar;
    cchTextMax: Integer;
    iImage: Integer;
    lParam: LPARAM;
  end;
  TTCItem = TTCItemA;
  PTCItem = PTCItemA;

  TTC_ItemA = TTCItemA;
  TTC_ItemW = TTCItemW;
  TTC_Item  = TTCItem;
  PTC_ItemA = PTCItemA;
  PTC_ItemW = PTCItemW;
  PTC_Item  = PTCItem;

const
  TCM_GETITEMA             = TCM_FIRST + 5;
  TCM_SETITEMA             = TCM_FIRST + 6;
  TCM_INSERTITEMA          = TCM_FIRST + 7;
  TCM_GETITEMW             = TCM_FIRST + 60;
  TCM_SETITEMW             = TCM_FIRST + 61;
  TCM_INSERTITEMW          = TCM_FIRST + 62;
  TCM_GETITEM             = TCM_GETITEMA;
  TCM_SETITEM             = TCM_SETITEMA;
  TCM_INSERTITEM          = TCM_INSERTITEMA;

  TCM_SETMINTABWIDTH      = TCM_FIRST + 49;
  TCM_DESELECTALL         = TCM_FIRST + 50;

function TabCtrl_SetMinTabWidth(Handle: HWnd; x: Integer): Integer;
procedure TabCtrl_DeselectAll(Handle: HWnd; fExcludeFocus: Integer);

const
  TCHT_NOWHERE     = $0001;
  TCHT_ONITEMICON  = $0002;
  TCHT_ONITEMLABEL = $0004;
  TCHT_ONITEM      = TCHT_ONITEMICON or TCHT_ONITEMLABEL;

type
  PTCHitTestInfo = ^TTCHitTestInfo;
  TTCHitTestInfo = packed record
    pt: TPoint;
    flags: UINT;
  end;
  PTC_HitTestInfo = PTCHitTestInfo;
  TTC_HitTestInfo = TTCHitTestInfo;

  TTCKeyDown = packed record
    hdr: TNMHDR;
    wVKey: Word;
    flags: UINT;
  end;
  TTC_KeyDown = TTCKeyDown;

const
  TCN_KEYDOWN             = TCN_FIRST - 0;
  TCN_SELCHANGE           = TCN_FIRST - 1;
  TCN_SELCHANGING         = TCN_FIRST - 2;


{ ====== ANIMATE CONTROL ================= }

const
  ANIMATE_CLASS = 'SysAnimate32';

const
  ACS_CENTER              = $0001;
  ACS_TRANSPARENT         = $0002;
  ACS_AUTOPLAY            = $0004;
  ACS_TIMER               = $0008; // don't use threads...use timers

  ACM_OPENA                = WM_USER + 100;
  ACM_OPENW                = WM_USER + 103;
  ACM_OPEN                = ACM_OPENA;

  ACM_PLAY                = WM_USER + 101;
  ACM_STOP                = WM_USER + 102;

  ACN_START               = 1;
  ACN_STOP                = 2;

//===========MONTHCAL CONTROL ======================
const
  MONTHCAL_CLASS = 'SysMonthCal32';

  // bit-packed array of "bold" info for a month
  // if a bit is on, that day is drawn bold
type
  MonthDayState = DWord;
  PMonthDayState = ^MonthDayState;

type
  PMCHitTestInfo = ^TMCHitTestInfo;
  TMCHitTestInfo = packed record
    cbSize: UINT;
    pt: TPoint;

    uHit: UINT; // out param
    st: TSystemTime;
  end;
  
const
  MCM_FIRST                           = $1000;

const
  MCM_GETCURSEL                       = MCM_FIRST + 1;
  MCM_SETCURSEL                       = MCM_FIRST + 2;
  MCM_GETMAXSELCOUNT                  = MCM_FIRST + 3;
  MCM_SETMAXSELCOUNT                  = MCM_FIRST + 4;
  MCM_GETSELRANGE                     = MCM_FIRST + 5;
  MCM_SETSELRANGE                     = MCM_FIRST + 6;
  MCM_GETMONTHRANGE                   = MCM_FIRST + 7;
  MCM_SETDAYSTATE                     = MCM_FIRST + 8;
  MCM_GETMINREQRECT                   = MCM_FIRST + 9;
  MCM_SETTODAY                        = MCM_FIRST + 12;
  MCM_GETTODAY                        = MCM_FIRST + 13;
  MCM_HITTEST                         = MCM_FIRST + 14;

function MonthCal_GetCurSel(hmc: HWnd; pst: PSystemTime): Bool;
function MonthCal_SetCurSel(hmc: HWnd; pst: PSystemTime): Bool;
function MonthCal_GetMaxSelCount(hmc: HWnd): DWord;
function MonthCal_SetMaxSelCount(hmc: HWnd; n: UINT): Bool;
function MonthCal_GetSelRange(hmc: HWnd; rgst: PSystemTime): Bool;
function MonthCal_SetSelRange(hmc: HWnd; rgst: PSystemTime): Bool;
function MonthCal_GetMonthRange(hmc: HWnd; gmr: DWord; rgst: PSystemTime): DWord;
function MonthCal_SetDayState(hmc: HWnd; cbds: Integer; rgds: PSystemTime): Bool;
function MonthCal_GetMinReqRect(hmc: HWnd; prc: PRect): Bool;
procedure MonthCal_SetToday(hmc: HWnd; pst: PSystemTime);
function MonthCal_GetToday(hmc: HWnd; pst: PSystemTime): Bool;
procedure MonthCal_HitTest(hmc: HWnd; pinfo: PMCHitTestInfo);

const
  MCHT_TITLE                           = $00010000;
  MCHT_CALENDAR                        = $00020000;
  MCHT_TODAYLINK                       = $00030000;

  MCHT_NEXT                            = $01000000; // these indicate that hitting
  MCHT_PREV                            = $02000000; // here will go to the next/prev month

  MCHT_NOWHERE                         = $00000000;

  MCHT_TITLEBK                         = (MCHT_TITLE);
  MCHT_TITLEMONTH                      = (MCHT_TITLE or $0001);
  MCHT_TITLEYEAR                       = (MCHT_TITLE or $0002);
  MCHT_TITLEBTNNEXT                    = (MCHT_TITLE or MCHT_NEXT);
  MCHT_TITLEBTNPREV                    = (MCHT_TITLE or MCHT_PREV);

  MCHT_CALENDARBK                      = (MCHT_CALENDAR);
  MCHT_CALENDARDATE                    = (MCHT_CALENDAR or $0001);
  MCHT_CALENDARDATENEXT                = (MCHT_CALENDARDATE or MCHT_NEXT);
  MCHT_CALENDARDATEPREV                = (MCHT_CALENDARDATE or MCHT_PREV);
  MCHT_CALENDARDAY                     = (MCHT_CALENDAR or $0002);
  MCHT_CALENDARWEEKNUM                 = (MCHT_CALENDAR or $0003);

  // set colors to draw control with -- see MCSC_ bits below
  MCM_SETCOLOR                         = MCM_FIRST + 10;
  MCM_GETCOLOR                         = MCM_FIRST + 11;

procedure MonthCal_SetColor(hmc: HWnd; iColor: TColorRef; clr: integer);
procedure MonthCal_GetColor(hmc: HWnd; iColor: TColorRef);

const
  MCSC_BACKGROUND                         = 0; // the background color (between months)
  MCSC_TEXT                               = 1; // the dates
  MCSC_TITLEBK                            = 2; // background of the title
  MCSC_TITLETEXT                          = 3;
  MCSC_MONTHBK                            = 4; // background within the month cal
  MCSC_TRAILINGTEXT                       = 5; // the text color of header and trailing days

  MCM_SETFIRSTDAYOFWEEK                   = MCM_FIRST + 15;
  MCM_GETFIRSTDAYOFWEEK                   = MCM_FIRST + 16;
  MCM_GETRANGE                            = MCM_FIRST + 17;
  MCM_SETRANGE                            = MCM_FIRST + 18;
  MCM_GETMONTHDELTA                       = MCM_FIRST + 19;
  MCM_SETMONTHDELTA                       = MCM_FIRST + 20;

procedure MonthCal_SetFirstDayOfWeek(hmc: HWnd; iDay: Integer);
function  MonthCal_GetFirstDayOfWeek(hmc: HWnd): DWord;
function  MonthCal_GetRange(hmc: HWnd; rgst: PSystemTime): DWord;
function  MonthCal_SetRange(hmc: HWnd; gdtr: DWord; rgst: PSystemTime): Bool;
function  MonthCal_GetMonthDelta(hmc: HWnd): Integer;
function  MonthCal_SetMonthDelta(hmc: HWnd; n: Integer): Integer;

type
  // MCN_SELCHANGE is sent whenever the currently displayed date changes
  // via month change, year change, keyboard navigation, prev/next button
  PNMSelChange = ^TNMSelChange;
  TNMSelChange = packed record
    nmhdr: TNMHDR; //this must be first, so we don't break WM_NOTIFY
    stSelStart: TSystemTime;
    stSelEnd: TSystemTime;
  end;
  NMSelChange = TNMSelChange;

const
  MCN_SELCHANGE                              = MCN_FIRST + 1;

// MCN_GETDAYSTATE is sent for MCS_DAYSTATE controls whenever new daystate
// information is needed(month or year scroll) to draw bolding information.
// The app must fill in cDayState months worth of information starting from
// stStart date.  The app may fill in the array at prgDayState or change
// prgDayState to point to a different array out of which the information
// will be copied.  (similar to tooltips).
//
type
  PNMDayState = ^TNMDayState;
  TNMDayState = packed record
    nmhdr: TNMHDR; // this must be first, so we don't break WM_NOTIFY
    stStart: TSystemTime;
    cDayState: Integer;
    prgDayState: PMonthDayState; //points to cDayState MONTHDAYSTATEs
  end;
  NMDayState = TNMDayState;

const
  MCN_GETDAYSTATE                           = MCN_FIRST + 3;

// MCN_SELECT is sent whenever a selection has occured (via mouse or keyboard)
type
  NMSelect = NMSelChange;
  PNMSelect = ^NMSelect;

const
  MCN_SELECT                                = MCN_FIRST + 4;

  MCS_DAYSTATE                              = $0001;
  MCS_MULTISELECT                           = $0002;
  MCS_WEEKNUMBERS                           = $0004;
  MCS_NOTODAY                               = $0008;

  GMR_VISIBLE                               = 0;  // visible portion of display
  GMR_DAYSTATE                              = 1;  // above plus the grayed out parts of partially displayed months


//=========== DateTimePick Control ==========================================

const
  DATETIMEPICK_CLASS = 'SysDateTimePick32';

  DTM_FIRST                        = $1000;

const
  DTM_GETSYSTEMTIME                = DTM_FIRST + 1;
  DTM_SETSYSTEMTIME                = DTM_FIRST + 2;
  DTM_GETRANGE                     = DTM_FIRST + 3;
  DTM_SETRANGE                     = DTM_FIRST + 4;
  DTM_SETFORMAT                    = DTM_FIRST + 5;

function DateTime_GetSystemTime(hdp: HWnd; pst: PSystemTime): DWord;
function DateTime_SetSystemTime(hdp: HWnd; gd: DWord; pst: PSystemTime): Bool;
function DateTime_GetRange(hdp: HWnd; rgst: PSystemTime): DWord;
function DateTime_SetRange(hdp: HWnd; gdtr: DWord; rgst: PSystemTime): Bool;
function DateTime_SetFormat(hdp: HWnd; sz: LPCSTR): Bool;

const
  DTM_SETFORMATA                   = DTM_FIRST + 5;
  DTM_SETFORMATW                   = DTM_FIRST + 50;
  DTM_SETMCCOLOR                   = DTM_FIRST + 6;
  DTM_GETMCCOLOR                   = DTM_FIRST + 7;
  DTM_GETMONTHCAL                  = DTM_FIRST + 8;
  DTM_SETMCFONT                    = DTM_FIRST + 9;
  DTM_GETMCFONT                    = DTM_FIRST + 10;

procedure DateTime_SetMonthCalColor(hdp: HWnd; iColor: TColorRef; clr: TColorRef);
procedure DateTime_GetMonthCalColor(hdp: HWnd; var iColor: TColorRef);
function  DateTime_GetMonthCal(hdp: HWnd): HWnd;
procedure DateTime_SetMonthCalFont(hdp: HWnd; Font: HFont; fReDraw: Integer);
procedure DateTime_GetMonthCalFont(hdp: HWnd);

const
  DTS_UPDOWN                       = $0001; // use UPDOWN instead of MONTHCAL
  DTS_SHOWNONE                     = $0002; // allow a NONE selection
  DTS_SHORTDATEFORMAT              = $0000; // use the short date format(app must forward WM_WININICHANGE messages)
  DTS_LONGDATEFORMAT               = $0004; // use the long date format(app must forward WM_WININICHANGE messages)
  DTS_TIMEFORMAT                   = $0009; // use the time format (app must forward WM_WININICHANGE messages)
  DTS_APPCANPARSE                  = $0010; // allow user entered strings (app MUST respond to DTN_USERSTRING)
  DTS_RIGHTALIGN                   = $0020; // right-align popup instead of left-align it

  DTN_DATETIMECHANGE               = DTN_FIRST + 1;
  DTN_USERSTRINGA                  = DTN_FIRST + 2; // the user has entered a string
  DTN_USERSTRINGW                  = DTN_FIRST + 15;
  DTN_USERSTRING                   = DTN_USERSTRINGA;
  DTN_WMKEYDOWNA                   = DTN_FIRST + 3; // modify keydown on app format field (X)
  DTN_WMKEYDOWNW                   = DTN_FIRST + 16;
  DTN_WMKEYDOWN                    = DTN_WMKEYDOWNA;
  DTN_FORMATA                      = DTN_FIRST + 4; // query display for app format field(X)
  DTN_FORMATW                      = DTN_FIRST + 17;
  DTN_FORMAT                       = DTN_FORMATA;
  DTN_FORMATQUERYA                 = DTN_FIRST + 5; // query formatting info for app format field(X)
  DTN_FORMATQUERYW                 = DTN_FIRST + 18;
  DTN_FORMATQUERY                  = DTN_FORMATQUERYA;
  DTN_DROPDOWN                     = DTN_FIRST + 6; // MonthCal has dropped down
  DTN_CLOSEUP                      = DTN_FIRST + 7; // MonthCal is popping up

type
  PNMDateTimeChange = ^TNMDateTimeChange;
  TNMDateTimeChange = packed record
    nmhdr: TNmhdr;
    dwFlags: DWord;  // GDT_VALID or GDT_NONE
    st: TSystemTime;  // valid if dwFlags = GDT_VALID
  end;

  PNMDateTimeStringA = ^TNMDateTimeStringA;
  TNMDateTimeStringA = packed record
    nmhdr: TNmhdr;
    pszUserString: LPCSTR;  // string user entered
    st: TSystemTime;        // app fills this in
    dwFlags: DWord;        // GDT_VALID or GDT_NONE
  end;

  PNMDateTimeStringW = ^TNMDateTimeStringW;
  TNMDateTimeStringW = packed record
    nmhdr: TNmhdr;
    pszUserString: LPCWSTR;     // string user entered
    st: TSystemTime;             // app fill this in
    dwFlags: DWord;             // GDT_VALID or GDT_NONE
  end;

  PNMDateTimeString = PNMDateTimeStringA;
  TNMDateTimeString = TNMDateTimeStringA;

  PNMDateTimeWMKeyDownA = ^TNMDateTimeWMKeyDownA;
  TNMDateTimeWMKeyDownA = packed record
    nmhdr: TNmhdr;
    nVirtKey: Integer;  // virtual key code of WM_KeyDown which MODIFIES an X field
    pszFormat: LPCSTR;   // format substring
    st: TSystemTime;     // current systemtiem, app should modify based on key
  end;

  PNMDateTimeWMKeyDownW = ^TNMDateTimeWMKeyDownW;
  TNMDateTimeWMKeyDownW = packed record
    nmhdr: TNmhdr;
    nVirtKey: Integer;  // virtual key code of WM_KeyDown which MODIFIES an X field
    pszFormat: LPCWSTR;   // format substring
    st: TSystemTime;     // current systemtiem, app should modify based on key
  end;

  PNMDateTimeWMKeyDown = PNMDateTimeWMKeyDownA;
  TNMDateTimeWMKeyDown = TNMDateTimeWMKeyDownA;

  PNMDateTimeFormatA = ^TNMDateTimeFormatA;
  TNMDateTimeFormatA = packed record
    nmhdr: TNmhdr;
    pszFormat: LPCSTR;  // format substring
    st: TSystemTime;    // current systemtime
    pszDisplay: LPCSTR; // string to display
    szDisplay: Array[0..63] of Char; // buffer pszDisplay originally points at
  end;

  PNMDateTimeFormatW = ^TNMDateTimeFormatW;
  TNMDateTimeFormatW = packed record
    nmhdr: TNmhdr;
    pszFormat: LPCWSTR;  // format substring
    st: TSystemTime;    // current systemtime
    pszDisplay: LPCWSTR; // string to display
    szDisplay: Array[0..63] of Char; // buffer pszDisplay originally points at
  end;

  PNMDateTimeFormat = PNMDateTimeFormatA;
  TNMDateTimeFormat = TNMDateTimeFormatA;

  PNMDateTimeFormatQueryA = ^TNMDateTimeFormatQueryA;
  TNMDateTimeFormatQueryA = packed record
    nmhdr: TNmhdr;
    pszFormat: LPCSTR;   // format substring
    szMax: TRect;        // max bounding rectangle rectangle app will use this format string
  end;

  PNMDateTimeFormatQueryW = ^TNMDateTimeFormatQueryW;
  TNMDateTimeFormatQueryW = packed record
    nmhdr: TNmhdr;
    pszFormat: LPCWSTR;   // format substring
    szMax: TRect;        // max bounding rectangle rectangle app will use this format string
  end;

  PNMDateTimeFormatQuery = PNMDateTimeFormatQueryA;
  TNMDateTimeFormatQuery = TNMDateTimeFormatQueryA;


const
  GDTR_MIN                         = $0001;
  GDTR_MAX                         = $0002;

  GDT_ERROR                       = -1;
  GDT_VALID                       = 0;
  GDT_NONE                        = 1;

// ========== TrackMouse Event ==============
const
  WM_MOUSEHOVER                        = $02A1;
  WM_MOUSELEAVE                        = $02A3;

// if the TRACKMOUSEEVENT structure and associated flags haven't been declared
// then declare them now.
//
  TME_HOVER                            = $00000001;
  TME_LEAVE                            = $00000002;
  TME_QUERY                            = $40000000;
  TME_CANCEL                           = $80000000;

  HOVER_DEFAULT                        = $FFFFFFFF;

type
  PTrackMouseEvent = ^TTrackMouseEvent;
  TTrackMouseEvent = packed record
    cbSize: DWord;
    dwFlags: DWord;
    hwndTrack: HWnd;
    dwHoverTime: DWord;
  end;

// Declare TrackMouseEvent.  This API tries to use the window manager's implementation
// of TrackMouseEvent if it is present, otherwise it emulates
function TrackMouseEvent(lpEventTrack: PTrackMouseEvent): Boolean; stdcall;



implementation

uses SysUtils;

const
  cctrl = 'comctl32.dll';

procedure InitCommonControls;  external cctrl name 'InitCommonControls';
function InitCommonControlsEx; external cctrl name 'InitCommonControlsEx';


{ Property Sheets }
function CreatePropertySheetPageA; external cctrl name 'CreatePropertySheetPageA';
function CreatePropertySheetPageW; external cctrl name 'CreatePropertySheetPageW';
function CreatePropertySheetPage; external cctrl name 'CreatePropertySheetPageA';
function DestroyPropertySheetPage; external cctrl name 'DestroyPropertySheetPage';
function PropertySheetA; external cctrl name 'PropertySheetA';
function PropertySheetW; external cctrl name 'PropertySheetW';
function PropertySheet; external cctrl name 'PropertySheetA';

{ Image List }
function ImageList_Create; external cctrl name 'ImageList_Create';
function ImageList_Destroy; external cctrl name 'ImageList_Destroy';
function ImageList_GetImageCount; external cctrl name 'ImageList_GetImageCount';
function ImageList_Add; external cctrl name 'ImageList_Add';
function ImageList_ReplaceIcon; external cctrl name 'ImageList_ReplaceIcon';
function ImageList_SetBkColor; external cctrl name 'ImageList_SetBkColor';
function ImageList_GetBkColor; external cctrl name 'ImageList_GetBkColor';
function ImageList_SetOverlayImage; external cctrl name 'ImageList_SetOverlayImage';

function ImageList_AddIcon(ImageList: HImageList; Icon: HIcon): Integer;
begin
  Result := ImageList_ReplaceIcon(ImageList, -1, Icon);
end;

function IndexToOverlayMask(Index: Integer): Integer;
begin
  Result := Index shl 8;
end;

function ImageList_Draw; external cctrl name 'ImageList_Draw';

function ImageList_Replace; external cctrl name 'ImageList_Replace';
function ImageList_AddMasked; external cctrl name 'ImageList_AddMasked';
function ImageList_DrawEx; external cctrl name 'ImageList_DrawEx';
function ImageList_DrawIndirect; external cctrl name 'ImageList_DrawIndirect';
function ImageList_Remove; external cctrl name 'ImageList_Remove';
function ImageList_GetIcon; external cctrl name 'ImageList_GetIcon';
function ImageList_LoadImage; external cctrl name 'ImageList_LoadImage';
function ImageList_Copy; external cctrl name 'ImageList_Copy';
function ImageList_BeginDrag; external cctrl name 'ImageList_BeginDrag';
function ImageList_EndDrag; external cctrl name 'ImageList_EndDrag';
function ImageList_DragEnter; external cctrl name 'ImageList_DragEnter';
function ImageList_DragLeave; external cctrl name 'ImageList_DragLeave';
function ImageList_DragMove; external cctrl name 'ImageList_DragMove';
function ImageList_SetDragCursorImage; external cctrl name 'ImageList_SetDragCursorImage';
function ImageList_DragShowNolock; external cctrl name 'ImageList_DragShowNolock';
function ImageList_GetDragImage; external cctrl name 'ImageList_GetDragImage';

{ macros }
procedure ImageList_RemoveAll(ImageList: HImageList);
begin
  ImageList_Remove(ImageList, -1);
end;

function ImageList_ExtractIcon(Instance: THandle; ImageList: HImageList;
  Image: Integer): HIcon;
begin
  Result := ImageList_GetIcon(ImageList, Image, 0);
end;

function ImageList_LoadBitmap(Instance: THandle; Bmp: PChar;
  CX, Grow: Integer; Mask: TColorRef): HImageList;
begin
  Result := ImageList_LoadImage(Instance, Bmp, CX, Grow, Mask,
    IMAGE_BITMAP, 0);
end;

function ImageList_GetIconSize; external cctrl name 'ImageList_GetIconSize';
function ImageList_SetIconSize; external cctrl name 'ImageList_SetIconSize';
function ImageList_GetImageInfo; external cctrl name 'ImageList_GetImageInfo';
function ImageList_Merge; external cctrl name 'ImageList_Merge';

{ Headers }

function Header_GetItemCount(Header: HWnd): Integer;
begin
  Result := SendMessage(Header, HDM_GETITEMCOUNT, 0, 0);
end;

function Header_InsertItem(Header: HWnd; Index: Integer;
  const Item: THDItem): Integer;
begin
  Result := SendMessage(Header, HDM_INSERTITEM, Index, Longint(@Item));
end;

function Header_DeleteItem(Header: HWnd; Index: Integer): Bool;
begin
  Result := Bool( SendMessage(Header, HDM_DELETEITEM, Index, 0) );
end;

function Header_GetItem(Header: HWnd; Index: Integer; var Item: THDItem): Bool;
begin
  Result := Bool( SendMessage(Header, HDM_GETITEM, Index, Longint(@Item)) );
end;

function Header_SetItem(Header: HWnd; Index: Integer; const Item: THDItem): Bool;
begin
  Result := Bool( SendMessage(Header, HDM_SETITEM, Index, Longint(@Item)) );
end;

function Header_Layout(Header: HWnd; Layout: PHDLayout): Bool;
begin
  Result := Bool( SendMessage(Header, HDM_LAYOUT, 0, Longint(Layout)) );
end;

function Header_GetItemRect(Header: HWnd; Item: Integer; Prc: lparam): Boolean;
begin
  Result := Bool( SendMessage(Header, HDM_GETITEMRECT, WParam(Item), Prc));
end;

function Header_SetImageList(Header: HWnd; ImageList: HImagelist): HImageList;
begin
  Result := HImageList( SendMessage(Header, HDM_SETIMAGELIST, 0, ImageList));
end;

function Header_GetImageList(Header: HWnd): HImageList;
begin
  Result := HImageList( SendMessage(Header, HDM_GETIMAGELIST, 0, 0) );
end;

function Header_OrderToIndex(Header: HWnd; I: Integer): Integer;
begin
  Result := Integer( SendMessage(Header, HDM_ORDERTOINDEX, WParam(I), 0) );
end;

function Header_CreateDragImage(Header: HWnd; I: Integer): HImageList;
begin
  Result := HImageList( SendMessage(Header, HDM_CREATEDRAGIMAGE, WParam(I), 0) );
end;

function Header_GetOrderArray(Header: HWnd; Count: WParam; lp: lparam): Bool;
begin
  Result := Bool( SendMessage(Header, HDM_GETORDERARRAY, WParam(Count), LParam(lp)) );
end;

function Header_SetOrderArray(Header: HWnd; Count: WParam; lp: lparam): Bool;
begin
  Result := Bool( SendMessage(Header, HDM_SETORDERARRAY, WParam(Count), LParam(lp)) );
end;

function Header_SetHotDivider(Header: HWnd; Position: WParam; Divider: LParam): integer;
begin
  Result := Integer( SendMessage(Header, HDM_SETHOTDIVIDER, WParam(Position), LParam(Divider)) );
end;


{ Toolbar }

function CreateToolBarEx; external cctrl name 'CreateToolbarEx';
function CreateMappedBitmap; external cctrl name 'CreateMappedBitmap';

{ Status bar }
procedure DrawStatusTextA; external cctrl name 'DrawStatusTextA';
procedure DrawStatusTextW; external cctrl name 'DrawStatusTextW';
procedure DrawStatusText; external cctrl name 'DrawStatusTextA';
function CreateStatusWindowA; external cctrl name 'CreateStatusWindowA';
function CreateStatusWindowW; external cctrl name 'CreateStatusWindowW';
function CreateStatusWindow; external cctrl name 'CreateStatusWindowA';

{ Menu Help }
procedure MenuHelp; external cctrl name 'MenuHelp';
function ShowHideMenuCtl; external cctrl name 'ShowHideMenuCtl';
procedure GetEffectiveClientRect; external cctrl name 'GetEffectiveClientRect';


{ Drag List Box }
procedure MakeDragList; external cctrl name 'MakeDragList';
procedure DrawInsert; external cctrl name 'DrawInsert';
function LBItemFromPt; external cctrl name 'LBItemFromPt';

{ UpDown control }
function CreateUpDownControl; external cctrl name 'CreateUpDownControl';


{ List View }
function ListView_GetBkColor(hWnd: HWND): TColorRef;
begin
  Result := SendMessage(hWnd, LVM_GETBKCOLOR, 0, 0);
end;

function ListView_SetBkColor(hWnd: HWND; clrBk: TColorRef): Bool;
begin
  Result := Bool( SendMessage(hWnd, LVM_SETBKCOLOR, 0, clrBk) );
end;

function ListView_GetImageList(hWnd: HWND; iImageList: Integer): HImageList;
begin
  Result := HImageList( SendMessage(hWnd, LVM_GETIMAGELIST, iImageList, 0) );
end;

function ListView_SetImageList(hWnd: HWND; himl: HImageList; iImageList: Integer): HImageList;
begin
  Result := HImageList( SendMessage(hWnd, LVM_SETIMAGELIST, iImageList, Longint(himl)) );
end;

function ListView_GetItemCount(hWnd: HWND): Integer;
begin
  Result := SendMessage(hWnd, LVM_GETITEMCOUNT, 0, 0);
end;

function IndexToStateImageMask(I: Longint): Longint;
begin
  Result := I shl 12;
end;

function ListView_GetItemA(hWnd: HWND; var pItem: TLVItemA): Bool;
begin
  Result := Bool( SendMessage(hWnd, LVM_GETITEM, 0, Longint(@pItem)) );
end;
function ListView_GetItemW(hWnd: HWND; var pItem: TLVItemW): Bool;
begin
  Result := Bool( SendMessage(hWnd, LVM_GETITEM, 0, Longint(@pItem)) );
end;
function ListView_GetItem(hWnd: HWND; var pItem: TLVItem): Bool;
begin
  Result := Bool( SendMessage(hWnd, LVM_GETITEM, 0, Longint(@pItem)) );
end;

function ListView_SetItemA(hWnd: HWND; const pItem: TLVItemA): Bool;
begin
  Result := Bool( SendMessage(hWnd, LVM_SETITEM, 0, Longint(@pItem)) );
end;
function ListView_SetItemW(hWnd: HWND; const pItem: TLVItemW): Bool;
begin
  Result := Bool( SendMessage(hWnd, LVM_SETITEM, 0, Longint(@pItem)) );
end;
function ListView_SetItem(hWnd: HWND; const pItem: TLVItem): Bool;
begin
  Result := Bool( SendMessage(hWnd, LVM_SETITEM, 0, Longint(@pItem)) );
end;

function ListView_InsertItemA(hWnd: HWND; const pItem: TLVItemA): Integer;
begin
  Result := Integer( SendMessage(hWnd, LVM_INSERTITEM, 0, Longint(@pItem)) );
end;
function ListView_InsertItemW(hWnd: HWND; const pItem: TLVItemW): Integer;
begin
  Result := Integer( SendMessage(hWnd, LVM_INSERTITEM, 0, Longint(@pItem)) );
end;
function ListView_InsertItem(hWnd: HWND; const pItem: TLVItem): Integer;
begin
  Result := Integer( SendMessage(hWnd, LVM_INSERTITEM, 0, Longint(@pItem)) );
end;

function ListView_DeleteItem(hWnd: HWND; i: Integer): Bool;
begin
  Result := Bool( SendMessage(hWnd, LVM_DELETEITEM, i, 0) );
end;

function ListView_DeleteAllItems(hWnd: HWND): Bool;
begin
  Result := Bool( SendMessage(hWnd, LVM_DELETEALLITEMS, 0, 0) );
end;

function ListView_GetCallbackMask(hWnd: HWND): UINT;
begin
  Result := SendMessage(hWnd, LVM_GETCALLBACKMASK, 0, 0);
end;

function ListView_SetCallbackMask(hWnd: HWND; mask: UINT): Bool;
begin
  Result := Bool( SendMessage(hWnd, LVM_SETCALLBACKMASK, mask, 0) );
end;

function ListView_GetNextItem(hWnd: HWND; iStart: Integer; Flags: UINT): Integer;
begin
  Result := SendMessage(hWnd, LVM_GETNEXTITEM, iStart, MakeLong(Flags, 0));
end;

function ListView_FindItemA(hWnd: HWND; iStart: Integer;
  const plvfi: TLVFindInfoA): Integer;
begin
  Result := SendMessage(hWnd, LVM_FINDITEM, iStart, Longint(@plvfi));
end;
function ListView_FindItemW(hWnd: HWND; iStart: Integer;
  const plvfi: TLVFindInfoW): Integer;
begin
  Result := SendMessage(hWnd, LVM_FINDITEM, iStart, Longint(@plvfi));
end;
function ListView_FindItem(hWnd: HWND; iStart: Integer;
  const plvfi: TLVFindInfo): Integer;
begin
  Result := SendMessage(hWnd, LVM_FINDITEM, iStart, Longint(@plvfi));
end;

function ListView_GetItemRect(hWnd: HWND; i: Integer; var prc: TRect;
  Code: Integer): Bool;
begin
  prc.left := Code;
  Result := Bool( SendMessage(hWnd, LVM_GETITEMRECT, i, Longint(@prc)) );
end;

function ListView_SetItemPosition(hWnd: HWND; i, x, y: Integer): Bool;
begin
  Result := Bool( SendMessage(hWnd, LVM_SETITEMPOSITION, i, MakeLong(x, y)) );
end;

function ListView_GetItemPosition(hwndLV: HWND; i: Integer;
  var ppt: TPoint): Bool;
begin
  Result := Bool( SendMessage(hWndLV, LVM_GETITEMPOSITION, i, Longint(@ppt)) );
end;

function ListView_GetStringWidthA(hwndLV: HWND; psz: PAnsiChar): Integer;
begin
  Result := SendMessage(hwndLV, LVM_GETSTRINGWIDTH, 0, Longint(psz));
end;
function ListView_GetStringWidthW(hwndLV: HWND; psz: PWideChar): Integer;
begin
  Result := SendMessage(hwndLV, LVM_GETSTRINGWIDTH, 0, Longint(psz));
end;
function ListView_GetStringWidth(hwndLV: HWND; psz: PChar): Integer;
begin
  Result := SendMessage(hwndLV, LVM_GETSTRINGWIDTH, 0, Longint(psz));
end;

function ListView_HitTest(hwndLV: HWND; var pinfo: TLVHitTestInfo): Integer;
begin
  Result := SendMessage(hwndLV, LVM_HITTEST, 0, Longint(@pinfo));
end;

function ListView_EnsureVisible(hwndLV: HWND; i: Integer; fPartialOK: Bool): Bool;
begin
  Result := SendMessage(hwndLV, LVM_ENSUREVISIBLE, i,
    MakeLong(Integer(fPartialOK), 0)) <> 0;
end;

function ListView_Scroll(hwndLV: HWnd; DX, DY: Integer): Bool;
begin
  Result := Bool( SendMessage(hwndLV, LVM_SCROLL, DX, DY) );
end;

function ListView_RedrawItems(hwndLV: HWND; iFirst, iLast: Integer): Bool;
begin
  Result := Bool( SendMessage(hwndLV, LVM_REDRAWITEMS, iFirst, iLast) );
end;

function ListView_Arrange(hwndLV: HWND; Code: UINT): Bool;
begin
  Result := Bool( SendMessage(hwndLV, LVM_ARRANGE, Code, 0) );
end;

function ListView_EditLabelA(hwndLV: HWND; i: Integer): HWND;
begin
  Result := HWND( SendMessage(hwndLV, LVM_EDITLABEL, i, 0) );
end;
function ListView_EditLabelW(hwndLV: HWND; i: Integer): HWND;
begin
  Result := HWND( SendMessage(hwndLV, LVM_EDITLABEL, i, 0) );
end;
function ListView_EditLabel(hwndLV: HWND; i: Integer): HWND;
begin
  Result := HWND( SendMessage(hwndLV, LVM_EDITLABEL, i, 0) );
end;

function ListView_GetEditControl(hwndLV: HWND): HWND;
begin
  Result := HWND( SendMessage(hwndLV, LVM_GETEDITCONTROL, 0, 0) );
end;

function ListView_GetColumnA(hwnd: HWND; iCol: Integer; var pcol: TLVColumnA): Bool;
begin
  Result := Bool( SendMessage(hwnd, LVM_GETCOLUMN, iCol, Longint(@pcol)) );
end;
function ListView_GetColumnW(hwnd: HWND; iCol: Integer; var pcol: TLVColumnW): Bool;
begin
  Result := Bool( SendMessage(hwnd, LVM_GETCOLUMN, iCol, Longint(@pcol)) );
end;
function ListView_GetColumn(hwnd: HWND; iCol: Integer; var pcol: TLVColumn): Bool;
begin
  Result := Bool( SendMessage(hwnd, LVM_GETCOLUMN, iCol, Longint(@pcol)) );
end;

function ListView_SetColumnA(hwnd: HWND; iCol: Integer; const pcol: TLVColumnA): Bool;
begin
  Result := Bool( SendMessage(hwnd, LVM_SETCOLUMN, iCol, Longint(@pcol)) );
end;
function ListView_SetColumnW(hwnd: HWND; iCol: Integer; const pcol: TLVColumnW): Bool;
begin
  Result := Bool( SendMessage(hwnd, LVM_SETCOLUMN, iCol, Longint(@pcol)) );
end;
function ListView_SetColumn(hwnd: HWND; iCol: Integer; const pcol: TLVColumn): Bool;
begin
  Result := Bool( SendMessage(hwnd, LVM_SETCOLUMN, iCol, Longint(@pcol)) );
end;

function ListView_InsertColumnA(hwnd: HWND; iCol: Integer; const pcol: TLVColumnA): Integer;
begin
  Result := SendMessage(hWnd, LVM_INSERTCOLUMN, iCol, Longint(@pcol));
end;
function ListView_InsertColumnW(hwnd: HWND; iCol: Integer; const pcol: TLVColumnW): Integer;
begin
  Result := SendMessage(hWnd, LVM_INSERTCOLUMN, iCol, Longint(@pcol));
end;
function ListView_InsertColumn(hwnd: HWND; iCol: Integer; const pcol: TLVColumn): Integer;
begin
  Result := SendMessage(hWnd, LVM_INSERTCOLUMN, iCol, Longint(@pcol));
end;

function ListView_DeleteColumn(hwnd: HWND; iCol: Integer): Bool;
begin
  Result := Bool( SendMessage(hWnd, LVM_DELETECOLUMN, iCol, 0) );
end;

function ListView_GetColumnWidth(hwnd: HWND; iCol: Integer): Integer;
begin
  Result := Integer( SendMessage(hwnd, LVM_GETCOLUMNWIDTH, iCol, 0) );
end;

function ListView_SetColumnWidth(hwnd: HWnd; iCol: Integer; cx: Integer): Bool;
begin
  Result := Bool( SendMessage(hwnd, LVM_SETCOLUMNWIDTH, iCol,
    MakeLong((cx), 0)) );
end;

function ListView_GetHeader(hwndLV: HWnd): Hwnd;
begin
  Result := HWnd(SendMessage(hwndLV, LVM_GETHEADER, 0, 0));
end;

function ListView_CreateDragImage(hwnd: HWND; i: Integer;
  const lpptUpLeft: TPoint): HImageList;
begin
  Result := HIMAGELIST( SendMessage(hwnd, LVM_CREATEDRAGIMAGE, i,
    Longint(@lpptUpLeft)));
end;

function ListView_GetViewRect(hwnd: HWND; var prc: TRect): Bool;
begin
  Result := Bool( SendMessage(hwnd, LVM_GETVIEWRECT, 0, Longint(@prc)) );
end;

function ListView_GetTextColor(hwnd: HWND): TColorRef;
begin
  Result := SendMessage(hwnd, LVM_GETTEXTCOLOR, 0, 0);
end;

function ListView_SetTextColor(hwnd: HWND; clrText: TColorRef): Bool;
begin
  Result := Bool( SendMessage(hwnd, LVM_SETTEXTCOLOR, 0, clrText) );
end;

function ListView_GetTextBkColor(hwnd: HWND): TColorRef;
begin
  Result := SendMessage(hwnd, LVM_GETTEXTBKCOLOR, 0, 0);
end;

function ListView_SetTextBkColor(hwnd: HWND; clrTextBk: TColorRef): Bool;
begin
  Result := Bool( SendMessage(hwnd, LVM_SETTEXTBKCOLOR, 0, clrTextBk) );
end;

function ListView_GetTopIndex(hwndLV: HWND): Integer;
begin
  Result := SendMessage(hwndLV, LVM_GETTOPINDEX, 0, 0);
end;

function ListView_GetCountPerPage(hwndLV: HWND): Integer;
begin
  Result := SendMessage(hwndLV, LVM_GETCOUNTPERPAGE, 0, 0);
end;

function ListView_GetOrigin(hwndLV: HWND; var ppt: TPoint): Bool;
begin
  Result := Bool( SendMessage(hwndLV, LVM_GETORIGIN, 0, Longint(@ppt)) );
end;

function ListView_Update(hwndLV: HWND; i: Integer): Bool;
begin
  Result := SendMessage(hwndLV, LVM_UPDATE, i, 0) <> 0;
end;

function ListView_SetItemState(hwndLV: HWND; i: Integer; data, mask: UINT): Bool;
var
  Item: TLVItem;
begin
  Item.stateMask := mask;
  Item.state := data;
  Result := Bool( SendMessage(hwndLV, LVM_SETITEMSTATE, i, Longint(@Item)) );
end;

function ListView_GetItemState(hwndLV: HWND; i, mask: Integer): Integer;
begin
  Result := SendMessage(hwndLV, LVM_GETITEMSTATE, i, mask);
end;

function ListView_GetCheckState(hwndLV: HWND; i: Integer): Integer;
begin
  Result := (UINT(SendMessage(hwndLV, LVM_GETITEMSTATE, WParam(i), LVIS_STATEIMAGEMASK)) shr 12) - 1;
end;

function ListView_GetItemTextA(hwndLV: HWND; i, iSubItem: Integer;
  pszText: PAnsiChar; cchTextMax: Integer): Integer;
var
  Item: TLVItemA;
begin
  Item.iSubItem := iSubItem;
  Item.cchTextMax := cchTextMax;
  Item.pszText := pszText;
  Result := SendMessage(hwndLV, LVM_GETITEMTEXT, i, Longint(@Item));
end;
function ListView_GetItemTextW(hwndLV: HWND; i, iSubItem: Integer;
  pszText: PWideChar; cchTextMax: Integer): Integer;
var
  Item: TLVItemW;
begin
  Item.iSubItem := iSubItem;
  Item.cchTextMax := cchTextMax;
  Item.pszText := pszText;
  Result := SendMessage(hwndLV, LVM_GETITEMTEXT, i, Longint(@Item));
end;
function ListView_GetItemText(hwndLV: HWND; i, iSubItem: Integer;
  pszText: PChar; cchTextMax: Integer): Integer;
var
  Item: TLVItem;
begin
  Item.iSubItem := iSubItem;
  Item.cchTextMax := cchTextMax;
  Item.pszText := pszText;
  Result := SendMessage(hwndLV, LVM_GETITEMTEXT, i, Longint(@Item));
end;

function ListView_SetItemTextA(hwndLV: HWND; i, iSubItem: Integer;
  pszText: PAnsiChar): Bool;
var
  Item: TLVItemA;
begin
  Item.iSubItem := iSubItem;
  Item.pszText := pszText;
  Result := Bool( SendMessage(hwndLV, LVM_SETITEMTEXT, i, Longint(@Item)) );
end;
function ListView_SetItemTextW(hwndLV: HWND; i, iSubItem: Integer;
  pszText: PWideChar): Bool;
var
  Item: TLVItemW;
begin
  Item.iSubItem := iSubItem;
  Item.pszText := pszText;
  Result := Bool( SendMessage(hwndLV, LVM_SETITEMTEXT, i, Longint(@Item)) );
end;
function ListView_SetItemText(hwndLV: HWND; i, iSubItem: Integer;
  pszText: PChar): Bool;
var
  Item: TLVItem;
begin
  Item.iSubItem := iSubItem;
  Item.pszText := pszText;
  Result := Bool( SendMessage(hwndLV, LVM_SETITEMTEXT, i, Longint(@Item)) );
end;

procedure ListView_SetItemCount(hwndLV: HWND; cItems: Integer);
begin
  SendMessage(hwndLV, LVM_SETITEMCOUNT, cItems, 0);
end;

procedure ListView_SetItemCountEx(hwndLV: HWnd; cItems: Integer; dwFlags: LParam);
begin
  SendMessage(hwndLV, LVM_SETITEMCOUNT, cItems, dwFlags);
end;

function ListView_SortItems(hwndLV: HWND; pfnCompare: TLVCompare;
  lPrm: Longint): Bool;
begin
  Result := Bool( SendMessage(hwndLV, LVM_SORTITEMS, lPrm,
    Longint(@pfnCompare)) );
end;

procedure ListView_SetItemPosition32(hwndLV: HWND; i, x, y: Integer);
var
  ptNewPos: TPoint;
begin
  ptNewPos.x := x;
  ptNewPos.y := y;
  SendMessage(hwndLV, LVM_SETITEMPOSITION32, i, Longint(@ptNewPos));
end;

function ListView_GetSelectedCount(hwndLV: HWND): UINT;
begin
  Result := SendMessage(hwndLV, LVM_GETSELECTEDCOUNT, 0, 0);
end;

function ListView_GetItemSpacing(hwndLV: HWND; fSmall: Integer): Longint;
begin
  Result := SendMessage(hwndLV, LVM_GETITEMSPACING, fSmall, 0);
end;

function ListView_GetISearchStringA(hwndLV: HWND; lpsz: PAnsiChar): Bool;
begin
  Result := Bool( SendMessage(hwndLV, LVM_GETISEARCHSTRING, 0,
    Longint(lpsz)) );
end;
function ListView_GetISearchStringW(hwndLV: HWND; lpsz: PWideChar): Bool;
begin
  Result := Bool( SendMessage(hwndLV, LVM_GETISEARCHSTRING, 0,
    Longint(lpsz)) );
end;

function ListView_GetISearchString(hwndLV: HWND; lpsz: PChar): Bool;
begin
  Result := Bool( SendMessage(hwndLV, LVM_GETISEARCHSTRING, 0,
    Longint(lpsz)) );
end;

function ListView_SetIconSpacing(hwndLV: HWND; cx: Integer; cy: Integer): DWord;
begin
  Result := DWord(SendMessage(hwndLV, LVM_SETICONSPACING, 0, LParam(MakeLong(cx, cy))));
end;

function ListView_SetExtendedListViewStyle(hwndLV: HWND; dw: Integer): DWord;
begin
  Result := DWord(SendMessage(hwndLV, LVM_SETEXTENDEDLISTVIEWSTYLE, 0, dw));
end;

function ListView_GetExtendedListViewStyle(hwndLV: HWND): DWord;
begin
  Result := DWord(SendMessage(hwndLV, LVM_GETEXTENDEDLISTVIEWSTYLE, 0, 0));
end;

function ListView_GetSubItemRect(Handle: HWnd; iItem: Integer; iSubItem: Integer; code: Integer; var prc: TRect): Boolean;
begin
  prc.Left := code;
  Result := Bool(SendMessage(Handle, LVM_GETSUBITEMRECT, WParam(iItem), LongInt(@prc)) );
end;

function ListView_SubItemHitTest(Handle: HWnd; plvhti: Integer): Integer;
begin
  Result := Integer( SendMessage(Handle, LVM_SUBITEMHITTEST, 0, LParam(PLVHitTestInfo(plvhti))));
end;

function ListView_SetColumnOrderArray(Handle: HWnd; iCount: Integer; pi: Integer): Bool;
begin
  Result := Bool( SendMessage(Handle, LVM_SETCOLUMNORDERARRAY, WParam(iCount), LParam(pi)));
end;

function ListView_GetColumnOrderArray(Handle: HWnd; iCount: Integer; pi: Integer): Bool;
begin
  Result := Bool( SendMessage(Handle, LVM_GETCOLUMNORDERARRAY, WParam(iCount), LParam(pi)));
end;

function ListView_SetHotItem(Handle: HWnd; i: Integer): Integer;
begin
  Result := Integer( SendMessage(Handle, LVM_SETHOTITEM, WParam(i), 0));
end;

function ListView_GetHotItem(Handle: Hwnd): Integer;
begin
  Result := Integer( SendMessage(Handle, LVM_GETHOTITEM, 0, 0));
end;

function ListView_SetHotCursor(Handle: HWnd; hCur: HCursor): HCursor;
begin
  Result := HCursor( SendMessage(Handle, LVM_SETHOTCURSOR, 0, LParam(hCur)));
end;

function ListView_GetHotCursor(Handle: HWnd): HCursor;
begin
  Result := HCursor( SendMessage(Handle, LVM_GETHOTCURSOR, 0, 0));
end;

function ListView_ApproximateViewRect(Handle: HWnd; iWidth: Integer; iHeight: Integer; iCount: Integer): DWord;
begin
  Result := DWord( SendMessage(Handle, LVM_APPROXIMATEVIEWRECT, iCount, MakeLParam(iWidth, iHeight)));
end;

function ListView_SetWorkArea(Handle: HWnd; var prc: TRect): Bool;
begin
  Result := Bool( SendMessage(Handle, LVM_SETWORKAREA, 0, Longint(@prc)));
end;

{ Tree View }

function TreeView_InsertItem(hwnd: HWND; const lpis: TTVInsertStruct): HTreeItem;
begin
  Result := HTreeItem( SendMessage(hwnd, TVM_INSERTITEM, 0, Longint(@lpis)) );
end;

function TreeView_DeleteItem(hwnd: HWND; hitem: HTreeItem): Bool;
begin
  Result := Bool( SendMessage(hwnd, TVM_DELETEITEM, 0, Longint(hitem)) );
end;

function TreeView_DeleteAllItems(hwnd: HWND): Bool;
begin
  Result := Bool( SendMessage(hwnd, TVM_DELETEITEM, 0, Longint(TVI_ROOT)) );
end;

function TreeView_Expand(hwnd: HWND; hitem: HTreeItem; code: Integer): Bool;
begin
  Result := Bool( SendMessage(hwnd, TVM_EXPAND, code, Longint(hitem)) );
end;

function TreeView_GetItemRect(hwnd: HWND; hitem: HTreeItem;
  var prc: TRect; code: Bool): Bool;
begin
  HTreeItem(Pointer(@prc)^) := hitem;
  Result := Bool( SendMessage(hwnd, TVM_GETITEMRECT, Integer(code), Longint(@prc)) );
end;

function TreeView_GetCount(hwnd: HWND): UINT;
begin
  Result := SendMessage(hwnd, TVM_GETCOUNT, 0, 0);
end;

function TreeView_GetIndent(hwnd: HWND): UINT;
begin
  Result := SendMessage(hwnd, TVM_GETINDENT, 0, 0);
end;

function TreeView_SetIndent(hwnd: HWND; indent: Integer): Bool;
begin
  Result := Bool( SendMessage(hwnd, TVM_SETINDENT, indent, 0) );
end;

function TreeView_GetImageList(hwnd: HWND; iImage: Integer): HImageList;
begin
  Result := HImageList( SendMessage(hwnd, TVM_GETIMAGELIST, iImage, 0) );
end;

function TreeView_SetImageList(hwnd: HWND; himl: HImageList;
  iImage: Integer): HImageList;
begin
  Result := HImageList( SendMessage(hwnd, TVM_SETIMAGELIST, iImage,
    Longint(himl)) );
end;

function TreeView_GetNextItem(hwnd: HWND; hitem: HTreeItem;
  code: Integer): HTreeItem;
begin
  Result := HTreeItem( SendMessage(hwnd, TVM_GETNEXTITEM, code,
    Longint(hitem)) );
end;

function TreeView_GetChild(hwnd: HWND; hitem: HTreeItem): HTreeItem;
begin
  Result := TreeView_GetNextItem(hwnd, hitem, TVGN_CHILD);
end;

function TreeView_GetNextSibling(hwnd: HWND; hitem: HTreeItem): HTreeItem;
begin
  Result := TreeView_GetNextItem(hwnd, hitem, TVGN_NEXT);
end;

function TreeView_GetPrevSibling(hwnd: HWND; hitem: HTreeItem): HTreeItem;
begin
  Result := TreeView_GetNextItem(hwnd, hitem, TVGN_PREVIOUS);
end;

function TreeView_GetParent(hwnd: HWND; hitem: HTreeItem): HTreeItem;
begin
  Result := TreeView_GetNextItem(hwnd, hitem, TVGN_PARENT);
end;

function TreeView_GetFirstVisible(hwnd: HWND): HTreeItem;
begin
  Result := TreeView_GetNextItem(hwnd, nil,  TVGN_FIRSTVISIBLE);
end;

function TreeView_GetNextVisible(hwnd: HWND; hitem: HTreeItem): HTreeItem;
begin
  Result := TreeView_GetNextItem(hwnd, hitem, TVGN_NEXTVISIBLE);
end;

function TreeView_GetPrevVisible(hwnd: HWND; hitem: HTreeItem): HTreeItem;
begin
  Result := TreeView_GetNextItem(hwnd, hitem, TVGN_PREVIOUSVISIBLE);
end;

function TreeView_GetSelection(hwnd: HWND): HTreeItem;
begin
  Result := TreeView_GetNextItem(hwnd, nil, TVGN_CARET);
end;

function TreeView_GetDropHilite(hwnd: HWND): HTreeItem;
begin
  Result := TreeView_GetNextItem(hwnd, nil, TVGN_DROPHILITE);
end;

function TreeView_GetRoot(hwnd: HWND): HTreeItem;
begin
  Result := TreeView_GetNextItem(hwnd, nil, TVGN_ROOT);
end;

function TreeView_Select(hwnd: HWND; hitem: HTreeItem;
  code: Integer): HTreeItem;
begin
  Result := HTreeItem( SendMessage(hwnd, TVM_SELECTITEM, code,
    Longint(hitem)) );
end;

function TreeView_SelectItem(hwnd: HWND; hitem: HTreeItem): HTreeItem;
begin
  Result := TreeView_Select(hwnd, hitem, TVGN_CARET);
end;

function TreeView_SelectDropTarget(hwnd: HWND; hitem: HTreeItem): HTreeItem;
begin
  Result := TreeView_Select(hwnd, hitem, TVGN_DROPHILITE);
end;

function TreeView_SelectSetFirstVisible(hwnd: HWND; hitem: HTreeItem): HTreeItem;
begin
  Result := TreeView_Select(hwnd, hitem, TVGN_FIRSTVISIBLE);
end;

function TreeView_GetItemA(hwnd: HWND; var pitem: TTVItemA): Bool;
begin
  Result := Bool( SendMessage(hwnd, TVM_GETITEM, 0, Longint(@pitem)) );
end;
function TreeView_GetItemW(hwnd: HWND; var pitem: TTVItemW): Bool;
begin
  Result := Bool( SendMessage(hwnd, TVM_GETITEM, 0, Longint(@pitem)) );
end;
function TreeView_GetItem(hwnd: HWND; var pitem: TTVItem): Bool;
begin
  Result := Bool( SendMessage(hwnd, TVM_GETITEM, 0, Longint(@pitem)) );
end;

function TreeView_SetItemA(hwnd: HWND; const pitem: TTVItemA): Bool;
begin
  Result := Bool( SendMessage(hwnd, TVM_SETITEM, 0, Longint(@pitem)) );
end;
function TreeView_SetItemW(hwnd: HWND; const pitem: TTVItemW): Bool;
begin
  Result := Bool( SendMessage(hwnd, TVM_SETITEM, 0, Longint(@pitem)) );
end;
function TreeView_SetItem(hwnd: HWND; const pitem: TTVItem): Bool;
begin
  Result := Bool( SendMessage(hwnd, TVM_SETITEM, 0, Longint(@pitem)) );
end;

function TreeView_EditLabelA(hwnd: HWND; hitem: HTreeItem): HWND;
begin
  Result := Windows.HWND( SendMessage(hwnd, TVM_EDITLABEL, 0, Longint(hitem)) );
end;
function TreeView_EditLabelW(hwnd: HWND; hitem: HTreeItem): HWND;
begin
  Result := Windows.HWND( SendMessage(hwnd, TVM_EDITLABEL, 0, Longint(hitem)) );
end;
function TreeView_EditLabel(hwnd: HWND; hitem: HTreeItem): HWND;
begin
  Result := Windows.HWND( SendMessage(hwnd, TVM_EDITLABEL, 0, Longint(hitem)) );
end;

function TreeView_GetEditControl(hwnd: HWND): HWND;
begin
  Result := Windows.HWND( SendMessage(hwnd, TVM_GETEDITCONTROL, 0, 0) );
end;

function TreeView_GetVisibleCount(hwnd: HWND): UINT;
begin
  Result := SendMessage(hwnd, TVM_GETVISIBLECOUNT, 0, 0);
end;

function TreeView_HitTest(hwnd: HWND; var lpht: TTVHitTestInfo): HTreeItem;
begin
  Result := HTreeItem( SendMessage(hwnd, TVM_HITTEST, 0, Longint(@lpht)) );
end;

function TreeView_CreateDragImage(hwnd: HWND; hitem: HTreeItem): HimageList;
begin
  Result := HImageList( SendMessage(hwnd, TVM_CREATEDRAGIMAGE, 0,
    Longint(hitem)) );
end;

function TreeView_SortChildren(hwnd: HWND; hitem: HTreeItem;
  recurse: Integer): Bool;
begin
  Result := Bool( SendMessage(hwnd, TVM_SORTCHILDREN, recurse,
    Longint(hitem)) );
end;

function TreeView_EnsureVisible(hwnd: HWND; hitem: HTreeItem): Bool;
begin
  Result := Bool( SendMessage(hwnd, TVM_ENSUREVISIBLE, 0, Longint(hitem)) );
end;

function TreeView_SortChildrenCB(hwnd: HWND; const psort: TTVSortCB;
  recurse: Integer): Bool;
begin
  Result := Bool( SendMessage(hwnd, TVM_SORTCHILDRENCB, recurse,
    Longint(@psort)) );
end;

function TreeView_EndEditLabelNow(hwnd: HWND; fCancel: Bool): Bool;
begin
  Result := Bool( SendMessage(hwnd, TVM_ENDEDITLABELNOW, Integer(fCancel),
    0) );
end;

function TreeView_GetISearchStringA(hwndTV: HWND; lpsz: PAnsiChar): Bool;
begin
  Result := Bool( SendMessage(hwndTV, TVM_GETISEARCHSTRING, 0,
    Longint(lpsz)) );
end;
function TreeView_GetISearchStringW(hwndTV: HWND; lpsz: PWideChar): Bool;
begin
  Result := Bool( SendMessage(hwndTV, TVM_GETISEARCHSTRING, 0,
    Longint(lpsz)) );
end;
function TreeView_GetISearchString(hwndTV: HWND; lpsz: PChar): Bool;
begin
  Result := Bool( SendMessage(hwndTV, TVM_GETISEARCHSTRING, 0,
    Longint(lpsz)) );
end;

// Tab control
function TabCtrl_SetMinTabWidth(Handle: HWnd; x: Integer): Integer;
begin
  Result := Integer( SendMessage(Handle, TCM_SETMINTABWIDTH, 0, x));
end;

procedure TabCtrl_DeselectAll(Handle: HWnd; fExcludeFocus: Integer);
begin
  SendMessage(Handle, TCM_DESELECTALL, fExcludeFocus, 0);
end;


// ====== MonthCal Control ============
function MonthCal_GetCurSel(hmc: HWnd; pst: PSystemTime): Bool;
begin
  Result := Bool( SendMessage(hmc, MCM_GETCURSEL, 0, LParam(Pst)));
end;

function MonthCal_SetCurSel(hmc: HWnd; pst: PSystemTime): Bool;
begin
  Result := Bool( SendMessage(hmc, MCM_SETCURSEL, 0, LParam(Pst)));
end;

function MonthCal_GetMaxSelCount(hmc: HWnd): DWord;
begin
  Result := DWord( SendMessage(hmc, MCM_GETMAXSELCOUNT, 0, 0));
end;

function MonthCal_SetMaxSelCount(hmc: HWnd; n: UINT): Bool;
begin
  Result := Bool( SendMessage(hmc, MCM_SETMAXSELCOUNT, WParam(n), 0));
end;

function MonthCal_GetSelRange(hmc: HWnd; rgst: PSystemTime): Bool;
begin
  Result := Bool(SendMessage(hmc, MCM_GETSELRANGE, 0, LParam(rgst)));
end;

function MonthCal_SetSelRange(hmc: HWnd; rgst: PSystemTime): Bool;
begin
  Result := Bool(SendMessage(hmc, MCM_SETSELRANGE, 0, LParam(rgst)));
end;

function MonthCal_GetMonthRange(hmc: HWnd; gmr: DWord; rgst: PSystemTime): DWord;
begin
  Result := DWord( SendMessage(hmc, MCM_GETMONTHRANGE, WParam(gmr), LParam(rgst)));
end;

function MonthCal_SetDayState(hmc: HWnd; cbds: Integer; rgds: PSystemTime): Bool;
begin
  Result := Bool(SendMessage(hmc, MCM_SETDAYSTATE, WParam(cbds), LParam(rgds)));
end;

function MonthCal_GetMinReqRect(hmc: HWnd; prc: PRect): Bool;
begin
  Result := Bool(SendMessage(hmc, MCM_GETMINREQRECT, 0, LParam(prc)));
end;

procedure MonthCal_SetToday(hmc: HWnd; pst: PSystemTime);
begin
  SendMessage(hmc, MCM_SETTODAY, 0, LParam(pst));
end;

function MonthCal_GetToday(hmc: HWnd; pst: PSystemTime): Bool;
begin
  Result := Bool(SendMessage(hmc, MCM_GETTODAY, 0, LParam(pst)));
end;

procedure MonthCal_HitTest(hmc: HWnd; pinfo: PMCHitTestInfo);
begin
  SendMessage(hmc, MCM_HITTEST, 0, LParam(pinfo));
end;

procedure MonthCal_SetFirstDayOfWeek(hmc: HWnd; iDay: Integer);
begin
  SendMessage(hmc, MCM_SETFIRSTDAYOFWEEK, 0, iDay);
end;

function  MonthCal_GetFirstDayOfWeek(hmc: HWnd): DWord;
begin
  Result := DWord( SendMessage(hmc, MCM_GETFIRSTDAYOFWEEK, 0, 0));
end;

function  MonthCal_GetRange(hmc: HWnd; rgst: PSystemTime): DWord;
begin
  Result := DWord( SendMessage(hmc, MCM_GETRANGE, 0, LParam(rgst)));
end;

function  MonthCal_SetRange(hmc: HWnd; gdtr: DWord; rgst: PSystemTime): Bool;
begin
  Result := Bool( SendMessage(hmc, MCM_SETRANGE, WParam(gdtr), LParam(rgst)));
end;

function  MonthCal_GetMonthDelta(hmc: HWnd): Integer;
begin
  Result := Integer( SendMessage(hmc, MCM_GETMONTHDELTA, 0, 0));
end;

function  MonthCal_SetMonthDelta(hmc: HWnd; n: Integer): Integer;
begin
  Result := Integer( SendMessage(hmc, MCM_SETMONTHDELTA, n, 0));
end;

procedure MonthCal_SetColor(hmc: HWnd; iColor: TColorRef; clr: integer);
begin
  SendMessage(hmc, MCM_SETCOLOR, iColor, clr);
end;

procedure MonthCal_GetColor(hmc: HWnd; iColor: TColorRef);
begin
  SendMessage(hmc, MCM_SETCOLOR, iColor, 0);
end;

//======= DateTime Pick Control =======================
function DateTime_GetSystemTime(hdp: HWnd; pst: PSystemTime): DWord;
begin
  Result := DWord( SendMessage(hdp, DTM_GETSYSTEMTIME, 0, LParam(pst)));
end;

function DateTime_SetSystemTime(hdp: HWnd; gd: DWord; pst: PSystemTime): Bool;
begin
  Result := Bool( SendMessage(hdp, DTM_SETSYSTEMTIME, WParam(gd), LParam(pst)));
end;

function DateTime_GetRange(hdp: HWnd; rgst: PSystemTime): DWord;
begin
  Result := DWord( SendMessage(hdp, DTM_GETRANGE, 0, LParam(rgst)));
end;

function DateTime_SetRange(hdp: HWnd; gdtr: DWord; rgst: PSystemTime): Bool;
begin
  Result := Bool( SendMessage(hdp, DTM_SETRANGE, WParam(gdtr), LParam(rgst)));
end;

function DateTime_SetFormat(hdp: HWnd; sz: LPCSTR): Bool;
begin
  Result := Bool( SendMessage(hdp, DTM_SETMCCOLOR, 0, LParam(sz)));
end;

procedure DateTime_SetMonthCalColor(hdp: HWnd; iColor: TColorRef; clr: TColorRef);
begin
  SendMessage(hdp, DTM_SETMCCOLOR, iColor, clr);
end;

procedure DateTime_GetMonthCalColor(hdp: HWnd; var iColor: TColorRef);
begin
  SendMessage(hdp, DTM_GETMCCOLOR, iColor, 0);
end;

function  DateTime_GetMonthCal(hdp: HWnd): HWnd;
begin
  Result := HWnd( SendMessage(hdp, DTM_GETMONTHCAL, 0, 0));
end;

procedure DateTime_SetMonthCalFont(hdp: HWnd; Font: HFont; fReDraw: Integer);
begin
  SendMessage(hdp, DTM_SETMCFONT, WParam(Font), LParam(fRedraw));
end;

procedure DateTime_GetMonthCalFont(hdp: HWnd);
begin
  SendMessage(hdp, DTM_GETMCFONT, 0, 0);
end;

// ======= TrackMouse Event ===============
function TrackMouseEvent; external cctrl name '_TrackMouseEvent';

end.

