{+--------------------------------------------------------------------------+
 | Created:     05.98
 | Author:      Martin Waldenburg
 | Copyright    1998, all rights reserved.
 | Description: Demo for TmwComboTree
 | DISCLAIMER:  This is provided as is, expressly without a warranty of any kind.
 |              You use it at your own risc.
 +--------------------------------------------------------------------------+}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ComCtrls, mwCombTree;

type
  TForm1 = class(TForm)
    mwComboTree1: TmwComboTree;
    ImageList1: TImageList;
    procedure FormShow(Sender: TObject);
  private
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormShow(Sender: TObject);
var
  aNode, bNode, cNode, dNode: TTreeNode;
  I, J, K, M: Integer;
  S: String;
begin
  For I := 1 to 3 do
  begin
    S := 'Root' + IntToStr(I);
    aNode := mwComboTree1.Add(nil, S);
    aNode.ImageIndex := 0;
    aNode.SelectedIndex := 1;
    For J := 1 to 3 do
    begin
      S := 'Child' + IntToStr(I) + '_' + IntToStr(J);
      bNode := mwComboTree1.AddChild(aNode, S);
      bNode.ImageIndex := 0;
      bNode.SelectedIndex := 1;
      For K := 1 to 3 do
      begin
        S := 'Child' + IntToStr(I) + '_' + IntToStr(J) + '_' + IntToStr(K);
        cNode := mwComboTree1.AddChild(bNode, S);
        cNode.ImageIndex := 0;
        cNode.SelectedIndex := 1;
        For M := 1 to 3 do
        begin
          S := 'Child' + IntToStr(I) + '_' + IntToStr(J) + '_' + IntToStr(K) + '_' + IntToStr(M);
          dNode := mwComboTree1.AddChild(cNode, S);
          dNode.ImageIndex := 0;
          dNode.SelectedIndex := 1;
        end;
      end;
    end;
  end
end;

end.

